/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import androidx.annotation.Nullable;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.HashSet;

public class OrientationUtils {
    private static HashSet<String> lockedActivities = new HashSet();

    private OrientationUtils() {
    }

    public static void unlockOrientation(Context context) {
        Context context2 = OrientationUtils.getActivity(context);
        if (context2 != null) {
            ComponentName componentName;
            if (!lockedActivities.contains(context2.getClass().getName())) {
                return;
            }
            Context context3 = context2;
            InstabugSDKLogger.v("IBG-Core", "Unlocking orientation for activity " + context2.toString());
            ComponentName componentName2 = componentName;
            Context context4 = context2;
            componentName = new ComponentName(context4, context4.getClass());
            try {
                context3.setRequestedOrientation(context3.getPackageManager().getActivityInfo((ComponentName)componentName2, (int)128).screenOrientation);
            }
            catch (Exception exception) {
                context2.setRequestedOrientation(-1);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                context2.setRequestedOrientation(-1);
            }
        }
    }

    public static void lockScreenOrientation(Context context) {
        Context context2 = OrientationUtils.getActivity(context);
        if (context2 != null) {
            Context context3 = context2;
            InstabugSDKLogger.v("IBG-Core", "Locking orientation for activity " + context2.toString());
            int n2 = context3.getWindowManager().getDefaultDisplay().getRotation();
            int n3 = context3.getResources().getConfiguration().orientation;
            if (n3 != 1) {
                if (n3 == 2) {
                    if (n2 != 0 && n2 != 1) {
                        context2.setRequestedOrientation(8);
                    } else {
                        context2.setRequestedOrientation(0);
                    }
                }
            } else if (n2 != 1 && n2 != 2) {
                context2.setRequestedOrientation(1);
            } else {
                context2.setRequestedOrientation(9);
            }
            lockedActivities.add(context2.getClass().getName());
        }
    }

    public static void handelOrientation(Context context) {
        Context context2;
        if (SettingsManager.getInstance().getRequestedOrientation() == -2) {
            OrientationUtils.lockScreenOrientation(context2);
        } else if ((context2 = OrientationUtils.getActivity(context2)) != null) {
            context2.setRequestedOrientation(OrientationUtils.getOrientation(SettingsManager.getInstance().getRequestedOrientation()));
        }
    }

    public static int getOrientation(int orientationValue) {
        switch (orientationValue) {
            default: {
                return -1;
            }
            case 14: {
                return 14;
            }
            case 13: {
                return 13;
            }
            case 12: {
                return 12;
            }
            case 11: {
                return 11;
            }
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: 
        }
        return 0;
    }

    public static boolean isInLandscape(Context context) {
        Context context2;
        return context != null && context2.getResources().getConfiguration().orientation == 2;
    }

    @Nullable
    private static Activity getActivity(Context context) {
        if (context != null) {
            Context context2;
            while (context2 instanceof ContextWrapper) {
                if (context2 instanceof Activity) {
                    return (Activity)context2;
                }
                context2 = ((ContextWrapper)context2).getBaseContext();
            }
        }
        return null;
    }
}

