/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.encryption.EncryptionManager;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FileUtils {
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    public static final String FLAG_ENCRYPTED = "_e";
    private static final int NUMBER_BYTES_TO_PROCESS = 256;
    private static final int IV_LENGTH = Build.VERSION.SDK_INT > 19 ? 12 : 16;

    public static int getFileType(@NonNull File file) {
        Object object;
        if (file.isDirectory()) {
            return 2;
        }
        return FileUtils.getIndexOfExtension((String)(object = ((File)object).getAbsolutePath())) == -1 ? -1 : FileUtils.getTypeFromExtension((String)object);
    }

    public static Intent getFileViewerIntent(@NonNull String pathOrUrl) {
        String string2;
        if (URLUtil.isNetworkUrl((String)pathOrUrl)) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        }
        return FileUtils.appropriateIntent(Uri.fromFile((File)new File(string2)), FileUtils.getExtension(string2));
    }

    public static String getExtension(@NonNull File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(@NonNull String absolutePath) {
        String string2;
        int n2 = FileUtils.getIndexOfExtension(absolutePath);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    public static boolean isVideoFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isVideoExtension(FileUtils.getExtension(file2));
    }

    public static boolean isImageFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isImageExtension(FileUtils.getExtension(file2));
    }

    public static boolean isTextFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isTextExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isCacheFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isCacheExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isVideoExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("mp4") || string2.equalsIgnoreCase("avi") || string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("3gpp") || string2.equalsIgnoreCase("ts") || string2.equalsIgnoreCase("AAC") || string2.equalsIgnoreCase("webm") || string2.equalsIgnoreCase("mkv");
    }

    public static boolean isImageExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("bmp") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("webp");
    }

    private static boolean isTextExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("txt");
    }

    private static boolean isCacheExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("cache");
    }

    public static void sortByLastModifiedAsc(@NonNull List<File> files) {
        Comparator<File> comparator;
        List<File> list = files;
        Comparator<File> comparator2 = comparator;
        try {
            comparator = new Comparator<File>(){

                public int a(File file, File file2) {
                    return Double.compare(file.lastModified(), file2.lastModified());
                }
            };
            Collections.sort(list, comparator2);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Exception " + exception.getMessage() + " while sorting list");
        }
    }

    public static long getSize(@NonNull File file) {
        File[] fileArray;
        if (!file.exists()) {
            return 0L;
        }
        long l2 = fileArray.length();
        if (fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 += FileUtils.getSize(fileArray[i2]);
            }
        }
        return l2;
    }

    private static int getTypeFromExtension(String absolutePath) {
        String string2 = FileUtils.getExtension(absolutePath);
        if (FileUtils.isVideoExtension(string2)) {
            return 0;
        }
        if (FileUtils.isImageExtension(string2)) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static Intent appropriateIntent(Uri uri, String extension) {
        Uri uri2;
        void var1_1;
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW");
        if (!extension.equalsIgnoreCase("doc") && !var1_1.equalsIgnoreCase("docx")) {
            if (var1_1.equalsIgnoreCase("pdf")) {
                intent2.setDataAndType(uri2, "application/pdf");
            } else if (!var1_1.equalsIgnoreCase("ppt") && !var1_1.equalsIgnoreCase("pptx")) {
                if (!var1_1.equalsIgnoreCase("xls") && !var1_1.equalsIgnoreCase("xlsx")) {
                    if (!var1_1.equalsIgnoreCase("zip") && !var1_1.equalsIgnoreCase("rar")) {
                        if (var1_1.equalsIgnoreCase("rtf")) {
                            intent2.setDataAndType(uri2, "application/rtf");
                        } else if (!var1_1.equalsIgnoreCase("wav") && !var1_1.equalsIgnoreCase("mp3")) {
                            if (var1_1.equalsIgnoreCase("gif")) {
                                intent2.setDataAndType(uri2, "image/gif");
                            } else if (!(var1_1.equalsIgnoreCase("jpg") || var1_1.equalsIgnoreCase("jpeg") || var1_1.equalsIgnoreCase("png"))) {
                                if (var1_1.equalsIgnoreCase("txt")) {
                                    intent2.setDataAndType(uri2, "text/plain");
                                } else if (!(var1_1.equalsIgnoreCase("3gp") || var1_1.equalsIgnoreCase("mpg") || var1_1.equalsIgnoreCase("mpeg") || var1_1.equalsIgnoreCase("mpe") || var1_1.equalsIgnoreCase("mp4") || var1_1.equalsIgnoreCase("avi"))) {
                                    intent2.setDataAndType(uri2, "*/*");
                                } else {
                                    intent2.setDataAndType(uri2, "video/*");
                                }
                            } else {
                                intent2.setDataAndType(uri2, "image/jpeg");
                            }
                        } else {
                            intent2.setDataAndType(uri2, "audio/x-wav");
                        }
                    } else {
                        intent2.setDataAndType(uri2, "application/x-wav");
                    }
                } else {
                    intent2.setDataAndType(uri2, "application/vnd.ms-excel");
                }
            } else {
                intent2.setDataAndType(uri2, "application/vnd.ms-powerpoint");
            }
        } else {
            intent2.setDataAndType(uri2, "application/msword");
        }
        Intent intent3 = intent2;
        intent3.addFlags(0x10000000);
        return intent3;
    }

    @Nullable
    public static File getFile(String path) {
        String string2;
        File file;
        File file2 = file;
        if (new File(string2).exists()) {
            return file2;
        }
        return null;
    }

    public static boolean isFileRelatedToBugOrCrashReport(String filePath) {
        String string2;
        return filePath.contains("vusf") || string2.contains("view-hierarchy-images") || string2.contains("bug_") && string2.endsWith("_.jpg") || string2.contains("view_hierarchy_attachment_") && string2.endsWith(".zip") || string2.contains("usersteps_") && string2.endsWith(".zip");
    }

    public static int getIndexOfExtension(String filename) {
        String string2 = filename;
        int n2 = string2.lastIndexOf(46);
        if (string2.lastIndexOf(47) > n2) {
            n2 = -1;
        }
        return n2;
    }

    public static boolean isEncryptedFile(String filePath) {
        Boolean bl;
        bl = PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable<Boolean>((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            @Nullable
            public Boolean a() {
                b b2 = this;
                int n2 = FileUtils.getIndexOfExtension(b2.a);
                return b2.a.substring(0, n2).endsWith(FileUtils.FLAG_ENCRYPTED);
            }
        });
        return bl != null ? bl : false;
    }

    public static String getPathWithEncryptedFlag(String path) {
        int n2 = FileUtils.getIndexOfExtension(path);
        if (n2 != -1) {
            String string2;
            String string3 = string2;
            string2 = string2.substring(0, n2);
            String string4 = string3.substring(n2);
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = FLAG_ENCRYPTED;
            objectArray[2] = string4;
            return String.format("%s%s%s", objectArray2);
        }
        return "";
    }

    public static String getPathWithDecryptedFlag(String path) {
        return path.replace(FLAG_ENCRYPTED, "");
    }

    public static boolean isReproStepFile(String filePath) {
        String string2;
        return (filePath.contains("step") || string2.contains("icon")) && string2.endsWith(".png") && !string2.contains("usersteps_") && !string2.endsWith(".zip");
    }

    public static boolean encryptFile(@NonNull String path) throws UnsatisfiedLinkError {
        Boolean bl;
        bl = PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable<Boolean>((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            @Nullable
            public Boolean a() {
                File file;
                File file2 = file;
                file = new File(this.a);
                boolean bl = FileUtils.access$000(1, file2);
                if (bl && (FileUtils.isReproStepFile(this.a) || FileUtils.isInternalAttachmentFile(this.a)) && !((String)(this = FileUtils.getPathWithEncryptedFlag(this.a))).equals("")) {
                    File file3;
                    File file4 = file2;
                    file2 = file3;
                    file3 = new File((String)this);
                    file4.renameTo(file2);
                }
                return bl;
            }
        });
        return bl != null ? bl : false;
    }

    private static boolean isInternalAttachmentFile(@NonNull String path) {
        return path.contains("internal-attachments");
    }

    public static boolean decryptFile(@NonNull String filePath) throws UnsatisfiedLinkError {
        Boolean bl;
        bl = PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable<Boolean>((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            @Nullable
            public Boolean a() {
                File file;
                File file2 = file;
                file = new File(string2.a);
                boolean bl = FileUtils.access$000(2, file2);
                if (bl && (FileUtils.isReproStepFile(string2.a) || FileUtils.isInternalAttachmentFile(string2.a))) {
                    String string2 = FileUtils.getPathWithDecryptedFlag(string2.a);
                    file2.renameTo(new File(string2));
                }
                return bl;
            }
        });
        return bl != null ? bl : false;
    }

    /*
     * Exception decompiling
     */
    private static boolean fileProcessor(int cipherMode, File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [17, 16, 15 : 119->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ProcessedBytes decryptOnTheFly(String filePath) throws UnsatisfiedLinkError {
        String string2;
        return FileUtils.fileDecryptionOnTheFlyProcessor(new File(string2));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static ProcessedBytes fileDecryptionOnTheFlyProcessor(File file) {
        void var0_3;
        Object object;
        block37: {
            RandomAccessFile randomAccessFile;
            block38: {
                File file2;
                block36: {
                    ProcessedBytes processedBytes;
                    byte[] byArray;
                    block35: {
                        byte[] byArray2;
                        block34: {
                            byte[] byArray3;
                            int n2;
                            int n3;
                            block33: {
                                RandomAccessFile randomAccessFile2;
                                object = null;
                                randomAccessFile = randomAccessFile2;
                                randomAccessFile2 = new RandomAccessFile(file2, "rws");
                                n3 = 256;
                                n2 = IV_LENGTH;
                                n3 = n2 + n3;
                                byArray3 = new byte[n3];
                                if (randomAccessFile2.length() <= (long)(n2 + 256)) break block33;
                                RandomAccessFile randomAccessFile3 = randomAccessFile;
                                RandomAccessFile randomAccessFile4 = randomAccessFile3;
                                long l2 = randomAccessFile3.length();
                                randomAccessFile4.seek(l2 - (long)(n2 + 256));
                            }
                            randomAccessFile.read(byArray3, 0, n3);
                            byArray2 = EncryptionManager.decrypt(byArray3);
                            if (randomAccessFile.length() <= (long)(n2 + 256)) break block34;
                            RandomAccessFile randomAccessFile5 = randomAccessFile;
                            RandomAccessFile randomAccessFile6 = randomAccessFile5;
                            long l3 = randomAccessFile5.length();
                            randomAccessFile6.seek(l3 - (long)(n2 + 256));
                        }
                        File file3 = file2;
                        int n4 = 0;
                        randomAccessFile.write(byArray2, n4, byArray2.length);
                        int n5 = (int)file3.length();
                        byArray = new byte[n5];
                        FileUtils.read(file3, byArray);
                        if (!FileUtils.isReproStepFile(file3.getPath())) break block35;
                        File file4 = file2;
                        File file5 = file4;
                        String string2 = FileUtils.getPathWithDecryptedFlag(file4.getPath());
                        file5.renameTo(new File(string2));
                    }
                    RandomAccessFile randomAccessFile7 = randomAccessFile;
                    ProcessedBytes processedBytes2 = processedBytes;
                    processedBytes = new ProcessedBytes(byArray, true);
                    try {
                        randomAccessFile7.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return processedBytes2;
                    catch (OutOfMemoryError outOfMemoryError) {
                        break block36;
                    }
                    catch (Exception exception) {
                        break block36;
                    }
                    catch (Throwable throwable) {
                        break block37;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        randomAccessFile = object;
                        object = outOfMemoryError;
                    }
                    catch (Exception exception) {
                        randomAccessFile = object;
                        object = exception;
                    }
                }
                InstabugSDKLogger.e("IBG-Core", "Error: " + object + " occurred while decrypting file in path: " + file2.getPath());
                NonFatals.reportNonFatal((Throwable)object, "Error: " + object + " occurred while decrypting file in path: " + file2.getPath());
                if (randomAccessFile == null) break block38;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return new ProcessedBytes(new byte[0], false);
            catch (Throwable throwable) {
                object = randomAccessFile;
            }
        }
        if (object != null) {
            try {
                ((RandomAccessFile)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        throw var0_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void read(File inputFile, byte[] outputBytes) throws IOException {
        void var0_3;
        FileInputStream fileInputStream;
        block6: {
            void v1;
            FileInputStream fileInputStream2;
            fileInputStream = null;
            FileInputStream fileInputStream3 = fileInputStream2;
            try {
                File file;
                void var1_4;
                v1 = var1_4;
                fileInputStream3(file);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block6;
            }
            try {
                fileInputStream2.read((byte[])v1);
            }
            catch (Throwable throwable) {
                fileInputStream = fileInputStream3;
                break block6;
            }
            fileInputStream2.close();
            return;
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        throw var0_3;
    }

    @WorkerThread
    @NonNull
    public static synchronized List<File> getStateFiles(String prefix) {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            File[] fileArray;
            object = object.getFilesDir().getParentFile();
            fileArray = (arg_0, arg_1) -> FileUtils.lambda$getStateFiles$0((String)fileArray, arg_0, arg_1);
            if (object != null && (fileArray = ((File)object).listFiles((FilenameFilter)fileArray)) != null) {
                arrayList2.addAll(Arrays.asList(fileArray));
            }
        }
        return arrayList2;
    }

    @Nullable
    public static String getFileName(@NonNull String path) {
        return Uri.parse((String)path).getLastPathSegment();
    }

    public static void deleteDirectory(@Nullable File file) {
        if (file != null) {
            File[] fileArray;
            File file2;
            if (file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    FileUtils.deleteDirectory(fileArray[i2]);
                }
            }
            file2.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getStateFiles$0(String prefix, File dir, String name) {
        void var2_2;
        String string2;
        return name.startsWith(string2) && var2_2.endsWith(".txt");
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(int x0, File x1) {
        void var1_1;
        return FileUtils.fileProcessor(x0, (File)var1_1);
    }
}

