/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.session;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.utils.PreferencesUtils;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionsBatchDTO;
import com.instabug.library.model.session.config.SessionsConfig;
import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.session.b;
import com.instabug.library.session.c;
import com.instabug.library.session.e;
import com.instabug.library.session.g;
import com.instabug.library.session.h;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class i {
    private SessionsConfig a;
    @NonNull
    private final com.instabug.library.session.a b;
    @NonNull
    private final PreferencesUtils c;
    @NonNull
    private final e d;
    @NonNull
    private final g e;
    @NonNull
    private final c f;

    public static i a(@NonNull Context object) {
        b b2;
        Context context = object;
        object = b2;
        b2 = new b();
        PreferencesUtils preferencesUtils = h.a(context);
        e e2 = h.b();
        g g2 = g.a(context);
        SessionsConfig sessionsConfig = SettingsManager.getSessionsSyncConfigurations(context);
        c c2 = h.a();
        return new i(sessionsConfig, (com.instabug.library.session.a)object, preferencesUtils, e2, g2, c2);
    }

    public i(@NonNull SessionsConfig sessionsConfig, @NonNull com.instabug.library.session.a a2, @NonNull PreferencesUtils preferencesUtils, @NonNull e e2, @NonNull g g2, @NonNull c c2) {
        this.a = sessionsConfig;
        this.b = a2;
        this.c = preferencesUtils;
        this.d = e2;
        this.e = g2;
        this.f = c2;
    }

    private void b(@NonNull List<SessionsBatchDTO> list) {
        h.a(() -> {
            list = list.iterator();
            while (list.hasNext()) {
                SessionsBatchDTO sessionsBatchDTO = (SessionsBatchDTO)list.next();
                if (this.f.a()) {
                    this.a(sessionsBatchDTO);
                    continue;
                }
                this.f.a(System.currentTimeMillis());
                this.b(sessionsBatchDTO);
            }
        });
    }

    private void a(@NonNull SessionsBatchDTO sessionsBatchDTO) {
        i i2 = list;
        List<String> list = SessionMapper.toIDs(sessionsBatchDTO);
        i2.d.b(list).a(list);
        i2.c();
    }

    private void b(final @NonNull SessionsBatchDTO sessionsBatchDTO) {
        Request.Callbacks<RequestResponse, Throwable> callbacks;
        final List<String> list = SessionMapper.toIDs(sessionsBatchDTO);
        Request.Callbacks<RequestResponse, Throwable> callbacks2 = callbacks;
        callbacks = new Request.Callbacks<RequestResponse, Throwable>(){

            public void a(RequestResponse requestResponse) {
                a a2 = this;
                a2.i.this.a("Synced a batch of " + sessionsBatchDTO.getSessions().size() + " session/s.");
                a2.i.this.f.a(0L);
                a2.i.this.d.b(list).a(list);
            }

            public void a(Throwable throwable) {
                if (throwable instanceof RateLimitedException) {
                    a a2 = rateLimitedException;
                    RateLimitedException rateLimitedException = (RateLimitedException)throwable;
                    rateLimitedException.i.this.a(rateLimitedException, a2.sessionsBatchDTO);
                } else {
                    InstabugCore.reportError(throwable, "Error: " + throwable.getMessage() + " while syncing sessions");
                }
            }
        };
        this.e.a(sessionsBatchDTO, callbacks2);
    }

    private void a(RateLimitedException rateLimitedException, @NonNull SessionsBatchDTO sessionsBatchDTO) {
        this.f.a(rateLimitedException.getPeriod());
        this.a(sessionsBatchDTO);
    }

    private void e() {
        this.a(TimeUtils.currentTimeMillis());
    }

    private long b() {
        long l2 = TimeUtils.currentTimeMillis() - this.c.getLong("key_last_batch_synced_at");
        return TimeUnit.MILLISECONDS.toMinutes(l2);
    }

    private void c() {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = "Sessions";
        super.a(String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", objectArray3));
    }

    private void a(@NonNull String string2) {
        InstabugSDKLogger.d("IBG-Core", string2);
    }

    public void a(@NonNull SessionsConfig sessionsConfig) {
        this.a = sessionsConfig;
    }

    @WorkerThread
    public i a() {
        i i2 = this;
        long l2 = i2.b();
        if (i2.a.getSyncMode() == 0) {
            i i3 = this;
            i3.a("Invalidating cache. Sync mode = " + this.a.getSyncMode());
            return i3;
        }
        if (!this.f() && this.a.getSyncMode() != 1) {
            if (InstabugDeviceProperties.getVersionCode().intValue() != SettingsManager.getInstance().getLastKnownVersionCode()) {
                i i4 = this;
                SettingsManager.getInstance().setVersionCode(InstabugDeviceProperties.getVersionCode());
                SettingsManager.getInstance().setIsFirstSession(true);
                i4.a("App version has changed. Marking cached sessions as ready for sync");
                i4.d.a();
            } else {
                this.a("Skipping sessions evaluation. Elapsed time since last sync = " + l2 + " mins. Sync configs = " + this.a.toString());
            }
        } else {
            i i5 = this;
            i5.a("Evaluating cached sessions. Elapsed time since last sync = " + l2 + " mins. Sync configs = " + this.a.toString());
            i5.d.a();
            i5.e();
        }
        return this;
    }

    public boolean f() {
        return this.b() >= (long)this.a.getSyncIntervalsInMinutes();
    }

    @WorkerThread
    public void g() {
        if (this.a.getSyncMode() == 0) {
            this.a("Sessions sync is not allowed. Sync mode = " + this.a.getSyncMode());
        } else {
            i i2 = this;
            i2.a("Syncing local with remote. Sync configs = " + this.a.toString());
            List<Object> list = i2.d.b();
            if (!list.isEmpty()) {
                list = SessionMapper.toModels(list);
                if (this.a.getSyncMode() == 1) {
                    i i3 = this;
                    list = i3.b.a(list, 1);
                    i3.a("Syncing " + list.size() + " batches of max 1 session per batch.");
                } else {
                    i i4 = this;
                    int n2 = i4.a.getMaxSessionsPerRequest();
                    list = i4.b.a(list, n2);
                    i4.a("Syncing " + list.size() + " batches of max " + n2 + " sessions per batch.");
                }
                this.b(list);
            } else {
                this.a("No sessions ready for sync. Skipping...");
            }
        }
    }

    public void a(long l2) {
        this.c.saveOrUpdateLong("key_last_batch_synced_at", l2);
    }

    public i d() {
        i i2 = this;
        i2.a(TimeUtils.currentTimeMillis() - TimeUnit.MINUTES.toMillis(this.a.getSyncIntervalsInMinutes()));
        return i2;
    }
}

