/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;

public class InstabugAlertDialog {

    public static class Builder {
        @NonNull
        private final Activity activity;
        @Nullable
        private String title;
        @Nullable
        private String message;
        @Nullable
        private String positiveButtonText;
        @Nullable
        private String negativeButtonText;
        @Nullable
        private DialogInterface.OnClickListener onPositiveClickListener;
        @Nullable
        private DialogInterface.OnClickListener onNegativeClickListener;
        @Nullable
        private String positiveButtonAccessibilityContentDescription;
        @Nullable
        private String negativeButtonAccessibilityContentDescription;
        private boolean isCancellable = true;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Activity activity) {
            void var1_1;
            this.activity = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$show$1(AlertDialog alertDialog, DialogInterface dialog) {
            AlertDialog alertDialog2 = alertDialog;
            alertDialog2.getButton(-1).setTextColor(InstabugCore.getPrimaryColor());
            alertDialog2.getButton(-2).setTextColor(InstabugCore.getPrimaryColor());
            if (AccessibilityUtils.isAccessibilityServiceEnabled()) {
                void var1_1;
                void v1 = var1_1;
                v1.getButton(-1).setContentDescription((CharSequence)this.positiveButtonAccessibilityContentDescription);
                v1.getButton(-2).setContentDescription((CharSequence)this.negativeButtonAccessibilityContentDescription);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTitle(@Nullable String title) {
            void var1_1;
            this.title = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMessage(@Nullable String message) {
            void var1_1;
            this.message = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPositiveButton(@Nullable String positiveButtonText, @Nullable DialogInterface.OnClickListener onPositiveClickListener) {
            void var2_2;
            void var1_1;
            this.positiveButtonText = var1_1;
            this.onPositiveClickListener = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNegativeButton(@Nullable String negativeButtonText, @Nullable DialogInterface.OnClickListener onNegativeClickListener) {
            void var2_2;
            void var1_1;
            this.negativeButtonText = var1_1;
            this.onNegativeClickListener = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCancellable(boolean cancellable) {
            void var1_1;
            this.isCancellable = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPositiveButtonAccessibilityContentDescription(@Nullable String positiveButtonAccessibilityContentDescription) {
            void var1_1;
            this.positiveButtonAccessibilityContentDescription = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNegativeButtonAccessibilityContentDescription(@Nullable String negativeButtonAccessibilityContentDescription) {
            void var1_1;
            this.negativeButtonAccessibilityContentDescription = var1_1;
            return this;
        }

        public AlertDialog show() {
            DialogInterface.OnClickListener onClickListener;
            AlertDialog.Builder builder;
            AlertDialog.Builder builder2 = builder;
            builder2((Context)this.activity, R.style.InstabugDialogStyle);
            builder.setTitle((CharSequence)this.title).setMessage((CharSequence)this.message).setCancelable(this.isCancellable);
            String string2 = this.positiveButtonText;
            if (string2 != null && (onClickListener = this.onPositiveClickListener) != null) {
                builder2.setPositiveButton((CharSequence)string2, onClickListener);
            }
            if (this.negativeButtonText != null) {
                string2 = this.onNegativeClickListener;
                if (string2 == null) {
                    string2 = (dialogInterface, i2) -> dialogInterface.cancel();
                }
                builder2.setNegativeButton((CharSequence)this.negativeButtonText, (DialogInterface.OnClickListener)string2);
            }
            builder2 = builder2.create();
            builder2.setOnShowListener(arg_0 -> this.lambda$show$1((AlertDialog)builder2, arg_0));
            if (!this.activity.isFinishing()) {
                builder2.show();
            }
            return builder2;
        }
    }
}

