/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import android.os.Build;
import android.util.Base64;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.encryption.StaticKeyProvider;
import com.instabug.library.encryption.c;
import com.instabug.library.encryption.iv.a;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EncryptionManager {
    @NotNull
    public static final EncryptionManager INSTANCE = new EncryptionManager();
    public static final int IV_V1 = 1;
    public static final int IV_V2 = 2;
    @NotNull
    private static final String AES_MODE = "AES/GCM/NoPadding";
    @NotNull
    private static final String ENCRYPTION_PREFIX = "^instaEncrypted^";
    @NotNull
    private static final String ENCRYPTION_NEW_LINE_REPLACEMENT = "^instaLINE^";
    private static final int IV_LENGTH = 128;
    @NotNull
    public static final String LINE_FEED = "\n\r";
    @NotNull
    private static final byte[] iv;

    private EncryptionManager() {
    }

    @JvmStatic
    @Nullable
    public static final String encryptWithStaticKey(@Nullable String data) {
        String string2;
        if (data != null) {
            Object object;
            block9: {
                String string3 = string2;
                object = INSTANCE;
                if (!StringsKt.startsWith$default((String)string3, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) break block9;
                return string2;
            }
            Cipher cipher = Cipher.getInstance(AES_MODE);
            Cipher cipher2 = cipher;
            String string4 = string2;
            object = ((EncryptionManager)object).getIvSpec();
            try {
                cipher2.init(1, StaticKeyProvider.a(), (AlgorithmParameterSpec)object);
                byte[] byArray = string4.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = cipher.doFinal(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data.toByteArray())");
                String string5 = Base64.encodeToString((byte[])byArray2, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeToString(cipherText, Base64.DEFAULT)");
                return StringsKt.replace$default((String)string5, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                NonFatals.reportNonFatalAndLog(outOfMemoryError, "OOM while encrypting string, returning original string", "IBG-Core");
            }
            catch (Exception exception) {
                NonFatals.reportNonFatalAndLog(exception, "Error while encrypting string, returning original string", "IBG-Core");
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String decryptWithStaticKey(@Nullable String data) {
        String string2;
        block11: {
            block10: {
                byte[] byArray;
                if (data == null) break block10;
                if (string2.length() == 0) {
                    return "";
                }
                Object object = INSTANCE;
                String string3 = StringsKt.replace$default((String)string2, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null);
                try {
                    byArray = Base64.decode((String)string3, (int)0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return string3;
                }
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n                Base64\u2026          )\n            }");
                Cipher cipher = Cipher.getInstance(AES_MODE);
                Cipher cipher2 = cipher;
                byte[] byArray2 = byArray;
                object = ((EncryptionManager)object).getIvSpec();
                cipher2.init(2, StaticKeyProvider.a(), (AlgorithmParameterSpec)object);
                object = cipher.doFinal(byArray2);
                try {
                    Object object2 = object;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"decryptedBytes");
                    Charset charset = Charset.forName("UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
                    return new String((byte[])object2, charset);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "OOM while decrypting string, returning original string");
                    NonFatals.reportNonFatal(outOfMemoryError, "OOM while decrypting string, returning original string");
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while decrypting string, returning original string");
                    NonFatals.reportNonFatal(exception, "Error: " + exception.getMessage() + "while decrypting string, returning original string");
                }
                break block11;
            }
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data) {
        return EncryptionManager.encrypt(data, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data, int ivVersion) {
        byte[] byArray;
        Object object;
        String string2;
        if (data == null) {
            return null;
        }
        try {
            void var1_1;
            Object object2 = INSTANCE;
            if (StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
                return string2;
            }
            object = Cipher.getInstance(AES_MODE);
            object2 = var1_1 == true ? ((EncryptionManager)object2).getIvSpec() : ((EncryptionManager)object2).getIvSpecV2();
            ((Cipher)object).init(1, c.a(), (AlgorithmParameterSpec)object2);
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = ((Cipher)object).doFinal(byArray2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "OOM while encrypting string, returning original string");
            NonFatals.reportNonFatal(outOfMemoryError, "OOM while encrypting string, returning original string");
            return string2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while encrypting string, returning original string");
            NonFatals.reportNonFatal(exception, "Error: " + exception.getMessage() + "while encrypting string, returning original string");
            return string2;
        }
        object = byArray;
        {
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data.toByteArray())");
            String string3 = Base64.encodeToString((byte[])object, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(cipherText, Base64.DEFAULT)");
            return Intrinsics.stringPlus((String)ENCRYPTION_PREFIX, (Object)StringsKt.replace$default((String)string3, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null));
        }
    }

    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data) {
        return EncryptionManager.decrypt(data, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data, int ivVersion) {
        byte[] byArray;
        String string2;
        if (data == null) {
            return null;
        }
        if (string2.length() == 0) {
            return "";
        }
        boolean bl = false;
        if (bl) {
            return "";
        }
        Object object = INSTANCE;
        if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
            return string2;
        }
        String string3 = string2;
        Object object2 = string3.substring(16, string3.length());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        try {
            byArray = Base64.decode((String)StringsKt.replace$default((String)object2, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null), (int)0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object2;
        }
        {
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n                Base64\u2026          )\n            }");
        }
        try {
            void var1_1;
            object2 = Cipher.getInstance(AES_MODE);
            object = var1_1 == true ? ((EncryptionManager)object).getIvSpec() : ((EncryptionManager)object).getIvSpecV2();
            ((Cipher)object2).init(2, c.a(), (AlgorithmParameterSpec)object);
            Object object3 = object2 = (Object)((Cipher)object2).doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"decryptedBytes");
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
            return new String((byte[])object3, charset);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "OOM while decrypting string, returning original string");
            NonFatals.reportNonFatal(outOfMemoryError, "OOM while decrypting string, returning original string");
            return string2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while decrypting string, returning original string");
            NonFatals.reportNonFatal(exception, "Error: " + exception.getMessage() + "while decrypting string, returning original string");
            return string2;
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        EncryptionManager encryptionManager = INSTANCE;
        Cipher cipher = Cipher.getInstance(AES_MODE);
        int n2 = 1;
        Key key = c.a();
        AlgorithmParameterSpec algorithmParameterSpec = encryptionManager.getIvSpec();
        cipher.init(n2, key, algorithmParameterSpec);
        byte[] byArray2 = cipher.doFinal(byArray);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            val cipher\u2026r.doFinal(data)\n        }");
            byArray = byArray2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while encrypting bytes");
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        EncryptionManager encryptionManager;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            encryptionManager = INSTANCE;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while decrypting bytes");
            return byArray;
        }
        Cipher cipher = Cipher.getInstance(AES_MODE);
        int n2 = 2;
        Key key = c.a();
        AlgorithmParameterSpec algorithmParameterSpec = encryptionManager.getIvSpec();
        cipher.init(n2, key, algorithmParameterSpec);
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data)");
        return byArray2;
    }

    private final AlgorithmParameterSpec getIvSpec() {
        Object object;
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            object = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(96, iv);
        } else {
            IvParameterSpec ivParameterSpec;
            object = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(iv);
        }
        return object;
    }

    private final synchronized AlgorithmParameterSpec getIvSpecV2() {
        AlgorithmParameterSpec algorithmParameterSpec;
        Object object = a.a();
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            algorithmParameterSpec = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(128, (byte[])object);
        } else {
            IvParameterSpec ivParameterSpec;
            algorithmParameterSpec = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec((byte[])object);
        }
        return algorithmParameterSpec;
    }

    static {
        byte[] byArray = "RandomAESIv1".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        iv = byArray;
    }

    @NotNull
    public final byte[] getIv() {
        return iv;
    }
}

