/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.internal.storage.operation.ReadStateFromFileDiskOperation;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.logging.d;
import com.instabug.library.model.a;
import com.instabug.library.model.b;
import com.instabug.library.model.p;
import com.instabug.library.q;
import com.instabug.library.sessionprofiler.model.timeline.e;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.TokenMappingServiceLocator;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.tracking.a0;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.f;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.visualusersteps.VisualUserStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_TOKEN = "application_token";
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    private static final String KEY_BATTERY_LEVEL = "battery_level";
    private static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_NAME = "name";
    public static final String KEY_PUSH_TOKEN = "push_token";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    private static final String KEY_MEMORY_FREE = "memory_free";
    private static final String KEY_MEMORY_TOTAL = "memory_total";
    private static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    public static final String KEY_SESSIONS_PROFILER = "sessions_profiler";
    private static final String KEY_APP_STATUS = "app_status";
    public static final String KEY_EXPERIMENTS = "experiments";
    public static final String KEY_DEVICE_ARCHITECTURE = "device_architecture";
    public static final String UUID = "UUID";
    public static final String KEY_CURRENT_ACTIVITY = "current_activity";
    public static final String KEY_ACTIVITY_NAME = "activity_name";
    private static final String ACTIVITY_NAME_FALLBACK = "NA";
    private static final String CURRENT_VIEW_FALLBACK = "NA";
    private static final String[] USER_DATA_KEYS = new String[]{"user_attributes", "email", "name", "push_token"};
    private static final String BUILD_PERCENTAGE = "build_percentage";
    private static final String APP_LAUNCH_ID = "app_launch_id";
    private static final float FULL_STATE_PERCENTAGE = 1.0f;
    @VisibleForTesting
    static final String VALUE_APP_STATUS_FOREGROUND = "foreground";
    @VisibleForTesting
    static final String VALUE_APP_STATUS_BACKGROUND = "background";
    private long duration;
    private boolean isDeviceRooted;
    private int batteryLevel;
    private boolean wifiState;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    public long freeStorage;
    private long totalStorage;
    @Nullable
    private String sdkVersion;
    @Nullable
    private String locale;
    @Nullable
    private String device;
    @Nullable
    private String OS;
    @Nullable
    private String carrier;
    @Nullable
    private String appPackageName;
    @Nullable
    private String appVersion;
    @Nullable
    private String batteryState;
    @Nullable
    private String screenDensity;
    @Nullable
    private String screenSize;
    @Nullable
    private String ScreenOrientation;
    @Nullable
    private String currentView;
    @Nullable
    private String instabugLog;
    @Nullable
    private List<String> consoleLog;
    @Nullable
    private List<p> userSteps;
    @Nullable
    private ArrayList<VisualUserStep> visualUserSteps;
    @Nullable
    private e sessionProfilerTimeline;
    @Nullable
    private String userEmail;
    @Nullable
    private String userName;
    @Nullable
    private String pushToken;
    @Nullable
    private String userData;
    private long reportedAt;
    @Nullable
    private String tags;
    @Nullable
    private String networkLogs;
    @Nullable
    private String userAttributes;
    @Nullable
    private String userEvents;
    @Nullable
    private Uri uri;
    @Nullable
    private String appStatus;
    @Nullable
    private String customUserAttribute;
    @Nullable
    private List<String> experiments;
    @Nullable
    private String deviceArchitecture;
    @Nullable
    private String uuid;
    @Nullable
    private String currentActivity;
    private boolean isMinimalState;
    private float buildPercentage = 1.0f;
    @Nullable
    private String appToken;
    @Nullable
    private String appLaunchId;

    public static State getState(Context context) {
        return State.getState(context, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static State getState(Context context, float percentage) {
        void var1_1;
        Context context2;
        return new Builder(context2).build(true, true, (float)var1_1);
    }

    public static State getNonChangingState(Context context) {
        Context context2;
        new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(context2)).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setAppVersion(DeviceStateProvider.getAppVersion(context2)).setAppPackageName(DeviceStateProvider.getAppPackageName(context2)).setScreenDensity(DeviceStateProvider.getScreenDensity(context2)).setScreenSize(DeviceStateProvider.getScreenSize(context2)).setCurrentView("NA").setCurrentActivity("NA").setReportedAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setDeviceArchitecture(DeviceStateProvider.getDeviceArchitecture()).setUuid(f.k()).setAppToken(TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken()).isMinimalState = true;
        return new State().setSdkVersion(DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(context2)).setDevice(DeviceStateProvider.getDevice()).setIsDeviceRooted(DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setAppVersion(DeviceStateProvider.getAppVersion(context2)).setAppPackageName(DeviceStateProvider.getAppPackageName(context2)).setScreenDensity(DeviceStateProvider.getScreenDensity(context2)).setScreenSize(DeviceStateProvider.getScreenSize(context2)).setCurrentView("NA").setCurrentActivity("NA").setReportedAt(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).setDeviceArchitecture(DeviceStateProvider.getDeviceArchitecture()).setUuid(f.k()).setAppToken(TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken());
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static State getState(Context context, @Nullable Uri uri) {
        void var1_1;
        Context context2;
        block8: {
            if (uri != null) {
                void var2_5;
                String string2 = DiskUtils.with(context2).readOperation(new ReadStateFromFileDiskOperation((Uri)var1_1)).execute();
                String string3 = string2.trim();
                if (string3.equals("{}")) break block8;
                if (string3.isEmpty()) break block8;
                try {
                    State state = new State();
                    state.setUri((Uri)var1_1);
                    state.fromJson(string2);
                    return state;
                }
                catch (Exception exception) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                InstabugCore.reportError((Throwable)var2_5, "retrieving state throws an exception, falling back to non-changing");
                InstabugSDKLogger.e("IBG-Core", "Retrieving state throws an exception, falling back to non-changing", (Throwable)var2_5);
            }
        }
        State state = State.getNonChangingState(context2);
        state.setUri((Uri)var1_1);
        return state;
    }

    /*
     * WARNING - void declaration
     */
    private State setSdkVersion(String sdkVersion) {
        void var1_1;
        this.sdkVersion = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setIsDeviceRooted(boolean isDeviceRooted) {
        void var1_1;
        this.isDeviceRooted = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setWifiState(boolean wifiState) {
        void var1_1;
        this.wifiState = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setUsedMemory(long usedMemory) {
        void var1_1;
        this.usedMemory = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setUsedStorage(long usedStorage) {
        void var1_1;
        this.usedStorage = var1_1;
        return this;
    }

    private long getFreeStorage() {
        return this.freeStorage;
    }

    /*
     * WARNING - void declaration
     */
    private State setFreeStorage(long freeStorage) {
        void var1_1;
        this.freeStorage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setTotalStorage(long totalStorage) {
        void var1_1;
        this.totalStorage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setAppStatus(String appStatus) {
        void var1_1;
        this.appStatus = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setConsoleLog(@Nullable List<String> consoleLogs) {
        void var1_1;
        this.consoleLog = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private State setReportedAt(long reportedAt) {
        void var1_1;
        this.reportedAt = var1_1;
        return this;
    }

    private static String getTagsAsString(List<String> tags) {
        List<String> list;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (tags != null && list.size() > 0) {
            int n10 = list.size();
            for (int i10 = 0; i10 < n10; ++i10) {
                stringBuilder2.append(list.get(i10));
                if (i10 == n10 - 1) continue;
                stringBuilder2.append(", ");
            }
        }
        return stringBuilder2.toString();
    }

    @Nullable
    private String getSessionProfilerTimeline() {
        Serializable this_ = ((State)this_).sessionProfilerTimeline;
        return this_ == null ? null : ((e)this_).b().toString();
    }

    @Nullable
    private String getDeviceArchitecture() {
        return this.deviceArchitecture;
    }

    public static String[] getUserDataKeys() {
        return (String[])USER_DATA_KEYS.clone();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private String getActivityNameFromJson(JSONObject stateJson) {
        void var1_1;
        if (stateJson.has(KEY_ACTIVITY_NAME)) {
            return var1_1.optString(KEY_ACTIVITY_NAME, "NA");
        }
        if (var1_1.has(KEY_CURRENT_ACTIVITY)) {
            return var1_1.optString(KEY_CURRENT_ACTIVITY, "NA");
        }
        return "NA";
    }

    private void retrieveConsoleLogs(JSONObject stateJsonObject) throws JSONException {
        LinkedList<String> linkedList;
        LinkedList<String> linkedList2;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray(linkedList2.getString(KEY_CONSOLE_LOG));
        linkedList2 = linkedList;
        linkedList = new LinkedList<String>();
        for (int i10 = 0; i10 < jSONArray2.length(); ++i10) {
            linkedList2.add(jSONArray2.optString(i10));
        }
        this.setConsoleLog(linkedList2);
    }

    private String getConsoleLogsForSync() {
        JSONArray jSONArray = this.getConsoleLog();
        b.a(jSONArray);
        return jSONArray.toString();
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<StateItem> getLogsItems(boolean forSync) {
        void var1_1;
        ArrayList<StateItem> arrayList;
        ArrayList<StateItem> arrayList2;
        ArrayList<StateItem> arrayList3 = arrayList2 = arrayList;
        arrayList3();
        this.addConsoleLogsItem(arrayList3, (boolean)var1_1);
        arrayList.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (this.visualUserSteps != null) {
            arrayList2.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        Feature.State state = Feature.State.ENABLED;
        if (q.c().b((Object)"TRACK_USER_STEPS") == state) {
            arrayList2.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (q.c().b((Object)"SESSION_PROFILER") == state && this.sessionProfilerTimeline != null) {
            arrayList2.add(new StateItem().setKey(KEY_SESSIONS_PROFILER).setValue(this.getSessionProfilerTimeline()));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private void addConsoleLogsItem(@NonNull ArrayList<StateItem> logsItems, boolean forSync) {
        void var1_1;
        String string2 = forSync ? ((State)((Object)string2)).getConsoleLogsForSync() : ((State)((Object)string2)).getConsoleLog().toString();
        var1_1.add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(string2));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$200(State x02, String x12) {
        void var1_1;
        return x02.setSdkVersion((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$300(State x02, boolean x12) {
        void var1_1;
        return x02.setIsDeviceRooted((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$400(State x02, String x12) {
        void var1_1;
        return x02.setAppStatus((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$500(State x02, boolean x12) {
        void var1_1;
        return x02.setWifiState((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$600(State x02, long x12) {
        void var1_1;
        return x02.setUsedMemory((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$700(State x02, long x12) {
        void var1_1;
        return x02.setFreeStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$800(State x02, long x12) {
        void var1_1;
        return x02.setUsedStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$900(State x02, long x12) {
        void var1_1;
        return x02.setTotalStorage((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1000(State x02, long x12) {
        void var1_1;
        return x02.setReportedAt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$1100(State x02, List x12) {
        void var1_1;
        return x02.setConsoleLog((List<String>)var1_1);
    }

    @Nullable
    public String getCustomUserAttribute() {
        return this.customUserAttribute;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomUserAttribute(@Nullable String customUserAttribute) {
        void var1_1;
        this.customUserAttribute = var1_1;
    }

    @Nullable
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    /*
     * WARNING - void declaration
     */
    public State setLocale(String locale) {
        void var1_1;
        this.locale = var1_1;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    /*
     * WARNING - void declaration
     */
    public State setDuration(long duration) {
        void var1_1;
        this.duration = var1_1;
        return this;
    }

    @Nullable
    public String getDevice() {
        return this.device;
    }

    /*
     * WARNING - void declaration
     */
    public State setDevice(String device) {
        void var1_1;
        this.device = var1_1;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    @Nullable
    public String getOS() {
        return this.OS;
    }

    /*
     * WARNING - void declaration
     */
    public State setOS(String OS) {
        void var1_1;
        this.OS = var1_1;
        return this;
    }

    @Nullable
    public String getCarrier() {
        return this.carrier;
    }

    /*
     * WARNING - void declaration
     */
    public State setCarrier(String carrier) {
        void var1_1;
        this.carrier = var1_1;
        return this;
    }

    @Nullable
    public String getAppPackageName() {
        return this.appPackageName;
    }

    /*
     * WARNING - void declaration
     */
    public State setAppPackageName(String appPackageName) {
        void var1_1;
        this.appPackageName = var1_1;
        return this;
    }

    @Nullable
    public String getAppVersion() {
        return this.appVersion;
    }

    /*
     * WARNING - void declaration
     */
    public State setAppVersion(String appVersion) {
        void var1_1;
        this.appVersion = var1_1;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public void setUri(@Nullable Uri uri) {
        void var1_1;
        this.uri = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public State setBatteryLevel(int batteryLevel) {
        void var1_1;
        this.batteryLevel = var1_1;
        return this;
    }

    @Nullable
    public String getBatteryState() {
        return this.batteryState;
    }

    /*
     * WARNING - void declaration
     */
    public State setBatteryState(String batteryState) {
        void var1_1;
        this.batteryState = var1_1;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    /*
     * WARNING - void declaration
     */
    public State setFreeMemory(long freeMemory) {
        void var1_1;
        this.freeMemory = var1_1;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    /*
     * WARNING - void declaration
     */
    public State setTotalMemory(long totalMemory) {
        void var1_1;
        this.totalMemory = var1_1;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    @Nullable
    public String getScreenDensity() {
        return this.screenDensity;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenDensity(String screenDensity) {
        void var1_1;
        this.screenDensity = var1_1;
        return this;
    }

    @Nullable
    public String getScreenSize() {
        return this.screenSize;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenSize(String screenSize) {
        void var1_1;
        this.screenSize = var1_1;
        return this;
    }

    @Nullable
    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    /*
     * WARNING - void declaration
     */
    public State setScreenOrientation(String screenOrientation) {
        void var1_1;
        this.ScreenOrientation = var1_1;
        return this;
    }

    @Nullable
    public String getCurrentView() {
        return this.currentView;
    }

    /*
     * WARNING - void declaration
     */
    public State setCurrentView(String currentView) {
        void var1_1;
        this.currentView = var1_1;
        return this;
    }

    @Nullable
    public String getAppStatus() {
        return this.appStatus;
    }

    public State setAppStatusToBackground() {
        State state = this;
        state.setAppStatus(VALUE_APP_STATUS_BACKGROUND);
        return state;
    }

    @Nullable
    public String getInstabugLog() {
        return this.instabugLog;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugLog(@Nullable String instabugLog) {
        void var1_1;
        this.instabugLog = var1_1;
    }

    public void updateConsoleLog() {
        State state = this;
        state.setConsoleLog(Builder.getConsoleLog(state.buildPercentage));
    }

    public void updateConsoleLog(ArrayList<a> logs) {
        Iterator iterator;
        List list = Builder.getConsoleLog(this.buildPercentage);
        if (list == null) {
            LinkedList linkedList;
            list = linkedList;
            linkedList = new LinkedList();
        }
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            try {
                list.add(((a)iterator.next()).toJson());
            }
            catch (Throwable throwable) {
                InstabugSDKLogger.e("IBG-Core", "couldn't add user console logs", throwable);
            }
        }
        this.setConsoleLog(list);
    }

    public JSONArray getConsoleLog() {
        block3: {
            if (this.consoleLog == null) break block3;
            try {
                return new JSONArray(this.consoleLog);
            }
            catch (Throwable throwable) {
                InstabugSDKLogger.e("IBG-Core", "couldn't add user console logs", throwable);
                IBGDiagnostics.reportNonFatal(throwable, "couldn't add user console logs");
            }
        }
        return new JSONArray();
    }

    public JSONArray getUserSteps() {
        return p.a(this.userSteps);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public State setUserSteps(List<p> userSteps) {
        void var1_1;
        this.userSteps = var1_1;
        return this;
    }

    @Nullable
    public String getUserEmail() {
        return this.userEmail;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserEmail(String userEmail) {
        void var1_1;
        this.userEmail = var1_1;
        return this;
    }

    @Nullable
    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserName(@Nullable String userName) {
        void var1_1;
        this.userName = var1_1;
        return this;
    }

    public State updateIdentificationAttrs() {
        String string2 = this.userEmail;
        if (string2 == null || string2.isEmpty()) {
            this.setUserEmail(f.n());
        }
        if ((string2 = this.userName) == null || string2.isEmpty()) {
            this.setUserName(f.o());
        }
        return this;
    }

    @Nullable
    public String getPushToken() {
        return this.pushToken;
    }

    /*
     * WARNING - void declaration
     */
    public State setPushToken(@Nullable String pushToken) {
        void var1_1;
        this.pushToken = var1_1;
        return this;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserData(String userData) {
        void var1_1;
        this.userData = var1_1;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    @Nullable
    public String getTags() {
        return this.tags;
    }

    /*
     * WARNING - void declaration
     */
    public State setTags(String tags) {
        void var1_1;
        this.tags = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setTags(List<String> tags) {
        void var1_1;
        this.tags = State.getTagsAsString((List<String>)var1_1);
        return this;
    }

    @Nullable
    public String getUserAttributes() {
        return this.userAttributes;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserAttributes(String userAttributes) {
        void var1_1;
        this.userAttributes = var1_1;
        return this;
    }

    @Nullable
    public String getNetworkLogs() {
        return this.networkLogs;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public State setNetworkLogs(@Nullable String networkLogs) {
        void var1_1;
        this.networkLogs = var1_1;
        return this;
    }

    @Nullable
    public String getUserEvents() {
        return this.userEvents;
    }

    /*
     * WARNING - void declaration
     */
    public State setUserEvents(String userEvents) {
        void var1_1;
        this.userEvents = var1_1;
        return this;
    }

    public void updateUserEvents() throws JSONException {
        this.setUserEvents(UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents(this.buildPercentage)).toString());
    }

    public String getVisualUserSteps() {
        return VisualUserStep.toJsonString(this.visualUserSteps);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public void setVisualUserSteps(@Nullable ArrayList<VisualUserStep> visualUserSteps) {
        void var1_1;
        this.visualUserSteps = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public State setSessionProfilerTimeline(e sessionProfilerTimeline) {
        void var1_1;
        this.sessionProfilerTimeline = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setExperiments(@Nullable List<String> experiments) {
        void var1_1;
        this.experiments = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setDeviceArchitecture(@Nullable String deviceArchitecture) {
        void var1_1;
        this.deviceArchitecture = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setUuid(@Nullable String uuid) {
        void var1_1;
        this.uuid = var1_1;
        return this;
    }

    @NonNull
    public String getCurrentActivityName() {
        Object this_ = ((State)this_).currentActivity;
        if (this_ == null) {
            this_ = "NA";
        }
        return this_;
    }

    @Nullable
    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public List<String> getExperiments() {
        return this.experiments;
    }

    public ArrayList<StateItem> getStateItems() {
        ArrayList<StateItem> arrayList;
        ArrayList<StateItem> arrayList2 = arrayList;
        arrayList = new ArrayList<StateItem>();
        if (!((State)((Object)this_)).isMinimalState) {
            ArrayList<StateItem> arrayList3 = arrayList2;
            arrayList3.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(((State)((Object)this_)).getBatteryLevel()));
            arrayList3.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(((State)((Object)this_)).getBatteryState()));
            arrayList3.add(new StateItem().setKey(KEY_CARRIER).setValue(((State)((Object)this_)).getCarrier()));
            arrayList3.add(new StateItem().setKey(KEY_EMAIL).setValue(((State)((Object)this_)).getUserEmail()));
            arrayList3.add(new StateItem().setKey(KEY_NAME).setValue(((State)((Object)this_)).getUserName()));
            arrayList3.add(new StateItem().setKey(KEY_PUSH_TOKEN).setValue(((State)((Object)this_)).getPushToken()));
            arrayList3.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(((State)((Object)this_)).getFreeMemory()));
            arrayList3.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(((State)((Object)this_)).getTotalMemory()));
            arrayList3.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(((State)((Object)this_)).getUsedMemory()));
            arrayList3.add(new StateItem().setKey(KEY_ORIENTATION).setValue(((State)((Object)this_)).getScreenOrientation()));
            arrayList3.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(((State)((Object)this_)).getFreeStorage()));
            arrayList3.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(((State)((Object)this_)).getTotalStorage()));
            arrayList3.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(((State)((Object)this_)).getUsedStorage()));
            arrayList3.add(new StateItem().setKey(KEY_TAGS).setValue(((State)((Object)this_)).getTags()));
            arrayList3.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(((State)((Object)this_)).isWifiEnable()));
            arrayList3.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(((State)((Object)this_)).getUserAttributes()));
            arrayList3.add(new StateItem().setKey(KEY_APP_STATUS).setValue(((State)((Object)this_)).getAppStatus()));
            JSONArray jSONArray = ((State)((Object)this_)).getExperiments();
            if (jSONArray != null && !jSONArray.isEmpty()) {
                JSONArray jSONArray2;
                JSONArray jSONArray3 = jSONArray;
                jSONArray = jSONArray2;
                jSONArray2 = new JSONArray();
                Iterator iterator = jSONArray3.iterator();
                while (iterator.hasNext()) {
                    jSONArray.put((Object)((String)iterator.next()));
                }
                arrayList2.add(new StateItem().setKey(KEY_EXPERIMENTS).setValue(jSONArray));
            }
        }
        ArrayList<StateItem> arrayList4 = arrayList2;
        arrayList4.add(new StateItem().setKey(KEY_ACTIVITY_NAME).setValue(((State)((Object)this_)).getCurrentActivityName()));
        arrayList4.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(((State)((Object)this_)).getAppPackageName()));
        arrayList4.add(new StateItem().setKey(KEY_APP_VERSION).setValue(((State)((Object)this_)).getAppVersion()));
        arrayList4.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(((State)((Object)this_)).getCurrentView()));
        arrayList4.add(new StateItem().setKey(KEY_DENSITY).setValue(((State)((Object)this_)).getScreenDensity()));
        arrayList4.add(new StateItem().setKey(KEY_DEVICE).setValue(((State)((Object)this_)).getDevice()));
        arrayList4.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(((State)((Object)this_)).isDeviceRooted()));
        arrayList4.add(new StateItem().setKey(KEY_DURATION).setValue(((State)((Object)this_)).getDuration()));
        arrayList4.add(new StateItem().setKey(KEY_LOCALE).setValue(((State)((Object)this_)).getLocale()));
        arrayList4.add(new StateItem().setKey(KEY_OS).setValue(((State)((Object)this_)).getOS()));
        arrayList4.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(((State)((Object)this_)).getReportedAt()));
        arrayList4.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(((State)((Object)this_)).getScreenSize()));
        arrayList4.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(((State)((Object)this_)).getSdkVersion()));
        String this_ = ((State)((Object)this_)).getDeviceArchitecture();
        if (this_ != null && !this_.isEmpty()) {
            arrayList2.add(new StateItem().setKey(KEY_DEVICE_ARCHITECTURE).setValue(this_));
        }
        return arrayList2;
    }

    public double getBuildPercentage() {
        return this.buildPercentage;
    }

    /*
     * WARNING - void declaration
     */
    public State setBuildPercentage(float percentage) {
        void var1_1;
        this.buildPercentage = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public State setCurrentActivity(String currentActivity) {
        void var1_1;
        this.currentActivity = var1_1;
        return this;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        double d10;
        String string2;
        JSONObject jSONObject;
        State state;
        JSONObject jSONObject2;
        State state2;
        JSONObject jSONObject3;
        JSONObject jSONObject4;
        String string3;
        JSONObject jSONObject5;
        State state3 = this_;
        JSONObject jSONObject6 = jSONObject5;
        jSONObject5 = new JSONObject();
        ArrayList<StateItem> arrayList = state3.getStateItems();
        int n10 = 0;
        while (true) {
            block21: {
                if (n10 >= arrayList.size()) break;
                string3 = arrayList.get(n10).getKey();
                if (string3 == null) break block21;
                jSONObject6.put(string3, ((StateItem)arrayList.get(n10)).getValue());
            }
            ++n10;
        }
        State state4 = this_;
        JSONObject jSONObject7 = jSONObject6;
        State state5 = this_;
        arrayList = UUID;
        jSONObject7.put((String)((Object)arrayList), (Object)state5.uuid);
        arrayList = state4.getLogsItems(false);
        n10 = 0;
        while (true) {
            block22: {
                if (n10 >= arrayList.size()) break;
                string3 = arrayList.get(n10).getKey();
                if (string3 == null) break block22;
                jSONObject6.put(string3, arrayList.get(n10).getValue());
            }
            ++n10;
        }
        try {
            JSONObject jSONObject8 = jSONObject6;
            jSONObject4 = jSONObject8;
            jSONObject3 = jSONObject8;
            state2 = this_;
            jSONObject2 = jSONObject6;
            state = this_;
            jSONObject = jSONObject6;
            string2 = BUILD_PERCENTAGE;
            d10 = ((State)this_).buildPercentage;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "Could create state json string, OOM", outOfMemoryError);
            return new JSONObject().toString();
        }
        jSONObject.put(string2, d10);
        Object this_ = KEY_APP_TOKEN;
        jSONObject2.put((String)this_, (Object)state.appToken);
        this_ = APP_LAUNCH_ID;
        jSONObject4.put((String)this_, (Object)state2.appLaunchId);
        return jSONObject3.toString();
    }

    @Override
    public void fromJson(String stateAsJson) throws JSONException {
        JSONArray jSONArray;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject((String)jSONArray).has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(jSONObject2.getString(KEY_APP_PACKAGE_NAME));
        }
        if (jSONObject2.has(KEY_APP_VERSION)) {
            this.setAppVersion(jSONObject2.getString(KEY_APP_VERSION));
        }
        if (jSONObject2.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(jSONObject2.getInt(KEY_BATTERY_LEVEL));
        }
        if (jSONObject2.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(jSONObject2.getString(KEY_BATTERY_STATUS));
        }
        if (jSONObject2.has(KEY_CARRIER)) {
            this.setCarrier(jSONObject2.getString(KEY_CARRIER));
        }
        if (jSONObject2.has(KEY_CONSOLE_LOG)) {
            this.retrieveConsoleLogs(jSONObject2);
        }
        if (jSONObject2.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(jSONObject2.getString(KEY_CURRENT_VIEW));
        }
        if (jSONObject2.has(KEY_DENSITY)) {
            this.setScreenDensity(jSONObject2.getString(KEY_DENSITY));
        }
        if (jSONObject2.has(KEY_DEVICE)) {
            this.setDevice(jSONObject2.getString(KEY_DEVICE));
        }
        if (jSONObject2.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(jSONObject2.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (jSONObject2.has(KEY_DURATION)) {
            this.setDuration(jSONObject2.getLong(KEY_DURATION));
        }
        if (jSONObject2.has(KEY_EMAIL)) {
            this.setUserEmail(jSONObject2.getString(KEY_EMAIL));
        }
        if (jSONObject2.has(KEY_NAME)) {
            this.setUserName(jSONObject2.getString(KEY_NAME));
        }
        if (jSONObject2.has(KEY_PUSH_TOKEN)) {
            this.setPushToken(jSONObject2.getString(KEY_PUSH_TOKEN));
        }
        if (jSONObject2.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(jSONObject2.getString(KEY_INSTABUG_LOG));
        }
        if (jSONObject2.has(KEY_LOCALE)) {
            this.setLocale(jSONObject2.getString(KEY_LOCALE));
        }
        if (jSONObject2.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(jSONObject2.getLong(KEY_MEMORY_FREE));
        }
        if (jSONObject2.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(jSONObject2.getLong(KEY_MEMORY_TOTAL));
        }
        if (jSONObject2.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(jSONObject2.getLong(KEY_MEMORY_USED));
        }
        if (jSONObject2.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(jSONObject2.getString(KEY_ORIENTATION));
        }
        if (jSONObject2.has(KEY_OS)) {
            this.setOS(jSONObject2.getString(KEY_OS));
        }
        if (jSONObject2.has(KEY_APP_STATUS)) {
            this.setAppStatus(jSONObject2.getString(KEY_APP_STATUS));
        }
        if (jSONObject2.has(KEY_REPORTED_AT)) {
            this.setReportedAt(jSONObject2.getLong(KEY_REPORTED_AT));
        }
        if (jSONObject2.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(jSONObject2.getString(KEY_SCREEN_SIZE));
        }
        if (jSONObject2.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(jSONObject2.getString(KEY_SDK_VERSION));
        }
        if (jSONObject2.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(jSONObject2.getLong(KEY_STORAGE_FREE));
        }
        if (jSONObject2.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(jSONObject2.getLong(KEY_STORAGE_TOTAL));
        }
        if (jSONObject2.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(jSONObject2.getLong(KEY_STORAGE_USED));
        }
        if (jSONObject2.has(KEY_TAGS)) {
            this.setTags(jSONObject2.getString(KEY_TAGS));
        }
        if (jSONObject2.has(KEY_USER_DATA)) {
            this.setUserData(jSONObject2.getString(KEY_USER_DATA));
        }
        if (jSONObject2.has(KEY_USER_STEPS)) {
            this.setUserSteps(p.a(new JSONArray(jSONObject2.getString(KEY_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_WIFI_STATE)) {
            this.setWifiState(jSONObject2.getBoolean(KEY_WIFI_STATE));
        }
        if (jSONObject2.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(jSONObject2.getString(KEY_USER_ATTRIBUTES));
        }
        if (jSONObject2.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(jSONObject2.getString(KEY_NETWORK_LOGS));
        }
        if (jSONObject2.has(KEY_USER_EVENTS)) {
            this.setUserEvents(jSONObject2.getString(KEY_USER_EVENTS));
        }
        if (jSONObject2.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(VisualUserStep.fromJson(new JSONArray(jSONObject2.getString(KEY_VISUAL_USER_STEPS))));
        }
        if (jSONObject2.has(KEY_SESSIONS_PROFILER)) {
            this.setSessionProfilerTimeline(e.a(new JSONObject(jSONObject2.getString(KEY_SESSIONS_PROFILER))));
        }
        if (jSONObject2.has(KEY_EXPERIMENTS)) {
            ArrayList<String> arrayList;
            jSONArray = jSONObject2.getJSONArray(KEY_EXPERIMENTS);
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>();
            for (int i10 = 0; i10 < jSONArray.length(); ++i10) {
                arrayList2.add((String)jSONArray.get(i10));
            }
            this.setExperiments(arrayList2);
        }
        if (jSONObject2.has(BUILD_PERCENTAGE)) {
            this.setBuildPercentage((float)jSONObject2.getDouble(BUILD_PERCENTAGE));
        }
        State state = this;
        State state2 = this;
        state2.setCurrentActivity(state2.getActivityNameFromJson(jSONObject2));
        state.setDeviceArchitecture(jSONObject2.optString(KEY_DEVICE_ARCHITECTURE));
        this.setUuid(jSONObject2.optString(state.uuid));
        if (jSONObject2.has(KEY_APP_TOKEN)) {
            this.setAppToken(jSONObject2.getString(KEY_APP_TOKEN));
        }
        if (jSONObject2.has(APP_LAUNCH_ID)) {
            this.setAppLaunchId(jSONObject2.getString(APP_LAUNCH_ID));
        }
    }

    public ArrayList<StateItem> getLogsItems() {
        return this.getLogsItems(true);
    }

    @NonNull
    public String toString() {
        try {
            return this_.toJson();
        }
        catch (JSONException jSONException) {
            Object this_ = jSONException;
            jSONException.printStackTrace();
            InstabugSDKLogger.e("IBG-Core", "Something went wrong while getting state.toString()" + this_.getMessage(), (Throwable)this_);
            return "error";
        }
    }

    @SuppressLint(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object state) {
        State state2;
        if (state == null) {
            return false;
        }
        if (state2 instanceof State) {
            return String.valueOf((state2 = (State)state2).getAppVersion()).equals(String.valueOf(this.getAppVersion())) && state2.getBatteryLevel() == this.getBatteryLevel() && String.valueOf(state2.getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(state2.getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(state2.getAppStatus()).equals(String.valueOf(this.getAppStatus())) && String.valueOf(state2.getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(state2.getCurrentView()).equals(String.valueOf(this.getCurrentView())) && state2.getDuration() == this.getDuration() && String.valueOf(state2.getDevice()).equals(String.valueOf(this.getDevice())) && state2.getFreeMemory() == this.getFreeMemory() && state2.getFreeStorage() == this.getFreeStorage() && String.valueOf(state2.getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(state2.getOS()).equals(String.valueOf(this.getOS())) && state2.getReportedAt() == this.getReportedAt() && String.valueOf(state2.getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(state2.getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(state2.getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(state2.getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && state2.getTotalMemory() == this.getTotalMemory() && state2.getTotalStorage() == this.getTotalStorage() && String.valueOf(state2.getTags()).equals(String.valueOf(this.getTags())) && state2.getUsedMemory() == this.getUsedMemory() && state2.getUsedStorage() == this.getUsedStorage() && String.valueOf(state2.getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(state2.getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(state2.getUserName()).equals(String.valueOf(this.getUserName())) && String.valueOf(state2.getPushToken()).equals(String.valueOf(this.getPushToken())) && String.valueOf(state2.getUserSteps()).equals(String.valueOf(this.getUserSteps())) && state2.isDeviceRooted() == this.isDeviceRooted() && state2.isWifiEnable() == this.isWifiEnable() && String.valueOf(state2.getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(state2.getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(state2.getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(state2.getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(state2.getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps())) && String.valueOf(state2.getSessionProfilerTimeline()).equals(String.valueOf(this.getSessionProfilerTimeline()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public void updateVisualUserSteps() {
        this.setVisualUserSteps(Builder.getVisualUserSteps());
    }

    /*
     * WARNING - void declaration
     */
    public void setAppLaunchId(@Nullable String appLaunchId) {
        void var1_1;
        this.appLaunchId = var1_1;
    }

    @Nullable
    public String getAppLaunchId() {
        return this.appLaunchId;
    }

    public boolean isMinimalState() {
        return this.isMinimalState;
    }

    @Nullable
    public String getAppToken() {
        return this.appToken;
    }

    /*
     * WARNING - void declaration
     */
    public State setAppToken(@Nullable String appToken) {
        void var1_1;
        this.appToken = var1_1;
        return this;
    }

    public static class Builder
    implements Serializable {
        private Context context;

        /*
         * WARNING - void declaration
         */
        public Builder(Context context) {
            void var1_1;
            this.context = var1_1;
        }

        @Nullable
        private static List<String> getConsoleLog(float percentage) {
            return a.a(percentage);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private List<String> getExperiments(float percentage) {
            void var1_1;
            List list = com.instabug.library.experiments.di.a.c().a((float)var1_1);
            int n10 = Math.round((float)com.instabug.library.experiments.di.a.d() * var1_1);
            if (list != null && list.size() > n10) {
                while (list.size() > 0 && list.size() > n10) {
                    list.remove(0);
                }
                return list;
            }
            return list;
        }

        @Nullable
        private String getInstabugLog() {
            block4: {
                if (!MemoryUtils.isLowMemory(this.context)) {
                    try {
                        if (q.c().b((Object)"INSTABUG_LOGS") != Feature.State.ENABLED) break block4;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugCore.reportError(outOfMemoryError, "Got error while parsing Instabug Logs");
                        InstabugSDKLogger.e("IBG-Core", "Got error while parsing Instabug Logs", outOfMemoryError);
                        break block4;
                    }
                    return InstabugLog.getLogs();
                }
                InstabugSDKLogger.e("IBG-Core", "Running low on memory. Excluding Instabug Logs serialization from state builder.");
            }
            return null;
        }

        private List<p> getUserSteps(float percentage) {
            ArrayList arrayList;
            int n10;
            block6: {
                try {
                    n10 = Math.round(percentage * 100.0f);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Unable to get user steps", exception);
                    return new ArrayList<p>();
                }
                arrayList = a0.a().b();
                if (arrayList.size() > n10) break block6;
                return arrayList;
            }
            ArrayList arrayList2 = arrayList;
            ArrayList arrayList3 = arrayList2;
            ArrayList arrayList4 = arrayList2;
            n10 = arrayList2.size() - n10;
            return arrayList3.subList(n10, arrayList4.size());
        }

        private static ArrayList<VisualUserStep> getVisualUserSteps() {
            return CoreServiceLocator.getReproStepsProxy().g();
        }

        /*
         * WARNING - void declaration
         */
        private e getSessionProfilerTimeline(float percentage) {
            void var1_1;
            return com.instabug.library.sessionprofiler.e.a().a((float)var1_1);
        }

        private String getUserEmail() {
            return f.n();
        }

        private String getUserName() {
            return f.o();
        }

        private String getPushNotificationToken() {
            return InstabugCore.getPushNotificationToken();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        /*
         * WARNING - void declaration
         */
        private String getUserEvents(float percentage) {
            if (!MemoryUtils.isLowMemory(this.context)) {
                void var0_3;
                try {
                    void var1_4;
                    return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents((float)var1_4)).toString();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                InstabugSDKLogger.e("IBG-Core", "Got error while parsing user events logs", (Throwable)var0_3);
            } else {
                InstabugSDKLogger.e("IBG-Core", "Running low on memory. Excluding UserEvents serialization from state builder.");
            }
            return "[]";
        }

        private String getCurrentActivity() {
            Object object = InstabugInternalTrackingDelegate.getInstance();
            if (object == null) {
                return "NA";
            }
            if ((object = ((InstabugInternalTrackingDelegate)object).getCurrentRealActivity()) == null) {
                return "NA";
            }
            return object.getClass().getName();
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public State build(boolean withInstabugLogs) {
            void var1_1;
            return this.build((boolean)var1_1, false, 1.0f);
        }

        public State buildSimplifiedState() {
            State state = State.access$300(State.access$200(new State(), DeviceStateProvider.getSdkVersion()).setLocale(DeviceStateProvider.getLocale(this.context)).setDuration(DeviceStateProvider.getActiveSessionDuration()).setDevice(DeviceStateProvider.getDevice()), DeviceStateProvider.isDeviceRooted()).setOS(DeviceStateProvider.getOS()).setCarrier(DeviceStateProvider.getCarrier(this.context));
            String string2 = InstabugCore.getStartedActivitiesCount() > 0 ? State.VALUE_APP_STATUS_FOREGROUND : State.VALUE_APP_STATUS_BACKGROUND;
            return State.access$1000(State.access$900(State.access$800(State.access$700(State.access$600(State.access$500(State.access$400(state, string2).setAppVersion(DeviceStateProvider.getAppVersion(this.context)).setAppPackageName(DeviceStateProvider.getAppPackageName(this.context)).setBatteryLevel(DeviceStateProvider.getBatteryLevel(this.context)).setBatteryState(DeviceStateProvider.getBatteryState(this.context)), DeviceStateProvider.getWifiState(this.context)).setFreeMemory(DeviceStateProvider.getFreeMemory(this.context)), DeviceStateProvider.getUsedMemory(this.context)).setTotalMemory(DeviceStateProvider.getTotalMemory(this.context)), DeviceStateProvider.getFreeStorage()), DeviceStateProvider.getUsedStorage()), DeviceStateProvider.getTotalStorage()).setScreenDensity(DeviceStateProvider.getScreenDensity(this.context)).setScreenSize(DeviceStateProvider.getScreenSize(this.context)).setScreenOrientation(DeviceStateProvider.getScreenOrientation(this.context)).setCurrentView(InstabugCore.getCurrentView()), this.getReportedAt()).setDeviceArchitecture(DeviceStateProvider.getDeviceArchitecture()).setUuid(f.k()).setAppToken(TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken());
        }

        /*
         * WARNING - void declaration
         */
        public State build(boolean withInstabugLogs, boolean withExperiments, float percentage) {
            void var2_2;
            void var1_1;
            void var3_3;
            State state = this.buildSimplifiedState();
            State.access$1100(state.setBuildPercentage((float)var3_3), Builder.getConsoleLog((float)var3_3)).setUserSteps(this.getUserSteps((float)var3_3)).setUserEmail(this.getUserEmail()).setUserName(this.getUserName()).setPushToken(this.getPushNotificationToken()).setUserData(this.getUserData()).setTags(this.getTags()).setUserAttributes(UserAttributesDbHelper.getSDKUserAttributes()).setNetworkLogs(this.getNetworkLogs((float)var3_3)).setUserEvents(this.getUserEvents((float)var3_3));
            if (q.c().b((Object)"SESSION_PROFILER") == Feature.State.ENABLED) {
                state.setSessionProfilerTimeline(this.getSessionProfilerTimeline((float)var3_3));
            }
            if (var1_1 != false && this.getInstabugLog() != null) {
                state.setInstabugLog(this.getInstabugLog());
            }
            if (var2_2 != false) {
                state.setExperiments(this.getExperiments((float)var3_3));
            }
            State state2 = state;
            state2.setCurrentActivity(this.getCurrentActivity());
            return state2;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public String getNetworkLogs(float percentage) {
            void var1_1;
            return d.a(MemoryGuard.from(this.context), (float)var1_1);
        }
    }

    public static class StateItem<V>
    implements Serializable {
        @Nullable
        String key;
        @Nullable
        V value;

        public StateItem() {
        }

        /*
         * WARNING - void declaration
         */
        public StateItem(@Nullable String key, @Nullable V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @Nullable
        public String getKey() {
            return this.key;
        }

        /*
         * WARNING - void declaration
         */
        public StateItem<V> setKey(@Nullable String key) {
            void var1_1;
            this.key = var1_1;
            return this;
        }

        @Nullable
        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public StateItem<V> setValue(@Nullable V value) {
            void var1_1;
            this.value = var1_1;
            return this;
        }

        @NonNull
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }

    @Keep
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action FINISHED;
        public static final /* enum */ Action ERROR;
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String name) {
            String string2;
            return Enum.valueOf(Action.class, string2);
        }

        static {
            Action action;
            Action action2;
            Action action3 = action2;
            FINISHED = new Action();
            Action action4 = action;
            ERROR = new Action();
            $VALUES = new Action[]{action3, action4};
        }
    }
}

