/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class InitialScreenshotHelper {
    private static Uri screenshotUri;

    public static void captureScreenshot(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        InitialScreenshotCapturingListener initialScreenshotCapturingListener;
        Object object = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (object == null) {
            return;
        }
        if (MemoryUtils.isLowMemory((Context)object)) {
            Activity activity = object;
            InstabugSDKLogger.e("IBG-Core", "Couldn't take initial screenshot due to low memory");
            initialScreenshotCapturingListener.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            Toast.makeText((Context)activity, (CharSequence)LocaleUtils.getLocaleStringResource(InstabugCore.getLocale((Context)activity), R.string.instabug_str_capturing_screenshot_error, (Context)object), (int)0).show();
            return;
        }
        if (InitialScreenshotHelper.isUsingMediaProjection()) {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener2 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    InitialScreenshotHelper.access$000(bitmap, initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "initial screenshot capturing got error: " + throwable.getMessage());
                    initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(true, object, screenshotCapturingListener2);
        } else {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            Activity activity = object;
            object = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    InitialScreenshotHelper.access$000(bitmap, initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "initial screenshot capturing got error: " + throwable.getMessage());
                    initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(activity, (ScreenshotProvider.ScreenshotCapturingListener)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBitmap(Bitmap bitmap, InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            void var1_1;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
            Object object;
            Bitmap bitmap2 = object;
            object = onSaveBitmapCallback;
            onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback((InitialScreenshotCapturingListener)var1_1){
                final /* synthetic */ InitialScreenshotCapturingListener a;
                {
                    this.a = initialScreenshotCapturingListener;
                }

                @Override
                public void onSuccess(Uri uri) {
                    screenshotUri = uri;
                    this.a.onScreenshotCapturedSuccessfully(uri);
                }

                @Override
                public void onError(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "initial screenshot capturing got error: " + throwable.getMessage());
                    this.a.onScreenshotCapturingFailed(throwable);
                }
            };
            BitmapUtils.saveBitmap(bitmap2, context, (BitmapUtils.OnSaveBitmapCallback)object);
        }
    }

    private static boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Bitmap x0, InitialScreenshotCapturingListener x1) {
        void var1_1;
        InitialScreenshotHelper.saveBitmap(x0, (InitialScreenshotCapturingListener)var1_1);
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

