/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.orchestrator.l;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.h;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.session.NullSessionException;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.q;
import com.instabug.library.sessioncontroller.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.w;
import com.instabug.library.user.f;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.z;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class a0 {
    @Nullable
    private static a0 d;
    private final SettingsManager a;
    @Nullable
    @VisibleForTesting
    IBGDisposable b;
    @Nullable
    private com.instabug.library.model.common.a c;

    private a0(SettingsManager settingsManager) {
        a0 a02 = this;
        a02.a = settingsManager;
        a02.p();
    }

    public static synchronized a0 e() {
        a0 a02 = d;
        if (a02 == null) {
            a0 a03;
            a02 = a03;
            d = new a0(SettingsManager.getInstance());
        }
        return a02;
    }

    public static synchronized void a(SettingsManager settingsManager) {
        if (d == null) {
            d = new a0(settingsManager);
        }
    }

    private void i() {
        if (this.a.getSessionStartedAt() != 0L) {
            com.instabug.library.model.common.a a2 = this.c;
            if (a2 != null) {
                a0 a02 = this;
                a02.a(a2);
                a02.l();
                a02.m();
                a02.a(SessionState.FINISH);
            }
        } else {
            InstabugSDKLogger.d("IBG-Core", "Instabug is enabled after session started, Session ignored");
        }
        this.n();
    }

    private void n() {
        this.c(null);
    }

    private void m() {
        long l2 = System.currentTimeMillis();
        InstabugCore.setLastSeenTimestamp(l2);
        ActionsOrchestrator.obtainOrchestrator(PoolProvider.getSingleThreadExecutor("last-seen-record")).addWorkerThreadAction(new l(f.k(), l2)).orchestrate();
    }

    private void a(@NonNull com.instabug.library.model.common.a a2) {
        if (SettingsManager.getInstance().isSessionEnabled()) {
            this.b(a2).flatMapCompletable(sessionLocalEntity -> {
                if (sessionLocalEntity != null) {
                    return new com.instabug.library.session.h().a((SessionLocalEntity)sessionLocalEntity);
                }
                return Completable.error((Throwable)new NullSessionException("sessionLocalEntity can't be null!"));
            }).subscribeOn(Schedulers.io()).subscribe((CompletableObserver)new z(this));
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private Single b(@NonNull com.instabug.library.model.common.a a2) {
        return Single.create(singleEmitter -> {
            Context context = Instabug.getApplicationContext();
            boolean bl = InstabugCore.isUsersPageEnabled();
            if (context != null) {
                singleEmitter.onSuccess((Object)new SessionLocalEntity.Factory().create(context, a2, bl));
            }
        });
    }

    private void q() {
        long l2 = System.currentTimeMillis() / 1000L;
        ((a0)((Object)string)).a.setSessionStartedAt(l2);
        if (SettingsManager.getInstance().isFirstRun()) {
            ((a0)((Object)string)).a.setIsFirstRun(false);
        }
        if (SettingsManager.getInstance().getFirstRunAt().getTime() == 0L) {
            ((a0)((Object)string)).a.setFirstRunAt(System.currentTimeMillis());
        }
        ((a0)((Object)string)).a.incrementSessionsCount();
        String string = f.k();
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new l(string, l2 *= 1000L)).orchestrate();
    }

    private void l() {
        if (SettingsManager.getInstance().isFirstDismiss()) {
            SettingsManager.getInstance().setIsFirstDismiss(false);
        }
    }

    private void a(SessionState sessionState) {
        if (sessionState.equals((Object)SessionState.FINISH)) {
            SettingsManager.getInstance().setIsAppOnForeground(false);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionFinished.INSTANCE);
        } else {
            SettingsManager.getInstance().setIsAppOnForeground(true);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionStarted.INSTANCE);
        }
        SessionStateEventBus.getInstance().post(sessionState);
    }

    private void p() {
        this.b = CurrentActivityLifeCycleEventBus.INSTANCE.subscribe(activityLifeCycleEvent -> {
            if (activityLifeCycleEvent == ActivityLifeCycleEvent.STOPPED) {
                this.h();
            }
        });
    }

    private int f() {
        return w.a().getCount();
    }

    private void b(boolean bl) {
        SettingsManager.getInstance().setIsFirstSession(bl);
    }

    @NonNull
    private com.instabug.library.model.common.a a() {
        Object object = this.c;
        if (object != null) {
            return object;
        }
        this.q();
        object = Instabug.getApplicationContext();
        String string = UUID.randomUUID().toString();
        String string2 = DeviceStateProvider.getOS();
        String string3 = f.k();
        object = object != null ? DeviceStateProvider.getAppVersion((Context)object) : null;
        long l2 = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        long l3 = System.nanoTime();
        boolean bl = this.k();
        return SessionMapper.toSession(string, string2, string3, (String)object, l2, l3, bl);
    }

    private void c(@Nullable com.instabug.library.model.common.a a2) {
        this.c = a2;
    }

    private boolean k() {
        if (!q.c().h()) {
            return false;
        }
        long l2 = SettingsManager.getInstance().getSessionStitchingTimeoutInSeconds(1800);
        long l3 = this.g();
        if (l3 != -1L && l3 <= l2) {
            InstabugSDKLogger.v("IBG-Core", "session stitched");
            return false;
        }
        InstabugSDKLogger.v("IBG-Core", "started new billable session");
        return true;
    }

    private long g() {
        long l2 = SettingsManager.getInstance().geLastForegroundTime();
        if (l2 != -1L) {
            return (System.currentTimeMillis() - l2) / 1000L;
        }
        return l2;
    }

    static /* synthetic */ void a(a0 a02, boolean bl) {
        a02.b(bl);
    }

    public long d() {
        if (this.a.getSessionStartedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - this.a.getSessionStartedAt();
    }

    public synchronized void b() {
        if (q.c().b((Object)"INSTABUG") == Feature.State.ENABLED) {
            SettingsManager.getInstance().setInBackground(true);
            if (q.c().h()) {
                SettingsManager.getInstance().setLastForegroundTime(System.currentTimeMillis());
            }
            this.i();
        }
    }

    public synchronized void o() {
        InstabugSDKLogger.d("IBG-Core", "Instabug is disabled during app session, ending current session");
        SettingsManager.getInstance().setInBackground(false);
        this.i();
    }

    public synchronized void j() {
        this.a(false);
    }

    public synchronized void a(boolean bl) {
        if (com.instabug.library.sessioncontroller.a.d() && !bl) {
            return;
        }
        if (!InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.BUILDING)) {
            a0 a02 = this;
            a02.c(a02.a());
            a02.a(SessionState.START);
            if (SettingsManager.getInstance().autoScreenRecordingEnabled()) {
                InternalAutoScreenRecorderHelper.getInstance().start();
            }
        }
    }

    @VisibleForTesting
    void h() {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            q.c().g(context);
        } else {
            InstabugSDKLogger.e("IBG-Core", "unable to saveFeaturesToSharedPreferences due to null appContext");
        }
        if (this.f() == 0 && Instabug.getApplicationContext() != null && h.a(Instabug.getApplicationContext())) {
            PoolProvider.postIOTask(this::b);
        }
    }

    @Nullable
    public synchronized Session c() {
        return this.c;
    }
}

