/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.screenshot.b;
import com.instabug.library.screenshot.c;
import com.instabug.library.screenshot.f;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import java.lang.ref.WeakReference;

public class ExtraScreenshotHelper
implements DefaultActivityLifeCycleEventHandler {
    @Nullable
    private WeakReference<ImageButton> captureButtonWeakReference;
    private boolean isCaptureButtonShown = false;
    @Nullable
    @VisibleForTesting
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    @Nullable
    private OnCaptureListener onCaptureListener;

    /*
     * WARNING - void declaration
     */
    @MainThread
    private void show(@NonNull Activity hostActivity) {
        if (!this.isCaptureButtonShown && !SettingsManager.getInstance().isProcessingForeground()) {
            void var1_1;
            ImageButton imageButton = this.createCaptureButton((Activity)var1_1);
            ViewCompat.setElevation((View)imageButton, (float)ViewUtils.convertDpToPx(var1_1.getApplicationContext(), 5.0f));
            ((ViewGroup)var1_1.getWindow().getDecorView()).addView((View)imageButton, (ViewGroup.LayoutParams)this.createCaptureButtonContainer((Activity)var1_1));
            this.isCaptureButtonShown = true;
            imageButton.setOnClickListener(arg_0 -> this.lambda$show$0((Activity)var1_1, arg_0));
            this.captureButtonWeakReference = new WeakReference<ImageButton>(imageButton);
            return;
        }
    }

    private ImageButton createCaptureButton(Activity hostActivity) {
        Drawable drawable2;
        ImageButton imageButton;
        ExtraScreenshotHelper extraScreenshotHelper = imageButton;
        new ImageButton((Context)drawable2).setId(R.id.instabug_extra_screenshot_button);
        extraScreenshotHelper.setScaleType(ImageView.ScaleType.CENTER);
        int n2 = R.string.ibg_extra_screenshot_button_content_description;
        extraScreenshotHelper.setContentDescription(LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(extraScreenshotHelper.getContext()), n2, extraScreenshotHelper.getContext()));
        Drawable drawable3 = ContextCompat.getDrawable((Context)hostActivity, (int)R.drawable.ibg_core_bg_white_oval);
        drawable2 = AppCompatResources.getDrawable((Context)drawable2, (int)R.drawable.ibg_core_ic_screenshot);
        if (drawable3 != null) {
            extraScreenshotHelper.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(drawable3));
        }
        if (drawable2 != null) {
            extraScreenshotHelper.setImageDrawable(drawable2);
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity hostActivity) {
        FrameLayout.LayoutParams layoutParams;
        ExtraScreenshotHelper extraScreenshotHelper = layoutParams;
        new FrameLayout.LayoutParams(-2, -2, 81).setMargins(0, 0, 0, 20);
        if (ScreenUtility.hasNavBar((Context)hostActivity) && Build.VERSION.SDK_INT >= 21) {
            void var1_1;
            ((FrameLayout.LayoutParams)extraScreenshotHelper).bottomMargin += ScreenUtility.getBottomInsets((Activity)var1_1);
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private void captureExtraScreenshot(Activity hostActivity, @Nullable OnCaptureListener onCaptureListener) {
        void var2_2;
        void var1_1;
        if (this.isUsingMediaProjection()) {
            f.c.b(new ScreenshotProvider.ScreenshotCapturingListener((Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    Object object = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
                    if (object != null) {
                        b b2;
                        Bitmap bitmap2 = bitmap;
                        BitmapUtils.maskBitmap(object, bitmap, SettingsManager.getInstance(), null);
                        bitmap = this.a;
                        object = b2;
                        b2 = new b(this);
                        BitmapUtils.saveBitmap(bitmap2, (Context)bitmap, (BitmapUtils.OnSaveBitmapCallback)object);
                    }
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    OnCaptureListener onCaptureListener = this.b;
                    if (onCaptureListener != null) {
                        onCaptureListener.onExtraScreenshotError(throwable);
                    }
                    ExtraScreenshotHelper.this.reset();
                    InstabugSDKLogger.e("IBG-Core", "Error capturing screenshot" + throwable.getMessage());
                }
            });
        } else {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener2 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(this, (Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    c c2;
                    Bitmap bitmap2 = bitmap;
                    bitmap = this.a;
                    c c3 = c2;
                    c2 = new c(this);
                    BitmapUtils.saveBitmap(bitmap2, (Context)bitmap, c3);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    OnCaptureListener onCaptureListener = onCaptureListener.b;
                    if (onCaptureListener != null) {
                        onCaptureListener.onExtraScreenshotError(throwable);
                    }
                    InstabugSDKLogger.e("IBG-Core", "Error while capturing screenshot" + throwable.getMessage());
                }
            };
            ScreenshotProvider.a((Activity)var1_1, screenshotCapturingListener2);
        }
    }

    private void reset() {
        this.hide();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        }
    }

    private boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    @MainThread
    private void hide() {
        ImageButton imageButton = this.captureButtonWeakReference;
        if (imageButton != null) {
            imageButton = (ImageButton)imageButton.get();
            if (this.isCaptureButtonShown && imageButton != null && imageButton.getParent() != null && imageButton.getParent() instanceof ViewGroup) {
                ((ViewGroup)imageButton.getParent()).removeView((View)imageButton);
                this.isCaptureButtonShown = false;
            }
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
        }
        this.currentActivityLifeCycleSubscriber.subscribe();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$show$0(Activity hostActivity, View v2) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.captureExtraScreenshot((Activity)var1_1, extraScreenshotHelper.onCaptureListener);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void init(OnCaptureListener onCaptureListener) {
        void var1_1;
        this.onCaptureListener = var1_1;
        this.subscribeToCurranActivityLifeCycle();
        InvocationManager.getInstance().switchOffInvocation();
        PresentationManager.getInstance().setInInstabugContext(true);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void release() {
        ImageButton imageButton = ((ExtraScreenshotHelper)((Object)this_)).captureButtonWeakReference;
        if (imageButton != null && (imageButton = (ImageButton)imageButton.get()) != null) {
            imageButton.setOnClickListener(null);
        }
        ((ExtraScreenshotHelper)((Object)this_)).captureButtonWeakReference = null;
        ((ExtraScreenshotHelper)((Object)this_)).onCaptureListener = null;
        ActivityLifecycleSubscriber this_ = ((ExtraScreenshotHelper)((Object)this_)).currentActivityLifeCycleSubscriber;
        if (this_ != null) {
            this_.unsubscribe();
        }
        PresentationManager.getInstance().setInInstabugContext(false);
        InvocationManager.getInstance().switchOnInvocation();
    }

    @Override
    public void handleActivityResumed() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v("IBG-Core", "Couldn't handle resume event current activity equal null");
        }
    }

    public void cancel() {
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.release();
    }

    @Override
    public void handleActivityPaused() {
        this.hide();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);

        public void onExtraScreenshotError(Throwable var1);
    }
}

