/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2;

import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BodyBufferHelper {
    @NotNull
    public static final BodyBufferHelper INSTANCE = new BodyBufferHelper();
    private static final long MAX_SIZE = 0x100000L;
    @NotNull
    public static final String MULTIPART_REQUEST_PREFIX = "multipart";
    @NotNull
    public static final String MAX_SIZE_ALERT = "body omitted due to its large size > 1MB";
    @NotNull
    public static final String MULTIPART_ALERT = "multipart body was omitted";

    private BodyBufferHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean isBodySizeAllowed(long size, long maxSize) {
        void var2_1;
        return size <= var2_1;
    }

    public static /* synthetic */ boolean isBodySizeAllowed$default(long l2, long l3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l3 = 0x100000L;
        }
        return BodyBufferHelper.isBodySizeAllowed(l2, l3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    public static final boolean isBodySizeAllowed(@NotNull String body, long maxSize) {
        void var1_1;
        String string2 = body;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"body");
        return (long)StringsKt.encodeToByteArray((String)string2).length <= var1_1;
    }

    public static /* synthetic */ boolean isBodySizeAllowed$default(String string2, long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l2 = 0x100000L;
        }
        return BodyBufferHelper.isBodySizeAllowed(string2, l2);
    }

    @JvmStatic
    public static final boolean isMultipartType(@Nullable String contentType) {
        String string2;
        return contentType != null && StringsKt.startsWith$default((String)string2, (String)MULTIPART_REQUEST_PREFIX, (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final void clear(@NotNull StringBuffer $this$clear) {
        StringBuffer stringBuffer = $this$clear;
        Intrinsics.checkNotNullParameter((Object)stringBuffer, (String)"<this>");
        stringBuffer.setLength(0);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String generateBodyMsg(boolean isBufferDisabled, long size, @NotNull Function0<String> fallback) {
        void var1_1;
        void var3_2;
        Intrinsics.checkNotNullParameter((Object)var3_2, (String)"fallback");
        return isBufferDisabled ? MULTIPART_ALERT : (!BodyBufferHelper.isBodySizeAllowed$default((long)var1_1, 0L, 2, null) ? MAX_SIZE_ALERT : (String)var3_2.invoke());
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isBodySizeAllowed(long size) {
        return BodyBufferHelper.isBodySizeAllowed$default(size, 0L, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isBodySizeAllowed(@NotNull String body) {
        String string2 = body;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"body");
        return BodyBufferHelper.isBodySizeAllowed$default(string2, 0L, 2, null);
    }
}

