/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.diagnostics.nonfatals;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.nonfatals.b;
import com.instabug.library.diagnostics.nonfatals.c;
import com.instabug.library.util.InstabugSDKLogger;

public class NonFatals {
    private static final String INSTABUG_PREFIX = "com.instabug.";
    private static final String METHOD_REPORT_ERROR = "reportError";
    private static final String METHOD_REPORT_NON_FATAL = "reportNonFatal";

    /*
     * WARNING - void declaration
     */
    public static void reportNonFatal(@NonNull Throwable throwable, @NonNull String message, int priority) {
        void var2_2;
        void var1_1;
        VoidRunnable voidRunnable;
        Throwable throwable2;
        if (!NonFatals.isCalledInternally(throwable)) {
            InstabugSDKLogger.e("IBG-Core", "Please refrain from using NonFatals.reportNonFatal as it is a private API");
            return;
        }
        final StackTraceElement stackTraceElement = NonFatals.getFirstInstabugElementFromStacktrace(throwable2.getStackTrace());
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1, (int)var2_2){
            final /* synthetic */ String c;
            final /* synthetic */ int d;
            {
                this.c = string2;
                this.d = n2;
            }

            @Override
            public void run() {
                if (InstabugCore.getFeatureState(Feature.NON_FATAL_ERRORS) == Feature.State.DISABLED) {
                    InstabugSDKLogger.d("IBG-Core", "NonFatals reporting is DISABLED");
                    return;
                }
                a a2 = stackTraceElement2;
                StackTraceElement stackTraceElement2 = a2.stackTraceElement;
                String string2 = a2.c;
                int n2 = a2.d;
                NonFatals.access$000(stackTraceElement2.throwable2, stackTraceElement2, string2, n2);
            }
        };
        APIChecker.checkAndRunInExecutor("NonFatals.reportNonFatal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void reportNonFatal(@NonNull Throwable throwable, @NonNull String message) {
        void var1_1;
        NonFatals.reportNonFatal(throwable, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static void reportNonFatalAndLog(@NonNull Throwable throwable, @NonNull String message, @NonNull String logTag) {
        void var2_2;
        void var1_1;
        NonFatals.reportNonFatalAndLog(throwable, (String)var1_1, 0, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void reportNonFatalAndLog(@NonNull Throwable throwable, @NonNull String message, int priority, @NonNull String logTag) {
        void var3_3;
        void var2_2;
        void var1_1;
        Throwable throwable2;
        if (!NonFatals.isCalledInternally(throwable)) {
            InstabugSDKLogger.e("IBG-Core", "Please refrain from using NonFatals.reportNonFatal as it is a private API");
            return;
        }
        StackTraceElement stackTraceElement = NonFatals.getFirstInstabugElementFromStacktrace(throwable2.getStackTrace());
        if (InstabugCore.getFeatureState(Feature.NON_FATAL_ERRORS) == Feature.State.DISABLED) {
            InstabugSDKLogger.d("IBG-Core", "NonFatals reporting is DISABLED");
            return;
        }
        NonFatals.createFormattedException(throwable2, stackTraceElement, (String)var1_1, (int)var2_2);
        InstabugSDKLogger.e((String)var3_3, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable StackTraceElement stackTraceElements, @NonNull String message, int priority) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            Throwable throwable2;
            InstabugSDKLogger.v("IBG-Core", "parsing nonfatal: " + throwable2.getClass().getCanonicalName());
            NonFatals.reportException(b.a(throwable, (StackTraceElement)var1_2, (String)var2_3, (int)var3_4));
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "parsing nonfatal error ", exception);
        }
    }

    private static void reportException(com.instabug.library.diagnostics.nonfatals.model.a nonFatal) {
        com.instabug.library.diagnostics.nonfatals.model.a a2;
        com.instabug.library.diagnostics.nonfatals.di.a.i().execute(new Runnable(){

            @Override
            public void run() {
                c c2 = com.instabug.library.diagnostics.nonfatals.di.a.g();
                if (c2 != null) {
                    c2.saveNonFatal(a2);
                }
            }
        });
    }

    private static boolean isCalledInternally(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        if (throwable != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()) != null && stackTraceElementArray.length > 0) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!stackTraceElement.getClassName().contains("instabug") || stackTraceElement.getClassName().contains("diagnostics")) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    @Nullable
    static StackTraceElement getFirstInstabugElementFromStacktrace(StackTraceElement[] stackTrace) {
        StackTraceElement[] stackTraceElementArray;
        if (stackTrace != null && stackTraceElementArray.length > 0) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!stackTraceElement.getClassName().startsWith(INSTABUG_PREFIX) || stackTraceElement.getMethodName().equals(METHOD_REPORT_ERROR) || stackTraceElement.getMethodName().equals(METHOD_REPORT_NON_FATAL)) continue;
                return stackTraceElement;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Throwable x0, StackTraceElement x1, String x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        NonFatals.createFormattedException(x0, (StackTraceElement)var1_1, (String)var2_2, (int)var3_3);
    }
}

