/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.MainThreadExecutor;
import com.instabug.library.util.threading.ReturnableSingleThreadExecutor;
import com.instabug.library.util.threading.SingleThreadPoolExecutor;
import com.instabug.library.util.threading.b;
import com.instabug.library.util.threading.c;
import com.instabug.library.util.threading.d;
import com.instabug.library.util.threading.e;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static PoolProvider INSTANCE;
    private static Map<String, SingleThreadPoolExecutor> singleThreadPoolExecutorhMap;
    private static Map<String, ReturnableSingleThreadExecutor> returnableSingleThreadPoolExecutorhMap;
    private static Map<String, c> networkingSingleThreadExecutorhMap;
    private static Map<String, b> monitoredSingleThreadExecutorMap;
    private final ThreadPoolExecutor forBitmapTasks;
    private final ThreadPoolExecutor forIOTasks;
    private final ThreadPoolExecutor forComputationTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private PoolProvider() {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3;
        d d2;
        d this_ = d2;
        d2 = new d(10);
        int n2 = NUMBER_OF_CORES;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue4 = linkedBlockingQueue3;
        linkedBlockingQueue3 = new LinkedBlockingQueue<Runnable>();
        v2.forBitmapTasks = new ThreadPoolExecutor(n2, n2, 10L, timeUnit, linkedBlockingQueue4, this_);
        int n3 = n2;
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue5 = linkedBlockingQueue2;
        linkedBlockingQueue2 = new LinkedBlockingQueue<Runnable>();
        v2.forIOTasks = new ThreadPoolExecutor(n4, n5, 10L, timeUnit, linkedBlockingQueue5, this_);
        linkedBlockingQueue5 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        v2.forComputationTasks = new ThreadPoolExecutor(1, 2, 10L, timeUnit, linkedBlockingQueue5, this_);
        v2.forScheduledTasks = new ScheduledThreadPoolExecutor(n2 * 2, this_);
        v2.mainThreadExecutor = new MainThreadExecutor();
    }

    public static void postBitmapTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forBitmapTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't perform bitmap task", outOfMemoryError);
                }
            }
        });
    }

    public static void postIOTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forIOTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                    }
                    InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
                }
            }
        });
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        Runnable runnable2;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            PoolProvider.postIOTask(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static void postComputationTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forComputationTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    PoolProvider.getInstance().forComputationTasks.execute(runnable2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run computation task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable2 = new Runnable((Runnable)object){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run delayed task", outOfMemoryError);
                }
            }
        };
        object = TimeUnit.MILLISECONDS;
        PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
    }

    public static void postMainThreadTaskWithoutCheck(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    public static void postMainThreadTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run task", outOfMemoryError);
                }
            }
        };
        executor.execute(runnable3);
    }

    public static Executor newBackgroundExecutor() {
        d d2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        d d3 = d2;
        d2 = new d(10);
        return new ThreadPoolExecutor(n3, n4, 60L, timeUnit, linkedBlockingQueue2, d3);
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        SingleThreadPoolExecutor singleThreadPoolExecutor;
        String string2;
        if (singleThreadPoolExecutorhMap.containsKey(string2)) {
            return singleThreadPoolExecutorhMap.get(string2);
        }
        SingleThreadPoolExecutor singleThreadPoolExecutor2 = singleThreadPoolExecutor;
        singleThreadPoolExecutor2();
        singleThreadPoolExecutor.setIdentifier(string2).setThreadPoolIdleListener(new e(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        singleThreadPoolExecutorhMap.put(string2, singleThreadPoolExecutor2);
        return singleThreadPoolExecutor;
    }

    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier) {
        c c2;
        String string2;
        if (networkingSingleThreadExecutorhMap.containsKey(string2)) {
            return networkingSingleThreadExecutorhMap.get(string2);
        }
        c c3 = c2;
        c3();
        c2.a(string2).a(new e(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        networkingSingleThreadExecutorhMap.put(string2, c3);
        return c2;
    }

    public static synchronized ReturnableSingleThreadExecutor getReturnableSingleThreadExecutor(String identifier) {
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor;
        String string2;
        if (returnableSingleThreadPoolExecutorhMap.containsKey(string2)) {
            return returnableSingleThreadPoolExecutorhMap.get(string2);
        }
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor2 = returnableSingleThreadExecutor;
        returnableSingleThreadExecutor = new ReturnableSingleThreadExecutor();
        returnableSingleThreadPoolExecutorhMap.put(string2, returnableSingleThreadExecutor2);
        return returnableSingleThreadExecutor;
    }

    public static synchronized b getMonitoredSingleThreadExecutor(String identifier) {
        b b2;
        String string2;
        if (monitoredSingleThreadExecutorMap.containsKey(string2)) {
            return monitoredSingleThreadExecutorMap.get(string2);
        }
        b b3 = b2;
        b2 = new b();
        monitoredSingleThreadExecutorMap.put(string2, b3);
        return b2;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("IBG-sync-Executor");
    }

    public static ReturnableSingleThreadExecutor getApiExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("IBG-Executor");
    }

    public static ReturnableSingleThreadExecutor getChatsCacheExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("chats-cache-executor");
    }

    public static ReturnableSingleThreadExecutor getSurveysDBExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("surveys-db-executor");
    }

    public static b getDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-db-executor");
    }

    public static ReturnableSingleThreadExecutor getFilesEncryptionExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("Files-Encryption");
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, SingleThreadPoolExecutor>();
        returnableSingleThreadPoolExecutorhMap = new HashMap<String, ReturnableSingleThreadExecutor>();
        networkingSingleThreadExecutorhMap = new HashMap<String, c>();
        monitoredSingleThreadExecutorMap = new HashMap<String, b>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }
}

