/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.internal.storage.cache.a;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static final Map<String, b> currentDownloadingFiles = new ConcurrentHashMap<String, b>();

    @Nullable
    public static a getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.v("IBG-Core", "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new a(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.v("IBG-Core", "In-memory assets created successfully");
        }
        InstabugSDKLogger.v("IBG-Core", "In-memory assets cache found");
        return (a)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public static AssetEntity createEmptyEntity(Context context, String fileUrl, AssetEntity.AssetType assetType) {
        void var2_2;
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        file = new File(AssetsCacheManager.getCacheDirectory(context2), String.valueOf(var1_1.hashCode()));
        return new AssetEntity(String.valueOf(var1_1.hashCode()), (AssetEntity.AssetType)var2_2, (String)var1_1, file2);
    }

    /*
     * WARNING - void declaration
     */
    public static void getAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        void var1_1;
        AssetEntity assetEntity2;
        Object object = AssetsCacheManager.getCache();
        object = object != null ? (AssetEntity)((InMemoryCache)object).get(assetEntity2.getKey()) : null;
        if (object != null) {
            InstabugSDKLogger.v("IBG-Core", "Get file from cache");
            var1_1.onSuccess((AssetEntity)object);
        } else if (AssetsCacheManager.isDownloading(assetEntity2.getKey())) {
            InstabugSDKLogger.v("IBG-Core", "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity2, (OnDownloadFinished)var1_1);
        } else {
            InstabugSDKLogger.v("IBG-Core", "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(assetEntity2, (OnDownloadFinished)var1_1);
        }
    }

    public static void downloadAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        Object object;
        if (assetEntity != null && object != null) {
            Request.Callbacks<AssetEntity, Throwable> callbacks;
            AssetEntity assetEntity2;
            b b2;
            b b3 = b2;
            new b().a(assetEntity2);
            List<OnDownloadFinished> list = b3.b();
            list.add((OnDownloadFinished)object);
            b3.a(list);
            object = b3.a();
            if (object != null) {
                currentDownloadingFiles.put(((AssetEntity)object).getKey(), b3);
            }
            object = callbacks;
            callbacks = new Request.Callbacks<AssetEntity, Throwable>(){

                public void a(@Nullable AssetEntity assetEntity) {
                    if (assetEntity != null) {
                        AssetEntity assetEntity22 = assetEntity;
                        AssetsCacheManager.addAssetEntity(assetEntity22);
                        AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity22);
                    }
                }

                public void a(Throwable throwable) {
                    InstabugSDKLogger.e("IBG-Core", "downloading asset entity got error: ", throwable);
                    AssetsCacheManager.notifyDownloadFailed(assetEntity2, throwable);
                }
            };
            com.instabug.library.networkv2.service.b.a().a(assetEntity2, (Request.Callbacks<AssetEntity, Throwable>)object);
        }
    }

    public static void addAssetEntity(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        a a2 = AssetsCacheManager.getCache();
        if (a2 != null && assetEntity2 != null) {
            a2.put(assetEntity2.getKey(), assetEntity2);
        }
    }

    public static boolean isDownloading(String key) {
        String string2;
        return currentDownloadingFiles.get(string2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        List<OnDownloadFinished> list;
        if ((list = currentDownloadingFiles.get(((AssetEntity)((Object)list)).getKey())) != null) {
            void var1_1;
            List<OnDownloadFinished> list2 = list;
            list = ((b)((Object)list2)).b();
            list.add((OnDownloadFinished)var1_1);
            ((b)((Object)list2)).a(list);
        }
    }

    public static void notifyDownloadFinishedSuccessfully(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        Object object;
        if (assetEntity != null && (object = currentDownloadingFiles.get(assetEntity2.getKey())) != null) {
            for (OnDownloadFinished onDownloadFinished : ((b)object).b()) {
                if (onDownloadFinished == null) continue;
                onDownloadFinished.onSuccess(assetEntity2);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable error) {
        AssetEntity assetEntity2;
        b b2 = currentDownloadingFiles.get(assetEntity2.getKey());
        if (b2 != null) {
            for (OnDownloadFinished onDownloadFinished : b2.b()) {
                void var1_1;
                if (onDownloadFinished == null) continue;
                onDownloadFinished.onFailed((Throwable)var1_1);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray;
        block5: {
            fileArray = AssetsCacheManager.getCacheDirectory(context).listFiles();
            if (fileArray != null) break block5;
            return;
        }
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                fileArray[i2].delete();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e("IBG-Core", "Error while cleaning up cache directory", exception);
                break;
            }
            continue;
        }
    }

    public static void cleanUpCache(Context context) {
        Context context2;
        Cache cache;
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context2);
    }

    public static File getCacheDirectory(Context context) {
        File file;
        Object object;
        object = Environment.getExternalStorageState().equals("mounted") && object.getExternalCacheDir() != null ? object.getExternalCacheDir().getPath() : object.getCacheDir().getAbsolutePath();
        File file2 = file;
        if (!new File((String)object + "/instabug/assetCache").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class b {
        @Nullable
        public AssetEntity a;
        public List<OnDownloadFinished> b;

        public b() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.b = arrayList2;
        }

        public b a(AssetEntity assetEntity) {
            this.a = assetEntity;
            return this;
        }

        public b a(List<OnDownloadFinished> list) {
            this.b = list;
            return this;
        }

        @Nullable
        public AssetEntity a() {
            return this.a;
        }

        public List<OnDownloadFinished> b() {
            return this.b;
        }
    }
}

