/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.HandlerThread;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.OnUserUUIDReadyCallback;
import com.instabug.library.Platform;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.c;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.d;
import com.instabug.library.h;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.b;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.State;
import com.instabug.library.visualusersteps.i;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Instabug {
    @Nullable
    private static volatile Instabug INSTANCE;
    private static Context appContext;
    private c delegate;

    /*
     * WARNING - void declaration
     */
    private Instabug(@NonNull c delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    @Deprecated
    public static void setDebugEnabled(boolean isDebugEnabled) {
    }

    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static int getPrimaryColor() {
        ReturnableRunnable<Integer> returnableRunnable;
        ReturnableRunnable<Integer> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Integer>(){

            @Nullable
            public Integer a() {
                return SettingsManager.getInstance().getPrimaryColor();
            }
        };
        Integer n2 = 0;
        return APIChecker.checkAndGet("Instabug.getPrimaryColor", returnableRunnable2, n2);
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) {
        int n2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setPrimaryColor(n2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setPrimaryColor", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static InstabugColorTheme getTheme() {
        ReturnableRunnable<InstabugColorTheme> returnableRunnable;
        ReturnableRunnable<InstabugColorTheme> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<InstabugColorTheme>(){

            public InstabugColorTheme a() {
                return SettingsManager.getInstance().getTheme();
            }
        };
        InstabugColorTheme instabugColorTheme = InstabugColorTheme.InstabugColorThemeLight;
        return APIChecker.checkAndGet("Instabug.getTheme", returnableRunnable2, instabugColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        void var1_1;
        Uri uri;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (uri == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileUri object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (this.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension passed to Instabug.addFileAttachment() is null");
                    return;
                }
                m0 m02 = this;
                Uri uri2 = m02.uri;
                SettingsManager.getInstance().addExtraAttachmentFile(uri2, m02.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment file uri: " + uri);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var1_1;
        byte[] byArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (object.byArray == null) {
                    InstabugSDKLogger.w("IBG-Core", "data object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (object.b == null) {
                    InstabugSDKLogger.w("IBG-Core", "fileNameWithExtension  passed to Instabug.addFileAttachment() is null");
                    return;
                }
                n0 n02 = object;
                Object object = n02.byArray;
                SettingsManager.getInstance().addExtraAttachmentFile((byte[])object, n02.b);
                InstabugSDKLogger.d("IBG-Core", "addFileAttachment bytes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    public static void clearFileAttachment() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().clearExtraAttachmentFiles();
                InstabugSDKLogger.d("IBG-Core", "clearFileAttachment");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearFileAttachment", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserData() {
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            public String a() {
                return SettingsManager.getInstance().getUserData();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserData", returnableRunnable2, "");
    }

    public static void setUserData(@NonNull String userData) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (d.c().b((Object)Feature.USER_DATA) == Feature.State.ENABLED) {
                    SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserData", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserEmail() {
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            public String a() {
                return b.h();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserEmail", returnableRunnable2, "");
    }

    public static void getUserUUID(@NonNull OnUserUUIDReadyCallback callback) {
        OnUserUUIDReadyCallback onUserUUIDReadyCallback;
        try {
            APIChecker.checkAndRunOrThrow("Instabug.getUserUUID", () -> PoolProvider.postIOTask(() -> PoolProvider.postMainThreadTask(() -> Instabug.lambda$getUserUUID$0(onUserUUIDReadyCallback, b.k()))));
        }
        catch (Exception exception) {
            PoolProvider.postMainThreadTaskWithoutCheck(() -> onUserUUIDReadyCallback.onUserUUIDReady(null));
        }
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getAppToken() {
        return SettingsManager.getInstance().getAppToken();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void identifyUser(@NonNull String username, @NonNull String email) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                if (Instabug.getApplicationContext() != null) {
                    a a2 = object;
                    String string2 = a2.string;
                    b.a(Instabug.getApplicationContext(), string2, a2.b);
                    string2 = object.string;
                    string2 = string2 != null && !string2.isEmpty() ? "non-empty-username" : "empty_username";
                    Object object = object.b;
                    object = object != null && !((String)object).isEmpty() ? "non-empty-email" : "empty-email";
                    InstabugSDKLogger.i("IBG-Core", "identifyUser username: " + string2 + " email: " + (String)object);
                } else {
                    InstabugSDKLogger.e("IBG-Core", "identifyUser failed to execute due to null app context");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.identifyUser", voidRunnable2);
    }

    @Nullable
    public static Context getApplicationContext() {
        return appContext;
    }

    @Nullable
    private static Instabug getInstance() {
        Object object;
        if (INSTANCE == null && com.instabug.library.internal.contentprovider.a.b() != null && (object = com.instabug.library.internal.contentprovider.a.b().a()) != null) {
            object = c.a(object);
            INSTANCE = new Instabug((c)object);
        }
        return INSTANCE;
    }

    public static void logoutUser() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                b.s();
                InstabugSDKLogger.d("IBG-Core", "logoutUser");
            }
        };
        APIChecker.checkAndRun("Instabug.logoutUser", voidRunnable2);
    }

    public static boolean isBuilt() {
        return INSTANCE != null && InstabugStateProvider.getInstance().getState() != InstabugState.NOT_BUILT && InstabugStateProvider.getInstance().getState() != InstabugState.BUILDING;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        Feature feature = Feature.INSTABUG;
        return d.c().c((Object)feature) && d.c().b((Object)feature) == Feature.State.ENABLED;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void enable() {
        if (d.c().b(Instabug.getApplicationContext()) == Feature.State.ENABLED) {
            PoolProvider.getApiExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    VoidRunnable voidRunnable;
                    VoidRunnable voidRunnable2 = voidRunnable;
                    voidRunnable = new VoidRunnable(this){

                        @Override
                        public void run() {
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.b(Feature.State.ENABLED);
                            }
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.H();
                            }
                            InstabugSDKLogger.d("IBG-Core", "enable");
                        }
                    };
                    APIChecker.checkBuilt("Instabug.enable", voidRunnable2);
                }
            });
        } else {
            VoidRunnable voidRunnable;
            VoidRunnable voidRunnable2 = voidRunnable;
            voidRunnable = new VoidRunnable(){

                @Override
                public void run() {
                    if (Instabug.getInstance() != null) {
                        Instabug.getInstance().delegate.b(Feature.State.ENABLED);
                    }
                    PoolProvider.postIOTaskWithCheck(new Runnable(this){

                        @Override
                        public void run() {
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.H();
                            }
                            InstabugSDKLogger.d("IBG-Core", "enable");
                        }
                    });
                }
            };
            APIChecker.checkBuilt("Instabug.enable", voidRunnable2);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void disable() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                }
                InstabugSDKLogger.d("IBG-Core", "disable");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disable", voidRunnable2);
    }

    public static void pauseSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.u();
                }
                InstabugSDKLogger.d("IBG-Core", "pauseSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.pauseSdk", voidRunnable2);
    }

    public static void resumeSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.A();
                }
                InstabugSDKLogger.d("IBG-Core", "resumeSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resumeSdk", voidRunnable2);
    }

    public static void setLocale(@NonNull Locale locale) {
        Locale locale2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (locale2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "locale object passed to Instabug.setLocale is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(locale2);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setLocale", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Locale getLocale(@Nullable Context context) {
        Object object;
        ReturnableRunnable<Locale> returnableRunnable;
        ReturnableRunnable<Locale> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Locale>(){

            @Nullable
            public Locale a() throws Exception {
                return SettingsManager.getInstance().getInstabugLocale(object);
            }
        };
        object = Locale.getDefault();
        return (Locale)APIChecker.checkAndGet("Instabug.getLocale", returnableRunnable2, object);
    }

    public static void addTags(String ... tags) {
        String[] stringArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().addTags(StringUtility.trimStrings(stringArray));
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addTags", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static ArrayList<String> getTags() {
        ReturnableRunnable<ArrayList<String>> returnableRunnable;
        ReturnableRunnable<ArrayList<String>> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<ArrayList<String>>(){

            @Nullable
            public ArrayList<String> a() {
                return SettingsManager.getInstance().getTags();
            }
        };
        return APIChecker.checkAndGet("Instabug.getTags", returnableRunnable2, null);
    }

    public static void resetTags() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().resetTags();
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resetTags", voidRunnable2);
    }

    public static void setCustomTextPlaceHolders(@NonNull InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (instabugCustomTextPlaceHolder2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "instabugCustomTextPlaceHolder object passed to Instabug.setCustomTextPlaceHolders() is null");
                    return;
                }
                SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setCustomTextPlaceHolders", voidRunnable2);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() {
        ReturnableRunnable<HashMap<String, String>> returnableRunnable;
        ReturnableRunnable<HashMap<String, String>> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<HashMap<String, String>>(){

            public HashMap<String, String> a() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.i();
                }
                return new HashMap<String, String>();
            }
        };
        return APIChecker.checkAndGet("Instabug.getAllUserAttributes", returnableRunnable2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void setUserAttribute(@NonNull String key, @NonNull String value) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    p p2 = string2;
                    String string2 = p2.string;
                    Instabug.getInstance().delegate.a(string2, p2.b);
                }
                InstabugSDKLogger.d("IBG-Core", "setUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserAttribute", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserAttribute(@NonNull String key) {
        String string;
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            @Nullable
            public String a() {
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.a(string);
                }
                return null;
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserAttribute", returnableRunnable2, null);
    }

    public static void removeUserAttribute(@NonNull String key) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(string);
                }
                InstabugSDKLogger.d("IBG-Core", "removeUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeUserAttribute", voidRunnable2);
    }

    public static void clearAllUserAttributes() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.e();
                }
                InstabugSDKLogger.d("IBG-Core", "clearAllUserAttributes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllUserAttributes", voidRunnable2);
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.setWelcomeMessageState() is null");
                    return;
                }
                PoolProvider.postIOTaskWithCheck(new Runnable(){

                    @Override
                    public void run() {
                        SettingsManager.getInstance().setWelcomeMessageState(state);
                        InstabugSDKLogger.d("IBG-Core", "setWelcomeMessageState: " + state.name());
                    }
                });
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setWelcomeMessageState", voidRunnable2);
    }

    public static void showWelcomeMessage(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w("IBG-Core", "welcomeMessageState object passed to Instabug.showWelcomeMessage() is null");
                    return;
                }
                if (!InstabugCore.isForegroundBusy() && Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(state);
                }
                InstabugSDKLogger.i("IBG-Core", "showWelcomeMessage: " + state.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.showWelcomeMessage", voidRunnable2);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setSessionProfilerState() is null");
                    return;
                }
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(state2);
                }
                InstabugSDKLogger.d("IBG-Core", "setSessionProfilerState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setSessionProfilerState", voidRunnable2);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w("IBG-Core", "state object passed to Instabug.setTrackingUserStepsState() is null");
                    return;
                }
                Feature feature = Feature.TRACK_USER_STEPS;
                d.c().a(feature, state2);
                InstabugSDKLogger.d("IBG-Core", "setTrackingUserStepsState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setTrackingUserStepsState", voidRunnable2);
    }

    public static void setReproStepsState(State reproStepsState) {
        State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                i.a(state);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setReproStepsState", voidRunnable2);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setTheme(instabugColorTheme);
                int n2 = l0.a[instabugColorTheme.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        SettingsManager.getInstance().setPrimaryColor(-15893761);
                        SettingsManager.getInstance().setStatusBarColor(-3815737);
                    }
                } else {
                    SettingsManager.getInstance().setPrimaryColor(-9580554);
                    SettingsManager.getInstance().setStatusBarColor(-16119286);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setColorTheme", voidRunnable2);
    }

    public static void logUserEvent(@NonNull String eventIdentifier) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InstabugUserEventLogger.getInstance().logUserEvent(string, new UserEventParam[0]);
                InstabugSDKLogger.d("IBG-Core", "logUserEvent: " + string);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.logUserEvent", voidRunnable2);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        Report.OnReportCreatedListener onReportCreatedListener;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.onReportSubmitHandler", voidRunnable2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        Feature.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state != null) {
                    SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(state);
                    InstabugSDKLogger.d("IBG-Core", "setAutoScreenRecordingAudioCapturingEnabled: " + state.name());
                }
                InstabugSDKLogger.w("IBG-Core", "isASRAudioEnabled object passed to Instabug.setAutoScreenRecordingAudioCapturingEnabled() is null");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingAudioCapturingEnabled", voidRunnable2);
    }

    public static void show() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                InvocationManager.getInstance().show();
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.show", voidRunnable2);
    }

    public static void addPrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.a(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addPrivateViews", voidRunnable2);
    }

    public static void removePrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.b(viewArray);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removePrivateViews", voidRunnable2);
    }

    public static boolean isBuilding() {
        return InstabugStateProvider.getInstance().getState() == InstabugState.BUILDING;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private static void disableInternal() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                    InstabugSDKLogger.d("IBG-Core", "disableInternal");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disableInternal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportScreenChange(@Nullable Bitmap screenshot, @NonNull String screenName) {
        if (!Instabug.isBuilt()) {
            return;
        }
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            void var1_1;
            Bitmap bitmap;
            Instabug.getInstance().delegate.a(bitmap, (String)var1_1);
            return;
        }
    }

    private static void setCurrentPlatform(@Platform int platform) {
        int n2;
        SettingsManager.getInstance().setCurrentPlatform(n2);
    }

    public static void addExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.a(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addExperiments", voidRunnable2);
    }

    public static void removeExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.b(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeExperiments", voidRunnable2);
    }

    public static void clearAllExperiments() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.d();
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllExperiments", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$getUserUUID$0(OnUserUUIDReadyCallback callback, String uuid) {
        void var1_1;
        callback.onUserUUIDReady((String)var1_1);
    }

    public static class Builder {
        private static volatile boolean isBuildCalled = false;
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State crashReportingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private State reproStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private Feature.State anrDefaultState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge;
        private int shakingThreshold;
        private int floatingButtonOffsetFromTop;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken) {
            void var2_2;
            void var1_1;
            InstabugInvocationEvent[] instabugInvocationEventArray = this_;
            InstabugInvocationEvent[] instabugInvocationEventArray2 = new InstabugInvocationEvent[1];
            InstabugInvocationEvent[] this_ = instabugInvocationEventArray2;
            instabugInvocationEventArray2[0] = InstabugInvocationEvent.SHAKE;
            super((Application)var1_1, (String)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(var1_1.getApplicationContext(), (String)var2_2, (InstabugInvocationEvent[])var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.application = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            void var2_2;
            void var3_3;
            void var1_1;
            Builder builder = this_;
            Builder builder2 = this_;
            Builder builder3 = this_;
            this_.instabugStatusBarColor = -3815737;
            this_.instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
            Object this_ = d.e;
            v3.userDataState = this_;
            v3.consoleLogState = this_;
            v3.instabugLogState = this_;
            v3.inAppMessagingState = this_;
            v3.crashReportingState = this_;
            v3.pushNotificationState = this_;
            v3.trackingUserStepsState = this_;
            v3.reproStepsState = State.ENABLED;
            v3.viewHierarchyState = Feature.State.DISABLED;
            v3.surveysState = this_;
            v3.userEventsState = this_;
            v3.anrDefaultState = this_;
            v3.emailFieldRequired = true;
            v3.emailFieldVisibility = true;
            v3.commentFieldRequired = false;
            v3.introMessageEnabled = true;
            v3.shouldPlaySounds = false;
            v3.successDialogEnabled = true;
            v3.instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
            v3.shakingThreshold = 650;
            v3.floatingButtonOffsetFromTop = -1;
            v3.isSurveysAutoShowing = true;
            v3.chatPromptOptionEnable = true;
            v3.bugPromptOptionEnable = true;
            v3.feedbackPromptOptionEnable = true;
            v3.deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();
            builder3.applicationContext = var1_1;
            builder2.instabugInvocationEvents = var3_3;
            builder.applicationToken = var2_2;
        }

        private void buildInFG(Feature.State instabugInitialState) {
            c c2;
            if (this.application == null) {
                return;
            }
            void v0 = c2;
            Builder builder = this;
            InstabugSDKLogger.d("IBG-Core", "Building Instabug From main thread, thread name: " + Thread.currentThread().getName());
            c2 = c.a(builder.application);
            INSTANCE = new Instabug(c2);
            InstabugSDKLogger.initLogger(builder.applicationContext);
            Object object = Feature.State.ENABLED;
            final boolean bl = v0 == object;
            Object object2 = d.c();
            Feature feature = Feature.INSTABUG;
            if (!bl) {
                object = Feature.State.DISABLED;
            }
            Builder builder2 = this;
            ((d)object2).a(feature, (Feature.State)((Object)object));
            c2.a(InstabugState.BUILDING);
            builder2.logDeprecatedApis();
            object = SettingsManager.getInstance().getAppToken();
            object2 = builder2.applicationToken;
            if (object2 != null && object != null && !((String)object2).equals(object)) {
                com.instabug.library.user.b.s();
            }
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            com.instabug.library.core.plugin.a.a(this.applicationContext);
            h.a(SettingsManager.getInstance());
            HandlerThread handlerThread = new HandlerThread("Sdk start thread"){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @SuppressLint(value={"STRICT_MODE_VIOLATION"})
                protected void onLooperPrepared() {
                    try {
                        b b2 = this;
                        b2.c2.a(applicationContext);
                        c c22 = b2.c2;
                        InstabugState instabugState = b2.bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                        b b3 = this;
                        c22.a(instabugState);
                        b3.c2.H();
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
                        InvocationManager.getInstance().notifyPrimaryColorChanged();
                        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvents);
                        if (floatingButtonOffsetFromTop != -1) {
                            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
                        }
                        b b4 = this;
                        SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                        b4.this.updateFeaturesStates();
                        Builder.access$1300(b4.this, bl);
                        InstabugSDKLogger.d("IBG-Core", "Built");
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e("IBG-Core", "Error while building the sdk: ", exception);
                    }
                }
            };
            handlerThread.setPriority(10);
            handlerThread.start();
        }

        private void updateFeaturesStates() {
            InstabugCore.setFeatureState(Feature.USER_DATA, this.userDataState);
            InstabugCore.setFeatureState(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugCore.setFeatureState(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugCore.setFeatureState(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugCore.setFeatureState(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugCore.setFeatureState(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugCore.setFeatureState(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            i.a(this.reproStepsState);
            InstabugCore.setFeatureState(Feature.VIEW_HIERARCHY_V2, this.viewHierarchyState);
            InstabugCore.setFeatureState(Feature.SURVEYS, this.surveysState);
            InstabugCore.setFeatureState(Feature.USER_EVENTS, this.userEventsState);
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logFeaturesStates(Boolean isInstabugEnabled) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", "User data feature state is set to " + (Object)((Object)this.userDataState));
            InstabugSDKLogger.v("IBG-Core", "Console log feature state is set to " + (Object)((Object)this.consoleLogState));
            InstabugSDKLogger.v("IBG-Core", "Instabug logs feature state is set to " + (Object)((Object)this.instabugLogState));
            InstabugSDKLogger.v("IBG-Core", "Crash reporting feature state is set to " + (Object)((Object)this.crashReportingState));
            InstabugSDKLogger.v("IBG-Core", "In-App messaging feature state is set to" + (Object)((Object)this.inAppMessagingState));
            InstabugSDKLogger.v("IBG-Core", "Push notification feature state is set to " + (Object)((Object)this.pushNotificationState));
            InstabugSDKLogger.v("IBG-Core", "Tracking user steps feature state is set to " + (Object)((Object)this.trackingUserStepsState));
            InstabugSDKLogger.v("IBG-Core", "Repro steps feature state is set to " + (Object)((Object)this.reproStepsState));
            InstabugSDKLogger.v("IBG-Core", "View hierarchy feature state is set to " + (Object)((Object)this.viewHierarchyState));
            InstabugSDKLogger.v("IBG-Core", "Surveys feature state is set to " + (Object)((Object)this.surveysState));
            InstabugSDKLogger.v("IBG-Core", "User events feature state is set to " + (Object)((Object)this.userEventsState));
            InstabugSDKLogger.v("IBG-Core", "Instabug overall state is set to " + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1300(Builder x0, Boolean x1) {
            void var1_1;
            x0.logFeaturesStates((Boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            void var1_1;
            this.instabugInvocationEvents = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            void var1_1;
            this.trackingUserStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReproStepsState(State state) {
            void var1_1;
            this.reproStepsState = var1_1;
            return this;
        }

        @Deprecated
        public Builder setDebugEnabled(boolean isDebugEnabled) {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSdkDebugLogsLevel(int level) {
            void var1_1;
            SettingsManager.getInstance().setLogLevel((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConsoleLogState(@NonNull Feature.State state) {
            void var1_1;
            this.consoleLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstabugLogState(@NonNull Feature.State state) {
            void var1_1;
            this.instabugLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserDataState(@NonNull Feature.State state) {
            void var1_1;
            this.userDataState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            void var1_1;
            this.inAppMessagingState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            void var1_1;
            this.viewHierarchyState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserEventsState(@NonNull Feature.State state) {
            void var1_1;
            this.userEventsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder ignoreFlagSecure(boolean shouldBeIgnored) {
            void var1_1;
            SettingsManager.getInstance().setIgnoreFlagSecure((boolean)var1_1);
            return this;
        }

        @Nullable
        public void build() {
            appContext = this.applicationContext;
            InstabugSDKLogger.d("IBG-Core", "building sdk with default state ");
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            Feature.State state = Feature.State.ENABLED;
            if (d.c().b(appContext) == state) {
                this.buildInBG(state);
            } else {
                this.buildInFG(state);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public void build(Feature.State instabugInitialState) {
            void var1_1;
            String string;
            appContext = this.applicationContext;
            if (instabugInitialState == Feature.State.DISABLED && ((string = this.applicationToken) == null || string.isEmpty())) {
                return;
            }
            InstabugSDKLogger.d("IBG-Core", "building sdk with state " + var1_1);
            if (isBuildCalled) {
                InstabugSDKLogger.v("IBG-Core", "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            if (d.c().b(appContext) == Feature.State.ENABLED) {
                this.buildInBG((Feature.State)var1_1);
            } else {
                this.buildInFG((Feature.State)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        @VisibleForTesting
        void buildInBG(Feature.State instabugInitialState) {
            void var1_1;
            PoolProvider.getApiExecutor().execute(new Runnable((Feature.State)var1_1){
                final /* synthetic */ Feature.State a;
                {
                    this.a = state;
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    void var2_5;
                    if (application == null) {
                        return;
                    }
                    a a2 = this;
                    InstabugSDKLogger.d("IBG-Core", "Building Instabug From BG thread, thread name: " + Thread.currentThread().getName());
                    c c2 = c.a(application);
                    INSTANCE = new Instabug(c2);
                    InstabugSDKLogger.initLogger(applicationContext);
                    Feature.State state = Feature.State.ENABLED;
                    boolean bl = a2.a == state;
                    d d2 = d.c();
                    Feature feature = Feature.INSTABUG;
                    if (!bl) {
                        Feature.State state2 = Feature.State.DISABLED;
                    }
                    a a3 = this;
                    d2.a(feature, (Feature.State)var2_5);
                    c2.a(InstabugState.BUILDING);
                    a3.this.logDeprecatedApis();
                    String string = SettingsManager.getInstance().getAppToken();
                    if (applicationToken != null && string != null && !applicationToken.equals(string)) {
                        com.instabug.library.user.b.s();
                    }
                    a a4 = this;
                    SettingsManager.getInstance().setAppToken(applicationToken);
                    com.instabug.library.core.plugin.a.a(applicationContext);
                    h.a(SettingsManager.getInstance());
                    try {
                        c2.a(applicationContext);
                        InstabugState instabugState = bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                        c c3 = c2;
                        c3.a(instabugState);
                        c3.H();
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
                        InvocationManager.getInstance().notifyPrimaryColorChanged();
                        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvents);
                        if (floatingButtonOffsetFromTop != -1) {
                            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
                        }
                        a a5 = this;
                        SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                        a5.this.updateFeaturesStates();
                        Builder.access$1300(a5.this, bl);
                        InstabugSDKLogger.d("IBG-Core", "SDK Built");
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e("IBG-Core", "Error while building the sdk: ", exception);
                    }
                }
            });
        }
    }
}

