/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static final Map<String, b> currentDownloadingFiles = new ConcurrentHashMap<String, b>();

    @Nullable
    public static com.instabug.library.internal.storage.cache.a getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new com.instabug.library.internal.storage.cache.a(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (com.instabug.library.internal.storage.cache.a)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public static AssetEntity createEmptyEntity(Context context, String fileUrl, AssetEntity.AssetType assetType) {
        void var2_2;
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        file = new File(AssetsCacheManager.getCacheDirectory(context2), String.valueOf(var1_1.hashCode()));
        return new AssetEntity(String.valueOf(var1_1.hashCode()), (AssetEntity.AssetType)var2_2, (String)var1_1, file2);
    }

    /*
     * WARNING - void declaration
     */
    public static void getAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        void var1_1;
        AssetEntity assetEntity2;
        Object object = AssetsCacheManager.getCache();
        object = object != null ? (AssetEntity)((InMemoryCache)object).get(assetEntity2.getKey()) : null;
        if (object != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            var1_1.onSuccess((AssetEntity)object);
        } else if (AssetsCacheManager.isDownloading(assetEntity2.getKey())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity2, (OnDownloadFinished)var1_1);
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(assetEntity2, (OnDownloadFinished)var1_1);
        }
    }

    public static void downloadAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        Request.Callbacks<AssetEntity, Throwable> callbacks;
        Request.Callbacks<AssetEntity, Throwable> callbacks2;
        AssetEntity assetEntity2;
        b b2;
        b b3 = b2;
        b3();
        b2.a(assetEntity2);
        List<OnDownloadFinished> list = b2.c();
        list.add((OnDownloadFinished)((Object)callbacks2));
        b2.a(list);
        callbacks2 = callbacks;
        callbacks = new Request.Callbacks<AssetEntity, Throwable>(){

            public void a(@Nullable AssetEntity assetEntity) {
                AssetEntity assetEntity22 = assetEntity;
                AssetsCacheManager.addAssetEntity(assetEntity22);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity22);
            }

            public void a(Throwable throwable) {
                a a2 = this;
                InstabugSDKLogger.e(a2, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(a2.assetEntity2, throwable);
            }
        };
        b2.a((Disposable)com.instabug.library.networkv2.e.b.a().a(assetEntity2, callbacks2));
        assetEntity2 = b2.a();
        if (assetEntity2 != null) {
            currentDownloadingFiles.put(assetEntity2.getKey(), b3);
        }
    }

    public static void addAssetEntity(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        com.instabug.library.internal.storage.cache.a a2 = AssetsCacheManager.getCache();
        if (a2 != null && assetEntity2 != null) {
            a2.put(assetEntity2.getKey(), assetEntity2);
        }
    }

    public static boolean isDownloading(String key) {
        String string2;
        return currentDownloadingFiles.get(string2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        List<OnDownloadFinished> list;
        if ((list = currentDownloadingFiles.get(((AssetEntity)((Object)list)).getKey())) != null) {
            void var1_1;
            List<OnDownloadFinished> list2 = list;
            list = ((b)((Object)list2)).c();
            list.add((OnDownloadFinished)var1_1);
            ((b)((Object)list2)).a(list);
        }
    }

    public static void notifyDownloadFinishedSuccessfully(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        Object object;
        if (assetEntity != null && (object = currentDownloadingFiles.get(assetEntity2.getKey())) != null) {
            for (OnDownloadFinished onDownloadFinished : ((b)object).c()) {
                if (onDownloadFinished == null) continue;
                onDownloadFinished.onSuccess(assetEntity2);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable error) {
        AssetEntity assetEntity2;
        b b2 = currentDownloadingFiles.get(assetEntity2.getKey());
        if (b2 != null) {
            for (OnDownloadFinished onDownloadFinished : b2.c()) {
                void var1_1;
                if (onDownloadFinished == null) continue;
                onDownloadFinished.onFailed((Throwable)var1_1);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    public static void stopRunningDownloads() {
        Iterator<Map.Entry<String, b>> iterator = currentDownloadingFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Disposable disposable = iterator.next().getValue().b();
            if (disposable == null) continue;
            disposable.dispose();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray;
        block5: {
            fileArray = AssetsCacheManager.getCacheDirectory(context).listFiles();
            if (fileArray != null) break block5;
            return;
        }
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                fileArray[i2].delete();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(AssetsCacheManager.class, exception.getMessage(), exception);
                break;
            }
            continue;
        }
    }

    public static void cleanUpCache(Context context) {
        Context context2;
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context2);
    }

    public static File getCacheDirectory(Context context) {
        File file;
        Object object;
        if (Environment.getExternalStorageState().equals("mounted") && object.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            object = object.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            object = object.getCacheDir().getAbsolutePath();
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/assetCache").exists()) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + file2.mkdirs());
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class b {
        @Nullable
        public AssetEntity a;
        @Nullable
        public Disposable b;
        public List<OnDownloadFinished> c;

        public b() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.c = arrayList2;
        }

        public b a(AssetEntity assetEntity) {
            this.a = assetEntity;
            return this;
        }

        @Nullable
        public Disposable b() {
            return this.b;
        }

        public b a(List<OnDownloadFinished> list) {
            this.c = list;
            return this;
        }

        @Nullable
        public AssetEntity a() {
            return this.a;
        }

        public b a(Disposable disposable) {
            this.b = disposable;
            return this;
        }

        public List<OnDownloadFinished> c() {
            return this.c;
        }
    }
}

