/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;

public abstract class InstabugBaseFragment
extends Fragment {
    @Nullable
    private View view;
    @Nullable
    private Activity activity;
    private boolean isStateRestored;

    @LayoutRes
    protected abstract int getLayout();

    protected abstract String getTitle();

    protected abstract void consumeNewInstanceSavedArguments();

    /*
     * WARNING - void declaration
     */
    public void onAttach(Activity activity) {
        void var1_1;
        super.onAttach((Activity)var1_1);
        this.activity = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        super.onCreate((Bundle)var1_1);
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onCreateView called");
        if (instabugBaseFragment.getArguments() != null) {
            InstabugBaseFragment instabugBaseFragment2 = this;
            InstabugSDKLogger.v((Object)instabugBaseFragment2, "Arguments found, calling consumeNewInstanceSavedArguments with " + this.getArguments());
            instabugBaseFragment2.consumeNewInstanceSavedArguments();
        }
        this.isStateRestored = false;
    }

    /*
     * WARNING - void declaration
     */
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        InstabugBaseFragment instabugBaseFragment2 = this;
        InstabugSDKLogger.v((Object)instabugBaseFragment2, "onCreateView called");
        instabugBaseFragment.view = var1_1.inflate(instabugBaseFragment2.getLayout(), (ViewGroup)var2_2, false);
        instabugBaseFragment.setTitle(instabugBaseFragment.getTitle());
        return instabugBaseFragment.view;
    }

    protected abstract void restoreState(Bundle var1);

    /*
     * WARNING - void declaration
     */
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onViewCreated called");
        super.onViewCreated((View)var1_1, (Bundle)var2_2);
        if (savedInstanceState != null) {
            InstabugBaseFragment instabugBaseFragment2 = this;
            InstabugSDKLogger.v((Object)instabugBaseFragment2, "savedInstanceState found, calling restoreState");
            instabugBaseFragment2.restoreState((Bundle)var2_2);
            instabugBaseFragment2.isStateRestored = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        InstabugBaseFragment instabugBaseFragment = this;
        super.onSaveInstanceState((Bundle)var1_1);
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onSaveInstanceState called, calling saveState");
        instabugBaseFragment.saveState((Bundle)var1_1);
    }

    public void onPause() {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onPause();
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onPause called, calling saveState");
    }

    public void onResume() {
        InstabugBaseFragment instabugBaseFragment = this;
        super.onResume();
        InstabugSDKLogger.v((Object)instabugBaseFragment, "onResume called, calling saveState");
    }

    protected abstract void saveState(Bundle var1);

    public boolean isStateRestored() {
        return this.isStateRestored;
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Activity getPreservedActivity() {
        InstabugBaseFragment instabugBaseFragment = this;
        InstabugSDKLogger.v((Object)instabugBaseFragment, "Returning preserved activity " + this.activity);
        return instabugBaseFragment.activity;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        View view = this.view;
        if (view == null) {
            InstabugSDKLogger.v((Object)this, "Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        if ((view = (TextView)view.findViewById(R.id.instabug_fragment_title)) != null) {
            void var1_1;
            InstabugSDKLogger.v((Object)this, "Setting fragment title to \"" + (String)var1_1 + "\"");
            view.setText((CharSequence)var1_1);
        } else {
            InstabugSDKLogger.v((Object)this, "instabug_fragment_title wasn't found, make sure your layout.xml contains it");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getLocalizedString(@StringRes int resourceId) {
        void var1_1;
        return LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(this.getContext()), (int)var1_1, this.getContext());
    }
}

