/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.core.os.ConfigurationCompat;
import com.instabug.library.Instabug;
import com.instabug.library.h;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.tracking.f;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DeviceStateProvider {
    private static final String NONE_SSID = "<unknown ssid>";
    private static final String TAG = "DeviceStateProvider";

    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            return a.d();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
    }

    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        return InstabugDeviceProperties.getAppVersion(context);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static int getBatteryLevel(Context context) {
        block6: {
            IntentFilter intentFilter;
            Context context2 = context;
            Context context3 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context3 = context2.registerReceiver(null, (IntentFilter)context3);
            if (context3 == null) break block6;
            Context context4 = context3;
            Context context5 = context4;
            int n2 = context4.getIntExtra("level", -1);
            return (int)((float)n2 / (float)context5.getIntExtra("scale", -1) * 100.0f);
        }
        try {
            InstabugSDKLogger.w(TAG, "Could't obtain battery level");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while get battery level", exception);
        }
        return -1;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getBatteryState(Context context) {
        block9: {
            CharSequence charSequence;
            block12: {
                block11: {
                    int n2;
                    Context context2;
                    block10: {
                        IntentFilter intentFilter;
                        Context context3 = context;
                        context2 = intentFilter;
                        intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                        context2 = context3.registerReceiver(null, (IntentFilter)context2);
                        if (context2 == null) break block9;
                        n2 = context2.getIntExtra("status", -1);
                        if (n2 != 2 && n2 != 5) {
                            n2 = 0;
                            break block10;
                        }
                        n2 = 1;
                    }
                    int n3 = context2.getIntExtra("plugged", -1);
                    boolean bl = n3 == 2;
                    n3 = n3 == 1 ? 1 : 0;
                    if (n2 == 0) break block11;
                    charSequence = new StringBuilder().append("Charging");
                    String string2 = n3 != 0 ? " through AC Charger" : (bl ? " through USB cable" : "");
                    charSequence = ((StringBuilder)charSequence).append(string2).toString();
                    break block12;
                }
                charSequence = "Unplugged";
            }
            return charSequence;
        }
        try {
            InstabugSDKLogger.w(TAG, "Could't obtain battery state");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while get battery state", exception);
        }
        return "Unknown";
    }

    public static boolean getWifiState(Context context) {
        boolean bl;
        block4: {
            block3: {
                Context context2;
                try {
                    context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1);
                    if (context2 == null) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Got error while get wifi state", exception);
                    return false;
                }
                if (!context2.isConnected()) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static String getWifiSSID(@Nullable Context context) {
        Object object;
        if (context == null) {
            InstabugSDKLogger.e(TAG, "Could not read wifi SSID. Context is null");
            return "";
        }
        if (DeviceStateProvider.getWifiState(object)) {
            block9: {
                object = (WifiManager)object.getApplicationContext().getSystemService("wifi");
                if (object == null) break block9;
                object = object.getConnectionInfo().getSSID();
                if (NONE_SSID.equalsIgnoreCase((String)object)) {
                    object = "";
                }
                return object;
            }
            try {
                InstabugSDKLogger.e(TAG, "Could not read wifi SSID. WifiManager is null");
                return "Connected";
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "exception while trying to read SSID. " + exception.getMessage(), exception);
                return "Connected";
            }
            catch (SecurityException securityException) {
                InstabugSDKLogger.e(TAG, "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                return "Connected";
            }
        }
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = context;
        Context context3 = memoryInfo;
        ((ActivityManager)context2.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return (DeviceStateProvider.calculateTotalMemory(context2) - context3.availMem) / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l2 = DeviceStateProvider.calculateTotalMemory(context);
        if (l2 == 0L) {
            InstabugSDKLogger.e(TAG, "Got error while calculate total memory");
            return -1L;
        }
        return l2 / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            Context context2;
            return DeviceStateProvider.calculateTotalMemoryApi16(context2);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.totalMem;
    }

    /*
     * Loose catch block
     */
    private static long calculateTotalMemoryPreApi16() {
        RandomAccessFile randomAccessFile;
        Object object;
        block19: {
            block20: {
                IOException iOException3;
                block18: {
                    RandomAccessFile randomAccessFile2;
                    object = null;
                    randomAccessFile = randomAccessFile2;
                    randomAccessFile2 = new RandomAccessFile("/proc/meminfo", "r");
                    String string2 = randomAccessFile2.readLine().split(":")[1].trim();
                    int n2 = 0;
                    int n3 = string2.length();
                    object = string2.substring(n2, n3 - 3).trim();
                    randomAccessFile2.close();
                    long l2 = Long.parseLong((String)object) * 1024L;
                    try {
                        randomAccessFile2.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    return l2;
                    catch (IOException iOException3) {
                        break block18;
                    }
                    catch (Throwable throwable) {
                        randomAccessFile = object;
                        object = throwable;
                        break block19;
                    }
                    catch (IOException iOException3) {
                        randomAccessFile = object;
                    }
                }
                iOException3.printStackTrace();
                if (randomAccessFile == null) break block20;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException4) {
                    iOException4.printStackTrace();
                }
            }
            return 0L;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        throw object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFreeStorage() {
        try {
            File file = DeviceStateProvider.getExternalCacheDir();
            if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                return file.getUsableSpace() / 0x100000L;
            }
            InstabugSDKLogger.e(TAG, "Got error while calculate free storage");
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while calculate free storage");
            return -1L;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getUsedStorage() {
        try {
            File file = DeviceStateProvider.getExternalCacheDir();
            if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                long l2 = file.getTotalSpace() - file.getFreeSpace();
                return l2 / 0x100000L;
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while calculate used storage");
            return -1L;
        }
        {
            InstabugSDKLogger.e(TAG, "Got error while calculate used storage");
            return -1L;
        }
    }

    public static long getTotalStorage() {
        block5: {
            File file;
            try {
                file = DeviceStateProvider.getExternalCacheDir();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "Got error while calculate total storage");
                return -1L;
            }
            if (!DeviceStateProvider.externalMemoryAvailable() || file == null) break block5;
            return (int)(file.getTotalSpace() / 0x100000L);
        }
        InstabugSDKLogger.e(TAG, "Got error while calculate total storage");
        return -1L;
    }

    @Nullable
    private static File getExternalCacheDir() {
        Context context = DeviceStateProvider.getApplicationContext();
        if (context != null) {
            return context.getExternalCacheDir();
        }
        return null;
    }

    @Nullable
    private static Context getApplicationContext() {
        return Instabug.getApplicationContext();
    }

    private static boolean externalMemoryAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(DeviceStateProvider.class, exception.getMessage(), exception);
            return false;
        }
    }

    public static String getScreenDensity(Context context) {
        int n2 = DeviceStateProvider.getDisplayMetrics((Context)context).densityDpi;
        if (n2 < 160) {
            return "ldpi";
        }
        if (n2 < 240) {
            return "mdpi";
        }
        if (n2 < 320) {
            return "hdpi";
        }
        if (n2 < 480) {
            return "xhdpi";
        }
        if (n2 < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        Context context2 = DeviceStateProvider.getDisplayMetrics(context);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = context2.widthPixels;
        objectArray[1] = context2.heightPixels;
        return String.format("%sx%s", objectArray2);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Context context2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            ((DisplayManager)context2.getSystemService("display")).getDisplay(0).getRealMetrics(displayMetrics2);
        } else {
            ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics2);
        }
        return displayMetrics2;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getCurrentView() {
        String string2 = f.e().a();
        if (string2.isEmpty()) {
            string2 = f.e().c();
        }
        return string2;
    }

    public static String getSdkVersion() {
        return "10.8.1";
    }

    public static String getLocale(Context context) {
        Context context2;
        if (ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration()).size() > 0) {
            return ConfigurationCompat.getLocales((Configuration)context2.getResources().getConfiguration()).get(0).getLanguage();
        }
        return context2.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return h.h().c();
    }

    public static String getDeviceArchitecture() {
        return Build.CPU_ABI;
    }
}

