/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.d.a;
import com.instabug.library.invocation.d.d;
import com.instabug.library.invocation.d.g;
import com.instabug.library.invocation.d.h;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InvocationManager {
    public static final String TAG = "InvocationManager";
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private InstabugInvocationEvent[] currentInstabugInvocationEvents;
    @Nullable
    private List<a> currentInvokers;
    @Nullable
    private a lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private boolean isInvocationAvailable;
    @Nullable
    private com.instabug.library.invocation.b invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.isInvocationAvailable = true;
        invocationManager.currentInvocationSettings = new InvocationSettings();
        invocationManager.currentInstabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
        invocationManager.currentInvokers = Collections.synchronizedList(new ArrayList());
        invocationManager.subscribeToCarenActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new com.instabug.library.invocation.b();
    }

    public static synchronized void init() {
        InstabugSDKLogger.d(TAG, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n2 = c.b[activityLifeCycleEvent.ordinal()];
                if (n2 != 1) {
                    if (n2 == 2) {
                        InstabugSDKLogger.d(InvocationManager.TAG, "current activity paused");
                        InvocationManager.this.sleep();
                    }
                } else {
                    InstabugSDKLogger.d(InvocationManager.TAG, "current activity resumed");
                    InvocationManager.this.listen();
                }
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private com.instabug.library.invocation.d.b getFloatingButtonInvoker() {
        InvocationManager invocationManager = this_;
        Object this_ = null;
        List<a> list = invocationManager.currentInvokers;
        if (list != null) {
            for (a a2 : list) {
                if (!(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                this_ = (com.instabug.library.invocation.d.b)a2;
                break;
            }
        }
        return this_;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        Disposable disposable = this.currentActivityLifeCycleDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.invocationRequestListenerImp = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        void var1_1;
        if (instabugInvocationEvent == null) {
            InstabugSDKLogger.e(InvocationManager.class.getName(), "Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        Object object = invocationManager.currentInvokers;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((a)object.next()).c();
            }
            this.currentInvokers.clear();
        }
        object = this.currentInstabugInvocationEvents;
        int n2 = this.currentInstabugInvocationEvents.length;
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3 = object[i2];
            InstabugSDKLogger.d(TAG, "set instabug invocation event: " + (Object)object3);
            if (object3 == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                ArrayList arrayList;
                object2 = arrayList;
                arrayList = new ArrayList();
                this.currentInvokers = object2;
            }
            object2 = Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (c.a[object3.ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    this.currentInvokers.add(new d(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 3: {
                    if (object2 != null) {
                        h h2;
                        object3 = h2;
                        h2 = new h((Context)object2, this.invocationRequestListenerImp);
                        this.currentInvokers.add((a)object3);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    this.currentInvokers.add(new com.instabug.library.invocation.d.b(this.invocationRequestListenerImp));
                    continue block7;
                }
                case 1: {
                    if (object2 != null) {
                        g g2;
                        object3 = g2;
                        ((g)object3)((Context)object2, this.invocationRequestListenerImp);
                        g2.a(this.currentInvocationSettings.getShakeThreshold());
                        this.currentInvokers.add((a)object3);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    InstabugInvocationEvent[] removeDuplicates(InstabugInvocationEvent[] events) {
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n2 = events.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            void var5_5 = var1_1[i2];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        Object object = arrayList2;
        return ((ArrayList)object).toArray(new InstabugInvocationEvent[((ArrayList)object).size()]);
    }

    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        return Arrays.copyOf(this.currentInstabugInvocationEvents, this.currentInstabugInvocationEvents.length);
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<a> getCurrentInvokers() {
        return this.currentInvokers;
    }

    @Nullable
    public a getLastUsedInvoker() {
        return this.lastUsedInvoker;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastUsedInvoker(@Nullable a lastUsedInvoker) {
        void var1_1;
        this.lastUsedInvoker = var1_1;
    }

    public void listen() {
        if (Instabug.isEnabled() && ((InvocationManager)this).isInvocationAvailable && ((InvocationManager)this).isPromptOptionsAvailable() && ((InvocationManager)this).currentInvokers != null && InstabugCore.getTargetActivity() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (a a2 : ((InvocationManager)this).currentInvokers) {
                if (a2.b()) continue;
                a2.a();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy() && (iterator = ((InvocationManager)((Object)iterator)).currentInvokers) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var1_1;
                a a2 = (a)iterator.next();
                if (!(a2 instanceof h)) continue;
                ((h)a2).a((MotionEvent)var1_1);
                break;
            }
        }
    }

    public void sleep() {
        Object this_ = ((InvocationManager)this_).currentInvokers;
        if (this_ != null) {
            this_ = this_.iterator();
            while (this_.hasNext()) {
                a a2 = (a)this_.next();
                if (!a2.b()) continue;
                a2.c();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable = false;
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable = true;
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.a.d();
    }

    public void notifyPrimaryColorChanged() {
        Object object;
        if (Instabug.isEnabled() && (object = this.currentInvokers) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                final a a2 = (a)object.next();
                if (InstabugCore.getTargetActivity() == null || !(a2 instanceof com.instabug.library.invocation.d.b)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this){

                    @Override
                    public void run() {
                        b b2 = this;
                        b2.a2.c();
                        b2.a2.a();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        com.instabug.library.invocation.d.b b2 = invocationManager.getFloatingButtonInvoker();
        if (b2 != null) {
            if (bl) {
                b2.c();
            } else {
                b2.e();
            }
        }
    }

    public void show() {
        com.instabug.library.invocation.b b2 = this.invocationRequestListenerImp;
        if (b2 != null) {
            b2.a();
        }
        this.lastUsedInvoker = null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        com.instabug.library.invocation.b this_ = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (this_ != null) {
            void var1_1;
            this_.b((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        com.instabug.library.invocation.b this_ = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (this_ != null) {
            void var1_1;
            this_.a((int)var1_1);
        }
    }
}

