/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import android.os.Build;
import android.util.Base64;
import com.instabug.library.encryption.b;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.charset.Charset;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/instabug/library/encryption/EncryptionManager;", "", "()V", "AES_MODE", "", "ENCRYPTION_NEW_LINE_REPLACEMENT", "ENCRYPTION_PREFIX", "LINE_FEED", "TAG", "iv", "", "getIv", "()[B", "decrypt", "data", "encrypt", "getIvSpec", "Ljava/security/spec/AlgorithmParameterSpec;", "instabug-core_defaultUiRelease"})
public final class EncryptionManager {
    private static final String TAG = "EncryptionManager";
    private static final String AES_MODE = "AES/GCM/NoPadding";
    private static final String ENCRYPTION_PREFIX = "^instaEncrypted^";
    private static final String ENCRYPTION_NEW_LINE_REPLACEMENT = "^instaLINE^";
    @NotNull
    public static final String LINE_FEED = "\n\r";
    @NotNull
    private static final byte[] iv;
    public static final EncryptionManager INSTANCE;

    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data) {
        String string2;
        if (data != null) {
            block8: {
                if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) break block8;
                return string2;
            }
            Cipher cipher = Cipher.getInstance(AES_MODE);
            cipher.init(1, b.a(), INSTANCE.getIvSpec());
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = cipher.doFinal(byArray);
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"cipher.doFinal(data.toByteArray())");
                StringBuilder stringBuilder = new StringBuilder().append(ENCRYPTION_PREFIX);
                String string3 = Base64.encodeToString((byte[])byArray2, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeToString(cipherText, Base64.DEFAULT)");
                return stringBuilder.append(StringsKt.replace$default((String)string3, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null)).toString();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "OOM while encrypting string, returning original string", outOfMemoryError);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "Error while encrypting string, returning original string", exception);
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data) {
        String string2;
        block12: {
            block11: {
                Object object;
                if (data == null) break block11;
                if (string2.length() == 0) {
                    return "";
                }
                if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
                    return string2;
                }
                String string3 = string2;
                Object object2 = string3.substring(16, string3.length());
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                try {
                    object = Base64.decode((String)StringsKt.replace$default((String)object2, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null), (int)0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return object2;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Base64.decode(encryptedD\u2026NT,\"\\n\"), Base64.DEFAULT)");
                Cipher cipher = Cipher.getInstance(AES_MODE);
                cipher.init(2, b.a(), INSTANCE.getIvSpec());
                byte[] byArray = cipher.doFinal((byte[])object);
                object2 = byArray;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"decryptedBytes");
                Charset charset = Charset.forName("UTF-8");
                object = charset;
                try {
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
                    return new String((byte[])object2, (Charset)object);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(TAG, "OOM while decrypting string, returning original string", outOfMemoryError);
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Error while decrypting string, returning null", exception);
                }
                break block12;
            }
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(AES_MODE);
        Object object = INSTANCE.getIvSpec();
        cipher.init(1, b.a(), (AlgorithmParameterSpec)object);
        byte[] byArray = cipher.doFinal((byte[])object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(AES_MODE);
        Object object = INSTANCE.getIvSpec();
        cipher.init(2, b.a(), (AlgorithmParameterSpec)object);
        byte[] byArray = cipher.doFinal((byte[])object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    private final AlgorithmParameterSpec getIvSpec() {
        Object object;
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            object = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(96, iv);
        } else {
            IvParameterSpec ivParameterSpec;
            object = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(iv);
        }
        return object;
    }

    private EncryptionManager() {
    }

    static {
        INSTANCE = new EncryptionManager();
        byte[] byArray = "RandomAESIv1".getBytes(Charsets.UTF_8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        iv = byArray;
        try {
            System.loadLibrary("ibg-native");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e(TAG, "Error loading native library", unsatisfiedLinkError);
        }
    }

    @NotNull
    public final byte[] getIv() {
        return iv;
    }
}

