/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import android.view.Window;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.d;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.b;
import com.instabug.library.tracking.e;
import com.instabug.library.tracking.f;
import com.instabug.library.tracking.g;
import com.instabug.library.tracking.h;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    public static final String TAG = "InstabugInternalTrackingDelegate";
    private static volatile InstabugInternalTrackingDelegate INSTANCE;
    private boolean isRegistered = false;
    private final a currentActivityMonitor;
    private final b activityLifecycleListener;
    @Nullable
    private WeakReference<Fragment> lastResumedFragment;
    @Nullable
    private WeakReference<Activity> currentActivity;
    private final h navigableViewsTrackingDelegate;

    public static void init(@Nullable Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@Nullable Application application) {
        h h2;
        b b2;
        a a2;
        Object object = a2;
        a2 = new a();
        ((InstabugInternalTrackingDelegate)((Object)h3)).currentActivityMonitor = object;
        object = b2;
        b2 = new b();
        ((InstabugInternalTrackingDelegate)((Object)h3)).activityLifecycleListener = object;
        if (application != null) {
            void var1_1;
            ((InstabugInternalTrackingDelegate)((Object)h3)).currentActivityMonitor.a((Application)var1_1);
            ((InstabugInternalTrackingDelegate)((Object)h3)).registerActivityLifecycleListener((Application)var1_1);
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = h3;
        h h3 = h2;
        h2 = new h();
        instabugInternalTrackingDelegate.navigableViewsTrackingDelegate = h3;
    }

    /*
     * WARNING - void declaration
     */
    private void registerWindowCallbacksIfNeeded(Activity activity) {
        void var1_1;
        if (activity == null) {
            return;
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = var1_1.getWindow();
        if (instabugInternalTrackingDelegate == null) {
            return;
        }
        if (!((instabugInternalTrackingDelegate = instabugInternalTrackingDelegate.getCallback()) instanceof g)) {
            InstabugSDKLogger.d(TAG, "register WindowCallbacks needed");
            var1_1.getWindow().setCallback((Window.Callback)new g((Window.Callback)instabugInternalTrackingDelegate));
        }
    }

    private boolean isUserTrackingStepsEnable() {
        return d.e().b((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isReproStepsEnable() {
        return d.e().b((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
            f.e().a(var1_1.getClass().getName(), "APPLICATION_CREATED");
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " created");
                f.e().a(string2.getClass().getName(), "ACTIVITY_CREATED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_CREATED", this_, string2, null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " started");
                f.e().a(string2.getClass().getName(), "ACTIVITY_STARTED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_STARTED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " resumed");
                f.e().a(var1_1.getClass().getName(), "ACTIVITY_RESUMED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                String string2 = v02.getClass().getSimpleName();
                String string3 = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_RESUMED", string2, string3, null);
                this.navigableViewsTrackingDelegate.b((Activity)var1_1);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
            this.registerWindowCallbacksIfNeeded((Activity)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentActivity(Activity activity) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            WeakReference<void> weakReference;
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            instabugInternalTrackingDelegate.currentActivity = this_;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = null;
        WeakReference<Activity> weakReference = this.currentActivity;
        if (weakReference != null) {
            object = (Activity)weakReference.get();
        }
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w(TAG, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w(TAG, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " paused");
                f.e().a(var1_1.getClass().getName(), "ACTIVITY_PAUSED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                object = v02.getClass().getSimpleName();
                weakReference = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_PAUSED", (String)object, (String)((Object)weakReference), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
        this.navigableViewsTrackingDelegate.a((Activity)var1_1);
    }

    void handleActivityStoppedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " stopped");
                f.e().a(string2.getClass().getName(), "ACTIVITY_STOPPED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_STOPPED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " destroyed");
                f.e().a(var1_1.getClass().getName(), "ACTIVITY_DESTROYED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                object = v02.getClass().getSimpleName();
                String string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.h.g().a("ACTIVITY_DESTROYED", (String)object, string2, null);
            }
            if (var1_1 != null && (object = this.currentActivity) != null && ((Reference)object).get() != null && var1_1 == this.currentActivity.get()) {
                this.currentActivity.clear();
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    void onFragmentAttached(Fragment fragment) {
        String string2;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_ATTACHED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = string2;
            String this_ = v1.getClass().getSimpleName();
            string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_ATTACHED", this_, string2, null);
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.ATTACHED);
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        Object object = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (object != null && ((Reference)object).get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_VIEW_CREATED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            void v2 = var1_1;
            String this_ = v2.getClass().getSimpleName();
            object = v2.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_VIEW_CREATED", this_, (String)object, null);
            instabugInternalTrackingDelegate.navigableViewsTrackingDelegate.b((Fragment)var1_1);
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.VIEW_CREATED);
    }

    void onFragmentStarted(Fragment fragment) {
        String string2;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STARTED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = string2;
            String this_ = v1.getClass().getSimpleName();
            string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_STARTED", this_, string2, null);
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        WeakReference<void> weakReference;
        WeakReference<Activity> weakReference2 = weakReference;
        weakReference = new WeakReference<void>(var1_1);
        this.lastResumedFragment = weakReference2;
        weakReference2 = this.currentActivity;
        if (weakReference2 != null && weakReference2.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            weakReference2 = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(var1_1.getClass().getName(), weakReference2.getClass().getName(), "FRAGMENT_RESUMED");
            }
        }
        if (this.isReproStepsEnable() && var1_1.getUserVisibleHint()) {
            weakReference2 = com.instabug.library.visualusersteps.h.g();
            String string2 = var1_1 instanceof DialogFragment ? "DIALOG_FRAGMENT_RESUMED" : "FRAGMENT_RESUMED";
            WeakReference<Activity> weakReference3 = weakReference2;
            void v3 = var1_1;
            weakReference2 = v3.getClass().getSimpleName();
            ((com.instabug.library.visualusersteps.h)((Object)weakReference3)).a(string2, (String)((Object)weakReference2), v3.getClass().getName(), null);
        }
        if (var1_1 != null && var1_1.getActivity() != null) {
            this.registerWindowCallbacksIfNeeded((Activity)var1_1.getActivity());
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.RESUMED);
    }

    void onFragmentPaused(Fragment fragment) {
        String string2;
        ((InstabugInternalTrackingDelegate)((Object)this_)).lastResumedFragment = null;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_PAUSED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = string2;
            String this_ = v1.getClass().getSimpleName();
            string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_PAUSED", this_, string2, null);
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.PAUSED);
    }

    void onFragmentStopped(Fragment fragment) {
        String string2;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STOPPED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = string2;
            String this_ = v1.getClass().getSimpleName();
            string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_STOPPED", this_, string2, null);
        }
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        Object object = this.currentActivity;
        if (object != null && ((Reference)object).get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                f.e().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_DETACHED");
            }
        }
        if (this.isReproStepsEnable()) {
            void v1 = var1_1;
            object = v1.getClass().getSimpleName();
            String string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_DETACHED", (String)object, string2, null);
        }
        this.navigableViewsTrackingDelegate.a((Fragment)var1_1);
        CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.DETACHED);
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_3;
        Activity activity = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        if (activity != null && activity.get() != null) {
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                void var1_1;
                f.e().a(var2_3.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, "FRAGMENT_VISIBILITY_CHANGED");
            }
        }
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
            void v1 = var2_3;
            String this_ = v1.getClass().getSimpleName();
            String string2 = v1.getClass().getName();
            com.instabug.library.visualusersteps.h.g().a("FRAGMENT_VISIBILITY_CHANGED", this_, string2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        e.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = null;
        WeakReference<Activity> weakReference = instabugInternalTrackingDelegate.currentActivity;
        if (weakReference != null) {
            activity = (Activity)weakReference.get();
        }
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    @Nullable
    public Object getLastSeenView() {
        WeakReference<Fragment> weakReference = this.lastResumedFragment;
        if (weakReference != null && weakReference.get() != null) {
            return this.lastResumedFragment.get();
        }
        return this.getTargetActivity();
    }

    /*
     * WARNING - void declaration
     */
    public void registerActivityLifecycleListener(Application application) {
        void var1_1;
        InstabugSDKLogger.d(TAG, "Registering activity lifecycle listener");
        var1_1.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.registerComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterActivityLifecycleListener(Application application) {
        void var1_1;
        InstabugSDKLogger.d(TAG, "Unregistering activity lifecycle listener");
        var1_1.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.unregisterComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = false;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        com.instabug.library.core.eventbus.a this_ = com.instabug.library.core.eventbus.a.getInstance();
        this_.a((Configuration)var1_1);
        com.instabug.library.core.eventbus.a.getInstance().post(this_);
    }
}

