/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AttachmentsDbHelper;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AttachmentsUtility {
    public static final String TAG = "AttachmentsUtility";
    public static final double MAX_FILE_SIZE_IN_MB = 5.0;

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentsUtility.getNewDirectory(context, "videos");
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(DiskUtils.getInstabugDirectory(context2) + "/" + (String)var1_1 + "/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static Pair<String, String> getFileNameAndSize(Context context, @Nullable Uri uri) {
        Context context2;
        block11: {
            String string2;
            if (uri == null) {
                return null;
            }
            if ((context2 = context2.getContentResolver().query((Uri)string2, null, null, null, null)) != null) {
                Pair pair;
                if (!context2.moveToFirst()) break block11;
                Context context3 = context2;
                Context context4 = context3;
                Context context5 = context3;
                Context context6 = context3;
                string2 = context3.getString(context3.getColumnIndex("_display_name"));
                String string3 = context6.getString(context5.getColumnIndex("_size"));
                Pair pair2 = pair;
                try {
                    pair = new Pair((Object)string2, (Object)string3);
                    return pair2;
                }
                finally {
                    if (context4 != null) {
                        context2.close();
                    }
                }
            }
        }
        if (context2 != null) {
            context2.close();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @RequiresApi(api=19)
    public static InputStream getFileInputStreamFileFromUri(Context context, Uri fileUri) {
        try {
            void var1_1;
            return context.getContentResolver().openInputStream((Uri)var1_1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, @Nullable Uri uri) {
        void var1_2;
        Cursor cursor;
        if (uri == null) {
            return null;
        }
        Cursor cursor2 = cursor;
        Cursor cursor3 = new String[1];
        cursor = cursor3;
        cursor3[0] = "_data";
        if ((cursor = cursor2.managedQuery((Uri)var1_2, (String[])cursor, null, null, null)) != null) {
            Cursor cursor4 = cursor;
            int n2 = cursor4.getColumnIndexOrThrow("_data");
            cursor4.moveToFirst();
            return cursor4.getString(n2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        void var1_2;
        Context context2;
        if (originalUri != null && context2 != null && var1_2.getPath() != null) {
            File file;
            block7: {
                File file2;
                Object object = var1_2.getLastPathSegment();
                File file3 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
                object = object == null ? "" : ((String)object).toLowerCase();
                if (file != null && SettingsManager.getInstance().getExtraAttachmentFiles() != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                    object = file;
                }
                file = file2;
                if (new File(file3, (String)object).exists()) {
                    File file4;
                    file = file4;
                    file4 = new File(file3, System.currentTimeMillis() + "_" + (String)object);
                }
                try {
                    if (AttachmentsUtility.validateFileSize((Uri)var1_2, 5.0)) break block7;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                    return null;
                }
                InstabugSDKLogger.w(TAG, "Attachment file " + var1_2.toString() + " size exceeds than the limit " + 5.0);
                return null;
            }
            DiskUtils.copyFromUriIntoFile(context2, (Uri)var1_2, file);
            return Uri.fromFile((File)file);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri, @Nullable String fileNameWithExtension, double fileSizeLimitInMbs) {
        void var1_2;
        Context context2;
        if (originalUri != null && context2 != null && var1_2.getPath() != null) {
            File file;
            block7: {
                File file2;
                Object object = var1_2.getLastPathSegment();
                File file3 = AttachmentsUtility.getFilesAttachmentDirectory(context2);
                object = object == null ? "" : ((String)object).toLowerCase();
                if (file != null && SettingsManager.getInstance().getExtraAttachmentFiles() != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_2)) {
                    object = file;
                }
                file = file2;
                if (new File(file3, (String)object).exists()) {
                    File file4;
                    file = file4;
                    file4 = new File(file3, System.currentTimeMillis() + "_" + (String)object);
                }
                try {
                    void var3_4;
                    if (AttachmentsUtility.validateFileSize((Uri)var1_2, (double)var3_4)) break block7;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(TAG, iOException.getMessage(), iOException);
                    return null;
                }
                InstabugSDKLogger.w(TAG, "Attachment file " + var1_2.toString() + " size exceeds than the limit " + 5.0);
                return null;
            }
            DiskUtils.copyFromUriIntoFile(context2, (Uri)var1_2, file);
            return Uri.fromFile((File)file);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileAttachmentUri(@Nullable Context context, Uri originalUri) {
        void var1_1;
        return AttachmentsUtility.getNewFileAttachmentUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File getAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentsUtility.getFilesAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        void var2_2;
        Object object;
        object = AttachmentsUtility.getAttachmentFile(object, (String)var2_2);
        try {
            AttachmentsUtility.saveBytesToFile(data, (File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            InstabugSDKLogger.e(TAG, iOException.getMessage(), (Throwable)object);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        void var0_3;
        BufferedOutputStream bufferedOutputStream;
        block6: {
            byte[] byArray;
            BufferedOutputStream bufferedOutputStream2;
            Object var2_5 = null;
            bufferedOutputStream = bufferedOutputStream2;
            try {
                void var1_4;
                byte[] byArray2;
                byArray = byArray2;
                bufferedOutputStream(new FileOutputStream((File)var1_4));
            }
            catch (Throwable throwable) {
                bufferedOutputStream = var2_5;
                break block6;
            }
            try {
                bufferedOutputStream2.write(byArray);
            }
            catch (Throwable throwable) {
                break block6;
            }
            bufferedOutputStream2.flush();
            bufferedOutputStream2.close();
            return;
        }
        if (bufferedOutputStream != null) {
            BufferedOutputStream bufferedOutputStream3 = bufferedOutputStream;
            bufferedOutputStream3.flush();
            bufferedOutputStream3.close();
        }
        throw var0_3;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"RESOURCE_LEAK"})
    public static File saveInputStreamToFile(Context context, InputStream inputStream, String fileName) {
        Throwable throwable;
        FileOutputStream fileOutputStream;
        block22: {
            block24: {
                block23: {
                    int n2;
                    Object object;
                    File file;
                    block25: {
                        FileOutputStream fileOutputStream2;
                        File file2;
                        file = file2;
                        file2 = new File(AttachmentsUtility.getFilesAttachmentDirectory(object), (String)((Object)fileOutputStream));
                        object = null;
                        fileOutputStream = fileOutputStream2;
                        fileOutputStream2 = new FileOutputStream(file);
                        object = new byte[1024];
                        break block25;
                        catch (Throwable throwable2) {
                            fileOutputStream = object;
                            break block22;
                        }
                        catch (Exception exception) {
                            fileOutputStream = object;
                            break block23;
                        }
                        catch (IOException iOException) {
                            fileOutputStream = object;
                            break block24;
                        }
                    }
                    while ((n2 = ((InputStream)((Object)throwable)).read((byte[])object)) != -1) {
                        fileOutputStream.write((byte[])object, 0, n2);
                    }
                    FileOutputStream fileOutputStream3 = fileOutputStream;
                    FileOutputStream fileOutputStream4 = fileOutputStream3;
                    FileOutputStream fileOutputStream5 = fileOutputStream3;
                    ((InputStream)((Object)throwable)).close();
                    try {
                        fileOutputStream4.flush();
                        fileOutputStream5.close();
                        return file;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    return file;
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        break block22;
                    }
                    catch (Exception exception) {
                        throwable = exception;
                    }
                    catch (IOException iOException) {
                        throwable = iOException;
                        break block24;
                    }
                }
                InstabugSDKLogger.e(TAG, throwable.getMessage(), throwable);
                if (fileOutputStream == null) return null;
                try {
                    FileOutputStream fileOutputStream6 = fileOutputStream;
                    fileOutputStream6.flush();
                    fileOutputStream6.close();
                    return null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            InstabugSDKLogger.e(TAG, "IO exception: " + throwable.getMessage(), throwable);
            if (fileOutputStream == null) return null;
            try {
                FileOutputStream fileOutputStream7 = fileOutputStream;
                fileOutputStream7.flush();
                fileOutputStream7.close();
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
            catch (Throwable throwable4) {
                // empty catch block
            }
        }
        if (fileOutputStream == null) throw throwable;
        try {
            FileOutputStream fileOutputStream8 = fileOutputStream;
            fileOutputStream8.flush();
            fileOutputStream8.close();
            throw throwable;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw throwable;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=19)
    @Nullable
    public static File getFileFromContentProvider(Context context, @Nullable Uri uri, String fileName) {
        Context context2;
        InputStream inputStream;
        if (uri == null) {
            return null;
        }
        if ((inputStream = AttachmentsUtility.getFileInputStreamFileFromUri(context2, (Uri)inputStream)) != null) {
            void var2_2;
            return AttachmentsUtility.saveInputStreamToFile(context2, inputStream, (String)var2_2);
        }
        InstabugSDKLogger.e(TAG, "Inputstream is null");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean validateFileSize(Uri originalUri, double maxFileSize) {
        void var1_1;
        double d2;
        long l2;
        Uri uri;
        if (Instabug.getApplicationContext() == null) {
            return false;
        }
        if (uri.getPath() == null) {
            return false;
        }
        if (uri.toString().contains("android.resource")) {
            InputStream inputStream;
            block7: {
                try {
                    inputStream = Instabug.getApplicationContext().getContentResolver().openInputStream(uri);
                    if (inputStream != null) break block7;
                    return false;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.w(TAG, "External attachment file " + uri.getPath() + " couldn't be loaded to calculate its size");
                    return false;
                }
            }
            l2 = inputStream.available();
        }
        l2 = new File(uri.getPath()).length();
        double d3 = l2;
        double d4 = d3 / 1048576.0;
        if (d2 > var1_1) {
            InstabugSDKLogger.w(TAG, "External attachment file size is " + l2 + " bytes or " + d4 + " MBs > maxFileSize " + (double)var1_1);
            return false;
        }
        return AttachmentsUtility.isValidSize(d3, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidSize(double sizeInBytes, double maxFileSize) {
        void var2_1;
        double d2;
        double d3 = sizeInBytes / 1048576.0;
        if (d2 > var2_1) {
            InstabugSDKLogger.w(TAG, "External attachment file size is " + d3 + " MBs > maxFileSize " + (double)var2_1);
            return false;
        }
        return true;
    }

    public static void encryptAttachments(@Nullable List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachments");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted() || attachment.getLocalPath() == null) continue;
                Attachment attachment2 = attachment;
                attachment2.setEncrypted(InstabugCore.encrypt(attachment2.getLocalPath()));
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void encryptAttachmentsAndUpdateDb(@Nullable List<Attachment> attachments) {
        InstabugSDKLogger.d(TAG, "encryptAttachmentsAndUpdateDb");
        if (attachments != null) {
            Iterator<Attachment> iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ContentValues contentValues;
                Attachment attachment = (Attachment)iterator.next();
                if (attachment.isEncrypted() || attachment.getLocalPath() == null) continue;
                Attachment attachment2 = attachment;
                boolean bl = InstabugCore.encrypt(attachment2.getLocalPath());
                attachment2.setEncrypted(bl);
                ContentValues contentValues2 = contentValues;
                contentValues2();
                contentValues.put("encrypted", Boolean.valueOf(bl));
                AttachmentsDbHelper.update(attachment2.getId(), contentValues2);
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static boolean decryptAttachmentAndUpdateDb(Attachment attachment) {
        Attachment attachment2;
        InstabugSDKLogger.d(TAG, "decryptAttachmentAndUpdateDb");
        if (attachment.isEncrypted() && attachment2.getLocalPath() != null) {
            ContentValues contentValues;
            boolean bl = InstabugCore.decrypt(attachment2.getLocalPath());
            Attachment attachment3 = attachment2;
            attachment3.setEncrypted(bl ^ true);
            attachment2 = contentValues;
            attachment2();
            String string2 = "encrypted";
            contentValues.put(string2, Boolean.valueOf(bl ^ true));
            AttachmentsDbHelper.update(attachment3.getId(), (ContentValues)attachment2);
            return bl;
        }
        return true;
    }
}

