/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class DiskUtils {
    public static final String TAG = "DiskUtils";
    private final Context context;

    /*
     * WARNING - void declaration
     */
    private DiskUtils(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getInstabugDirectory(Context context) {
        File file;
        Object object;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = DiskUtils.getInternalStoragePath(object);
                InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
            }
        } else {
            object = DiskUtils.getInternalStoragePath(object);
            InstabugSDKLogger.i(TAG, "External storage not available, saving file to internal storage.");
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static synchronized File getInsatbugLogDirectory(String directoryLogName, Context context) {
        String string2;
        File file;
        String string3 = DiskUtils.getInstabugDirectory(context).getAbsolutePath().concat("/");
        File file2 = file;
        if (!new File(string3.concat(string2)).exists() && !file2.mkdir()) {
            Log.w((String)TAG, (String)"failed logs directory to create");
        }
        return file2;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        void var1_1;
        if (bitmap != null && var1_1 != null) {
            Bitmap bitmap2;
            FileOutputStream fileOutputStream;
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "starting save viewHierarchy image, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2((File)var1_1);
            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream2);
            fileOutputStream.close();
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "viewHierarchy image saved, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File directory) {
        File[] fileArray;
        if (directory.exists() && fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    public static void copyFromUriIntoFile(@NonNull Context context, Uri source, File target) throws IOException {
        IOException iOException2;
        block8: {
            Object object;
            InputStream inputStream;
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            if (source != null && (inputStream = object.getContentResolver().openInputStream((Uri)inputStream)) != null) {
                BufferedInputStream bufferedInputStream2;
                bufferedInputStream = bufferedInputStream2;
                bufferedInputStream2 = new BufferedInputStream(inputStream);
            }
            if (bufferedInputStream != null) {
                void var2_4;
                InstabugSDKLogger.d(TAG, "Target file path: " + var2_4.getPath());
                inputStream = Uri.fromFile((File)var2_4);
                if (inputStream != null && (object = object.getContentResolver().openOutputStream((Uri)inputStream)) != null) {
                    BufferedOutputStream bufferedOutputStream;
                    filterOutputStream = bufferedOutputStream;
                    bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                }
                if (filterOutputStream != null) {
                    int n2;
                    object = new byte[32768];
                    while ((n2 = bufferedInputStream.read((byte[])object)) > 0) {
                        ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n2);
                    }
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException2) {
                    break block8;
                }
            }
            if (bufferedInputStream == null) return;
            bufferedInputStream.close();
            return;
        }
        if (iOException2.getMessage() == null) return;
        InstabugSDKLogger.e(TAG, iOException2.getMessage(), iOException2);
    }

    public static void deleteFile(String fileLocalPath) {
        String string2;
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                new File(string2).delete();
            }
        });
    }

    public static DiskUtils with(Context context) {
        Context context2;
        return new DiskUtils(context2);
    }

    public static boolean isFileExist(String path) {
        String string2;
        return new File(string2).exists();
    }

    /*
     * WARNING - void declaration
     */
    public static File createStateTextFile(Context context, String fileNamePrefix) {
        void var1_1;
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append(object.getFilesDir().getAbsolutePath());
        object = File.pathSeparator;
        return new File(stringBuilder.append((String)object).append((String)var1_1).append((String)object).append(System.currentTimeMillis()).append(".txt").toString());
    }

    public static void deleteCrashStateFiles() {
        DiskUtils.deleteStateFiles("crash_state");
    }

    public static void deleteAllStateFiles() {
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            object = object.getFilesDir().getParentFile();
            FilenameFilter filenameFilter = (dir, name) -> {
                void var1_1;
                return name.startsWith("files:") && var1_1.endsWith(".txt");
            };
            if (object != null && (object = ((File)object).listFiles(filenameFilter)) != null) {
                int n2 = ((Object)object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((File)object[i2]).delete();
                }
            }
        }
    }

    public static void deleteStateFiles(String filePrefix) {
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            File[] fileArray;
            FilenameFilter filenameFilter;
            object = object.getFilesDir().getParentFile();
            FilenameFilter filenameFilter2 = filenameFilter;
            filenameFilter = new FilenameFilter((String)fileArray){
                final /* synthetic */ String a;
                {
                    this.a = string2;
                }

                @Override
                public boolean accept(File file, String string2) {
                    return string2.startsWith("files:" + this.a) && string2.endsWith(".txt");
                }
            };
            if (object != null && (fileArray = ((File)object).listFiles(filenameFilter2)) != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2].delete();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> operation) {
        void var1_1;
        return new ReadOperationExecutor((DiskOperation<String, Void>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> operation) {
        void var1_1;
        return new WriteOperationExecutor(this.context, (DiskOperation<Uri, Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> operation) {
        void var1_1;
        return new DeleteOperationExecutor((DiskOperation<Boolean, Void>)var1_1);
    }
}

