/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2.request;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.b;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    private static final String TAG = "Request";
    private static final String SHORTEN_APP_TOKEN = "at";
    private static final String SHORTEN_UUID = "uid";
    private static final String APP_TOKEN = "application_token";
    private static final String UUID = "uuid";
    public static final String BASIC_AUTH_VALUE_PREFIX = "Basic ";
    @Nullable
    private final String appTokenValue = SettingsManager.getInstance().getAppToken();
    private final String uuidValue = b.i();
    private final String sdkVersionValue = DeviceStateProvider.getSdkVersion();
    private final String requestUrl;
    @Nullable
    private final String endPoint;
    @Nullable
    private final String requestMethod;
    private final int requestType;
    private final List<RequestParameter> urlParameters;
    private final List<RequestParameter> bodyParameters;
    private final List<RequestParameter<String>> headers;
    @Nullable
    private final FileToUpload fileToUpload;
    @Nullable
    private final File downloadedFile;
    private final boolean shorten;
    private boolean hasUuid = true;
    private boolean noDefaultParameters = false;

    /*
     * WARNING - void declaration
     */
    public Request(Builder builder) {
        boolean bl;
        ArrayList arrayList;
        void var1_2;
        String string2;
        this.endPoint = string2 = ((Builder)var1_2).endpoint;
        string2 = builder.requestUrl != null ? ((Builder)var1_2).requestUrl : "https://api.instabug.com/api/sdk/v3" + string2;
        this.requestUrl = string2;
        int n2 = ((Builder)var1_2).type != -1 ? ((Builder)var1_2).type : 1;
        this.requestType = n2;
        this.requestMethod = ((Builder)var1_2).method;
        this.fileToUpload = ((Builder)var1_2).fileToUpload;
        this.downloadedFile = ((Builder)var1_2).downloadedFile;
        boolean bl2 = ((Builder)var1_2).shorten;
        n2 = bl2 ? 1 : 0;
        this.shorten = bl2;
        if (((Builder)var1_2).urlParameters != null) {
            arrayList = ((Builder)var1_2).urlParameters;
        } else {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
        }
        this.urlParameters = arrayList;
        if (((Builder)var1_2).bodyParameters != null) {
            arrayList = ((Builder)var1_2).bodyParameters;
        } else {
            ArrayList arrayList3;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
        this.bodyParameters = arrayList;
        if (((Builder)var1_2).headers != null) {
            arrayList = ((Builder)var1_2).headers;
        } else {
            ArrayList arrayList4;
            arrayList = arrayList4;
            arrayList4 = new ArrayList();
        }
        this.headers = arrayList;
        this.hasUuid = ((Builder)var1_2).hasUuid;
        this.noDefaultParameters = bl = ((Builder)var1_2).noDefaultParameters;
        this.handleBaseParams(n2 != 0, this.hasUuid, bl);
    }

    /*
     * WARNING - void declaration
     */
    private void handleBaseParams(boolean shorten, boolean hasUuid, boolean noDefaultParameters) {
        void var2_4;
        void var1_1;
        this.headers.add(new RequestParameter<String>("IBG-SDK-VERSION", this.sdkVersionValue));
        if (noDefaultParameters) {
            return;
        }
        if (var1_1 == false) {
            Object object = this.appTokenValue;
            if (object != null) {
                RequestParameter<String> requestParameter;
                RequestParameter<String> requestParameter2 = requestParameter;
                requestParameter = new RequestParameter<String>(APP_TOKEN, (String)object);
                this.addParameter(requestParameter2);
            }
            if (var2_4 != false) {
                RequestParameter<String> requestParameter;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(UUID, this.uuidValue);
                this.addParameter((RequestParameter)object);
            }
        } else {
            Object object = this.appTokenValue;
            if (object != null) {
                RequestParameter<String> requestParameter;
                RequestParameter<String> requestParameter3 = requestParameter;
                requestParameter = new RequestParameter<String>(SHORTEN_APP_TOKEN, (String)object);
                this.addParameter(requestParameter3);
            }
            if (var2_4 != false) {
                RequestParameter<String> requestParameter;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(SHORTEN_UUID, this.uuidValue);
                this.addParameter((RequestParameter)object);
            }
        }
    }

    private String getUrlEncodedParameters() {
        Request request = this_;
        a this_ = a.a();
        for (RequestParameter requestParameter : request.urlParameters) {
            this_.a(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void addParameter(RequestParameter requestParameter) {
        String string2 = this.requestMethod;
        if (string2 != null) {
            void var1_1;
            if (!string2.equals("GET") && !this.requestMethod.equals("DELETE")) {
                this.addBodyParameter((RequestParameter)var1_1);
            } else {
                this.addUrlParameter((RequestParameter)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addUrlParameter(RequestParameter parameter) {
        void var1_1;
        this.urlParameters.add((RequestParameter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addBodyParameter(RequestParameter parameter) {
        void var1_1;
        this.bodyParameters.add((RequestParameter)var1_1);
    }

    @Nullable
    public String getEndpoint() {
        return this.endPoint;
    }

    public String getRequestUrl() {
        if (!this.getUrlEncodedParameters().isEmpty()) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public String getRequestUrlForLogging() {
        if (SettingsManager.shouldLogExtraRequestData() && !this.getUrlEncodedParameters().isEmpty()) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public String getRequestMethod() {
        String this_ = ((Request)((Object)this_)).requestMethod;
        if (this_ == null) {
            return "GET";
        }
        return this_;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public List<RequestParameter<String>> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<RequestParameter> getRequestUrlParameters() {
        return Collections.unmodifiableList(this.urlParameters);
    }

    public List<RequestParameter> getRequestBodyParameters() {
        return Collections.unmodifiableList(this.bodyParameters);
    }

    /*
     * WARNING - void declaration
     */
    public String getRequestBody() {
        void var1_4;
        JSONObject jSONObject;
        Request request = this_;
        Request this_ = jSONObject;
        jSONObject = new JSONObject();
        Iterator<RequestParameter> iterator = request.getRequestBodyParameters().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Request request2 = this_;
            RequestParameter requestParameter = iterator.next();
            RequestParameter requestParameter2 = requestParameter;
            String string2 = requestParameter.getKey();
            request2.put(string2, requestParameter2.getValue());
        }
        try {
            return this_.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Request request3 = this_;
        System.gc();
        InstabugSDKLogger.e(TAG, "OOM Exception trying to remove large logs...", (Throwable)var1_4);
        var1_4.printStackTrace();
        try {
            request3.remove("console_log");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(TAG, "Failed to resolve OOM, returning empty request body", (Throwable)var1_4);
            outOfMemoryError.printStackTrace();
            return "{}";
        }
        request3.remove("instabug_log");
        request3.remove("network_log");
        return request3.toString();
    }

    @Nullable
    public FileToUpload getFileToUpload() {
        return this.fileToUpload;
    }

    @Nullable
    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public Builder builder() {
        return Builder.access$1300(Builder.access$1200(new Builder().endpoint(this.endPoint).url(this.requestUrl).method(this.requestMethod).type(this.requestType).shorten(this.shorten).fileToUpload(this.fileToUpload).fileToDownload(this.downloadedFile), this.bodyParameters), this.urlParameters).setHeaders(this.headers);
    }

    @NonNull
    public String toString() {
        String string2 = this.requestMethod;
        if (string2 != null && string2.equals("GET")) {
            return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod;
        }
        return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod + " | Body: " + this.getRequestBody();
    }

    public boolean isMultiPartRequest() {
        return this.fileToUpload != null;
    }

    public static class Builder {
        @Nullable
        private String requestUrl;
        @Nullable
        private String endpoint;
        @Nullable
        private String method;
        private int type;
        @Nullable
        private ArrayList<RequestParameter> urlParameters;
        @Nullable
        private ArrayList<RequestParameter> bodyParameters;
        @Nullable
        private ArrayList<RequestParameter<String>> headers;
        @Nullable
        private FileToUpload fileToUpload;
        @Nullable
        private File downloadedFile;
        private boolean shorten;
        private boolean hasUuid;
        private boolean noDefaultParameters;

        public Builder() {
            Builder builder = this_;
            builder.type = -1;
            builder.hasUuid = true;
            builder.noDefaultParameters = false;
            builder.addHeader(new RequestParameter<String>("IBG-OS", "android"));
            builder.addHeader(new RequestParameter<String>("IBG-OS-VERSION", Build.VERSION.RELEASE));
            builder.addHeader(new RequestParameter<String>("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion()));
            String string2 = SettingsManager.getInstance().getAppToken();
            if (string2 != null) {
                RequestParameter<String> requestParameter;
                Builder builder2 = this_;
                RequestParameter<String> this_ = requestParameter;
                requestParameter = new RequestParameter<String>("IBG-APP-TOKEN", string2);
                builder2.addHeader(this_);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Builder addUrlParameter(RequestParameter parameter) {
            void var1_1;
            if (this.urlParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.urlParameters = arrayList2;
            }
            Builder builder = this;
            builder.urlParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setUrlParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).urlParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).urlParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.urlParameters = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder addBodyParameter(RequestParameter parameter) {
            void var1_1;
            if (this.bodyParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.bodyParameters = arrayList2;
            }
            Builder builder = this;
            builder.bodyParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setBodyParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).bodyParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).bodyParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.bodyParameters = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1200(Builder x0, List x1) {
            void var1_1;
            return x0.setBodyParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1300(Builder x0, List x1) {
            void var1_1;
            return x0.setUrlParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder url(String url) {
            void var1_1;
            this.requestUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder endpoint(@Nullable String endpoint) {
            void var1_1;
            this.endpoint = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder method(@Nullable String requestMethod) {
            void var1_1;
            this.method = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder type(int requestType) {
            void var1_1;
            this.type = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addParameter(RequestParameter requestParameter) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.addBodyParameter((RequestParameter)var1_1);
                } else {
                    this.addUrlParameter((RequestParameter)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setParameter(List<RequestParameter> requestParameters) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.setBodyParameter((List<RequestParameter>)var1_1);
                } else {
                    this.setUrlParameter((List<RequestParameter>)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder shorten(boolean isShortedKeys) {
            void var1_1;
            this.shorten = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder hasUuid(boolean hasUuid) {
            void var1_1;
            this.hasUuid = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addHeader(RequestParameter<String> header) {
            void var1_1;
            if (this.headers == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.headers = arrayList2;
            }
            Builder builder = this;
            builder.headers.add((RequestParameter<String>)var1_1);
            return builder;
        }

        public Builder setHeaders(List<RequestParameter<String>> headers) {
            ArrayList arrayList;
            ArrayList arrayList2;
            if (headers == null) {
                ArrayList arrayList3;
                arrayList2 = arrayList3;
                arrayList3 = new ArrayList();
            }
            Builder builder = arrayList4;
            ArrayList arrayList4 = arrayList;
            arrayList = new ArrayList(arrayList2);
            builder.headers = arrayList4;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToUpload(@Nullable FileToUpload fileToUpload) {
            void var1_1;
            this.fileToUpload = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToDownload(@Nullable File file) {
            void var1_1;
            this.downloadedFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder disableDefaultParameters(boolean noDefaultParameters) {
            void var1_1;
            this.noDefaultParameters = var1_1;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }

    public static interface Callbacks<T, K> {
        public void onSucceeded(T var1);

        public void onFailed(K var1);
    }
}

