/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.dbv2;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.internal.storage.cache.dbv2.IBGCursor;
import com.instabug.library.internal.storage.cache.dbv2.IBGWhereArg;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.List;

public class IBGDbManager {
    public static final String TAG = "IBGDbManagerV2";
    private static SQLiteOpenHelper dbHelper;
    private static IBGDbManager instance;
    @Nullable
    private Boolean databaseTransactionsEnabled;
    @Nullable
    private SQLiteDatabase database;

    public static synchronized void init(com.instabug.library.internal.storage.cache.dbv2.a helper) {
        if (instance == null) {
            com.instabug.library.internal.storage.cache.dbv2.a a2;
            instance = new IBGDbManager();
            dbHelper = a2;
        }
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    public static synchronized IBGDbManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                IBGDbManager.init(new com.instabug.library.internal.storage.cache.dbv2.a(Instabug.getApplicationContext()));
            } else {
                throw new IllegalStateException("IBGDbManagerV2 is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    private IBGDbManager() {
    }

    private synchronized void openDatabase() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase == null || !sQLiteDatabase.isOpen()) {
            this.database = dbHelper.getWritableDatabase();
        }
    }

    private synchronized boolean databaseInitializedAndOpen() {
        IBGDbManager this_ = this_.database;
        return this_ != null && this_.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static synchronized void tearDown() {
        SQLiteOpenHelper sQLiteOpenHelper = dbHelper;
        if (sQLiteOpenHelper != null) {
            sQLiteOpenHelper.close();
            dbHelper = null;
        }
        IBGDbManager iBGDbManager = instance;
        synchronized (iBGDbManager) {
            SQLiteDatabase sQLiteDatabase = IBGDbManager.instance.database;
            if (sQLiteDatabase != null) {
                sQLiteDatabase.close();
                IBGDbManager.instance.database = null;
            }
            instance = null;
            return;
        }
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((IBGDbManager)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((IBGDbManager)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled(Instabug.getApplicationContext()) ^ true;
        }
        return (this = ((IBGDbManager)this).databaseTransactionsEnabled) != null ? (Boolean)this : false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logOperationFailedWarning(String message) {
        IBGDbManager this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on a closed database. Falling back silently");
        } else {
            void var1_1;
            InstabugSDKLogger.w(TAG, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(IBGDbManager x0, String x1) {
        void var1_1;
        x0.logOperationFailedWarning((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>((String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            {
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
            public Long a() {
                b b2 = this;
                b2.IBGDbManager.this.openDatabase();
                try {
                    if (b2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        b b3 = this;
                        String string2 = b3.a;
                        return IBGDbManager.this.database.insert(string2, b3.b, this.c.toContentValues());
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB insertion failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion failed due to: " + outOfMemoryError.getMessage());
                    return -1L;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB insertion failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion failed due to: " + exception.getMessage());
                    return -1L;
                }
            }
        });
        return l2 == null ? -1L : l2;
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>((String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            {
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
            public Long a() {
                c c2 = this;
                c2.IBGDbManager.this.openDatabase();
                try {
                    if (c2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        c c3 = this;
                        String string2 = c3.a;
                        return IBGDbManager.this.database.insertWithOnConflict(string2, c3.b, this.c.toContentValues(), 4);
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB insertion with on conflict failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict failed due to: " + outOfMemoryError.getMessage());
                    return -1L;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB insertion with on conflict failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict failed due to: " + exception.getMessage());
                    return -1L;
                }
            }
        });
        return l2 == null ? -1L : l2;
    }

    /*
     * WARNING - void declaration
     */
    public void execSQL(@NonNull String sql) {
        void var1_1;
        PoolProvider.getDatabaseExecutor().execute(new Runnable((String)var1_1){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public void run() {
                d d2 = this;
                d2.IBGDbManager.this.openDatabase();
                try {
                    if (d2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        IBGDbManager.this.database.execSQL(this.a);
                        return;
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB execution a sql failed");
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB execution a sql failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB execution a sql failed due to: " + outOfMemoryError.getMessage());
                    return;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB execution a sql failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB execution a sql failed due to: " + exception.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>((String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            {
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Long a() {
                e e2 = this;
                e2.IBGDbManager.this.openDatabase();
                try {
                    if (e2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        e e3 = this;
                        String string2 = e3.a;
                        return IBGDbManager.this.database.insertWithOnConflict(string2, e3.b, this.c.toContentValues(), 5);
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict replace failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB insertion with on conflict replace failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict replace failed due to: " + outOfMemoryError.getMessage());
                    return -1L;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB insertion with on conflict replace failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB insertion with on conflict replace failed due to: " + exception.getMessage());
                    return -1L;
                }
            }
        });
        return l2 == null ? -1L : l2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor rawQuery(@NonNull String sql, @Nullable List<IBGWhereArg> selectionArgs) {
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<IBGCursor>((String)var1_1, (List)var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ List b;
            {
                this.a = string2;
                this.b = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public IBGCursor a() {
                f f2 = this;
                f2.IBGDbManager.this.openDatabase();
                try {
                    if (f2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        return new IBGCursor(IBGDbManager.this.database.rawQuery(this.a, IBGWhereArg.argsListToStringArray(this.b)));
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB raw query faile");
                    return null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB raw query failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB raw query faile due to: " + outOfMemoryError.getMessage());
                    return null;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB raw query failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB raw query faile due to: " + exception.getMessage());
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Integer>((String)var1_1, (String)var2_2, (List)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ List c;
            {
                this.a = string2;
                this.b = string3;
                this.c = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Integer a() {
                g g2 = this;
                g2.IBGDbManager.this.openDatabase();
                try {
                    if (g2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        g g3 = this;
                        String string2 = g3.a;
                        return IBGDbManager.this.database.delete(string2, g3.b, IBGWhereArg.argsListToStringArray(this.c));
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB deletion failed");
                    return 0;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB deletion failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB deletion failed due to: " + outOfMemoryError.getMessage());
                    return 0;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB deletion failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB deletion failed due to: " + exception.getMessage());
                }
                return 0;
            }
        });
        return n2 == null ? 0 : n2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<IBGCursor>((String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            {
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            @Nullable
            public IBGCursor a() {
                h h2 = this;
                h2.IBGDbManager.this.openDatabase();
                try {
                    if (h2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        h h3 = this;
                        String string2 = h3.a;
                        String[] stringArray = h3.b;
                        String string3 = h3.c;
                        String[] stringArray2 = IBGWhereArg.argsListToStringArray(h3.d);
                        String string4 = h3.e;
                        String string5 = h3.f;
                        String string6 = h3.g;
                        return new IBGCursor(IBGDbManager.this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6));
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB query faile");
                    return null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    NonFatals.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query faile due to: " + outOfMemoryError.getMessage());
                    return null;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB query failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query faile due to: " + exception.getMessage());
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int update(@NonNull String table, @NonNull IBGContentValues values, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Integer>((String)var1_1, (IBGContentValues)var2_2, (String)var3_3, (List)var4_4){
            final /* synthetic */ String a;
            final /* synthetic */ IBGContentValues b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            {
                this.a = string2;
                this.b = iBGContentValues;
                this.c = string3;
                this.d = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Integer a() {
                i i2 = this;
                i2.IBGDbManager.this.openDatabase();
                try {
                    if (i2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        i i3 = this;
                        String string2 = i3.a;
                        ContentValues contentValues = i3.b.toContentValues();
                        String string3 = i3.c;
                        return IBGDbManager.this.database.update(string2, contentValues, string3, IBGWhereArg.argsListToStringArray(this.d));
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB update failed");
                    return -1;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB update failed: " + outOfMemoryError.getMessage());
                    NonFatals.reportNonFatal(outOfMemoryError, "DB update failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB update failed due to: " + outOfMemoryError.getMessage());
                    return -1;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB update failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB update failed due to: " + exception.getMessage());
                    return -1;
                }
            }
        });
        return n2 == null ? 0 : n2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<IBGCursor>((String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7, (String)var8_8){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ String h;
            {
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
                this.h = string7;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public IBGCursor a() {
                j j2 = this;
                j2.IBGDbManager.this.openDatabase();
                try {
                    if (j2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        j j3 = this;
                        String string2 = j3.a;
                        String[] stringArray = j3.b;
                        String string3 = j3.c;
                        String[] stringArray2 = IBGWhereArg.argsListToStringArray(j3.d);
                        String string4 = j3.e;
                        String string5 = j3.f;
                        String string6 = j3.g;
                        String string7 = j3.h;
                        return new IBGCursor(IBGDbManager.this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6, string7));
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB query failed");
                    return null;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB query failed: " + outOfMemoryError.getMessage());
                    NonFatals.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query failed due to: " + outOfMemoryError.getMessage());
                    return null;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB query failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query failed due to: " + exception.getMessage());
                    return null;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void beginTransaction() {
        IBGDbManager iBGDbManager = this;
        iBGDbManager.openDatabase();
        try {
            if (iBGDbManager.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning("DB transaction failed");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            NonFatals.reportNonFatal(outOfMemoryError, "DB transaction failed: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            NonFatals.reportNonFatal(exception, "DB transaction failed: " + exception.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to:" + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning("DB end transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            NonFatals.reportNonFatal(outOfMemoryError, "DB end transaction not successful due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            NonFatals.reportNonFatal(exception, "DB end transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void setTransactionSuccessful() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning("DB transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            NonFatals.reportNonFatal(outOfMemoryError, "DB transaction not successful due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB transaction not successful due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            NonFatals.reportNonFatal(exception, "DB transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB transaction not successful due to: " + exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public long queryNumEntries(@NonNull String tableName) {
        void var1_1;
        Long l2 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>((String)var1_1){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Long a() {
                a a2 = this;
                a2.IBGDbManager.this.openDatabase();
                try {
                    if (a2.IBGDbManager.this.databaseInitializedAndOpen()) {
                        return DatabaseUtils.queryNumEntries((SQLiteDatabase)IBGDbManager.this.database, (String)this.a);
                    }
                    IBGDbManager.access$300(IBGDbManager.this, "DB query num entries failed");
                    return -1L;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB query num entries failed: " + outOfMemoryError.getMessage());
                    NonFatals.reportNonFatal(outOfMemoryError, "DB query num entries failed: " + outOfMemoryError.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query num entries failed due to: " + outOfMemoryError.getMessage());
                    return -1L;
                }
                catch (Exception exception) {
                    NonFatals.reportNonFatal(exception, "DB query num entries failed: " + exception.getMessage());
                    IBGDbManager.access$300(IBGDbManager.this, "DB query num entries failed due to: " + exception.getMessage());
                    return -1L;
                }
            }
        });
        return l2 == null ? -1L : l2;
    }
}

