/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import androidx.annotation.VisibleForTesting;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0003\u001a\u00020\u0002H\u0087 \u00a8\u0006\u0006"}, d2={"Lcom/instabug/library/encryption/StaticKeyProvider;", "", "", "getKeyString", "<init>", "()V", "instabug-core_defaultUiRelease"})
public final class StaticKeyProvider {
    @NotNull
    public static final StaticKeyProvider a = new StaticKeyProvider();

    private StaticKeyProvider() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final Key a() {
        String string2;
        try {
            string2 = StaticKeyProvider.getKeyString();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("StaticKeyProvider", "Error loading native library");
            return null;
        }
        Charset charset = Charsets.UTF_8;
        if (string2 == null) throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new SecretKeySpec(byArray, "AES");
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final native String getKeyString();

    static {
        try {
            System.loadLibrary("ibg-native");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("StaticKeyProvider", "Error loading native library");
            NonFatals.reportNonFatal(unsatisfiedLinkError, "Error loading native library");
        }
    }
}

