/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apichecker;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.apichecker.a;
import com.instabug.library.apichecker.b;
import com.instabug.library.d;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class APIChecker {
    private static final String TAG = "API Checker";
    public static final String NOT_BUILT_ERROR_MESSAGE = "Instabug API {%s} was called before the SDK is built. To build it, please call Instabug.Builder().build().";
    public static final String MAIN_THREAD_ERROR_MESSAGE = "Threading violation: {%s} should only be called from a background thread, but was called from main thread.";
    public static final String NOT_ENABLED_ERROR_MESSAGE = "Instabug API {%s} was called while the SDK is disabled. To enable it, please call Instabug.enable().";
    public static final String NOT_EXECUTED_ERROR_MESSAGE = "Instabug failed to execute {%s}";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T checkAndGet(@NonNull String apiName, @NonNull ReturnableRunnable<T> runnable, @Nullable T fallbackValue) {
        void var2_3;
        void var1_1;
        String string2;
        APIChecker.logApiCall(apiName);
        if (d.c().b(Instabug.getApplicationContext()) == Feature.State.ENABLED) {
            APIChecker.checkMainThreadCalls(string2);
            return (T)PoolProvider.getApiExecutor().executeAndGet(() -> APIChecker.lambda$checkAndGet$0((ReturnableRunnable)var1_1, string2, var2_3));
        }
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            return var1_1.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled(string2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt(string2);
        }
        return var2_3;
    }

    private static void checkMainThreadCalls(String apiName) {
        if (Thread.currentThread().getName().equals("main")) {
            String string2;
            APIChecker.logMainThreadWarning(string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRunInExecutor(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        void var1_1;
        String string2;
        if (d.c().b(Instabug.getApplicationContext()) == Feature.State.ENABLED) {
            APIChecker.logApiCall(string2);
            PoolProvider.getApiExecutor().execute(() -> APIChecker.lambda$checkAndRunInExecutor$1((VoidRunnable)var1_1, string2));
        } else {
            APIChecker.checkAndRun(string2, (VoidRunnable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRunInExecutorThenPostOnMain(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        void var1_1;
        String string2;
        if (d.c().b(Instabug.getApplicationContext()) == Feature.State.ENABLED) {
            APIChecker.logApiCall(string2);
            PoolProvider.getApiExecutor().execute(() -> APIChecker.lambda$checkAndRunInExecutorThenPostOnMain$3((VoidRunnable)var1_1, string2));
        } else {
            APIChecker.checkAndRun(string2, (VoidRunnable)var1_1);
        }
    }

    public static void checkAndRun(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        APIChecker.logApiCall(string2);
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled(string2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt(string2);
        }
    }

    public static void checkBuilt(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        APIChecker.logApiCall(string2);
        try {
            APIChecker.checkBuilt();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt(string2);
        }
    }

    public static void checkEnable(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        APIChecker.logApiCall(string2);
        try {
            APIChecker.checkEnabled();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled(string2);
        }
    }

    private static void checkBuilt() throws a {
        if (Instabug.isBuilt()) {
            return;
        }
        throw new a("Instabug API called before Instabug.Builder().build() was called");
    }

    private static void checkEnabled() throws b {
        if (Instabug.isEnabled()) {
            return;
        }
        throw new b("Instabug API called while Instabug SDK was disabled");
    }

    private static void logSdkNotEnabled(String apiName) {
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        Log.e((String)TAG, (String)String.format(NOT_ENABLED_ERROR_MESSAGE, objectArray2));
    }

    private static void logSdkNotBuilt(String apiName) {
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        Log.e((String)TAG, (String)String.format(NOT_BUILT_ERROR_MESSAGE, objectArray2));
    }

    private static void logMainThreadWarning(String apiName) {
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        Log.w((String)TAG, (String)String.format(MAIN_THREAD_ERROR_MESSAGE, objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    private static void logExecutionException(String apiName, Exception e2) {
        void var1_1;
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        InstabugSDKLogger.e(TAG, String.format(NOT_EXECUTED_ERROR_MESSAGE, objectArray2) + " due to" + var1_1.getMessage());
    }

    private static void logApiCall(String apiName) {
        String string2;
        InstabugSDKLogger.d(TAG, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$checkAndRunInExecutorThenPostOnMain$3(VoidRunnable runnable, String apiName) {
        void var1_2;
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            PoolProvider.postMainThreadTask(() -> {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            APIChecker.logExecutionException((String)var1_2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled((String)var1_2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$checkAndRunInExecutor$1(VoidRunnable runnable, String apiName) {
        void var1_2;
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException((String)var1_2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled((String)var1_2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$checkAndGet$0(ReturnableRunnable runnable, String apiName, Object fallbackValue) throws Exception {
        void var2_3;
        void var1_2;
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            return runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException((String)var1_2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled((String)var1_2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt((String)var1_2);
        }
        return var2_3;
    }
}

