/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context, AttributeSet attr2) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    private void initialize() {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        ScaleImageView scaleImageView = this;
        scaleImageView.setScaleType(ImageView.ScaleType.MATRIX);
        scaleImageView.mMatrix = new Matrix();
        Drawable drawable2 = scaleImageView.getDrawable();
        if (drawable2 != null) {
            ScaleImageView scaleImageView2 = this;
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            scaleImageView2.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            scaleImageView2.setOnTouchListener(scaleImageView2);
        }
        drawable2 = gestureDetector;
        Context context = this.mContext;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent motionEvent) {
                a a10 = this;
                a10.ScaleImageView.this.maxZoomTo((int)motionEvent.getX(), (int)motionEvent.getY());
                a10.ScaleImageView.this.cutting();
                return super.onDoubleTap(motionEvent);
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener2);
        this.mDetector = drawable2;
    }

    /*
     * WARNING - void declaration
     */
    private float distance(float x02, float x12, float y02, float y12) {
        void var4_5;
        void var3_4;
        void var0_1;
        void var2_3;
        float f10 = x02 - var2_3;
        void v12 = var0_1 = var3_4 - var4_5;
        return (float)Math.sqrt(f10 * f10 + v12 * v12);
    }

    private float dispDistance() {
        int n10 = this.mWidth;
        int n11 = this.mHeight;
        return (float)Math.sqrt(n10 * n10 + n11 * n11);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageBitmap((Bitmap)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(int resId) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageResource((int)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFrame(int l10, int t10, int r10, int b10) {
        boolean bl;
        int n10;
        int n11;
        float f10;
        float f11;
        void var2_4;
        void var4_6;
        void var1_2;
        void var3_5;
        void var5_7 = var3_5 - var1_2;
        this.mWidth = var5_7;
        this.mHeight = var4_6 - var2_4;
        this.mMatrix.reset();
        this.mScale = f11 = (float)var5_7 / (float)this.mIntrinsicWidth;
        int n12 = this.mIntrinsicHeight;
        int n13 = this.mHeight;
        if (f10 * (float)n11 > (float)n10) {
            ScaleImageView scaleImageView = this;
            scaleImageView.mScale = f11 = (float)n13 / (float)n12;
            float f12 = f11;
            scaleImageView.mMatrix.postScale(f12, f12);
            bl = (var3_5 - scaleImageView.mWidth) / 2;
            n12 = 0;
        } else {
            ScaleImageView scaleImageView = this;
            float f13 = f11;
            scaleImageView.mMatrix.postScale(f13, f13);
            n12 = (var4_6 - scaleImageView.mHeight) / 2;
            bl = false;
        }
        ScaleImageView scaleImageView = this;
        float f14 = (float)bl;
        scaleImageView.mMatrix.postTranslate(f14, (float)n12);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
        scaleImageView.mMinScale = f14 = scaleImageView.mScale;
        ScaleImageView scaleImageView2 = this;
        int n14 = scaleImageView2.mWidth / 2;
        scaleImageView.zoomTo(f14, n14, scaleImageView2.mHeight / 2);
        scaleImageView.cutting();
        return super.setFrame((int)var1_2, (int)var2_4, (int)var3_5, (int)var4_6);
    }

    /*
     * WARNING - void declaration
     */
    protected float getValue(Matrix matrix, int whichValue) {
        void var2_2;
        void var1_1;
        var1_1.getValues(this.mMatrixValues);
        return this.mMatrixValues[var2_2];
    }

    protected float getScale() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 0);
    }

    public float getTranslateX() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 2);
    }

    protected float getTranslateY() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 5);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void maxZoomTo(int x9, int y9) {
        void var2_2;
        void var1_1;
        if (this.mMinScale != this.getScale()) {
            float f10;
            float f11 = this.mMinScale;
            if (this.getScale() - f10 > 0.1f) {
                this.zoomTo(f11 / this.getScale(), (int)var1_1, (int)var2_2);
                return;
            }
        }
        ScaleImageView scaleImageView = this;
        scaleImageView.zoomTo(scaleImageView.MAX_SCALE / this.getScale(), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void zoomTo(float scale, int x9, int y9) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getScale() * var1_1 < this.mMinScale) {
            return;
        }
        if (var1_1 >= 1.0f && this.getScale() * var1_1 > this.MAX_SCALE) {
            return;
        }
        ScaleImageView scaleImageView = this;
        void v12 = var1_1;
        scaleImageView.mMatrix.postScale((float)v12, (float)v12);
        ScaleImageView scaleImageView2 = this;
        int n10 = scaleImageView2.mWidth;
        float f10 = -((float)n10 * var1_1 - (float)n10) / 2.0f;
        int n11 = scaleImageView2.mHeight;
        scaleImageView.mMatrix.postTranslate(f10, -((float)n11 * var1_1 - (float)n11) / 2.0f);
        scaleImageView.mMatrix.postTranslate((float)(-(var2_2 - this.mWidth / 2)) * var1_1, 0.0f);
        scaleImageView.mMatrix.postTranslate(0.0f, (float)(-(var3_3 - this.mHeight / 2)) * var1_1);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
    }

    public void cutting() {
        int n10;
        ScaleImageView scaleImageView = this;
        int n11 = (int)((float)scaleImageView.mIntrinsicWidth * this.getScale());
        int n12 = (int)((float)scaleImageView.mIntrinsicHeight * this.getScale());
        if (scaleImageView.getTranslateX() < (float)(-(n11 - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n11 - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n12 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n12 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n11 < (n10 = this.mWidth)) {
            this.mMatrix.postTranslate((float)(n10 - n11) / 2.0f, 0.0f);
        }
        if (n12 < (n11 = this.mHeight)) {
            this.mMatrix.postTranslate(0.0f, (float)(n11 - n12) / 2.0f);
        }
        ScaleImageView scaleImageView2 = this;
        scaleImageView2.setImageMatrix(scaleImageView2.mMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(MotionEvent event) {
        block10: {
            int n10;
            void var1_4;
            block7: {
                block8: {
                    block9: {
                        if (this.mDetector.onTouchEvent((MotionEvent)var1_4)) {
                            return true;
                        }
                        void v02 = var1_4;
                        n10 = v02.getPointerCount();
                        int n11 = v02.getAction();
                        if (n11 == 0) break block7;
                        if (n11 == 1) break block8;
                        if (n11 == 2) break block9;
                        if (n11 == 5) break block7;
                        if (n11 == 6) break block8;
                        if (n11 == 261) break block7;
                        if (n11 == 262) break block8;
                        break block10;
                    }
                    if (n10 >= 2 && this.isScaling) {
                        ScaleImageView scaleImageView = this;
                        void v22 = var1_4;
                        float f10 = v22.getX(0);
                        float f11 = v22.getX(1);
                        float f12 = v22.getY(0);
                        float f13 = v22.getY(1);
                        this.mPrevDistance = f10 = scaleImageView.distance(f10, f11, f12, f13);
                        float f14 = (f10 - this.mPrevDistance) / this.dispDistance() + 1.0f;
                        ScaleImageView scaleImageView2 = this;
                        int n12 = scaleImageView2.mWidth / 2;
                        scaleImageView.zoomTo(f14 * f14, n12, scaleImageView2.mHeight / 2);
                        scaleImageView.cutting();
                    } else if (!this.isScaling) {
                        ScaleImageView scaleImageView = this;
                        ScaleImageView scaleImageView3 = this;
                        int n13 = scaleImageView3.mPrevMoveX - (int)var1_4.getX();
                        int n14 = scaleImageView3.mPrevMoveY - (int)var1_4.getY();
                        this.mPrevMoveX = (int)var1_4.getX();
                        scaleImageView.mPrevMoveY = (int)var1_4.getY();
                        scaleImageView.mMatrix.postTranslate((float)(-n13), (float)(-n14));
                        scaleImageView.cutting();
                    }
                    break block10;
                }
                if (var1_4.getPointerCount() <= 1) {
                    this.isScaling = false;
                }
                break block10;
            }
            if (n10 >= 2) {
                void v72 = var1_4;
                float f15 = v72.getX(0);
                float f16 = v72.getX(1);
                float f17 = v72.getY(0);
                float f18 = v72.getY(1);
                this.mPrevDistance = this.distance(f15, f16, f17, f18);
                this.isScaling = true;
            } else {
                this.mPrevMoveX = (int)var1_4.getX();
                this.mPrevMoveY = (int)var1_4.getY();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouch(View v10, MotionEvent event) {
        void var2_2;
        return super.onTouchEvent((MotionEvent)var2_2);
    }
}

