/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.core.os.ConfigurationCompat;
import com.instabug.library.Instabug;
import com.instabug.library.f8;
import com.instabug.library.g3;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DeviceStateProvider {
    private static final String NONE_SSID = "<unknown ssid>";
    private static final String TAG = "DeviceStateProvider";

    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            return g3.d();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
    }

    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        return InstabugDeviceProperties.getAppVersion(context);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static int getBatteryLevel(Context context) {
        block6: {
            IntentFilter intentFilter;
            Context context2 = context;
            Context context3 = intentFilter;
            intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context3 = context2.registerReceiver(null, (IntentFilter)context3);
            if (context3 == null) break block6;
            Context context4 = context3;
            Context context5 = context4;
            int n10 = context4.getIntExtra("level", -1);
            return (int)((float)n10 / (float)context5.getIntExtra("scale", -1) * 100.0f);
        }
        try {
            InstabugSDKLogger.w(TAG, "Could't obtain battery level");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while get battery level", exception);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getBatteryState(Context context) {
        block13: {
            block15: {
                block16: {
                    block14: {
                        v0 = context;
                        var0 = v1;
                        v1 = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                        var0 = v0.registerReceiver(null, (IntentFilter)var0);
                        if (var0 == null) break block13;
                        var1_4 = var0.getIntExtra("status", -1);
                        if (var1_4 != 2 && var1_4 != 5) {
                            var1_4 = 0;
                            break block14;
                        }
                        var1_4 = 1;
                    }
                    var0_1 = var0.getIntExtra("plugged", -1);
                    var2_6 = var0_1 == 2;
                    var0_1 = var0_1 == 1 ? 1 : 0;
                    if (var1_4 == 0) break block15;
                    var0_2 = new StringBuilder().append("Charging");
                    if (var0_1 == 0) break block16;
                    v2 = " through AC Charger";
lbl25:
                    // 3 sources

                    while (true) {
                        var1_5 = v2;
                        ** GOTO lbl35
                        break;
                    }
                }
                if (!var2_6) ** GOTO lbl33
                v2 = " through USB cable";
                ** GOTO lbl25
lbl33:
                // 1 sources

                v2 = "";
                ** continue;
lbl35:
                // 1 sources

                v3 = var0_2.append(var1_5).toString();
lbl36:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v3 = "Unplugged";
            ** continue;
            var0_2 = v3;
            return var0_2;
        }
        try {
            InstabugSDKLogger.w("DeviceStateProvider", "Could't obtain battery state");
        }
        catch (Exception var0_3) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery state", var0_3);
        }
        return "Unknown";
    }

    public static boolean getWifiState(Context context) {
        boolean bl;
        block4: {
            block3: {
                Context context2;
                try {
                    context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1);
                    if (context2 == null) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Got error while get wifi state", exception);
                    return false;
                }
                if (!context2.isConnected()) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static String getWifiSSID(@Nullable Context context) {
        Object object;
        if (context == null) {
            InstabugSDKLogger.e(TAG, "Could not read wifi SSID. Context is null");
            return "";
        }
        if (DeviceStateProvider.getWifiState(object)) {
            block9: {
                block10: {
                    object = (WifiManager)object.getApplicationContext().getSystemService("wifi");
                    if (object == null) break block9;
                    object = object.getConnectionInfo().getSSID();
                    if (!NONE_SSID.equalsIgnoreCase((String)object)) break block10;
                    object = "";
                }
                return object;
            }
            try {
                InstabugSDKLogger.e(TAG, "Could not read wifi SSID. WifiManager is null");
                return "Connected";
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "exception while trying to read SSID. " + exception.getMessage(), exception);
                return "Connected";
            }
            catch (SecurityException securityException) {
                InstabugSDKLogger.e(TAG, "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                return "Connected";
            }
        }
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = context;
        Context context3 = memoryInfo;
        ((ActivityManager)context2.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return (DeviceStateProvider.calculateTotalMemory(context2) - context3.availMem) / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l10 = DeviceStateProvider.calculateTotalMemory(context);
        if (l10 == 0L) {
            InstabugSDKLogger.e(TAG, "Got error while calculate total memory");
            return -1L;
        }
        return l10 / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            Context context2;
            return DeviceStateProvider.calculateTotalMemoryApi16(context2);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(new ActivityManager.MemoryInfo());
        return context2.totalMem;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long calculateTotalMemoryPreApi16() {
        block16: {
            var0 = null;
            var1_3 = v0;
            v0 = new RandomAccessFile("/proc/meminfo", "r");
            v1 = v0.readLine().split(":")[1].trim();
            var0 = v1.substring(0, v1.length() - 3).trim();
            v0.close();
            var0_1 = Long.parseLong((String)var0) * 1024L;
            try {
                v0.close();
                return var0_1;
            }
            catch (IOException v2) {
                v2.printStackTrace();
            }
            return var0_1;
            catch (Throwable var0_2) {
                break block16;
            }
            catch (IOException v3) {
                var0 = var1_3;
                ** GOTO lbl-1000
            }
            catch (Throwable var1_4) {
                var1_3 = var0;
                var0 = var1_4;
                break block16;
            }
            catch (IOException v3) {
                // empty catch block
            }
lbl-1000:
            // 2 sources

            {
                v3.printStackTrace();
                if (var0 == null) return 0L;
            }
            try {
                var0.close();
                return 0L;
            }
            catch (IOException v4) {
                v4.printStackTrace();
            }
            return 0L;
        }
        if (var1_3 == null) throw var0;
        try {
            var1_3.close();
            throw var0;
        }
        catch (IOException v5) {
            v5.printStackTrace();
        }
        throw var0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFreeStorage() {
        try {
            File file = DeviceStateProvider.getExternalCacheDir();
            if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                return file.getUsableSpace() / 0x100000L;
            }
            InstabugSDKLogger.e(TAG, "Got error while calculate free storage");
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while calculate free storage");
            return -1L;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getUsedStorage() {
        try {
            File file = DeviceStateProvider.getExternalCacheDir();
            if (DeviceStateProvider.externalMemoryAvailable() && file != null) {
                long l10 = file.getTotalSpace() - file.getFreeSpace();
                return l10 / 0x100000L;
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "Got error while calculate used storage");
            return -1L;
        }
        {
            InstabugSDKLogger.e(TAG, "Got error while calculate used storage");
            return -1L;
        }
    }

    public static long getTotalStorage() {
        block5: {
            File file;
            try {
                file = DeviceStateProvider.getExternalCacheDir();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "Got error while calculate total storage");
                return -1L;
            }
            if (!DeviceStateProvider.externalMemoryAvailable() || file == null) break block5;
            return (int)(file.getTotalSpace() / 0x100000L);
        }
        InstabugSDKLogger.e(TAG, "Got error while calculate total storage");
        return -1L;
    }

    @Nullable
    private static File getExternalCacheDir() {
        Context context = DeviceStateProvider.getApplicationContext();
        if (context != null) {
            return context.getExternalCacheDir();
        }
        return null;
    }

    @Nullable
    private static Context getApplicationContext() {
        return Instabug.getApplicationContext();
    }

    private static boolean externalMemoryAvailable() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(DeviceStateProvider.class, exception.getMessage(), exception);
            return false;
        }
    }

    public static String getScreenDensity(Context context) {
        int n10 = DeviceStateProvider.getDisplayMetrics((Context)context).densityDpi;
        if (n10 < 160) {
            return "ldpi";
        }
        if (n10 < 240) {
            return "mdpi";
        }
        if (n10 < 320) {
            return "hdpi";
        }
        if (n10 < 480) {
            return "xhdpi";
        }
        if (n10 < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        Context context2 = DeviceStateProvider.getDisplayMetrics(context);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = context2.widthPixels;
        objectArray[1] = context2.heightPixels;
        return String.format("%sx%s", objectArray2);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Context context2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            ((DisplayManager)context2.getSystemService("display")).getDisplay(0).getRealMetrics(displayMetrics2);
        } else {
            ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics2);
        }
        return displayMetrics2;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getSdkVersion() {
        return "10.12.0";
    }

    public static String getLocale(Context context) {
        Context context2;
        if (ConfigurationCompat.getLocales((Configuration)context.getResources().getConfiguration()).size() > 0) {
            return ConfigurationCompat.getLocales((Configuration)context2.getResources().getConfiguration()).get(0).getLanguage();
        }
        return context2.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return f8.e().d();
    }

    public static String getDeviceArchitecture() {
        return Build.CPU_ABI;
    }
}

