/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.view.MotionEvent;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.b3;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.f8;
import com.instabug.library.i3;
import com.instabug.library.m3;
import com.instabug.library.m7;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.n7;
import com.instabug.library.q0;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.d;
import com.instabug.library.tracking.e;
import com.instabug.library.tracking.f;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    public static final String TAG = "InstabugInternalTrackingDelegate";
    private static volatile InstabugInternalTrackingDelegate INSTANCE;
    private static final String FRAGMENT_NAV_HOST_NAME = "androidx.navigation.fragment.NavHostFragment";
    private boolean isRegistered;
    private final q0 currentActivityMonitor;
    private final a activityLifecycleListener;
    private final n7 screenOffEventMonitor;
    private final m7 screenOffEventListener;
    @Nullable
    private WeakReference<Fragment> lastResumedFragment;
    @Nullable
    private WeakReference<Activity> currentActivity;
    @Nullable
    private WeakReference<Activity> currentRealActivity;
    private final f navigableViewsTrackingDelegate;
    @Nullable
    private Disposable sessionStateDisposable;

    public static void init(@NonNull Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@NonNull Application application) {
        f f10;
        m7 m72;
        void var1_1;
        i3 i32;
        a a10;
        q0 q02;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        instabugInternalTrackingDelegate.isRegistered = false;
        Object object = q02;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate2 = this_;
        ((q0)object)();
        instabugInternalTrackingDelegate2.currentActivityMonitor = object;
        object = a10;
        a10 = new a();
        instabugInternalTrackingDelegate2.activityLifecycleListener = object;
        object = i32;
        i32 = new i3((Context)var1_1);
        instabugInternalTrackingDelegate2.screenOffEventMonitor = object;
        object = m72;
        m72 = new m7((InstabugInternalTrackingDelegate)((Object)this_)){

            @Override
            public void a() {
                f8.e().b();
            }
        };
        instabugInternalTrackingDelegate2.screenOffEventListener = object;
        q02.a((Application)var1_1);
        instabugInternalTrackingDelegate.registerLifecycleListeners((Application)var1_1);
        f this_ = f10;
        f10 = new f();
        instabugInternalTrackingDelegate.navigableViewsTrackingDelegate = this_;
    }

    /*
     * WARNING - void declaration
     */
    private void registerWindowCallbacksIfNeeded(Activity activity) {
        void var1_1;
        if (activity == null) {
            return;
        }
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = var1_1.getWindow();
        if (instabugInternalTrackingDelegate == null) {
            return;
        }
        if (!((instabugInternalTrackingDelegate = instabugInternalTrackingDelegate.getCallback()) instanceof e)) {
            InstabugSDKLogger.d(TAG, "register WindowCallbacks needed");
            var1_1.getWindow().setCallback((Window.Callback)new e((Window.Callback)instabugInternalTrackingDelegate));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNavHostFragment(Fragment fragment) {
        void var1_1;
        if (fragment == null) {
            return false;
        }
        return FRAGMENT_NAV_HOST_NAME.equals(var1_1.getClass().getName());
    }

    private boolean isASessionRunning() {
        return f8.e().c() != null;
    }

    private void registerSessionEventsListener() {
        if (this.sessionStateDisposable == null) {
            this.sessionStateDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<SessionState>(){

                public void a(SessionState sessionState) throws Exception {
                    if (sessionState == SessionState.START) {
                        InstabugInternalTrackingDelegate.this.screenOffEventMonitor.a(InstabugInternalTrackingDelegate.this.screenOffEventListener);
                    } else if (sessionState == SessionState.FINISH) {
                        InstabugInternalTrackingDelegate.this.screenOffEventMonitor.a();
                    }
                }
            });
        }
    }

    private void unRegisterSessionEventsListener() {
        Disposable disposable = this.sessionStateDisposable;
        if (disposable != null) {
            disposable.dispose();
            this.sessionStateDisposable = null;
        }
    }

    private boolean isUserTrackingStepsEnable() {
        return b3.c().b((Object)Feature.TRACK_USER_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isReproStepsEnable() {
        return b3.c().b((Object)Feature.REPRO_STEPS) == Feature.State.ENABLED && InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED);
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " created");
            m3.a().a(var1_1.getClass().getName(), "APPLICATION_CREATED");
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " created");
                m3.a().a(string2.getClass().getName(), "ACTIVITY_CREATED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_CREATED", this_, string2, null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " started");
                m3.a().a(string2.getClass().getName(), "ACTIVITY_STARTED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable() && SettingsManager.getInstance().getCurrentPlatform() == 2) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_STARTED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " resumed");
                m3.a().a(var1_1.getClass().getName(), "ACTIVITY_RESUMED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                String string2 = v02.getClass().getSimpleName();
                String string3 = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_RESUMED", string2, string3, null);
                this.navigableViewsTrackingDelegate.c((Activity)var1_1);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
            this.registerWindowCallbacksIfNeeded((Activity)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentActivity(Activity activity) {
        void var1_1;
        ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity = new WeakReference<void>(var1_1);
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            WeakReference<void> weakReference;
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            instabugInternalTrackingDelegate.currentActivity = this_;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = null;
        WeakReference<Activity> weakReference = this.currentActivity;
        if (weakReference != null) {
            object = (Activity)weakReference.get();
        }
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w(TAG, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w(TAG, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " paused");
                m3.a().a(var1_1.getClass().getName(), "ACTIVITY_PAUSED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                object = v02.getClass().getSimpleName();
                weakReference = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_PAUSED", (String)object, (String)((Object)weakReference), null);
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
        this.navigableViewsTrackingDelegate.b((Activity)var1_1);
    }

    void handleActivityStoppedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, string2.getClass().getSimpleName() + " stopped");
                m3.a().a(string2.getClass().getName(), "ACTIVITY_STOPPED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isReproStepsEnable()) {
                void v02 = string2;
                String this_ = v02.getClass().getSimpleName();
                string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_STOPPED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.d(TAG, var1_1.getClass().getSimpleName() + " destroyed");
                m3.a().a(var1_1.getClass().getName(), "ACTIVITY_DESTROYED");
            }
            if (this.isReproStepsEnable()) {
                void v02 = var1_1;
                object = v02.getClass().getSimpleName();
                String string2 = v02.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("ACTIVITY_DESTROYED", (String)object, string2, null);
            }
            if (var1_1 != null && (object = this.currentActivity) != null && ((Reference)object).get() != null && var1_1 == this.currentActivity.get()) {
                this.currentActivity.clear();
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    void onFragmentAttached(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_ATTACHED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v12 = string2;
                String string3 = v12.getClass().getSimpleName();
                string2 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_ATTACHED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.ATTACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var1_1)) {
            Object object = ((InstabugInternalTrackingDelegate)((Object)string2)).currentActivity;
            if (object != null && ((Reference)object).get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_VIEW_CREATED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isReproStepsEnable()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                void v22 = var1_1;
                String string2 = v22.getClass().getSimpleName();
                object = v22.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_VIEW_CREATED", string2, (String)object, null);
                instabugInternalTrackingDelegate.navigableViewsTrackingDelegate.c((Fragment)var1_1);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.VIEW_CREATED);
            return;
        }
    }

    void onFragmentStarted(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STARTED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v12 = string2;
                String string3 = v12.getClass().getSimpleName();
                string2 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_STARTED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STARTED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            WeakReference<void> weakReference;
            WeakReference<Activity> weakReference2 = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            this.lastResumedFragment = weakReference2;
            weakReference2 = this.currentActivity;
            if (weakReference2 != null && weakReference2.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                weakReference2 = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(var1_1.getClass().getName(), weakReference2.getClass().getName(), "FRAGMENT_RESUMED");
                }
            }
            if (this.isReproStepsEnable() && var1_1.getUserVisibleHint()) {
                weakReference2 = com.instabug.library.visualusersteps.f.d();
                String string2 = var1_1 instanceof DialogFragment ? "DIALOG_FRAGMENT_RESUMED" : "FRAGMENT_RESUMED";
                WeakReference<Activity> weakReference3 = weakReference2;
                void v32 = var1_1;
                weakReference2 = v32.getClass().getSimpleName();
                ((com.instabug.library.visualusersteps.f)((Object)weakReference3)).b(string2, (String)((Object)weakReference2), v32.getClass().getName(), null);
            }
            if (var1_1.getActivity() != null) {
                this.registerWindowCallbacksIfNeeded((Activity)var1_1.getActivity());
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.RESUMED);
            return;
        }
    }

    void onFragmentPaused(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            ((InstabugInternalTrackingDelegate)((Object)string3)).lastResumedFragment = null;
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_PAUSED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v12 = string2;
                String string3 = v12.getClass().getSimpleName();
                string2 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_PAUSED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.PAUSED);
            return;
        }
    }

    void onFragmentStopped(Fragment fragment) {
        String string2;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string3)).isNavHostFragment((Fragment)string2)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string3)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string3;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(string2.getClass().getName(), activity.getClass().getName(), "FRAGMENT_STOPPED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string3)).isReproStepsEnable()) {
                void v12 = string2;
                String string3 = v12.getClass().getSimpleName();
                string2 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_STOPPED", string3, string2, null);
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STOPPED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Object object = this.currentActivity;
            if (object != null && ((Reference)object).get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                object = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    m3.a().a(var1_1.getClass().getName(), object.getClass().getName(), "FRAGMENT_DETACHED");
                }
            }
            if (this.isReproStepsEnable()) {
                void v12 = var1_1;
                object = v12.getClass().getSimpleName();
                String string2 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_DETACHED", (String)object, string2, null);
            }
            this.navigableViewsTrackingDelegate.b((Fragment)var1_1);
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.DETACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_3;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var2_3)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string2)).currentActivity;
            if (activity != null && activity.get() != null) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = string2;
                activity = (Activity)instabugInternalTrackingDelegate.currentActivity.get();
                if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                    void var1_1;
                    m3.a().a(var2_3.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + (boolean)var1_1, "FRAGMENT_VISIBILITY_CHANGED");
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isReproStepsEnable()) {
                void v12 = var2_3;
                String string2 = v12.getClass().getSimpleName();
                String string3 = v12.getClass().getName();
                com.instabug.library.visualusersteps.f.d().b("FRAGMENT_VISIBILITY_CHANGED", string2, string3, null);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        d.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getCurrentRealActivity() {
        WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity;
        return this_ == null ? null : (Activity)this_.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = null;
        WeakReference<Activity> weakReference = instabugInternalTrackingDelegate.currentActivity;
        if (weakReference != null) {
            activity = (Activity)weakReference.get();
        }
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
        } else if (activity != null) {
            this_ = activity;
        }
        return this_;
    }

    @Nullable
    public Object getLastSeenView() {
        WeakReference<Fragment> weakReference = this.lastResumedFragment;
        if (weakReference != null && weakReference.get() != null) {
            return this.lastResumedFragment.get();
        }
        return this.getTargetActivity();
    }

    /*
     * WARNING - void declaration
     */
    public void registerLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d(TAG, "Registering activity lifecycle listener");
        var1_1.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.registerComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        if (this.isASessionRunning()) {
            this.screenOffEventMonitor.a(this.screenOffEventListener);
        }
        this.registerSessionEventsListener();
        this.isRegistered = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterLifecycleListeners(Application application) {
        void var1_1;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
        InstabugSDKLogger.d(TAG, "Unregistering activity lifecycle listener");
        var1_1.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.unregisterComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        instabugInternalTrackingDelegate.screenOffEventMonitor.a();
        instabugInternalTrackingDelegate.unRegisterSessionEventsListener();
        instabugInternalTrackingDelegate.isRegistered = false;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        com.instabug.library.core.eventbus.a this_ = com.instabug.library.core.eventbus.a.a();
        this_.a((Configuration)var1_1);
        com.instabug.library.core.eventbus.a.a().post(this_);
    }
}

