/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.diagnostics.nonfatals;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.l5;
import com.instabug.library.n5;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.v5;
import com.instabug.library.z7;

public class NonFatals {
    private static final String TAG = "NonFatals";
    private static final String INSTABUG_PREFIX = "com.instabug.";
    private static final String METHOD_REPORT_ERROR = "reportError";
    private static final String METHOD_REPORT_NON_FATAL = "reportNonFatal";

    /*
     * WARNING - void declaration
     */
    public static void reportNonFatal(@NonNull Throwable throwable, @NonNull String message) {
        void var1_1;
        VoidRunnable voidRunnable;
        Throwable throwable2;
        if (!NonFatals.isCalledInternally(throwable)) {
            InstabugSDKLogger.e(TAG, "Please refrain from using NonFatals.reportNonFatal as it is a private API");
            return;
        }
        final StackTraceElement stackTraceElement = NonFatals.getFirstInstabugElementFromStacktrace(throwable2.getStackTrace());
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String c;
            {
                this.c = string2;
            }

            @Override
            public void run() {
                if (InstabugCore.getFeatureState(Feature.NON_FATAL_ERRORS) == Feature.State.DISABLED) {
                    InstabugSDKLogger.d(NonFatals.TAG, "NonFatals reporting is DISABLED");
                    return;
                }
                a a10 = stackTraceElement2;
                StackTraceElement stackTraceElement2 = a10.stackTraceElement;
                NonFatals.access$000(stackTraceElement2.throwable2, stackTraceElement2, a10.c);
            }
        };
        APIChecker.checkAndRunInExecutor("NonFatals.reportNonFatal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void createFormattedException(@NonNull Throwable throwable, @Nullable StackTraceElement stackTraceElements, @NonNull String message) {
        Throwable throwable2;
        InstabugSDKLogger.d(TAG, "parsing nonfatal: " + throwable2.getClass().getCanonicalName());
        try {
            void var2_3;
            void var1_2;
            NonFatals.reportException(n5.a(throwable, (StackTraceElement)var1_2, (String)var2_3));
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "parsing nonfatal error ", exception);
        }
    }

    private static void reportException(final l5 l52) {
        z7.i().execute(new Runnable(){

            @Override
            public void run() {
                v5 v52 = z7.g();
                if (v52 != null) {
                    v52.saveNonFatal(l52);
                }
            }
        });
    }

    private static boolean isCalledInternally(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        if (throwable != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()) != null && stackTraceElementArray.length > 0) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!stackTraceElement.getClassName().contains("instabug") || stackTraceElement.getClassName().contains("diagnostics")) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    @Nullable
    static StackTraceElement getFirstInstabugElementFromStacktrace(StackTraceElement[] stackTrace) {
        StackTraceElement[] stackTraceElementArray;
        if (stackTrace != null && stackTraceElementArray.length > 0) {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (!stackTraceElement.getClassName().startsWith(INSTABUG_PREFIX) || stackTraceElement.getMethodName().equals(METHOD_REPORT_ERROR) || stackTraceElement.getMethodName().equals(METHOD_REPORT_NON_FATAL)) continue;
                return stackTraceElement;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Throwable x02, StackTraceElement x12, String x22) {
        void var2_2;
        void var1_1;
        NonFatals.createFormattedException(x02, (StackTraceElement)var1_1, (String)var2_2);
    }
}

