/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.h;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.Observer;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class AnalyticsWrapper {
    @NonNull
    private static final String TAG = "AnalyticsWrapper";
    @Nullable
    private static AnalyticsWrapper INSTANCE;
    @Nullable
    private volatile com.instabug.library.analytics.a analyticsLogger;

    @NonNull
    public static synchronized AnalyticsWrapper getInstance() {
        AnalyticsWrapper analyticsWrapper = INSTANCE;
        if (analyticsWrapper == null) {
            AnalyticsWrapper analyticsWrapper2;
            analyticsWrapper = analyticsWrapper2;
            INSTANCE = new AnalyticsWrapper();
        }
        return analyticsWrapper;
    }

    private AnalyticsWrapper() {
        h.a().onErrorResumeNext(h.a()).subscribeOn(Schedulers.computation()).subscribe((Observer)new DisposableObserver<Boolean>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.i(AnalyticsWrapper.TAG, "SDK analytics is enabled: " + bl);
                if (bl.booleanValue()) {
                    AnalyticsWrapper.this.enableAnalyticsLogging();
                } else {
                    a a10 = this;
                    a10.AnalyticsWrapper.this.disableAnalyticsLogging();
                    a10.AnalyticsWrapper.this.dropCachedLogs();
                }
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e(AnalyticsWrapper.TAG, throwable.getClass().getSimpleName(), throwable);
            }

            public void onComplete() {
            }
        });
    }

    public static long getLastUploadedAt(Context context) {
        return com.instabug.library.analytics.a.a(context);
    }

    /*
     * WARNING - void declaration
     */
    public static void setLastUploadedAt(long analyticsUploadedAt, Context context) {
        void var2_1;
        com.instabug.library.analytics.a.a(analyticsUploadedAt, (Context)var2_1);
    }

    public static boolean haveBeenCleanedBefore(Context context) {
        return com.instabug.library.analytics.a.b(context);
    }

    /*
     * WARNING - void declaration
     */
    public static void setBeingCleaned(boolean isCleaned, Context context) {
        void var1_1;
        com.instabug.library.analytics.a.a(isCleaned, (Context)var1_1);
    }

    @Nullable
    private com.instabug.library.analytics.a getAnalyticsLogger() {
        return this.analyticsLogger;
    }

    /*
     * WARNING - void declaration
     */
    private void setAnalyticsLogger(@Nullable com.instabug.library.analytics.a logger) {
        void var1_1;
        this.analyticsLogger = var1_1;
    }

    private void enableAnalyticsLogging() {
        if (((AnalyticsWrapper)((Object)this_)).getAnalyticsLogger() == null) {
            com.instabug.library.analytics.a a10;
            AnalyticsWrapper analyticsWrapper = this_;
            com.instabug.library.analytics.a this_ = a10;
            a10 = new com.instabug.library.analytics.a();
            analyticsWrapper.setAnalyticsLogger(this_);
        }
    }

    private void disableAnalyticsLogging() {
        com.instabug.library.analytics.a a10 = this.getAnalyticsLogger();
        if (a10 != null) {
            a10.a();
        }
        this.setAnalyticsLogger(null);
    }

    @WorkerThread
    private void dropCachedLogs() {
        com.instabug.library.analytics.util.a.b();
        com.instabug.library.analytics.util.a.a();
    }

    /*
     * WARNING - void declaration
     */
    public void catchApiUsageAsync(String apiName, Api.Parameter ... parameters) {
        void var2_2;
        void var1_1;
        PoolProvider.postIOTaskWithCheck(new Runnable((String)var1_1, (Api.Parameter[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ Api.Parameter[] b;
            {
                this.a = string;
                this.b = parameterArray;
            }

            @Override
            public void run() {
                b b10 = string;
                String string = b10.a;
                string.AnalyticsWrapper.this.catchApiUsage(string, b10.b);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void catchApiUsage(String apiName, Api.Parameter ... parameters) {
        if ((this = ((AnalyticsWrapper)this).getAnalyticsLogger()) != null) {
            void var2_2;
            void var1_1;
            ((com.instabug.library.analytics.a)this).a((String)var1_1, (Api.Parameter[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void catchDeprecatedApiUsage(String apiName, Api.Parameter ... parameters) {
        if ((this = ((AnalyticsWrapper)this).getAnalyticsLogger()) != null) {
            void var2_2;
            void var1_1;
            ((com.instabug.library.analytics.a)this).b((String)var1_1, (Api.Parameter[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void catchLoggingApiUsage(String apiName, Api.Parameter ... parameters) {
        if ((this = ((AnalyticsWrapper)this).getAnalyticsLogger()) != null) {
            void var2_2;
            void var1_1;
            ((com.instabug.library.analytics.a)this).d((String)var1_1, (Api.Parameter[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void catchDeprecatedLoggingApiUsage(String apiName, Api.Parameter ... parameters) {
        if ((this = ((AnalyticsWrapper)this).getAnalyticsLogger()) != null) {
            void var2_2;
            void var1_1;
            ((com.instabug.library.analytics.a)this).c((String)var1_1, (Api.Parameter[])var2_2);
        }
    }
}

