/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.HandlerThread;
import android.util.Log;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.Platform;
import com.instabug.library.analytics.AnalyticsWrapper;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.b3;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.f8;
import com.instabug.library.i9;
import com.instabug.library.internal.contentprovider.a;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.Report;
import com.instabug.library.s9;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.u2;
import com.instabug.library.ui.onboarding.WelcomeMessage;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.util.InstabugDeprecationLogger;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.State;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Instabug {
    private static final String TAG = "Instabug";
    @Nullable
    private static volatile Instabug INSTANCE;
    private static Context appContext;
    private u2 delegate;

    /*
     * WARNING - void declaration
     */
    private Instabug(@NonNull u2 delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        boolean bl;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("isDebugEnabled").setType(Boolean.TYPE).setValue(bl);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setDebugEnabled", parameterArray2);
                SettingsManager.getInstance().setDebugEnabled(bl);
                InstabugSDKLogger.i(Instabug.TAG, "setDebugEnabled " + bl);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setDebugEnabled", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static int getPrimaryColor() {
        ReturnableRunnable<Integer> returnableRunnable;
        ReturnableRunnable<Integer> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Integer>(){

            @Nullable
            public Integer a() {
                return SettingsManager.getInstance().getPrimaryColor();
            }
        };
        Integer n10 = 0;
        return APIChecker.checkAndGet("Instabug.getPrimaryColor", returnableRunnable2, n10);
    }

    public static void setPrimaryColor(@ColorInt int primaryColorValue) {
        int n10;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("primaryColorValue").setType(Integer.TYPE).setValue(String.valueOf(n10));
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setPrimaryColor", parameterArray2);
                SettingsManager.getInstance().setPrimaryColor(n10);
                InstabugSDKLogger.i(Instabug.TAG, "setPrimaryColor");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setPrimaryColor", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public static InstabugColorTheme getTheme() {
        ReturnableRunnable<InstabugColorTheme> returnableRunnable;
        ReturnableRunnable<InstabugColorTheme> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<InstabugColorTheme>(){

            public InstabugColorTheme a() {
                return SettingsManager.getInstance().getTheme();
            }
        };
        InstabugColorTheme instabugColorTheme = InstabugColorTheme.InstabugColorThemeLight;
        return APIChecker.checkAndGet("Instabug.getTheme", returnableRunnable2, instabugColorTheme);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        void var1_1;
        Uri uri;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (s03.uri == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "fileUri object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (s03.b == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "fileNameWithExtension object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[2];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("fileUri").setType(Uri.class);
                parameterArray[1] = new Api.Parameter().setName("fileNameWithExtension").setType(String.class);
                AnalyticsWrapper.getInstance().catchLoggingApiUsage("addFileAttachment", parameterArray2);
                s0 s02 = s03;
                s0 s03 = s02.uri;
                SettingsManager.getInstance().addExtraAttachmentFile((Uri)s03, s02.b);
                InstabugSDKLogger.i(Instabug.TAG, "addFileAttachment uriFile");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var1_1;
        byte[] byArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string;
            }

            @Override
            public void run() {
                if (object.byArray == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "data object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                if (object.b == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "fileNameWithExtension object passed to Instabug.addFileAttachment() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[2];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("data").setType(Uri.class);
                parameterArray[1] = new Api.Parameter().setName("fileNameWithExtension").setType(String.class);
                AnalyticsWrapper.getInstance().catchLoggingApiUsage("addFileAttachment", parameterArray2);
                t0 t02 = object;
                Object object = t02.byArray;
                SettingsManager.getInstance().addExtraAttachmentFile((byte[])object, t02.b);
                InstabugSDKLogger.i(Instabug.TAG, "addFileAttachment bytes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addFileAttachment", voidRunnable2);
    }

    public static void clearFileAttachment() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchLoggingApiUsage("clearFileAttachment", new Api.Parameter[0]);
                SettingsManager.getInstance().clearExtraAttachmentFiles();
                InstabugSDKLogger.i(Instabug.TAG, "clearFileAttachment");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearFileAttachment", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserData() {
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            public String a() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.getUserData", new Api.Parameter[0]);
                InstabugSDKLogger.i(Instabug.TAG, "getUserData");
                return SettingsManager.getInstance().getUserData();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserData", returnableRunnable2, "");
    }

    public static void setUserData(@NonNull String userData) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("userData").setType(String.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setUserData", parameterArray2);
                if (b3.c().b((Object)Feature.USER_DATA) == Feature.State.ENABLED) {
                    SettingsManager.getInstance().setUserData(StringUtility.trimString(string, 1000));
                    InstabugSDKLogger.i(Instabug.TAG, "setUserData");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserData", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserEmail() {
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            public String a() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.getUserEmail", new Api.Parameter[0]);
                InstabugSDKLogger.i(Instabug.TAG, "getUserEmail");
                return i9.f();
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserEmail", returnableRunnable2, "");
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getAppToken() {
        return SettingsManager.getInstance().getAppToken();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void identifyUser(@NonNull String username, @NonNull String email) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[2];
                Object object = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("username").setType(String.class);
                parameterArray[1] = new Api.Parameter().setName("email");
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.identifyUser", (Api.Parameter[])object);
                if (Instabug.getApplicationContext() != null) {
                    b b10 = object2;
                    object = b10.string;
                    i9.a(Instabug.getApplicationContext(), (String)object, b10.b);
                    object = object2.string;
                    object = object != null && !((String)object).isEmpty() ? "non-empty-username" : "empty_username";
                    Object object2 = object2.b;
                    object2 = object2 != null && !((String)object2).isEmpty() ? "non-empty-email" : "empty-email";
                    InstabugSDKLogger.i(Instabug.TAG, "identifyUser username: " + (String)object + " email: " + (String)object2);
                } else {
                    InstabugSDKLogger.e(Instabug.TAG, "identifyUser failed to execute due to null app context");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.identifyUser", voidRunnable2);
    }

    @Nullable
    public static Context getApplicationContext() {
        return appContext;
    }

    @Nullable
    private static Instabug getInstance() {
        Object object;
        if (INSTANCE == null && a.b() != null && (object = a.b().a()) != null) {
            object = u2.a(object);
            INSTANCE = new Instabug((u2)object);
        }
        return INSTANCE;
    }

    public static void logoutUser() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.logoutUser", new Api.Parameter[0]);
                i9.o();
                InstabugSDKLogger.i(Instabug.TAG, "logoutUser");
            }
        };
        APIChecker.checkAndRun("Instabug.logoutUser", voidRunnable2);
    }

    public static boolean isBuilt() {
        return INSTANCE != null && InstabugStateProvider.getInstance().getState() != InstabugState.NOT_BUILT && InstabugStateProvider.getInstance().getState() != InstabugState.BUILDING;
    }

    public static boolean isEnabled() {
        if (!Instabug.isBuilt()) {
            return false;
        }
        Feature feature = Feature.INSTABUG;
        return b3.c().c((Object)feature) && b3.c().b((Object)feature) == Feature.State.ENABLED;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void enable() {
        if (b3.c().b(Instabug.getApplicationContext()) == Feature.State.ENABLED) {
            PoolProvider.getApiExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    VoidRunnable voidRunnable;
                    VoidRunnable voidRunnable2 = voidRunnable;
                    voidRunnable = new VoidRunnable(this){

                        @Override
                        public void run() {
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.b(Feature.State.ENABLED);
                            }
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.H();
                            }
                            InstabugSDKLogger.i(Instabug.TAG, "enable");
                            AnalyticsWrapper.getInstance().catchApiUsage("enable", new Api.Parameter[0]);
                        }
                    };
                    APIChecker.checkBuilt("Instabug.enable", voidRunnable2);
                }
            });
        } else {
            VoidRunnable voidRunnable;
            VoidRunnable voidRunnable2 = voidRunnable;
            voidRunnable = new VoidRunnable(){

                @Override
                public void run() {
                    if (Instabug.getInstance() != null) {
                        Instabug.getInstance().delegate.b(Feature.State.ENABLED);
                    }
                    PoolProvider.postIOTaskWithCheck(new Runnable(this){

                        @Override
                        public void run() {
                            if (Instabug.getInstance() != null) {
                                Instabug.getInstance().delegate.H();
                            }
                            InstabugSDKLogger.i(Instabug.TAG, "enable");
                            AnalyticsWrapper.getInstance().catchApiUsage("enable", new Api.Parameter[0]);
                        }
                    });
                }
            };
            APIChecker.checkBuilt("Instabug.enable", voidRunnable2);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static synchronized void disable() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("disable", new Api.Parameter[0]);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                }
                InstabugSDKLogger.i(Instabug.TAG, "disable");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disable", voidRunnable2);
    }

    public static void pauseSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.u();
                }
                InstabugSDKLogger.i(Instabug.TAG, "pauseSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.pauseSdk", voidRunnable2);
    }

    public static void resumeSdk() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.A();
                }
                InstabugSDKLogger.i(Instabug.TAG, "resumeSdk");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resumeSdk", voidRunnable2);
    }

    public static void setLocale(@NonNull Locale locale) {
        Locale locale2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (locale2 == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "locale object passed to Instabug.setLocale is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("locale").setType(Locale.class).setValue(locale2);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setLocale", parameterArray2);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(locale2);
                }
                InstabugSDKLogger.i(Instabug.TAG, "setLocale");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setLocale", voidRunnable2);
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Locale getLocale(@Nullable Context context) {
        Object object;
        ReturnableRunnable<Locale> returnableRunnable;
        ReturnableRunnable<Locale> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<Locale>(){

            @Nullable
            public Locale a() throws Exception {
                return SettingsManager.getInstance().getInstabugLocale(object);
            }
        };
        object = Locale.getDefault();
        return (Locale)APIChecker.checkAndGet("Instabug.getLocale", returnableRunnable2, object);
    }

    public static void addTags(String ... tags) {
        String[] stringArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.addTags", new Api.Parameter[0]);
                SettingsManager.getInstance().addTags(StringUtility.trimStrings(stringArray));
                InstabugSDKLogger.i(Instabug.TAG, "addTags");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addTags", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static ArrayList<String> getTags() {
        ReturnableRunnable<ArrayList<String>> returnableRunnable;
        ReturnableRunnable<ArrayList<String>> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<ArrayList<String>>(){

            @Nullable
            public ArrayList<String> a() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.getTags", new Api.Parameter[0]);
                return SettingsManager.getInstance().getTags();
            }
        };
        return APIChecker.checkAndGet("Instabug.getTags", returnableRunnable2, null);
    }

    public static void resetTags() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.resetTags", new Api.Parameter[0]);
                SettingsManager.getInstance().resetTags();
                InstabugSDKLogger.i(Instabug.TAG, "resetTags");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.resetTags", voidRunnable2);
    }

    public static void setCustomTextPlaceHolders(@NonNull InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (instabugCustomTextPlaceHolder2 == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "instabugCustomTextPlaceHolder object passed to Instabug.setCustomTextPlaceHolders() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("instabugCustomTextPlaceHolder").setType(InstabugCustomTextPlaceHolder.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setCustomTextPlaceHolders", parameterArray2);
                SettingsManager.getInstance().setCustomPlaceHolders(instabugCustomTextPlaceHolder2);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setCustomTextPlaceHolders", voidRunnable2);
    }

    @Nullable
    public static HashMap<String, String> getAllUserAttributes() {
        ReturnableRunnable<HashMap<String, String>> returnableRunnable;
        ReturnableRunnable<HashMap<String, String>> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<HashMap<String, String>>(){

            public HashMap<String, String> a() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.getAllUserAttributes", new Api.Parameter[0]);
                InstabugSDKLogger.i(Instabug.TAG, "getAllUserAttributes");
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.i();
                }
                return new HashMap<String, String>();
            }
        };
        return APIChecker.checkAndGet("Instabug.getAllUserAttributes", returnableRunnable2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void setUserAttribute(@NonNull String key, @NonNull String value) {
        void var1_1;
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable((String)var1_1){
            final /* synthetic */ String b;
            {
                this.b = string2;
            }

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[2];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("key").setType(String.class);
                parameterArray[1] = new Api.Parameter().setName("value").setType(String.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setUserAttribute", parameterArray2);
                if (Instabug.getInstance() != null) {
                    q q10 = string2;
                    String string2 = q10.string;
                    Instabug.getInstance().delegate.a(string2, q10.b);
                }
                InstabugSDKLogger.i(Instabug.TAG, "setUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setUserAttribute", voidRunnable2);
    }

    @Nullable
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getUserAttribute(@NonNull String key) {
        String string;
        ReturnableRunnable<String> returnableRunnable;
        ReturnableRunnable<String> returnableRunnable2 = returnableRunnable;
        returnableRunnable = new ReturnableRunnable<String>(){

            @Nullable
            public String a() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("key").setType(String.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.getUserAttribute", parameterArray2);
                InstabugSDKLogger.i(Instabug.TAG, "getUserAttribute");
                if (Instabug.getInstance() != null) {
                    return Instabug.getInstance().delegate.a(string);
                }
                return null;
            }
        };
        return APIChecker.checkAndGet("Instabug.getUserAttribute", returnableRunnable2, null);
    }

    public static void removeUserAttribute(@NonNull String key) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("key").setType(String.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.removeUserAttribute", parameterArray2);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(string);
                }
                InstabugSDKLogger.i(Instabug.TAG, "removeUserAttribute");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeUserAttribute", voidRunnable2);
    }

    public static void clearAllUserAttributes() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.clearAllUserAttributes", new Api.Parameter[0]);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.e();
                }
                InstabugSDKLogger.i(Instabug.TAG, "clearAllUserAttributes");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllUserAttributes", voidRunnable2);
    }

    public static Date getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt();
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    public static void setWelcomeMessageState(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "welcomeMessageState object passed to Instabug.setWelcomeMessageState() is null");
                    return;
                }
                PoolProvider.postIOTaskWithCheck(new Runnable(){

                    @Override
                    public void run() {
                        Api.Parameter[] parameterArray = new Api.Parameter[1];
                        Api.Parameter[] parameterArray2 = parameterArray;
                        parameterArray[0] = new Api.Parameter().setName("WelcomeMessageState").setType(String.class).setValue(state.toString());
                        AnalyticsWrapper.getInstance().catchApiUsage("Instabug.showWelcomeMessage", parameterArray2);
                        SettingsManager.getInstance().setWelcomeMessageState(state);
                        InstabugSDKLogger.i(Instabug.TAG, "setWelcomeMessageState: " + state.name());
                    }
                });
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setWelcomeMessageState", voidRunnable2);
    }

    public static void showWelcomeMessage(@NonNull WelcomeMessage.State welcomeMessageState) {
        WelcomeMessage.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "welcomeMessageState object passed to Instabug.showWelcomeMessage() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("showWelcomeMessage").setType(String.class).setValue(state.toString());
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.showWelcomeMessage", parameterArray2);
                if (!InstabugCore.isForegroundBusy() && Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.b(state);
                }
                InstabugSDKLogger.i(Instabug.TAG, "showWelcomeMessage: " + state.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.showWelcomeMessage", voidRunnable2);
    }

    @Deprecated
    public static void setViewHierarchyState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "state object passed to Instabug.setViewHierarchyState() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Object object = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setViewHierarchyState", (Api.Parameter)object);
                object = Feature.VIEW_HIERARCHY_V2;
                b3.c().a((Feature)((Object)object), state2);
                InstabugSDKLogger.i(Instabug.TAG, "setViewHierarchyState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setViewHierarchyState", voidRunnable2);
    }

    @Deprecated
    public static void setAutoScreenRecordingMaxDuration(int autoScreenRecordingMaxDuration) {
        int n10;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("setAutoScreenRecordingMaxDuration").setType(Boolean.class).setValue(String.valueOf(n10));
                AnalyticsWrapper.getInstance().catchDeprecatedApiUsage("setAutoScreenRecordingMaxDuration", parameterArray2);
                SettingsManager.getInstance().setAutoScreenRecordingMaxDuration(n10);
                Log.e((String)Instabug.class.getName(), (String)"AutoScreen recording is disabled please contact support for further details.");
                InstabugSDKLogger.i(Instabug.TAG, "setAutoScreenRecordingMaxDuration " + n10);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingMaxDuration", voidRunnable2);
    }

    public static void setSessionProfilerState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "state object passed to Instabug.setSessionProfilerState() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setSessionProfilerState", parameterArray2);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.a(state2);
                }
                InstabugSDKLogger.i(Instabug.TAG, "setSessionProfilerState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setSessionProfilerState", voidRunnable2);
    }

    public static void setTrackingUserStepsState(@NonNull Feature.State state) {
        Feature.State state2;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state2 == null) {
                    InstabugSDKLogger.w(Instabug.TAG, "state object passed to Instabug.setTrackingUserStepsState() is null");
                    return;
                }
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Object object = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setTrackingUserStepsState", (Api.Parameter)object);
                object = Feature.TRACK_USER_STEPS;
                b3.c().a((Feature)((Object)object), state2);
                InstabugSDKLogger.i(Instabug.TAG, "setTrackingUserStepsState: " + state2.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setTrackingUserStepsState", voidRunnable2);
    }

    public static void setReproStepsState(State reproStepsState) {
        State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                s9.a(state);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setReproStepsState", voidRunnable2);
    }

    public static void setColorTheme(@NonNull InstabugColorTheme instabugTheme) {
        InstabugColorTheme instabugColorTheme;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("instabugTheme").setType(InstabugColorTheme.class).setValue((Object)instabugColorTheme);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setColorTheme", parameterArray2);
                SettingsManager.getInstance().setTheme(instabugColorTheme);
                int n10 = q0.a[instabugColorTheme.ordinal()];
                if (n10 != 1) {
                    if (n10 == 2) {
                        SettingsManager.getInstance().setPrimaryColor(-15893761);
                        SettingsManager.getInstance().setStatusBarColor(-3815737);
                    }
                } else {
                    SettingsManager.getInstance().setPrimaryColor(-9580554);
                    SettingsManager.getInstance().setStatusBarColor(-16119286);
                }
                InstabugSDKLogger.i(Instabug.TAG, "setColorTheme: " + instabugColorTheme.name());
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setColorTheme", voidRunnable2);
    }

    public static void logUserEvent(@NonNull String eventIdentifier) {
        String string;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("eventIdentifier").setType(String.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.logUserEvent", parameterArray2);
                InstabugUserEventLogger.getInstance().logUserEvent(string, new UserEventParam[0]);
                InstabugSDKLogger.i(Instabug.TAG, "logUserEvent");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.logUserEvent", voidRunnable2);
    }

    public static void onReportSubmitHandler(Report.OnReportCreatedListener listener) {
        Report.OnReportCreatedListener onReportCreatedListener;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("listener").setType(Report.OnReportCreatedListener.class);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.onReportSubmitHandler", parameterArray2);
                SettingsManager.getInstance().setOnReportCreatedListener(onReportCreatedListener);
                InstabugSDKLogger.i(Instabug.TAG, "onReportSubmitHandler");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.onReportSubmitHandler", voidRunnable2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingDuration(@IntRange(from=30L, to=180L) int maxDuration) {
        int n10;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Api.Parameter[] parameterArray2 = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("maxDuration").setType(Integer.class).setValue(n10);
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setAutoScreenRecordingDuration", parameterArray2);
                SettingsManager.getInstance().setAutoScreenRecordingDuration(n10);
                InstabugSDKLogger.i(Instabug.TAG, "setAutoScreenRecordingDuration: " + n10);
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingDuration", voidRunnable2);
    }

    @VisibleForTesting
    static void setAutoScreenRecordingAudioCapturingEnabled(Feature.State isASRAudioEnabled) {
        Feature.State state;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                if (state != null) {
                    Api.Parameter[] parameterArray = new Api.Parameter[1];
                    Api.Parameter[] parameterArray2 = parameterArray;
                    parameterArray[0] = new Api.Parameter().setName("asrAudioCapturingEnabled").setType(Feature.State.class).setValue(state.name());
                    AnalyticsWrapper.getInstance().catchApiUsage("Instabug.setAutoScreenRecordingAudioCapturingEnabled", parameterArray2);
                    SettingsManager.getInstance().setAutoScreenRecordingAudioCapturingState(state);
                    InstabugSDKLogger.i(Instabug.TAG, "setAutoScreenRecordingAudioCapturingEnabled: " + state.name());
                }
                InstabugSDKLogger.w(Instabug.TAG, "isASRAudioEnabled object passed to Instabug.setAutoScreenRecordingAudioCapturingEnabled() is null");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setAutoScreenRecordingAudioCapturingEnabled", voidRunnable2);
    }

    public static void show() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.show", new Api.Parameter[0]);
                InvocationManager.getInstance().show();
                InstabugSDKLogger.i(Instabug.TAG, "show");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.show", voidRunnable2);
    }

    @Deprecated
    public static void setViewsAsPrivate(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchDeprecatedApiUsage("setViewsAsPrivate", new Api.Parameter[0]);
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.c(viewArray);
                }
                InstabugSDKLogger.i(Instabug.TAG, "setViewsAsPrivate");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.setViewsAsPrivate", voidRunnable2);
    }

    public static void addPrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.addPrivateViews", new Api.Parameter[0]);
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.a(viewArray);
                }
                InstabugSDKLogger.i(Instabug.TAG, "addPrivateViews");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addPrivateViews", voidRunnable2);
    }

    public static void removePrivateViews(View ... views) {
        View[] viewArray;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.removePrivateViews", new Api.Parameter[0]);
                if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
                    Instabug.getInstance().delegate.b(viewArray);
                }
                InstabugSDKLogger.i(Instabug.TAG, "removePrivateViews");
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removePrivateViews", voidRunnable2);
    }

    public static boolean isBuilding() {
        return InstabugStateProvider.getInstance().getState() == InstabugState.BUILDING;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private static void disableInternal() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() {
                AnalyticsWrapper.getInstance().catchApiUsage("Instabug.disableInternal", new Api.Parameter[0]);
                if (Instabug.getInstance() != null) {
                    Instabug.getInstance().delegate.N();
                    InstabugSDKLogger.i(Instabug.TAG, "disableInternal");
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.disableInternal", voidRunnable2);
    }

    /*
     * WARNING - void declaration
     */
    private static void reportScreenChange(@Nullable Bitmap screenshot, @NonNull String screenName) {
        if (!Instabug.isBuilt()) {
            return;
        }
        if (Instabug.getInstance() != null && Instabug.getInstance().delegate != null) {
            void var1_1;
            Api.Parameter[] parameterArray;
            Bitmap bitmap;
            if (bitmap != null) {
                Api.Parameter[] parameterArray2 = new Api.Parameter[1];
                parameterArray = parameterArray2;
                parameterArray2[0] = new Api.Parameter().setName("screenshot").setType(Bitmap.class).setValue(bitmap);
                AnalyticsWrapper.getInstance().catchDeprecatedApiUsage("screenshot", parameterArray);
            }
            Api.Parameter[] parameterArray3 = new Api.Parameter[1];
            parameterArray = parameterArray3;
            parameterArray3[0] = new Api.Parameter().setName("screenName").setType(String.class).setValue(var1_1);
            AnalyticsWrapper.getInstance().catchDeprecatedApiUsage("screenName", parameterArray);
            Instabug.getInstance().delegate.a(bitmap, (String)var1_1);
            return;
        }
    }

    private static void setCurrentPlatform(@Platform int platform) {
        int n10;
        SettingsManager.getInstance().setCurrentPlatform(n10);
    }

    public static void addExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Object object = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("addExperiments").setType(List.class).setValue(list);
                AnalyticsWrapper.getInstance().catchApiUsageAsync("Instabug.addExperiments", (Api.Parameter)object);
                object = Instabug.getInstance();
                if (object != null) {
                    ((Instabug)object).delegate.a(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.addExperiments", voidRunnable2);
    }

    public static void removeExperiments(@NonNull List<String> experiments) {
        List<String> list;
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                Api.Parameter[] parameterArray = new Api.Parameter[1];
                Object object = parameterArray;
                parameterArray[0] = new Api.Parameter().setName("removeExperiments").setType(List.class).setValue(list);
                AnalyticsWrapper.getInstance().catchApiUsageAsync("Instabug.removeExperiments", (Api.Parameter)object);
                object = Instabug.getInstance();
                if (object != null) {
                    ((Instabug)object).delegate.b(list);
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.removeExperiments", voidRunnable2);
    }

    public static void clearAllExperiments() {
        VoidRunnable voidRunnable;
        VoidRunnable voidRunnable2 = voidRunnable;
        voidRunnable = new VoidRunnable(){

            @Override
            public void run() throws Exception {
                AnalyticsWrapper.getInstance().catchApiUsageAsync("Instabug.clearAllExperiments", new Api.Parameter[0]);
                Instabug instabug = Instabug.getInstance();
                if (instabug != null) {
                    instabug.delegate.d();
                }
            }
        };
        APIChecker.checkAndRunInExecutor("Instabug.clearAllExperiments", voidRunnable2);
    }

    public static class Builder {
        private static volatile boolean isBuildCalled = false;
        private String applicationToken;
        private Context applicationContext;
        @Nullable
        private Application application;
        private int instabugStatusBarColor;
        private InstabugInvocationEvent[] instabugInvocationEvents;
        private Feature.State userDataState;
        private Feature.State consoleLogState;
        private Feature.State instabugLogState;
        private Feature.State inAppMessagingState;
        private Feature.State crashReportingState;
        private Feature.State pushNotificationState;
        private Feature.State trackingUserStepsState;
        private State reproStepsState;
        private Feature.State viewHierarchyState;
        private Feature.State surveysState;
        private Feature.State userEventsState;
        private Feature.State anrDefaultState;
        private boolean emailFieldRequired;
        private boolean emailFieldVisibility;
        private boolean commentFieldRequired;
        private boolean introMessageEnabled;
        private boolean shouldPlaySounds;
        private boolean successDialogEnabled;
        private InstabugFloatingButtonEdge instabugFloatingButtonEdge;
        private int shakingThreshold;
        private int floatingButtonOffsetFromTop;
        private boolean isSurveysAutoShowing;
        private boolean chatPromptOptionEnable;
        private boolean bugPromptOptionEnable;
        private boolean feedbackPromptOptionEnable;
        private List<Integer> deprecatedMethodsToBeLogedAfterBuild;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken) {
            void var2_2;
            void var1_1;
            InstabugInvocationEvent[] instabugInvocationEventArray = this_;
            InstabugInvocationEvent[] instabugInvocationEventArray2 = new InstabugInvocationEvent[1];
            InstabugInvocationEvent[] this_ = instabugInvocationEventArray2;
            instabugInvocationEventArray2[0] = InstabugInvocationEvent.SHAKE;
            super((Application)var1_1, (String)var2_2, this_);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Application application, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvent) {
            this(var1_1.getApplicationContext(), (String)var2_2, (InstabugInvocationEvent[])var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.application = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        Builder(@NonNull Context applicationContext, @NonNull String applicationToken, InstabugInvocationEvent ... instabugInvocationEvents) {
            void var2_2;
            void var3_3;
            void var1_1;
            Builder builder = this_;
            Builder builder2 = this_;
            Builder builder3 = this_;
            this_.instabugStatusBarColor = -3815737;
            this_.instabugInvocationEvents = new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
            Object this_ = b3.e;
            v3.userDataState = this_;
            v3.consoleLogState = this_;
            v3.instabugLogState = this_;
            v3.inAppMessagingState = this_;
            v3.crashReportingState = this_;
            v3.pushNotificationState = this_;
            v3.trackingUserStepsState = this_;
            v3.reproStepsState = State.ENABLED;
            v3.viewHierarchyState = Feature.State.DISABLED;
            v3.surveysState = this_;
            v3.userEventsState = this_;
            v3.anrDefaultState = this_;
            v3.emailFieldRequired = true;
            v3.emailFieldVisibility = true;
            v3.commentFieldRequired = false;
            v3.introMessageEnabled = true;
            v3.shouldPlaySounds = false;
            v3.successDialogEnabled = true;
            v3.instabugFloatingButtonEdge = InstabugFloatingButtonEdge.RIGHT;
            v3.shakingThreshold = 650;
            v3.floatingButtonOffsetFromTop = -1;
            v3.isSurveysAutoShowing = true;
            v3.chatPromptOptionEnable = true;
            v3.bugPromptOptionEnable = true;
            v3.feedbackPromptOptionEnable = true;
            v3.deprecatedMethodsToBeLogedAfterBuild = new ArrayList<Integer>();
            builder3.applicationContext = var1_1;
            builder2.instabugInvocationEvents = var3_3;
            builder.applicationToken = var2_2;
        }

        private void buildInFG(Feature.State instabugInitialState) {
            u2 u22;
            if (this.application == null) {
                return;
            }
            void v02 = u22;
            Builder builder = this;
            InstabugSDKLogger.d(Instabug.TAG, "Building Instabug From main thread, thread name: " + Thread.currentThread().getName());
            u22 = u2.a(builder.application);
            INSTANCE = new Instabug(u22);
            InstabugSDKLogger.initLogger(builder.applicationContext);
            Object object = Feature.State.ENABLED;
            final boolean bl = v02 == object;
            Object object2 = b3.c();
            Feature feature = Feature.INSTABUG;
            if (!bl) {
                object = Feature.State.DISABLED;
            }
            Builder builder2 = this;
            ((b3)object2).a(feature, (Feature.State)((Object)object));
            u22.a(InstabugState.BUILDING);
            builder2.logDeprecatedApis();
            object = SettingsManager.getInstance().getAppToken();
            object2 = builder2.applicationToken;
            if (object2 != null && object != null && !((String)object2).equals(object)) {
                i9.o();
            }
            SettingsManager.getInstance().setAppToken(this.applicationToken);
            com.instabug.library.core.plugin.a.a(this.applicationContext);
            f8.a(SettingsManager.getInstance());
            HandlerThread handlerThread = new HandlerThread("Sdk start thread"){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @SuppressLint(value={"STRICT_MODE_VIOLATION"})
                protected void onLooperPrepared() {
                    try {
                        b b10 = this;
                        b10.u22.a(applicationContext);
                        u2 u222 = b10.u22;
                        InstabugState instabugState = b10.bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                        b b11 = this;
                        u222.a(instabugState);
                        b11.u22.H();
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
                        InvocationManager.getInstance().notifyPrimaryColorChanged();
                        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvents);
                        if (floatingButtonOffsetFromTop != -1) {
                            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
                        }
                        b b12 = this;
                        SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                        b12.this.updateFeaturesStates();
                        Builder.access$1300(b12.this, bl);
                        InstabugSDKLogger.i(Instabug.TAG, "Built");
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(Instabug.TAG, "Error while building the sdk: ", exception);
                    }
                }
            };
            handlerThread.setPriority(10);
            handlerThread.start();
        }

        private void updateFeaturesStates() {
            InstabugCore.setFeatureState(Feature.USER_DATA, this.userDataState);
            InstabugCore.setFeatureState(Feature.CONSOLE_LOGS, this.consoleLogState);
            InstabugCore.setFeatureState(Feature.INSTABUG_LOGS, this.instabugLogState);
            InstabugCore.setFeatureState(Feature.CRASH_REPORTING, this.crashReportingState);
            InstabugCore.setFeatureState(Feature.IN_APP_MESSAGING, this.inAppMessagingState);
            InstabugCore.setFeatureState(Feature.PUSH_NOTIFICATION, this.pushNotificationState);
            InstabugCore.setFeatureState(Feature.TRACK_USER_STEPS, this.trackingUserStepsState);
            s9.a(this.reproStepsState);
            InstabugCore.setFeatureState(Feature.VIEW_HIERARCHY_V2, this.viewHierarchyState);
            InstabugCore.setFeatureState(Feature.SURVEYS, this.surveysState);
            InstabugCore.setFeatureState(Feature.USER_EVENTS, this.userEventsState);
        }

        private void logDeprecatedApis() {
            Iterator<Integer> this_ = ((Builder)((Object)this_)).deprecatedMethodsToBeLogedAfterBuild.iterator();
            while (this_.hasNext()) {
                InstabugDeprecationLogger.getInstance().log((Integer)this_.next());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void logFeaturesStates(Boolean isInstabugEnabled) {
            void var1_1;
            Builder builder = this;
            InstabugSDKLogger.v(builder, "User data feature state is set to " + (Object)((Object)this.userDataState));
            InstabugSDKLogger.v(builder, "Console log feature state is set to " + (Object)((Object)this.consoleLogState));
            InstabugSDKLogger.v(builder, "Instabug logs feature state is set to " + (Object)((Object)this.instabugLogState));
            InstabugSDKLogger.v(builder, "Crash reporting feature state is set to " + (Object)((Object)this.crashReportingState));
            InstabugSDKLogger.v(builder, "In-App messaging feature state is set to" + (Object)((Object)this.inAppMessagingState));
            InstabugSDKLogger.v(builder, "Push notification feature state is set to " + (Object)((Object)this.pushNotificationState));
            InstabugSDKLogger.v(builder, "Tracking user steps feature state is set to " + (Object)((Object)this.trackingUserStepsState));
            InstabugSDKLogger.v(builder, "Repro steps feature state is set to " + (Object)((Object)this.reproStepsState));
            InstabugSDKLogger.v(builder, "View hierarchy feature state is set to " + (Object)((Object)this.viewHierarchyState));
            InstabugSDKLogger.v(builder, "Surveys feature state is set to " + (Object)((Object)this.surveysState));
            InstabugSDKLogger.v(builder, "User events feature state is set to " + (Object)((Object)this.userEventsState));
            InstabugSDKLogger.v(builder, "Instabug overall state is set to " + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$1300(Builder x02, Boolean x12) {
            void var1_1;
            x02.logFeaturesStates((Boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInvocationEvents(InstabugInvocationEvent ... instabugInvocationEvents) {
            void var1_1;
            this.instabugInvocationEvents = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTrackingUserStepsState(@NonNull Feature.State state) {
            void var1_1;
            this.trackingUserStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReproStepsState(State state) {
            void var1_1;
            this.reproStepsState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setDebugEnabled(boolean isDebugEnabled) {
            void var1_1;
            SettingsManager.getInstance().setDebugEnabled((boolean)var1_1);
            InstabugSDKLogger.i(Instabug.TAG, "setDebugEnabled " + (boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConsoleLogState(@NonNull Feature.State state) {
            void var1_1;
            this.consoleLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstabugLogState(@NonNull Feature.State state) {
            void var1_1;
            this.instabugLogState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserDataState(@NonNull Feature.State state) {
            void var1_1;
            this.userDataState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInAppMessagingState(@NonNull Feature.State state) {
            void var1_1;
            this.inAppMessagingState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewHierarchyState(@NonNull Feature.State state) {
            void var1_1;
            this.viewHierarchyState = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUserEventsState(@NonNull Feature.State state) {
            void var1_1;
            this.userEventsState = var1_1;
            return this;
        }

        @Nullable
        public void build() {
            appContext = this.applicationContext;
            InstabugSDKLogger.d(Instabug.TAG, "building sdk with default state ");
            if (isBuildCalled) {
                InstabugSDKLogger.d(Instabug.TAG, "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            Feature.State state = Feature.State.ENABLED;
            if (b3.c().b(appContext) == state) {
                InstabugSDKLogger.d(Instabug.TAG, "building sdk in BG");
                this.buildInBG(state);
            } else {
                InstabugSDKLogger.d(Instabug.TAG, "building sdk in FG");
                this.buildInFG(state);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public void build(Feature.State instabugInitialState) {
            void var1_1;
            appContext = this.applicationContext;
            InstabugSDKLogger.d(Instabug.TAG, "building sdk with state " + var1_1);
            if (isBuildCalled) {
                InstabugSDKLogger.d(Instabug.TAG, "isBuildCalled true returning..");
                return;
            }
            isBuildCalled = true;
            if (b3.c().b(appContext) == Feature.State.ENABLED) {
                InstabugSDKLogger.d(Instabug.TAG, "building sdk in BG");
                this.buildInBG((Feature.State)var1_1);
            } else {
                InstabugSDKLogger.d(Instabug.TAG, "building sdk in FG");
                this.buildInFG((Feature.State)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        @VisibleForTesting
        void buildInBG(Feature.State instabugInitialState) {
            void var1_1;
            PoolProvider.getApiExecutor().execute(new Runnable((Feature.State)var1_1){
                final /* synthetic */ Feature.State a;
                {
                    this.a = state;
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    void var2_5;
                    if (application == null) {
                        return;
                    }
                    a a10 = this;
                    InstabugSDKLogger.d(Instabug.TAG, "Building Instabug From BG thread, thread name: " + Thread.currentThread().getName());
                    u2 u22 = u2.a(application);
                    INSTANCE = new Instabug(u22);
                    InstabugSDKLogger.initLogger(applicationContext);
                    Feature.State state = Feature.State.ENABLED;
                    boolean bl = a10.a == state;
                    b3 b32 = b3.c();
                    Feature feature = Feature.INSTABUG;
                    if (!bl) {
                        Feature.State state2 = Feature.State.DISABLED;
                    }
                    a a11 = this;
                    b32.a(feature, (Feature.State)var2_5);
                    u22.a(InstabugState.BUILDING);
                    a11.this.logDeprecatedApis();
                    String string = SettingsManager.getInstance().getAppToken();
                    if (applicationToken != null && string != null && !applicationToken.equals(string)) {
                        i9.o();
                    }
                    a a12 = this;
                    SettingsManager.getInstance().setAppToken(applicationToken);
                    com.instabug.library.core.plugin.a.a(applicationContext);
                    f8.a(SettingsManager.getInstance());
                    try {
                        u22.a(applicationContext);
                        InstabugState instabugState = bl ? InstabugState.ENABLED : InstabugState.DISABLED;
                        u2 u23 = u22;
                        u23.a(instabugState);
                        u23.H();
                        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
                        InvocationManager.getInstance().notifyPrimaryColorChanged();
                        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEvents);
                        if (floatingButtonOffsetFromTop != -1) {
                            InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
                        }
                        a a13 = this;
                        SDKCoreEventPublisher.post(new SDKCoreEvent("sdk_state", "built"));
                        a13.this.updateFeaturesStates();
                        Builder.access$1300(a13.this, bl);
                        InstabugSDKLogger.d(Instabug.TAG, "Built");
                        return;
                    }
                    catch (Exception exception) {
                        InstabugSDKLogger.e(Instabug.TAG, "Error while building the sdk: ", exception);
                    }
                }
            });
        }
    }
}

