/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.instacapture.screenshot.ScreenshotTaker;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.Action;
import com.instabug.library.util.memory.MemoryGuard;
import com.instabug.library.util.memory.predicate.MemoryNotLowPredicate;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import com.instabug.library.visualusersteps.VisualUserStepsHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;

public class BitmapUtils {
    public static final String TAG = "BitmapUtils";
    private static final String ICON_FILE_PREFIX = "icon";

    @Nullable
    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Uri uri2;
        block3: {
            uri2 = null;
            if (Instabug.getApplicationContext() == null) break block3;
            try {
                Uri uri3;
                uri2 = uri3 = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InstabugSDKLogger.e(TAG, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            }
        }
        return uri2;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            MemoryGuard.from(context2).withPredicate(new MemoryNotLowPredicate()).forOperation("compressing a bitmap with size: " + var1_1.length()).doAction(new Action((File)var1_1){
                final /* synthetic */ File a;
                {
                    this.a = file;
                }

                @Override
                public void onAffirmed() throws Throwable {
                    BitmapUtils.compressBitmapAndSave(this.a);
                }

                @Override
                public void onDenied() throws Throwable {
                    InstabugSDKLogger.e(BitmapUtils.TAG, "Not enough memory for compressing image");
                }
            });
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        var1_2 = v0;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        v1 = new FileInputStream(var0);
        v2 = v1;
        BitmapFactory.decodeStream((InputStream)v1, null, (BitmapFactory.Options)var1_2);
        v2.close();
        var2_3 = 1;
        while (true) {
            if (var1_2.outWidth / var2_3 / 2 < 900) break;
            if (var1_2.outHeight / var2_3 / 2 < 900) break;
            var2_3 *= 2;
            continue;
            break;
        }
        var1_2 = v3;
        new BitmapFactory.Options().inSampleSize = var2_3;
        var2_4 = v4;
        var1_2 = BitmapFactory.decodeStream((InputStream)new FileInputStream(var0), null, (BitmapFactory.Options)var1_2);
        var3_5 = v5;
        v5 = new FileOutputStream(var0);
        if (var1_2 == null) ** GOTO lbl35
        v6 = var1_2;
        v7 = v6;
        v6.compress(BitmapUtils.getImageMimeType(var0), 100, (OutputStream)var3_5);
        try {
            v7.recycle();
lbl35:
            // 2 sources

            var3_5.close();
            var2_4.close();
        }
        catch (Exception var0_1) {
            var0_1.printStackTrace();
            InstabugSDKLogger.e("BitmapUtils", "compressBitmapAndSave bitmap doesn't compressed correctly " + var0_1.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmapWithFallback(String localPath, ImageView imageView, @DrawableRes int fallbackDrawable) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (int)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(@NonNull String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n10 = options.outHeight;
        int n11 = options2.outWidth;
        int n12 = 1;
        int n13 = 500;
        int n14 = 500;
        if (n10 > n13 || n11 > n14) {
            int n15 = n11;
            n11 = n10 / 2;
            n10 = n15 / 2;
            while (n11 / n12 >= n13 && n10 / n12 >= n14) {
                n12 *= 2;
            }
        }
        return n12;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var1_1;
        Bitmap bitmap2;
        void var3_3;
        void var2_2;
        PoolProvider.postBitmapTask(new Runnable((File)var2_2, (String)var3_3, bitmap2, (int)var1_1, (OnSaveBitmapCallback)var4_4){
            final /* synthetic */ File a;
            final /* synthetic */ String b;
            final /* synthetic */ Bitmap c;
            final /* synthetic */ int d;
            final /* synthetic */ OnSaveBitmapCallback e;
            {
                this.a = file;
                this.b = string2;
                this.c = bitmap;
                this.d = n10;
                this.e = onSaveBitmapCallback;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                File file2 = file;
                file = new File(this.a, this.b + "_" + System.currentTimeMillis() + ".png");
                InstabugSDKLogger.v(BitmapUtils.TAG, "image path: " + file2.toString());
                BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                    boolean bl = BitmapUtils.access$100(this.c, compressFormat, this.d, bufferedOutputStream2);
                    bufferedOutputStream2.close();
                    file2 = Uri.fromFile((File)file2);
                    if (bl && file2 != null) {
                        this.e.onSuccess((Uri)file2);
                        return;
                    }
                    this.e.onError(new Throwable("Uri equal null"));
                    return;
                }
                catch (IOException iOException) {
                    this.e.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        void var1_1;
        PoolProvider.postBitmapTask(new Runnable((Context)var1_1, bitmap2, (OnSaveBitmapCallback)var2_2){
            final /* synthetic */ Context a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = context;
                this.b = bitmap;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream;
                File file;
                Object object = DiskUtils.getInstabugDirectory(this.a);
                File file2 = file;
                file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(BitmapUtils.TAG, "image path: " + file2.toString());
                object = bufferedOutputStream;
                ((BufferedOutputStream)object)(new FileOutputStream(file2));
                final boolean bl = BitmapUtils.access$100(this.b, Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
                bufferedOutputStream.close();
                file2 = Uri.fromFile((File)file);
                try {
                    new Handler(Looper.getMainLooper()).post(new Runnable((Uri)file2){
                        final /* synthetic */ Uri b;
                        {
                            this.b = uri;
                        }

                        @Override
                        public void run() {
                            Uri uri;
                            if (bl && (uri = this.b) != null) {
                                c.onSuccess(uri);
                            } else {
                                c.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    this.c.onError(iOException);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void saveDrawableBitmap(Drawable drawable2, long currentTime, OnSaveBitmapCallback callback) {
        void var3_2;
        Drawable drawable3;
        void var1_1;
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postBitmapTask(new Runnable((long)var1_1, drawable3, (OnSaveBitmapCallback)var3_2){
            final /* synthetic */ long a;
            final /* synthetic */ Drawable b;
            final /* synthetic */ OnSaveBitmapCallback c;
            {
                this.a = l10;
                this.b = drawable2;
                this.c = onSaveBitmapCallback;
            }

            @Override
            public void run() {
                d d10 = this;
                d d11 = d10;
                final File file = BitmapUtils.getIconTargetDirectory(d10.a);
                try {
                    InstabugSDKLogger.v(BitmapUtils.TAG, "image path: " + file.getPath());
                    BitmapUtils.access$200(d11.b, new OnBitmapReady(){

                        /*
                         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                         * Unable to fully structure code
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void onBitmapReady(@Nullable Bitmap var1_4) {
                            block15: {
                                block16: {
                                    if (var1_4 == null) {
                                        return;
                                    }
                                    var2_5 = false;
                                    var3_6 = null;
                                    var4_7 = v0;
                                    v1 = var1_4;
                                    var4_7(new FileOutputStream(file));
                                    var2_5 = BitmapUtils.access$100(v1, Bitmap.CompressFormat.PNG, 100, var4_7);
                                    v0.close();
                                    catch (Throwable var0_1) {
                                        var3_6 = var4_7;
                                        break block15;
                                    }
                                    catch (IOException v2) {
                                        var3_6 = var4_7;
                                        ** GOTO lbl-1000
                                    }
                                    catch (IOException v3) {
                                        InstabugSDKLogger.e("BitmapUtils", "can't close BufferedOutputStream");
                                    }
                                    break block16;
                                    catch (Throwable var0_2) {
                                        break block15;
                                    }
                                    catch (IOException v4) {}
lbl-1000:
                                    // 2 sources

                                    {
                                        InstabugSDKLogger.e("BitmapUtils", "can't compress bitmap");
                                        if (var3_6 == null) break block16;
                                    }
                                    {
                                        var3_6.close();
                                    }
                                }
                                var1_4 = Uri.fromFile((File)file);
                                if (var2_5 && var1_4 != null) {
                                    c.onSuccess((Uri)var1_4);
                                    return;
                                }
                                c.onError(new Throwable("Uri equal null"));
                                return;
                            }
                            if (var3_6 == null) throw var0_3;
                            try {
                                var3_6.close();
                                throw var0_3;
                            }
                            catch (IOException v5) {
                                InstabugSDKLogger.e("BitmapUtils", "can't close BufferedOutputStream");
                            }
                            throw var0_3;
                        }

                        @Override
                        public void onBitmapFailedToLoad() {
                        }
                    });
                }
                catch (Exception exception) {
                    this.c.onError(exception);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(@Nullable Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            AssetsCacheManager.getAssetEntity(AssetsCacheManager.createEmptyEntity(context2, (String)var1_1, (AssetEntity.AssetType)var2_2), new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                @Override
                public void onSuccess(final AssetEntity assetEntity) {
                    InstabugSDKLogger.d(BitmapUtils.TAG, "Asset Entity downloaded: " + assetEntity.getFile().getPath());
                    if (ThreadUtils.isCurrentThreadMain()) {
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                BitmapUtils.access$300(assetEntity, a);
                            }
                        });
                    } else {
                        BitmapUtils.access$300(assetEntity, this.a);
                    }
                }

                @Override
                public void onFailed(Throwable throwable) {
                    InstabugSDKLogger.e(BitmapUtils.TAG, "Asset Entity downloading got error", throwable);
                    this.a.onBitmapFailedToLoad();
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        try {
            AssetEntity assetEntity2;
            onBitmapReady.onBitmapReady(BitmapFactory.decodeStream((InputStream)new FileInputStream(assetEntity2.getFile())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var1_2;
            InstabugSDKLogger.e(TAG, "Asset Entity downloading got FileNotFoundException error", fileNotFoundException);
            var1_2.onBitmapFailedToLoad();
        }
    }

    @WorkerThread
    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getIconTargetDirectory(long currentTime) {
        long l10;
        File file = VisualUserStepsHelper.getVisualUserStepsDirectory(Instabug.getApplicationContext());
        return new File(file, "icon_" + l10 + ".png");
    }

    /*
     * WARNING - void declaration
     */
    private static void drawableToBitmap(Drawable drawable2, OnBitmapReady onBitmapReady) {
        void var1_1;
        Drawable drawable3;
        Context context;
        if (drawable2 instanceof BitmapDrawable && (context = ((BitmapDrawable)drawable3).getBitmap()) != null) {
            var1_1.onBitmapReady(BitmapUtils.resizeBitmap((Bitmap)context, 24.0f, 24.0f));
            return;
        }
        context = Instabug.getApplicationContext();
        if (context != null) {
            int n10 = DisplayUtils.dpToPxIntRounded(context.getResources(), 72);
            final int n11 = drawable3.getIntrinsicWidth();
            final int n12 = drawable3.getIntrinsicHeight();
            if (n11 <= n10 && n12 <= n10) {
                Canvas canvas;
                Bitmap bitmap = Bitmap.createBitmap((int)n11, (int)n12, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas2 = canvas;
                canvas = new Canvas(bitmap);
                if (drawable3.getConstantState() != null) {
                    drawable3 = drawable3.getConstantState().newDrawable();
                }
                PoolProvider.postMainThreadTask(new Runnable((OnBitmapReady)var1_1, bitmap){
                    final /* synthetic */ OnBitmapReady e;
                    final /* synthetic */ Bitmap f;
                    {
                        this.e = onBitmapReady;
                        this.f = bitmap;
                    }

                    @Override
                    public void run() {
                        f f10 = this;
                        f f11 = this;
                        int n10 = f11.canvas2.getWidth();
                        int n112 = f11.canvas2.getHeight();
                        f10.drawable3.setBounds(0, 0, n10, n112);
                        f10.drawable3.draw(canvas2);
                        PoolProvider.postBitmapTask(new Runnable(){

                            @Override
                            public void run() {
                                a a10 = object;
                                Object object = a10.this;
                                object = BitmapUtils.access$400(object.n11, object.n12);
                                f f10 = a10.this;
                                Object object2 = object;
                                Object object3 = object2[0];
                                f10.e.onBitmapReady(BitmapUtils.resizeBitmap(f10.f, (float)object3, (float)object2[1]));
                            }
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n10;
        float f10 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f10;
        fArray[1] = f10;
        if (realHeight > n10) {
            fArray2[0] = (float)n10 / (float)var1_1 * f10;
        } else if (var1_1 < n10) {
            fArray2[1] = (float)var1_1 / (float)n10 * f10;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v22 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v22 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        if (imageUri.getPath() != null) {
            void var3_3;
            Bitmap bitmap2;
            void var2_2;
            void var1_1;
            PoolProvider.postBitmapTask(new Runnable((Uri)var1_1, (Context)var2_2, bitmap2, (OnSaveBitmapCallback)var3_3){
                final /* synthetic */ Uri a;
                final /* synthetic */ Context b;
                final /* synthetic */ Bitmap c;
                final /* synthetic */ OnSaveBitmapCallback d;
                {
                    this.a = uri;
                    this.b = context;
                    this.c = bitmap;
                    this.d = onSaveBitmapCallback;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (this.a.getPath() == null) return;
                    g g10 = this;
                    final Uri uri = Uri.fromFile((File)new File(this.a.getPath()));
                    OutputStream outputStream = g10.b.getContentResolver().openOutputStream(uri);
                    if (outputStream == null) return;
                    final boolean bl = BitmapUtils.access$100(this.c, Bitmap.CompressFormat.PNG, 100, outputStream);
                    try {
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                OnSaveBitmapCallback onSaveBitmapCallback;
                                if (bl && (onSaveBitmapCallback = d) != null) {
                                    onSaveBitmapCallback.onSuccess(uri);
                                }
                            }
                        });
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (fileNotFoundException.getMessage() == null) return;
                        InstabugSDKLogger.e(BitmapUtils.TAG, fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                    return;
                }
            });
        }
    }

    public static void maskBitmap(@Nullable Activity activity, Bitmap bitmap, @NonNull SettingsManager settingsManager, @Nullable Canvas canvas) {
        Object object;
        RootViewInfo rootViewInfo;
        Collection<View> collection;
        Canvas canvas2;
        if (activity == null) {
            return;
        }
        if (canvas2 == null) {
            Canvas canvas3;
            canvas2 = canvas3;
            canvas3 = new Canvas((Bitmap)collection);
        }
        collection = ((SettingsManager)((Object)rootViewInfo)).getPrivateViews();
        for (View object2 : collection) {
            if (object2 == null || object.findViewById(object2.getId()) == null || !ScreenshotTaker.isVisible(object2)) continue;
            View view = object2;
            view.getLocationOnScreen(new int[2]);
            canvas2.drawRect(ScreenshotTaker.getVisibleRect(view), new Paint());
        }
        if ((object = FieldHelper.getRootViews((Activity)object, null)) != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                rootViewInfo = (RootViewInfo)object.next();
                for (Object object2 : collection) {
                    Paint paint;
                    if (object2 == null || rootViewInfo.getView().findViewById(object2.getId()) == null || !ScreenshotTaker.isVisible(object2)) continue;
                    Rect rect = ScreenshotTaker.getVisibleRect(object2);
                    object2 = new int[2];
                    rootViewInfo.getView().getLocationOnScreen((int[])object2);
                    rect.top += object2[1];
                    rect.bottom += object2[1];
                    object2 = paint;
                    paint = new Paint();
                    canvas2.drawRect(rect, (Paint)object2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private static boolean compressQuietly(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        boolean bl;
        block4: {
            block3: {
                void var3_4;
                void var2_3;
                void var1_2;
                Bitmap bitmap2;
                try {
                    if (bitmap.isRecycled()) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, exception.toString(), exception);
                    return false;
                }
                if (!bitmap2.compress((Bitmap.CompressFormat)var1_2, (int)var2_3, (OutputStream)var3_4)) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(Bitmap x02, Bitmap.CompressFormat x12, int x22, OutputStream x32) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BitmapUtils.compressQuietly(x02, (Bitmap.CompressFormat)var1_1, (int)var2_2, (OutputStream)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Drawable x02, OnBitmapReady x12) {
        void var1_1;
        BitmapUtils.drawableToBitmap(x02, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AssetEntity x02, OnBitmapReady x12) {
        void var1_1;
        BitmapUtils.decodeBitmap(x02, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[] access$400(int x02, int x12) {
        void var1_1;
        return BitmapUtils.getTargetDimensions(x02, (int)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(@Nullable Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

