/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;

public final class Dot
extends RelativeLayout {
    private static final int DEFAULT_INACTIVE_DIAMETER_DP = 6;
    private static final int DEFAULT_ACTIVE_DIAMETER_DP = 9;
    private static final int DEFAULT_INACTIVE_COLOR = -1;
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final int DEFAULT_TRANSITION_DURATION_MS = 200;
    private static final boolean DEFAULT_INITIALLY_ACTIVE = false;
    private static final String TAG = "DOT";
    private int inactiveDiameterPx;
    private int activeDiameterPx;
    private int inactiveColor;
    private int activeColor;
    private int transitionDurationMs;
    @Nullable
    private State state;
    private ShapeDrawable shape;
    private ImageView drawableHolder;
    @Nullable
    private AnimatorSet currentAnimator;

    /*
     * WARNING - void declaration
     */
    public Dot(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Dot(Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Dot(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void var3_3;
        void var2_2;
        void var1_1;
        Dot dot = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        dot.currentAnimator = null;
        dot.init((AttributeSet)var2_2, (int)var3_3);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE", "CustomViewStyleable"})
    private void init(@Nullable AttributeSet attrs, int defStyleAttr) {
        int n10;
        TypedArray typedArray;
        typedArray = this.getContext().obtainStyledAttributes((AttributeSet)typedArray, R.styleable.IBDot, n10, 0);
        Dot dot = this;
        n10 = ViewUtils.convertDpToPx(dot.getContext(), 9.0f);
        this.inactiveDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerInactiveDiameter, ViewUtils.convertDpToPx(dot.getContext(), 6.0f));
        this.activeDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerActiveDiameter, n10);
        this.inactiveColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerInactiveColor, -1);
        this.activeColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerActiveColor, -1);
        this.transitionDurationMs = typedArray.getInt(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        State state = typedArray.getBoolean(R.styleable.IBDot_ibViewPagerInitiallyActive, false) ? State.ACTIVE : State.INACTIVE;
        this.state = state;
        typedArray.recycle();
        this.reflectParametersInView();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void reflectParametersInView() {
        ShapeDrawable shapeDrawable;
        int n10;
        Dot dot = this;
        dot.removeAllViews();
        int n11 = n10 = Math.max(dot.inactiveDiameterPx, this.activeDiameterPx);
        dot.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n11, n11));
        dot.setGravity(17);
        State state = dot.state;
        State state2 = State.ACTIVE;
        int n12 = state == state2 ? this.activeDiameterPx : this.inactiveDiameterPx;
        int n13 = state == state2 ? this.activeColor : this.inactiveColor;
        Dot dot2 = this;
        State state3 = state2 = shapeDrawable;
        state3((Shape)new OvalShape());
        this.shape = state3;
        shapeDrawable.setIntrinsicWidth(n12);
        dot2.shape.setIntrinsicHeight(n12);
        dot2.shape.getPaint().setColor(n13);
        this.drawableHolder = new ImageView(this.getContext());
        this.drawableHolder.setImageDrawable(null);
        dot2.drawableHolder.setImageDrawable((Drawable)this.shape);
        dot2.addView((View)dot2.drawableHolder);
    }

    /*
     * WARNING - void declaration
     */
    private void animateDotChange(int startSize, int endSize, int startColor, int endColor, int duration) {
        if (startSize >= 0) {
            void var2_3;
            if (var2_3 >= 0) {
                void var5_8;
                if (var5_8 >= 0) {
                    void var3_5;
                    void var1_1;
                    void var4_7;
                    AnimatorSet animatorSet;
                    AnimatorSet animatorSet2 = this.currentAnimator;
                    if (animatorSet2 != null) {
                        animatorSet2.cancel();
                    }
                    Dot dot = this;
                    AnimatorSet animatorSet3 = animatorSet2 = animatorSet;
                    animatorSet3();
                    this.currentAnimator = animatorSet3;
                    animatorSet.setDuration((long)var5_8);
                    dot.currentAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, (int)var2_3, (int)var4_7, (int)var1_1, (int)var3_5){
                        final /* synthetic */ int val$endSize;
                        final /* synthetic */ int val$endColor;
                        final /* synthetic */ int val$startSize;
                        final /* synthetic */ int val$startColor;
                        final /* synthetic */ Dot this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$endSize = n10;
                            this.val$endColor = n11;
                            this.val$startSize = n12;
                            this.val$startColor = n13;
                        }

                        public void onAnimationStart(Animator animation) {
                            if (this.this$0.state == State.INACTIVE) {
                                Dot.access$002(this.this$0, State.TRANSITIONING_TO_ACTIVE);
                            } else if (this.this$0.state == State.ACTIVE) {
                                Dot.access$002(this.this$0, State.TRANSITIONING_TO_INACTIVE);
                            }
                        }

                        public void onAnimationEnd(Animator animation) {
                            if (this.this$0.state != null && !this.this$0.state.isStable()) {
                                Dot dot = this.this$0;
                                Dot.access$002(dot, dot.state.transitioningTo());
                            }
                            1 v12 = this;
                            Dot.access$100(v12.this$0, this.val$endSize);
                            Dot.access$200(v12.this$0, this.val$endColor);
                            Dot.access$302(v12.this$0, null);
                        }

                        public void onAnimationCancel(Animator animation) {
                            if (this.this$0.state != null && !this.this$0.state.isStable()) {
                                Dot dot = this.this$0;
                                Dot.access$002(dot, dot.state.transitioningFrom());
                            }
                            1 v12 = this;
                            Dot.access$100(v12.this$0, this.val$startSize);
                            Dot.access$200(v12.this$0, this.val$startColor);
                            Dot.access$302(v12.this$0, null);
                        }
                    });
                    ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{var1_1, var2_3});
                    valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                        final /* synthetic */ Dot this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onAnimationUpdate(ValueAnimator animation) {
                            void var1_2;
                            int n10 = (Integer)var1_2.getAnimatedValue();
                            Dot.access$100(this.this$0, n10);
                        }
                    });
                    ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                    valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, (int)var4_7){
                        final /* synthetic */ int val$endColor;
                        final /* synthetic */ Dot this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$endColor = n10;
                        }

                        public void onAnimationUpdate(ValueAnimator animation) {
                            Dot.access$200(this.this$0, this.val$endColor);
                        }
                    });
                    AnimatorSet animatorSet4 = dot.currentAnimator;
                    if (animatorSet4 != null) {
                        animatorSet4.playTogether(new Animator[]{valueAnimator, valueAnimator2});
                        this.currentAnimator.start();
                    }
                    return;
                }
                throw new IllegalArgumentException("duration cannot be less than 0");
            }
            throw new IllegalArgumentException("endSize cannot be less than 0");
        }
        throw new IllegalArgumentException("startSize cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void changeSize(int newSizePx) {
        void var1_1;
        Dot dot = this;
        dot.shape.setIntrinsicWidth((int)var1_1);
        dot.shape.setIntrinsicHeight((int)var1_1);
        dot.drawableHolder.setImageDrawable(null);
        dot.drawableHolder.setImageDrawable((Drawable)this.shape);
    }

    /*
     * WARNING - void declaration
     */
    private void changeColor(int newColor) {
        void var1_1;
        this.shape.getPaint().setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ State access$002(Dot x02, State x12) {
        void var1_1;
        var0.state = var1_1;
        return x12;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(Dot x02, int x12) {
        void var1_1;
        x02.changeSize((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Dot x02, int x12) {
        void var1_1;
        x02.changeColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ AnimatorSet access$302(Dot x02, AnimatorSet x12) {
        void var1_1;
        var0.currentAnimator = var1_1;
        return x12;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setInactiveDiameterPx(int inactiveDiameterPx) {
        if (inactiveDiameterPx >= 0) {
            void var1_1;
            Dot dot = this;
            dot.inactiveDiameterPx = var1_1;
            dot.reflectParametersInView();
            return dot;
        }
        throw new IllegalArgumentException("inactiveDiameterPx cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public Dot setInactiveDiameterDp(int inactiveDiameterDp) {
        if (inactiveDiameterDp >= 0) {
            void var1_1;
            Dot dot = this;
            dot.setInactiveDiameterPx(ViewUtils.convertDpToPx(dot.getContext(), (float)var1_1));
            return dot;
        }
        throw new IllegalArgumentException("inactiveDiameterDp cannot be less than 0");
    }

    public int getInactiveDiameter() {
        return this.inactiveDiameterPx;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setActiveDiameterPx(int activeDiameterPx) {
        if (activeDiameterPx >= 0) {
            void var1_1;
            Dot dot = this;
            dot.activeDiameterPx = var1_1;
            dot.reflectParametersInView();
            return dot;
        }
        throw new IllegalArgumentException("activeDiameterPx cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public Dot setActiveDiameterDp(int activeDiameterDp) {
        if (activeDiameterDp >= 0) {
            void var1_1;
            Dot dot = this;
            dot.setActiveDiameterPx((int)var1_1);
            return dot;
        }
        throw new IllegalArgumentException("activeDiameterDp cannot be less than 0");
    }

    public int getActiveDiameter() {
        return this.activeDiameterPx;
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setInactiveColor(int inactiveColor) {
        void var1_1;
        Dot dot = this;
        dot.inactiveColor = var1_1;
        dot.reflectParametersInView();
        return dot;
    }

    public int getActiveColor() {
        return this.activeColor;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setActiveColor(int activeColor) {
        void var1_1;
        Dot dot = this;
        dot.activeColor = var1_1;
        dot.reflectParametersInView();
        return dot;
    }

    public int getTransitionDuration() {
        return this.transitionDurationMs;
    }

    /*
     * WARNING - void declaration
     */
    public Dot setTransitionDuration(int transitionDurationMs) {
        if (transitionDurationMs >= 0) {
            void var1_1;
            this.transitionDurationMs = var1_1;
            return this;
        }
        throw new IllegalArgumentException("transitionDurationMs cannot be less than 0");
    }

    /*
     * WARNING - void declaration
     */
    public void toggleState(boolean animate) {
        void var1_1;
        Object object = this.currentAnimator;
        if (object != null) {
            object.cancel();
        }
        if ((object = this.state) != State.ACTIVE) {
            this.setActive((boolean)var1_1);
        } else if (object != State.INACTIVE) {
            this.setInactive((boolean)var1_1);
        } else {
            Log.e((String)TAG, (String)"[Animation trying to start from illegal state]");
        }
    }

    public void setInactive(boolean animate) {
        int n10;
        AnimatorSet animatorSet = this.currentAnimator;
        if (animatorSet != null) {
            animatorSet.cancel();
        }
        if (n10 != 0 && this.state != State.INACTIVE && this.transitionDurationMs > 0) {
            Dot dot = this;
            int n11 = dot.activeDiameterPx;
            n10 = dot.inactiveDiameterPx;
            int n12 = dot.activeColor;
            int n13 = dot.inactiveColor;
            int n14 = dot.transitionDurationMs;
            dot.animateDotChange(n11, n10, n12, n13, n14);
        } else {
            Dot dot = this;
            dot.changeSize(dot.inactiveDiameterPx);
            dot.changeColor(dot.inactiveColor);
            dot.state = State.INACTIVE;
        }
    }

    public void setActive(boolean animate) {
        int n10;
        AnimatorSet animatorSet = this.currentAnimator;
        if (animatorSet != null) {
            animatorSet.cancel();
        }
        if (n10 != 0 && this.state != State.ACTIVE && this.transitionDurationMs > 0) {
            Dot dot = this;
            int n11 = dot.inactiveDiameterPx;
            n10 = dot.activeDiameterPx;
            int n12 = dot.inactiveColor;
            int n13 = dot.activeColor;
            int n14 = dot.transitionDurationMs;
            dot.animateDotChange(n11, n10, n12, n13, n14);
        } else {
            Dot dot = this;
            dot.changeSize(dot.activeDiameterPx);
            dot.changeColor(dot.activeColor);
            dot.state = State.ACTIVE;
        }
    }

    protected static final class State
    extends Enum<State> {
        public static final /* enum */ State INACTIVE;
        public static final /* enum */ State ACTIVE;
        public static final /* enum */ State TRANSITIONING_TO_ACTIVE;
        public static final /* enum */ State TRANSITIONING_TO_INACTIVE;
        private static final /* synthetic */ State[] $VALUES;
        private final boolean isStable;
        @Nullable
        private final State to;
        @Nullable
        private final State from;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            String string2;
            return Enum.valueOf(State.class, string2);
        }

        /*
         * WARNING - void declaration
         */
        private State(@Nullable boolean isStable, State to, State from) {
            void var5_5;
            void var4_4;
            void var3_3;
            this.isStable = var3_3;
            this.to = var4_4;
            this.from = var5_5;
        }

        static {
            State state;
            State state2;
            State state3;
            State state4;
            State state5 = state4;
            INACTIVE = new State(true, null, null);
            State state6 = state3;
            ACTIVE = new State(true, null, null);
            State state7 = state2;
            TRANSITIONING_TO_ACTIVE = new State(false, state6, state5);
            State state8 = state;
            TRANSITIONING_TO_INACTIVE = new State(false, state5, state6);
            $VALUES = new State[]{state5, state6, state7, state8};
        }

        public boolean isStable() {
            return this.isStable;
        }

        @Nullable
        public State transitioningTo() {
            return this.to;
        }

        @Nullable
        public State transitioningFrom() {
            return this.from;
        }
    }
}

