/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d9;
import com.instabug.library.g2;
import com.instabug.library.i;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributesDbHelper;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.UserAttributes;
import com.instabug.library.p;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.filters.Filters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SessionLocalEntity {
    private static final String TAG = "SessionLocalEntity";
    private final String id;
    private final String os;
    private final String device;
    private final long duration;
    private final long startedAt;
    private final String userName;
    private final String userEmail;
    private final String sdkVersion;
    private final String appVersion;
    private final String userEvents;
    private final String customAttributes;
    private final String userEventsKeys;
    private final String customAttributesKeys;
    private final boolean crashReportingEnabled;
    private final boolean isStitchedSessionLead;
    private final int syncStatus;
    private final String uuid;
    private final String appToken;
    private final boolean usersPageEnabled;
    @Nullable
    private final String productionUsage;

    /*
     * WARNING - void declaration
     */
    public SessionLocalEntity(String id2, String os, String device, long duration, long startedAt, String userName, String userEmail, String sdkVersion, String appVersion, String userEvents, String customAttributes, String userEventsKeys, String customAttributesKeys, boolean crashReportingEnabled, int syncStatus, String uuid, String appToken, boolean usersPageEnabled, @Nullable String productionUsage, boolean isStitchedSessionLead) {
        void var22_20;
        void var21_19;
        void var20_18;
        void var19_17;
        void var18_16;
        void var17_15;
        void var16_14;
        void var15_13;
        void var14_12;
        void var13_11;
        void var12_10;
        void var11_9;
        void var10_8;
        void var9_7;
        void var8_6;
        void var6_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = var1_1;
        this.os = var2_2;
        this.device = var3_3;
        this.duration = var4_4;
        this.startedAt = var6_5;
        this.userName = var8_6;
        this.userEmail = var9_7;
        this.sdkVersion = var10_8;
        this.appVersion = var11_9;
        this.userEvents = var12_10;
        this.customAttributes = var13_11;
        this.userEventsKeys = var14_12;
        this.customAttributesKeys = var15_13;
        this.crashReportingEnabled = var16_14;
        this.syncStatus = var17_15;
        this.uuid = var18_16;
        this.appToken = var19_17;
        this.usersPageEnabled = var20_18;
        this.productionUsage = var21_19;
        this.isStitchedSessionLead = var22_20;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getId() {
        return this.id;
    }

    public String getOs() {
        return this.os;
    }

    public String getDevice() {
        return this.device;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStartTimestampMicros() {
        return this.startedAt;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    public String getUserEventsKeys() {
        return this.userEventsKeys;
    }

    public String getCustomAttributesKeys() {
        return this.customAttributesKeys;
    }

    public boolean isCrashReportingEnabled() {
        return this.crashReportingEnabled;
    }

    public boolean isStitchedSessionLead() {
        return this.isStitchedSessionLead;
    }

    public int getSyncStatus() {
        return this.syncStatus;
    }

    public boolean isUsersPageEnabled() {
        return this.usersPageEnabled;
    }

    @Nullable
    public String getProductionUsage() {
        return this.productionUsage;
    }

    public static class Factory {
        /*
         * Unable to fully structure code
         */
        @Nullable
        private String getProductionUsage() {
            block21: {
                block20: {
                    if (!InstabugCore.isFeatureAvailable(Feature.PRODUCTION_USAGE_DETECTION)) break block21;
                    this = v0;
                    v0 = new JSONObject();
                    var1_1 = i.a(Instabug.getApplicationContext());
                    if (var1_1 == null) break block20;
                    v1 = this.put("store_url", var1_1);
lbl9:
                    // 2 sources

                    while (true) {
                        ** GOTO lbl15
                        break;
                    }
                }
                v1 = this.put("store_url", "other");
                ** continue;
lbl15:
                // 1 sources

                v2 = this;
                v3 = v2;
                v4 = v2;
                this = v5;
                try {
                    v5 = new JSONObject();
                }
                catch (JSONException v6) {
                    return null;
                }
                var1_1 = v7;
                new JSONObject().put("enabled", InstabugCore.isFeatureEnabled(Feature.BUG_REPORTING));
                v5.put("bugs", (Object)var1_1);
                var1_1 = v8;
                new JSONObject().put("enabled", InstabugCore.isFeatureEnabled(Feature.SURVEYS));
                v5.put("surveys", (Object)var1_1);
                var1_1 = v9;
                new JSONObject().put("enabled", InstabugCore.isFeatureEnabled(Feature.FEATURE_REQUESTS));
                v5.put("feature_requests", (Object)var1_1);
                var1_1 = v10;
                new JSONObject().put("enabled", InstabugCore.isAPMEnabled());
                v5.put("apm", (Object)var1_1);
                v3.put("features", this);
                return v4.toString();
            }
            return null;
        }

        private boolean isCrashReportingEnabled() {
            return InstabugCore.isFeatureEnabled(Feature.CRASH_REPORTING);
        }

        @Nullable
        private String getOs(boolean usersPageEnabled) {
            return usersPageEnabled ? "SDK Level " + InstabugDeviceProperties.getCurrentOSLevel() : null;
        }

        @Nullable
        private String getDevice(boolean usersPageEnabled) {
            return usersPageEnabled ? InstabugDeviceProperties.getDeviceType() : null;
        }

        private long getCurrentSessionTimeUntilNow() {
            long l10 = SettingsManager.getInstance().getSessionStartedAt();
            if (l10 == 0L) {
                return 0L;
            }
            return System.currentTimeMillis() / 1000L - l10;
        }

        private long getSessionStartedAt() {
            return SettingsManager.getInstance().getSessionStartedAt();
        }

        @Nullable
        private String getUserName(boolean usersPageEnabled) {
            return usersPageEnabled ? d9.g() : null;
        }

        @Nullable
        private String getUserEmail(boolean usersPageEnabled) {
            return usersPageEnabled ? d9.f() : null;
        }

        @NonNull
        private String getSdkVersion() {
            return "10.11.1";
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private String getAppVersion(Context context) {
            void var1_1;
            return context == null ? null : InstabugDeviceProperties.getAppVersion((Context)var1_1);
        }

        @NonNull
        private String getUserAttributesAsStringJsonObject() {
            Object object = "{}";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(p.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                UserAttributes userAttributes = new UserAttributes();
                userAttributes.putMap(hashMap);
                object = userAttributes.toString();
            }
            return object;
        }

        @NonNull
        private String getUserAttributesKeysAsStringJsonArray() {
            Object object = "[]";
            HashMap<String, String> hashMap = Filters.applyOn(UserAttributesDbHelper.getAll()).apply(p.g()).thenGet();
            if (hashMap != null && hashMap.size() != 0) {
                UserAttributes userAttributes = new UserAttributes();
                userAttributes.putMap(hashMap);
                object = userAttributes.keysAsStringJsonArray();
            }
            return object;
        }

        @NonNull
        private String getUserEventsAsStringJsonArray() {
            Object object = "[]";
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            try {
                object = UserEvent.toJson(new ArrayList<UserEvent>(list)).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SessionLocalEntity.TAG, "parsing user events got error: " + jSONException.getMessage(), jSONException);
            }
            return object;
        }

        @NonNull
        private String getUserEventsKeysAsStringJsonArray() {
            List<UserEvent> list = InstabugUserEventLogger.getInstance().getUserEvents();
            return UserEvent.keysAsJsonArray(new ArrayList<UserEvent>(list)).toString();
        }

        private boolean isFirstSession() {
            return SettingsManager.getInstance().isFirstSession();
        }

        private int getSyncStatus() {
            return this.isFirstSession() ? 1 : 0;
        }

        @NonNull
        private String getUuid() {
            return d9.i();
        }

        @Nullable
        private String getAppToken() {
            return SettingsManager.getInstance().getAppToken();
        }

        @NonNull
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public SessionLocalEntity create(Context object, @NonNull g2 object2, boolean bl) {
            g2 g22 = object2;
            Factory factory = string2;
            String string2 = object2.getId();
            object2 = factory.getOs(bl);
            String string3 = factory.getDevice(bl);
            long l10 = factory.getCurrentSessionTimeUntilNow();
            long l11 = factory.getSessionStartedAt();
            String string4 = factory.getUserName(bl);
            String string5 = factory.getUserEmail(bl);
            String string6 = factory.getSdkVersion();
            object = factory.getAppVersion((Context)object);
            String string7 = factory.getUserEventsAsStringJsonArray();
            String string8 = factory.getUserAttributesAsStringJsonObject();
            String string9 = factory.getUserEventsKeysAsStringJsonArray();
            String string10 = factory.getUserAttributesKeysAsStringJsonArray();
            boolean bl2 = factory.isCrashReportingEnabled();
            int n10 = factory.getSyncStatus();
            String string11 = factory.getUuid();
            String string12 = factory.getAppToken();
            String string13 = factory.getProductionUsage();
            boolean bl3 = g22.isStitchedSessionLead();
            return new SessionLocalEntity(string2, (String)object2, string3, l10, l11, string4, string5, string6, (String)object, string7, string8, string9, string10, bl2, n10, string11, string12, bl, string13, bl3);
        }
    }
}

