/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.model.a;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Report {
    private static final int ITEMS_LIST_LIMIT = 10;
    private static final int FILES_LIST_LIMIT = 3;
    private static final String TAG = "Report";
    private ArrayList<String> tags;
    private ArrayList<a> consoleLogs;
    @Nullable
    private String userData;
    private HashMap<String, String> userAttributes;
    private HashMap<Uri, String> fileAttachments;

    public Report() {
        HashMap hashMap;
        HashMap hashMap2;
        ArrayList arrayList;
        ArrayList arrayList2;
        Object this_ = arrayList2;
        arrayList2 = new ArrayList();
        v1.tags = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v1.consoleLogs = this_;
        this_ = hashMap2;
        hashMap2 = new HashMap();
        v1.userAttributes = this_;
        this_ = hashMap;
        hashMap = new HashMap();
        v1.fileAttachments = this_;
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(String ... tag) {
        void var1_1;
        int n10;
        if (tag == null) {
            return;
        }
        for (n10 = 0; this.tags.size() < 10 && n10 < ((void)var1_1).length; ++n10) {
            this.tags.add((String)var1_1[n10]);
        }
        if (n10 < ((void)var1_1).length) {
            InstabugSDKLogger.w(TAG, "Some tags were ignored. Maximum allowed tags count reached. Please note that you can add up to 10 tags.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addTag(ArrayList<String> tags) {
        void var1_1;
        int n10;
        if (tags == null) {
            return;
        }
        for (n10 = 0; this.tags.size() < 10 && n10 < var1_1.size(); ++n10) {
            this.tags.add((String)var1_1.get(n10));
        }
        if (n10 < var1_1.size()) {
            InstabugSDKLogger.w(TAG, "Some tags were ignored. Maximum allowed tags count reached. Please note that you can add up to 10 tags.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFileAttachment(@NonNull Uri fileUri, @NonNull String fileNameWithExtension) {
        if (this.fileAttachments.size() < 3) {
            void var2_2;
            void var1_1;
            this.fileAttachments.put((Uri)var1_1, (String)var2_2);
        } else {
            InstabugSDKLogger.w(TAG, "File was ignored. Maximum allowed files count reached. Please note that you can add up to 10 files.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addFileAttachment(@NonNull byte[] data, @NonNull String fileNameWithExtension) {
        void var2_2;
        Uri uri;
        if (this.fileAttachments.size() >= 3) {
            InstabugSDKLogger.w(TAG, "File was ignored. Maximum allowed files count reached. Please note that you can add up to 10 files.");
            return;
        }
        Context context = Instabug.getApplicationContext();
        if (context != null && AttachmentsUtility.isValidSize(((void)uri).length, 5.0) && (uri = AttachmentsUtility.getUriFromBytes(context, (byte[])uri, (String)var2_2)) != null) {
            this.fileAttachments.put(uri, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUserAttribute(@NonNull String key, String value) {
        void var2_2;
        void var1_1;
        if (this.userAttributes.size() >= 10) {
            InstabugSDKLogger.w(TAG, "User attribute was ignored. Maximum allowed attributes count reached. Please note that you can add up to 10 user attributes.");
            return;
        }
        this.userAttributes.put((String)var1_1, (String)var2_2);
    }

    public void addUserAttributes(HashMap<String, String> userAttributes) {
        Iterator iterator;
        if (userAttributes == null) {
            return;
        }
        iterator = ((HashMap)((Object)iterator)).entrySet().iterator();
        while (this.userAttributes.size() < 10 && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null) continue;
            this.userAttributes.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (iterator.hasNext()) {
            InstabugSDKLogger.w(TAG, "Some attributes were ignored. Maximum allowed attributes count reached. Please note that you can add up to 10 user attributes.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendToConsoleLogs(String logMessage) {
        void var1_1;
        a a10;
        if (((Report)((Object)this_)).consoleLogs.size() >= 10) {
            InstabugSDKLogger.w(TAG, "Console log was ignored. Maximum allowed logs count reached. Please note that you can add up to 10 log messages.");
            return;
        }
        Report report = this_;
        a this_ = a10;
        this_();
        a10.c((String)var1_1);
        a10.a(System.currentTimeMillis());
        report.consoleLogs.add(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void logVerbose(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.v((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logDebug(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.d((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logInfo(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.i((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logWarn(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.w((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void logError(String logMessage) {
        if (InstabugCore.getFeatureState(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
            void var1_1;
            InstabugLog.e((String)var1_1);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public ArrayList<a> getConsoleLog() {
        return this.consoleLogs;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserData(@NonNull String userData) {
        void var1_1;
        this.userData = StringUtility.trimString((String)var1_1, 1000);
    }

    public HashMap<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public HashMap<Uri, String> getFileAttachments() {
        return this.fileAttachments;
    }

    /*
     * WARNING - void declaration
     */
    public void addConsoleLogs(ArrayList<a> consoleLogArrayList) {
        void var1_1;
        int n10;
        if (consoleLogArrayList == null) {
            return;
        }
        for (n10 = 0; this.consoleLogs.size() <= 10 && n10 < var1_1.size(); ++n10) {
            this.consoleLogs.add((a)var1_1.get(n10));
        }
        if (n10 < var1_1.size()) {
            InstabugSDKLogger.w(TAG, "Some console logs were ignored. Maximum allowed logs count reached. Please note that you can add up to 10 log messages.");
        }
    }

    public static interface OnReportCreatedListener {
        public void onReportCreated(Report var1);
    }
}

