/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.dbv2;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.b2;
import com.instabug.library.c2;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.f2;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.List;

public class IBGDbManager {
    public static final String TAG = "IBGDbManagerV2";
    private static SQLiteOpenHelper dbHelper;
    private static IBGDbManager instance;
    @Nullable
    private Boolean databaseTransactionsEnabled;
    @Nullable
    private SQLiteDatabase database;

    public static synchronized void init(c2 c22) {
        if (instance == null) {
            instance = new IBGDbManager();
            dbHelper = c22;
        }
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    public static synchronized IBGDbManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                IBGDbManager.init(new c2(Instabug.getApplicationContext()));
            } else {
                throw new IllegalStateException("IBGDbManagerV2 is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    private IBGDbManager() {
    }

    private synchronized void openDatabase() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase == null || !sQLiteDatabase.isOpen()) {
            this.database = dbHelper.getWritableDatabase();
        }
    }

    private synchronized boolean databaseInitializedAndOpen() {
        IBGDbManager this_ = this_.database;
        return this_ != null && this_.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static synchronized void tearDown() {
        SQLiteOpenHelper sQLiteOpenHelper = dbHelper;
        if (sQLiteOpenHelper != null) {
            sQLiteOpenHelper.close();
            dbHelper = null;
        }
        IBGDbManager iBGDbManager = instance;
        synchronized (iBGDbManager) {
            SQLiteDatabase sQLiteDatabase = IBGDbManager.instance.database;
            if (sQLiteDatabase != null) {
                sQLiteDatabase.close();
                IBGDbManager.instance.database = null;
            }
            instance = null;
            return;
        }
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((IBGDbManager)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((IBGDbManager)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled(Instabug.getApplicationContext()) ^ true;
        }
        return (this = ((IBGDbManager)this).databaseTransactionsEnabled) != null ? (Boolean)this : false;
    }

    private synchronized void logOperationFailedWarning() {
        IBGDbManager this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on a closed database. Falling back silently");
        } else {
            InstabugSDKLogger.w(TAG, "Failed to do database operation. Falling back silently");
        }
    }

    public long insert(final @NonNull String string2, final @Nullable String string3, final @NonNull b2 b22) {
        Long l10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
            public Long a() {
                b b10 = this;
                b10.IBGDbManager.this.openDatabase();
                try {
                    if (b10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        b b11 = this;
                        String string22 = b11.string2;
                        return IBGDbManager.this.database.insert(string22, b11.string3, b22.a());
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB insertion failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
            }
        });
        return l10 == null ? -1L : l10;
    }

    public long insertWithOnConflict(final @NonNull String string2, final @Nullable String string3, final @NonNull b2 b22) {
        Long l10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
            public Long a() {
                c c10 = this;
                c10.IBGDbManager.this.openDatabase();
                try {
                    if (c10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        c c11 = this;
                        String string22 = c11.string2;
                        return IBGDbManager.this.database.insertWithOnConflict(string22, c11.string3, b22.a(), 4);
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB insertion with on conflict failed: " + exception.getMessage(), exception);
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
            }
        });
        return l10 == null ? -1L : l10;
    }

    /*
     * WARNING - void declaration
     */
    public void execSQL(@NonNull String sql) {
        void var1_1;
        PoolProvider.getDatabaseExecutor().execute(new Runnable((String)var1_1){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public void run() {
                d d10 = this;
                d10.IBGDbManager.this.openDatabase();
                try {
                    if (d10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        IBGDbManager.this.database.execSQL(this.a);
                        return;
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB execution a sql failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                }
            }
        });
    }

    public long insertWithOnConflictReplace(final @NonNull String string2, final @Nullable String string3, final @NonNull b2 b22) {
        Long l10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Long a() {
                e e10 = this;
                e10.IBGDbManager.this.openDatabase();
                try {
                    if (e10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        e e11 = this;
                        String string22 = e11.string2;
                        return IBGDbManager.this.database.insertWithOnConflict(string22, e11.string3, b22.a(), 5);
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB insertion with on conflict replace failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
            }
        });
        return l10 == null ? -1L : l10;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public com.instabug.library.internal.storage.cache.dbv2.a rawQuery(@NonNull String sql, @Nullable List<f2> selectionArgs) {
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<com.instabug.library.internal.storage.cache.dbv2.a>((String)var1_1, (List)var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ List b;
            {
                this.a = string2;
                this.b = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public com.instabug.library.internal.storage.cache.dbv2.a a() {
                f f10 = this;
                f10.IBGDbManager.this.openDatabase();
                try {
                    if (f10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        return new com.instabug.library.internal.storage.cache.dbv2.a(IBGDbManager.this.database.rawQuery(this.a, f2.a(this.b)));
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB raw query failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable List<f2> whereArgs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Integer>((String)var1_1, (String)var2_2, (List)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ List c;
            {
                this.a = string2;
                this.b = string3;
                this.c = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Integer a() {
                g g10 = this;
                g10.IBGDbManager.this.openDatabase();
                try {
                    if (g10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        g g11 = this;
                        String string2 = g11.a;
                        return IBGDbManager.this.database.delete(string2, g11.b, f2.a(this.c));
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return 0;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB deletion failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                }
                return 0;
            }
        });
        return n10 == null ? 0 : n10;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public com.instabug.library.internal.storage.cache.dbv2.a query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<f2> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<com.instabug.library.internal.storage.cache.dbv2.a>((String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            {
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            @Nullable
            public com.instabug.library.internal.storage.cache.dbv2.a a() {
                h h10 = this;
                h10.IBGDbManager.this.openDatabase();
                try {
                    if (h10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        h h11 = this;
                        String string2 = h11.a;
                        String[] stringArray = h11.b;
                        String string3 = h11.c;
                        String[] stringArray2 = f2.a(h11.d);
                        String string4 = h11.e;
                        String string5 = h11.f;
                        String string6 = h11.g;
                        return new com.instabug.library.internal.storage.cache.dbv2.a(IBGDbManager.this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6));
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB query failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
            }
        });
    }

    public int update(final @NonNull String string2, final @NonNull b2 b22, final @Nullable String string3, final @Nullable List<f2> list) {
        Integer n10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Integer>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Integer a() {
                i i10 = this;
                i10.IBGDbManager.this.openDatabase();
                try {
                    if (i10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        i i11 = this;
                        String string22 = i11.string2;
                        ContentValues contentValues = i11.b22.a();
                        String string32 = i11.string3;
                        return IBGDbManager.this.database.update(string22, contentValues, string32, f2.a(list));
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB update failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1;
                }
            }
        });
        return n10 == null ? 0 : n10;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public com.instabug.library.internal.storage.cache.dbv2.a query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<f2> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<com.instabug.library.internal.storage.cache.dbv2.a>((String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7, (String)var8_8){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ String h;
            {
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
                this.h = string7;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public com.instabug.library.internal.storage.cache.dbv2.a a() {
                j j10 = this;
                j10.IBGDbManager.this.openDatabase();
                try {
                    if (j10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        j j11 = this;
                        String string2 = j11.a;
                        String[] stringArray = j11.b;
                        String string3 = j11.c;
                        String[] stringArray2 = f2.a(j11.d);
                        String string4 = j11.e;
                        String string5 = j11.f;
                        String string6 = j11.g;
                        String string7 = j11.h;
                        return new com.instabug.library.internal.storage.cache.dbv2.a(IBGDbManager.this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6, string7));
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB query failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return null;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void beginTransaction() {
        IBGDbManager iBGDbManager = this;
        iBGDbManager.openDatabase();
        try {
            if (iBGDbManager.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB transaction failed: " + exception.getMessage(), exception);
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB end transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void setTransactionSuccessful() {
        try {
            if (this.databaseInitializedAndOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * WARNING - void declaration
     */
    public long queryNumEntries(@NonNull String tableName) {
        void var1_1;
        Long l10 = PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable<Long>((String)var1_1){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
            public Long a() {
                a a10 = this;
                a10.IBGDbManager.this.openDatabase();
                try {
                    if (a10.IBGDbManager.this.databaseInitializedAndOpen()) {
                        return DatabaseUtils.queryNumEntries((SQLiteDatabase)IBGDbManager.this.database, (String)this.a);
                    }
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(IBGDbManager.TAG, "DB query num entries failed: " + exception.getMessage());
                    IBGDbManager.this.logOperationFailedWarning();
                    return -1L;
                }
            }
        });
        return l10 == null ? -1L : l10;
    }
}

