/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.util.InstabugSDKLogger;

public class SQLiteDatabaseWrapper {
    public static final String TAG = "SQLiteDatabaseWrapper";
    @Nullable
    private SQLiteDatabase database;
    private SQLiteOpenHelper databaseHelper;
    @Nullable
    private Boolean databaseTransactionsEnabled;

    /*
     * WARNING - void declaration
     */
    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        void var1_1;
        this.databaseHelper = var1_1;
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled(Instabug.getApplicationContext()) ^ true;
        }
        return (this = ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled) != null ? (Boolean)this : false;
    }

    private synchronized void logOperationFailedWarning() {
        SQLiteDatabaseWrapper this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.w(TAG, "Attempted to do operation on a closed database. Falling back silently");
        } else {
            InstabugSDKLogger.w(TAG, "Failed to do database operation. Falling back silently");
        }
    }

    void open() {
        block4: {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase == null) break block4;
            if (!sQLiteDatabase.isOpen()) break block4;
            return;
        }
        try {
            this.database = this.databaseHelper.getWritableDatabase();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(this, "Error while opening the DB: " + exception.getMessage(), exception);
            NonFatals.reportNonFatal(exception, "Error while opening the DB: " + exception.getMessage());
        }
    }

    public synchronized void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void beginTransaction() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB transaction failed due to: " + exception.getMessage(), exception);
            NonFatals.reportNonFatal(exception, "DB transaction failed due to: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insert((String)var1_1, (String)var2_3, (ContentValues)var3_4);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB insertion failed due to: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB insertion failed due to: " + exception.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_3, (ContentValues)var3_4, 4);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB insertion with on conflict failed: " + exception.getMessage(), exception);
            NonFatals.reportNonFatal(exception, "DB insertion with on conflict failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_3, (ContentValues)var3_4, 5);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB insertion with on conflict replace failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB insertion with on conflict replace failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void execSQL(@NonNull String sql) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var1_1;
                this.database.execSQL((String)var1_1);
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB execution a sql failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB execution a sql failed: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void setTransactionSuccessful() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB transaction not successful due to: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB end transaction not successful due to: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB end transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var2_3;
                void var1_1;
                return this.database.rawQuery((String)var1_1, (String[])var2_3);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB raw query failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB raw query failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.delete((String)var1_1, (String)var2_3, (String[])var3_4);
            }
            this.logOperationFailedWarning();
            return 0;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB deletion failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB raw query failed: " + exception.getMessage());
            this.logOperationFailedWarning();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int update(@NonNull String table, @NonNull ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.update((String)var1_1, (ContentValues)var2_3, (String)var3_4, (String[])var4_5);
            }
            this.logOperationFailedWarning();
            return -1;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB update failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB update failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var7_8;
                void var6_7;
                void var5_6;
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_3, (String)var3_4, (String[])var4_5, (String)var5_6, (String)var6_7, (String)var7_8);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB query failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB query failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var8_9;
                void var7_8;
                void var6_7;
                void var5_6;
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_3, (String)var3_4, (String[])var4_5, (String)var5_6, (String)var6_7, (String)var7_8, (String)var8_9);
            }
            this.logOperationFailedWarning();
            return null;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB query failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB query failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long queryNumEntries(@NonNull String tableName) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var1_1;
                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)var1_1);
            }
            this.logOperationFailedWarning();
            return -1L;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(TAG, "DB query num entries failed: " + exception.getMessage());
            NonFatals.reportNonFatal(exception, "DB query num entries failed: " + exception.getMessage());
            this.logOperationFailedWarning();
            return -1L;
        }
    }

    @VisibleForTesting
    public void closeDB() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase != null) {
            sQLiteDatabase.close();
            this.database = null;
        }
    }
}

