/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AttachmentManager {
    public static final String TAG = "AttachmentManager";
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    @Nullable
    public static File getAttachmentDirectory(@Nullable Context context) {
        File file;
        Object object;
        if (context == null && Instabug.isBuilt()) {
            object = Instabug.getApplicationContext();
        }
        if (object == null) {
            return null;
        }
        if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = AttachmentManager.getInternalStoragePath(object);
            }
        } else {
            object = AttachmentManager.getInternalStoragePath(object);
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public static File getNewDirectory(@Nullable Context context, String directoryName) {
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/" + (String)var1_1 + "/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getVideoRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/frames/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/videos/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        Context context2;
        File file;
        File file2 = file;
        if (!new File(AttachmentManager.getAttachmentDirectory(context2) + "/auto_recording/").exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        SimpleDateFormat simpleDateFormat;
        Object object = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        Object object2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "auto-recording-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    private static void saveBytesToFile(byte[] data, File file) {
        block22: {
            var2_14 = null;
            var3_15 = v0;
            try {
                v1 = var0;
                var3_15(new FileOutputStream((File)var1_12));
            }
            catch (Throwable var0_6) {
                break block22;
            }
            catch (IOException var0_7) {
                // empty catch block
                ** GOTO lbl-1000
            }
            catch (FileNotFoundException var0_9) {
                // empty catch block
                ** GOTO lbl-1000
            }
            v0.write(v1);
lbl-1000:
            // 3 sources

            {
                while (true) {
                    InstabugSDKLogger.e("AttachmentManager", var0_2.getMessage(), (Throwable)var0_2);
                    return;
                }
                catch (Throwable var0_3) {
                    var2_14 = var3_15;
                    break block22;
                }
                catch (IOException var0_4) {
                    var2_14 = var3_15;
                    ** GOTO lbl-1000
                }
                catch (FileNotFoundException var0_5) {
                    var2_14 = var3_15;
                    ** GOTO lbl-1000
                }
                try {
                    v0.flush();
                    v0.close();
                    return;
                }
                catch (IOException var0_1) {}
                if (var0_1.getMessage() == null) return;
                ** GOTO lbl-1000
            }
lbl-1000:
            // 2 sources

            {
                if (var0.getMessage() != null) {
                    InstabugSDKLogger.e("AttachmentManager", var0.getMessage(), (Throwable)var0);
                }
                if (var2_14 == null) return;
            }
            try {
                v2 = var2_14;
                v2.flush();
                v2.close();
                return;
            }
            catch (IOException var0_8) {
                if (var0_8.getMessage() == null) return;
                ** GOTO lbl-1000
            }
lbl-1000:
            // 2 sources

            {
                if (var0.getMessage() != null) {
                    InstabugSDKLogger.e("AttachmentManager", var0.getMessage(), (Throwable)var0);
                }
                if (var2_14 == null) return;
            }
            try {
                v3 = var2_14;
                v3.flush();
                v3.close();
                return;
            }
            catch (IOException var0_10) {
                if (var0_10.getMessage() == null) return;
                ** continue;
            }
        }
        if (var2_14 == null) throw var0_11;
        try {
            v4 = var2_14;
            v4.flush();
            v4.close();
            throw var0_11;
        }
        catch (IOException var1_13) {
            if (var1_13.getMessage() == null) throw var0_11;
            InstabugSDKLogger.e("AttachmentManager", var1_13.getMessage(), var1_13);
        }
        throw var0_11;
    }

    /*
     * WARNING - void declaration
     */
    private static File getAttachmentFile(Context context, String fileName) {
        void var1_1;
        File file;
        Object object = AttachmentManager.getAttachmentDirectory(context);
        File file2 = file;
        if (new File((File)object, (String)var1_1).exists()) {
            File file3;
            file2 = file3;
            file3 = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + (String)var1_1);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        void var2_2;
        Object object;
        object = AttachmentManager.getAttachmentFile(object, (String)var2_2);
        AttachmentManager.saveBytesToFile(data, (File)object);
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFromUriIntoFile(@Nullable Context context, @NonNull Uri source, File target) {
        block39: {
            block33: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    if (context == null) {
                                        return;
                                    }
                                    if (var0 /* !! */ .getContentResolver() == null) {
                                        return;
                                    }
                                    var3_19 = null;
                                    var4_20 /* !! */  = null;
                                    try {
                                        var1_15 = var0 /* !! */ .getContentResolver().openInputStream((Uri)var1_15);
                                    }
                                    catch (Throwable var0_9) {
                                        break block33;
                                    }
                                    catch (IOException var0_10) {
                                        // empty catch block
                                        ** GOTO lbl-1000
                                    }
                                    catch (FileNotFoundException var0_12) {
                                        // empty catch block
                                        ** GOTO lbl-1000
                                    }
                                    {
                                        var0 /* !! */  = var0 /* !! */ .getContentResolver().openOutputStream(Uri.fromFile((File)var2_17));
                                        if (var1_15 == null) return;
                                        if (var0 /* !! */  != null) break block34;
                                        return;
                                    }
                                }
                                var5_21 = v0;
                                {
                                    v0 = new BufferedInputStream((InputStream)var1_15);
                                }
                                InstabugSDKLogger.d("AttachmentManager", "Target file path: " + var2_17.getPath());
lbl-1000:
                                // 1 sources

                                {
                                    while (true) {
                                        if ((var2_18 = var5_21.read((byte[])var0 /* !! */ )) <= 0) ** GOTO lbl36
                                        ** GOTO lbl-1000
lbl-1000:
                                        // 3 sources

                                        {
                                            while (true) {
                                                InstabugSDKLogger.e("AttachmentManager", var0_2.getMessage(), (Throwable)var0_2);
                                                return;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                var1_15.write((byte[])var0 /* !! */ , 0, var2_18);
                                                continue;
                                            }
lbl36:
                                            // 1 sources

                                            try {
                                                var1_15.close();
                                                var5_21.close();
                                                return;
                                            }
                                            catch (IOException var0_1) {}
                                            if (var0_1.getMessage() == null) return;
                                        }
                                        break;
                                    }
                                    catch (Throwable var0_6) {
                                        var3_19 = var5_21;
                                        break block33;
                                    }
                                    catch (IOException var0_7) {
                                        var3_19 = var5_21;
                                        ** GOTO lbl-1000
                                    }
                                    catch (FileNotFoundException var0_8) {
                                        var3_19 = var5_21;
                                        ** GOTO lbl-1000
                                    }
                                    var1_15 = v1;
                                    {
                                        v1 = new BufferedOutputStream((OutputStream)var0 /* !! */ );
                                    }
                                    var0 /* !! */  = (Context)new byte[32768];
                                    ** continue;
                                }
lbl-1000:
                                // 2 sources

                                {
                                    if (var0 /* !! */ .getMessage() != null) {
                                        InstabugSDKLogger.e("AttachmentManager", var0 /* !! */ .getMessage(), (Throwable)var0 /* !! */ );
                                    }
                                    if (var4_20 /* !! */  == null) break block35;
                                }
                                try {
                                    var4_20 /* !! */ .close();
                                }
                                catch (IOException var0_11) {
                                    break block36;
                                }
                            }
                            if (var3_19 == null) return;
                            var3_19.close();
                            return;
                        }
                        if (var0_11.getMessage() == null) return;
                        ** GOTO lbl-1000
lbl-1000:
                        // 2 sources

                        {
                            if (var0 /* !! */ .getMessage() != null) {
                                InstabugSDKLogger.e("AttachmentManager", var0 /* !! */ .getMessage(), (Throwable)var0 /* !! */ );
                            }
                            if (var4_20 /* !! */  == null) break block37;
                        }
                        try {
                            var4_20 /* !! */ .close();
                        }
                        catch (IOException var0_13) {
                            break block38;
                        }
                    }
                    if (var3_19 == null) return;
                    var3_19.close();
                    return;
                }
                if (var0_13.getMessage() == null) return;
                ** while (true)
            }
            if (var4_20 /* !! */  != null) {
                try {
                    var4_20 /* !! */ .close();
                }
                catch (IOException var1_16) {
                    break block39;
                }
            }
            if (var3_19 == null) throw var0_14;
            var3_19.close();
            throw var0_14;
        }
        if (var1_16.getMessage() == null) throw var0_14;
        InstabugSDKLogger.e("AttachmentManager", var1_16.getMessage(), var1_16);
        throw var0_14;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        void var1_2;
        if (activity != null && var1_2 != null) {
            Cursor cursor;
            Cursor cursor2 = cursor;
            Cursor cursor3 = new String[1];
            cursor = cursor3;
            cursor3[0] = "_data";
            if ((cursor = cursor2.managedQuery((Uri)var1_2, (String[])cursor, null, null, null)) != null) {
                Cursor cursor4 = cursor;
                int n10 = cursor4.getColumnIndexOrThrow("_data");
                cursor4.moveToFirst();
                return cursor4.getString(n10);
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri, @Nullable String fileNameWithExtension) {
        Object object;
        String string2;
        void var1_1;
        if (originalUri == null) {
            return null;
        }
        String string3 = "";
        String string4 = var1_1.getLastPathSegment();
        if (string4 != null) {
            string3 = string4.toLowerCase();
        }
        if (string2 == null || SettingsManager.getInstance().getExtraAttachmentFiles() == null || !SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(var1_1)) {
            string2 = string3;
        }
        Context context2 = object;
        object = AttachmentManager.getAttachmentFile(object, string2);
        AttachmentManager.copyFromUriIntoFile(context2, (Uri)var1_1, (File)object);
        if (!AttachmentManager.validateFileSize((Uri)var1_1, (File)object)) {
            return null;
        }
        return Uri.fromFile((File)object);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri) {
        void var1_1;
        return AttachmentManager.getNewFileUri(context, (Uri)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean validateFileSize(Uri uri, File attachmentFile) {
        Uri uri2;
        if (SettingsManager.getInstance().getExtraAttachmentFiles() != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri2)) {
            double d10;
            void var1_2;
            double d11 = (double)var1_2.length() / 1048576.0;
            if (d10 > 50.0) {
                InstabugSDKLogger.w(TAG, "Attachment size is" + d11 + ", exceeds " + 50.0 + " MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, Context context, a callback) {
        block5: {
            var1_2 = AttachmentManager.getAttachmentDirectory(context);
            var3_4 = v0;
            v0 = new File((File)var1_2, "bug_" + System.currentTimeMillis() + "_.jpg");
            InstabugSDKLogger.v("AttachmentManager", "image path: " + var3_4.toString());
            var1_2 = v1;
            var1_2(new FileOutputStream(var3_4));
            var0.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)var1_2);
            v1.close();
            var0 = Uri.fromFile((File)v0);
            if (var0 == null) ** GOTO lbl17
            try {
                var2_3.onSuccess((Uri)var0);
                break block5;
lbl17:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void saveBitmap(Bitmap bitmap, File attachmentDirectory, a callback) {
        block11: {
            block12: {
                block10: {
                    var3_4 = v0;
                    v0 = new File((File)var1_2, "frame_" + System.currentTimeMillis() + "_.jpg");
                    InstabugSDKLogger.v("AttachmentManager", "video frame path: " + var3_4.toString());
                    var1_2 = v1;
                    v1 = new BufferedOutputStream(new FileOutputStream(var3_4));
                    if (bitmap.getWidth() <= var0.getHeight()) break block10;
                    v2 = var0.getWidth();
lbl10:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
                }
                v2 = var0.getHeight();
                ** continue;
                var4_5 = v2;
                if (var4_5 <= 640) break block12;
                v3 = AttachmentManager.resizeBitmap(var0, 640).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
lbl20:
                // 2 sources

                while (true) {
                    ** GOTO lbl26
                    break;
                }
            }
            v3 = AttachmentManager.resizeBitmap(var0, 320).compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)var1_2);
            ** continue;
lbl26:
            // 1 sources

            var1_2.close();
            var0 = Uri.fromFile((File)var3_4);
            if (var0 == null) ** GOTO lbl32
            try {
                var2_3.onSuccess((Uri)var0);
                break block11;
lbl32:
                // 1 sources

                var2_3.onError(new Throwable("Uri equal null"));
            }
            catch (IOException var0_1) {
                var2_3.onError(var0_1);
            }
        }
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        Bitmap bitmap;
        int n10;
        int n11;
        float f10;
        Bitmap bitmap2 = image;
        int n12 = bitmap2.getWidth();
        float f11 = (float)n12 / (float)bitmap2.getHeight();
        if (f10 > 1.0f) {
            n10 = (int)((float)n11 / f11);
        } else {
            int n13 = n10 = (int)((float)n11 * f11);
            n10 = n11;
            n11 = n13;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n11, (int)n10, (boolean)false);
    }

    public static void deleteRecursive(File fileOrDirectory) {
        File file;
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                int n10 = fileArray.length;
                for (int i10 = 0; i10 < n10; ++i10) {
                    AttachmentManager.deleteRecursive(fileArray[i10]);
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static interface a {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

