/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventPublisher;
import com.instabug.library.d9;
import com.instabug.library.e8;
import com.instabug.library.g2;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.orchestrator.h;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.session.NullSessionException;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.x7;
import com.instabug.library.y2;
import com.instabug.library.z2;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.observers.DisposableCompletableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class a8 {
    @Nullable
    private static a8 e;
    private SettingsManager a;
    private int b;
    private z2 c;
    @Nullable
    private g2 d;

    private a8(SettingsManager settingsManager) {
        z2 z22;
        a8 a82 = object;
        a82.a = settingsManager;
        a82.q();
        Object object = z22;
        z22 = new z2();
        a82.c = object;
    }

    public static synchronized a8 e() {
        a8 a82 = e;
        if (a82 == null) {
            a8 a83;
            a82 = a83;
            e = new a8(SettingsManager.getInstance());
        }
        return a82;
    }

    public static synchronized void a(SettingsManager settingsManager) {
        if (e == null) {
            e = new a8(settingsManager);
        }
    }

    private void h() {
        ++this.b;
    }

    private void i() {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            y2.c().g(context);
        } else {
            InstabugSDKLogger.w("SessionManager", "unable to saveFeaturesToSharedPreferences due to null appContext");
        }
        if (--this.b == 0 && Instabug.getApplicationContext() != null && x7.a(Instabug.getApplicationContext())) {
            this.b();
        }
    }

    private void j() {
        if (this.a.getSessionStartedAt() != 0L) {
            g2 g22 = this.d;
            if (g22 != null) {
                a8 a82 = this;
                a82.a(g22);
                a82.m();
                a82.n();
                a82.a(SessionState.FINISH);
            }
        } else {
            InstabugSDKLogger.d("SessionManager", "Instabug is enabled after session started, Session ignored");
        }
        this.o();
    }

    private void o() {
        Context context = Instabug.getApplicationContext();
        z2 z22 = this.c;
        if (z22 != null && context != null) {
            try {
                z22.a(context);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InstabugSDKLogger.d("SessionManager", "This app is not registered");
            }
        }
        this.c(null);
    }

    private void n() {
        long l10 = System.currentTimeMillis();
        InstabugCore.setLastSeenTimestamp(l10);
        ActionsOrchestrator.obtainOrchestrator(PoolProvider.getSingleThreadExecutor("last-seen-record")).addWorkerThreadAction(new h(d9.i(), l10)).orchestrate();
    }

    private void a(@NonNull g2 g22) {
        if (SettingsManager.getInstance().isSessionEnabled()) {
            this.b(g22).flatMapCompletable((Function)new Function<SessionLocalEntity, Completable>(this){

                public Completable a(@NonNull SessionLocalEntity sessionLocalEntity) {
                    if (sessionLocalEntity != null) {
                        return new e8().a(sessionLocalEntity);
                    }
                    return Completable.error((Throwable)new NullSessionException("sessionLocalEntity can't be null!"));
                }
            }).subscribeOn(Schedulers.io()).subscribe((CompletableObserver)new DisposableCompletableObserver(){

                public void onComplete() {
                    a8.this.a(false);
                }

                public void onError(@NonNull Throwable throwable) {
                    InstabugSDKLogger.e("SessionManager", throwable.getClass().getSimpleName(), throwable);
                }
            });
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private Single<SessionLocalEntity> b(final @NonNull g2 g22) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<SessionLocalEntity>(this){

            public void subscribe(@NonNull SingleEmitter<SessionLocalEntity> object) {
                Context context = Instabug.getApplicationContext();
                boolean bl = InstabugCore.isUsersPageEnabled();
                if (context != null) {
                    SessionLocalEntity.Factory factory;
                    SingleEmitter<SessionLocalEntity> singleEmitter = object;
                    object = factory;
                    object();
                    singleEmitter.onSuccess((Object)factory.create(context, g22, bl));
                }
            }
        });
    }

    private void r() {
        long l10 = System.currentTimeMillis() / 1000L;
        ((a8)((Object)string)).a.setSessionStartedAt(l10);
        if (SettingsManager.getInstance().isFirstRun()) {
            ((a8)((Object)string)).a.setIsFirstRun(false);
        }
        if (SettingsManager.getInstance().getFirstRunAt().getTime() == 0L) {
            ((a8)((Object)string)).a.setFirstRunAt(System.currentTimeMillis());
        }
        ((a8)((Object)string)).a.incrementSessionsCount();
        String string = d9.i();
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new h(string, l10 *= 1000L)).orchestrate();
    }

    private void m() {
        if (SettingsManager.getInstance().isFirstDismiss()) {
            SettingsManager.getInstance().setIsFirstDismiss(false);
        }
    }

    private void a(SessionState sessionState) {
        if (sessionState.equals((Object)SessionState.FINISH)) {
            SettingsManager.getInstance().setIsAppOnForeground(false);
            SDKCoreEventPublisher.post(new SDKCoreEvent("session", "finished"));
        } else {
            SettingsManager.getInstance().setIsAppOnForeground(true);
            SDKCoreEventPublisher.post(new SDKCoreEvent("session", "started"));
        }
        SessionStateEventBus.getInstance().post(sessionState);
    }

    private void q() {
        CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n10 = com.instabug.library.a8$e.a[activityLifeCycleEvent.ordinal()];
                if (n10 != 1) {
                    if (n10 == 2) {
                        a8.this.i();
                    }
                } else {
                    a8.this.h();
                }
            }
        });
    }

    private void a(boolean bl) {
        SettingsManager.getInstance().setIsFirstSession(bl);
    }

    @NonNull
    private g2 a() {
        Object object = this.d;
        if (object != null) {
            return object;
        }
        this.r();
        object = Instabug.getApplicationContext();
        String string = UUID.randomUUID().toString();
        String string2 = DeviceStateProvider.getOS();
        String string3 = d9.i();
        object = object != null ? DeviceStateProvider.getAppVersion((Context)object) : null;
        long l10 = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        long l11 = System.nanoTime();
        boolean bl = this.l();
        return SessionMapper.toSession(string, string2, string3, (String)object, l10, l11, bl);
    }

    private void c(@Nullable g2 g22) {
        this.d = g22;
    }

    private boolean l() {
        if (!y2.c().g()) {
            return false;
        }
        long l10 = SettingsManager.getInstance().getSessionStitchingTimeoutInSeconds(1800);
        long l11 = this.g();
        if (l11 != -1L && l11 <= l10) {
            InstabugSDKLogger.d("SessionManager", "session stitched");
            return false;
        }
        InstabugSDKLogger.d("SessionManager", "started new billable session");
        return true;
    }

    private long g() {
        long l10 = SettingsManager.getInstance().geLastForegroundTime();
        if (l10 != -1L) {
            return (System.currentTimeMillis() - l10) / 1000L;
        }
        return l10;
    }

    public long d() {
        if (this.a.getSessionStartedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - this.a.getSessionStartedAt();
    }

    public synchronized void b() {
        if (y2.c().b((Object)Feature.INSTABUG) == Feature.State.ENABLED) {
            SettingsManager.getInstance().setInBackground(true);
            if (y2.c().g()) {
                SettingsManager.getInstance().setLastForegroundTime(System.currentTimeMillis());
            }
            this.j();
        }
    }

    public synchronized void p() {
        InstabugSDKLogger.d("SessionManager", "Instabug is disabled during app session, ending current session");
        SettingsManager.getInstance().setInBackground(false);
        this.j();
    }

    public synchronized void k() {
        a8 a82 = this;
        a82.c(a82.a());
        a82.a(SessionState.START);
        if (a82.c != null) {
            IntentFilter intentFilter;
            IntentFilter intentFilter2 = intentFilter;
            intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            Context context = Instabug.getApplicationContext();
            if (Instabug.isEnabled() && !this.c.a() && context != null) {
                this.c.a(context, intentFilter2);
            }
        }
        if (SettingsManager.getInstance().autoScreenRecordingEnabled()) {
            InternalAutoScreenRecorderHelper.getInstance().start();
        }
    }

    public int f() {
        return this.b;
    }

    @Nullable
    public synchronized Session c() {
        return this.d;
    }
}

