/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.f5;
import com.instabug.library.o6;
import com.instabug.library.p8;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.MainThreadExecutor;
import com.instabug.library.util.threading.ReturnableSingleThreadExecutor;
import com.instabug.library.util.threading.SingleThreadPoolExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final String TAG = "PoolProvider";
    private static PoolProvider INSTANCE;
    private static Map<String, SingleThreadPoolExecutor> singleThreadPoolExecutorhMap;
    private static Map<String, ReturnableSingleThreadExecutor> returnableSingleThreadPoolExecutorhMap;
    private static Map<String, f5> networkingSingleThreadExecutorhMap;
    private final ThreadPoolExecutor forBitmapTasks;
    private final ThreadPoolExecutor forIOTasks;
    private final ThreadPoolExecutor forComputationTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            IllegalStateException illegalStateException2 = illegalStateException;
            InstabugSDKLogger.e(TAG, illegalStateException.toString(), illegalStateException2);
            return null;
        }
    }

    private PoolProvider() {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3;
        o6 o62;
        o6 this_ = o62;
        o62 = new o6(10);
        int n10 = NUMBER_OF_CORES;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue4 = linkedBlockingQueue3;
        linkedBlockingQueue3 = new LinkedBlockingQueue<Runnable>();
        v2.forBitmapTasks = new ThreadPoolExecutor(n10, n10, 10L, timeUnit, linkedBlockingQueue4, this_);
        int n11 = n10;
        int n12 = n11 * 2;
        int n13 = n11 * 2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue5 = linkedBlockingQueue2;
        linkedBlockingQueue2 = new LinkedBlockingQueue<Runnable>();
        v2.forIOTasks = new ThreadPoolExecutor(n12, n13, 10L, timeUnit, linkedBlockingQueue5, this_);
        linkedBlockingQueue5 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        v2.forComputationTasks = new ThreadPoolExecutor(1, 2, 10L, timeUnit, linkedBlockingQueue5, this_);
        v2.forScheduledTasks = new ScheduledThreadPoolExecutor(n10 * 2, this_);
        v2.mainThreadExecutor = new MainThreadExecutor();
    }

    public static void postBitmapTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forBitmapTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't perform bitmap task", outOfMemoryError);
                }
            }
        });
    }

    public static void postIOTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forIOTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run i/o task", outOfMemoryError);
                }
            }
        });
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        Runnable runnable2;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            PoolProvider.postIOTask(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static void postComputationTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().forComputationTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    PoolProvider.getInstance().forComputationTasks.execute(runnable2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run computation task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable2 = new Runnable((Runnable)object){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run delayed task", outOfMemoryError);
                }
            }
        };
        object = TimeUnit.MILLISECONDS;
        PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
    }

    public static void postMainThreadTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run task", outOfMemoryError);
                }
            }
        };
        executor.execute(runnable3);
    }

    public static Executor newBackgroundExecutor() {
        o6 o62;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n10 = NUMBER_OF_CORES;
        int n11 = n10 * 2;
        int n12 = n10 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        o6 o63 = o62;
        o62 = new o6(10);
        return new ThreadPoolExecutor(n11, n12, 60L, timeUnit, linkedBlockingQueue2, o63);
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        SingleThreadPoolExecutor singleThreadPoolExecutor;
        String string2;
        if (singleThreadPoolExecutorhMap.containsKey(string2)) {
            return singleThreadPoolExecutorhMap.get(string2);
        }
        SingleThreadPoolExecutor singleThreadPoolExecutor2 = singleThreadPoolExecutor;
        singleThreadPoolExecutor2();
        singleThreadPoolExecutor.setIdentifier(string2).setThreadPoolIdleListener(new p8(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        singleThreadPoolExecutorhMap.put(string2, singleThreadPoolExecutor2);
        return singleThreadPoolExecutor;
    }

    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier) {
        f5 f52;
        String string2;
        if (networkingSingleThreadExecutorhMap.containsKey(string2)) {
            return networkingSingleThreadExecutorhMap.get(string2);
        }
        f5 f53 = f52;
        f53();
        f52.a(string2).a(new p8(){

            @Override
            public void a(@Nullable String string2) {
                if (string2 != null) {
                    singleThreadPoolExecutorhMap.remove(string2);
                }
            }
        });
        networkingSingleThreadExecutorhMap.put(string2, f53);
        return f52;
    }

    public static synchronized ReturnableSingleThreadExecutor getReturnableSingleThreadExecutor(String identifier) {
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor;
        String string2;
        if (returnableSingleThreadPoolExecutorhMap.containsKey(string2)) {
            return returnableSingleThreadPoolExecutorhMap.get(string2);
        }
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor2 = returnableSingleThreadExecutor;
        returnableSingleThreadExecutor = new ReturnableSingleThreadExecutor();
        returnableSingleThreadPoolExecutorhMap.put(string2, returnableSingleThreadExecutor2);
        return returnableSingleThreadExecutor;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("IBG-sync-Executor");
    }

    public static ReturnableSingleThreadExecutor getApiExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("IBG-Executor");
    }

    public static ReturnableSingleThreadExecutor getChatsCacheExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("chats-cache-executor");
    }

    public static ReturnableSingleThreadExecutor getSurveysDBExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("surveys-db-executor");
    }

    public static ReturnableSingleThreadExecutor getDatabaseExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("IBG-database-executor");
    }

    public static ReturnableSingleThreadExecutor getFilesEncryptionExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("Files-Encryption");
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, SingleThreadPoolExecutor>();
        returnableSingleThreadPoolExecutorhMap = new HashMap<String, ReturnableSingleThreadExecutor>();
        networkingSingleThreadExecutorhMap = new HashMap<String, f5>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }
}

