/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;

public class BitmapWorkerTask
extends AsyncTask<String, Void, Bitmap> {
    private final WeakReference<ImageView> imageViewReference;
    private float targetWidth;
    private float targetHeight;
    private boolean resize;
    @DrawableRes
    int fallbackResourceDrawable;
    @Nullable
    private OnImageLoadedListener onImageLoadedListener;

    /*
     * WARNING - void declaration
     */
    public BitmapWorkerTask(ImageView imageView) {
        void var1_1;
        WeakReference<void> weakReference;
        Object this_ = weakReference;
        weakReference = new WeakReference<void>(var1_1);
        v1.imageViewReference = this_;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapWorkerTask(ImageView imageView, @DrawableRes int fallbackResourceDrawable) {
        void var2_2;
        void var1_1;
        WeakReference<void> weakReference;
        Object this_ = weakReference;
        weakReference = new WeakReference<void>(var1_1);
        v1.imageViewReference = this_;
        v1.fallbackResourceDrawable = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapWorkerTask(ImageView imageView, float targetWidth, float targetHeight) {
        this((ImageView)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.targetWidth = var2_2;
        this.targetHeight = var3_3;
        this.resize = true;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapWorkerTask(ImageView imageView, @Nullable OnImageLoadedListener onImageLoadedListener) {
        this((ImageView)var1_1);
        void var2_2;
        void var1_1;
        this.onImageLoadedListener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public BitmapWorkerTask(ImageView imageView, float targetWidth, float targetHeight, @Nullable OnImageLoadedListener onImageLoadedListener) {
        this((ImageView)var1_1, (float)var2_2, (float)var3_3);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.onImageLoadedListener = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected Bitmap doInBackground(String ... params) {
        void var1_5;
        block7: {
            Bitmap bitmap;
            block6: {
                BitmapWorkerTask bitmapWorkerTask = this;
                bitmap = BitmapUtils.decodeSampledBitmapFromLocalPath((String)bitmap[0]);
                if (!bitmapWorkerTask.resize) break block6;
                Bitmap bitmap2 = bitmap;
                BitmapWorkerTask bitmapWorkerTask2 = this;
                BitmapWorkerTask bitmapWorkerTask3 = bitmapWorkerTask2;
                float f10 = bitmapWorkerTask2.targetWidth;
                try {
                    bitmap = BitmapUtils.resizeBitmap(bitmap2, f10, bitmapWorkerTask3.targetHeight);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    break block7;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bitmap;
        }
        InstabugSDKLogger.e((Object)this, "Something went wrong while loading bitmap", (Throwable)var1_5);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void onPostExecute(@Nullable Bitmap bitmap) {
        ImageView imageView = (ImageView)((BitmapWorkerTask)((Object)onImageLoadedListener)).imageViewReference.get();
        if (bitmap != null) {
            if (imageView != null) {
                void var1_1;
                imageView.setImageBitmap((Bitmap)var1_1);
                OnImageLoadedListener onImageLoadedListener = ((BitmapWorkerTask)((Object)onImageLoadedListener)).onImageLoadedListener;
                if (onImageLoadedListener != null) {
                    onImageLoadedListener.onImageLoaded();
                }
            }
        } else if (imageView != null) {
            try {
                imageView.setImageResource(((BitmapWorkerTask)((Object)onImageLoadedListener)).fallbackResourceDrawable);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(onImageLoadedListener, "Something went wrong while loading image resource", exception);
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded();
    }
}

