/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.a;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.i8;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.l7;
import com.instabug.library.o;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.t8;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.y1;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class InvocationManager {
    public static final String TAG = "InvocationManager";
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private AtomicReferenceArray<InstabugInvocationEvent> currentInstabugInvocationEvents;
    private List<a> currentInvokersList;
    @Nullable
    private AtomicReferenceArray<a> currentInvokers;
    @Nullable
    private AtomicReference<a> lastUsedInvoker;
    private Disposable currentActivityLifeCycleDisposable;
    private AtomicBoolean isInvocationAvailable;
    @Nullable
    private AtomicReference<com.instabug.library.invocation.a> invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.currentInvokersList = new ArrayList<a>();
        invocationManager.lastUsedInvoker = new AtomicReference();
        invocationManager.isInvocationAvailable = new AtomicBoolean(true);
        invocationManager.currentInvocationSettings = new InvocationSettings();
        this.currentInstabugInvocationEvents = new AtomicReferenceArray<InstabugInvocationEvent>(1);
        this.currentInstabugInvocationEvents.set(0, InstabugInvocationEvent.SHAKE);
        invocationManager.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
        invocationManager.subscribeToCarenActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new AtomicReference<com.instabug.library.invocation.a>(new com.instabug.library.invocation.a());
    }

    @NonNull
    private a[] createInvokersList() {
        this.currentInvokersList = new ArrayList<a>();
        return this.currentInvokersList.toArray(new a[this.currentInvokersList.size()]);
    }

    private void addToCurrentInvokers(a a10) {
        this.currentInvokersList.add(a10);
        List<a> list = this.currentInvokersList;
        this.currentInvokers = new AtomicReferenceArray<a>(list.toArray(new a[list.size()]));
    }

    public static synchronized void init() {
        InstabugSDKLogger.d(TAG, "initializing invocationManager");
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void subscribeToCarenActivityLifeCycle() {
        this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

            public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                int n10 = c.b[activityLifeCycleEvent.ordinal()];
                if (n10 != 1) {
                    if (n10 == 2) {
                        InstabugSDKLogger.d(InvocationManager.TAG, "current activity paused");
                        InvocationManager.this.sleep();
                    }
                } else {
                    InstabugSDKLogger.d(InvocationManager.TAG, "current activity resumed");
                    InvocationManager.this.listen();
                }
            }
        });
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private y1 getFloatingButtonInvoker() {
        y1 y12 = null;
        if (this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                a a10 = this.currentInvokers.get(i10);
                if (!(a10 instanceof y1)) continue;
                y12 = (y1)a10;
                break;
            }
        }
        return y12;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        Disposable disposable = this.currentActivityLifeCycleDisposable;
        if (disposable != null && !disposable.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.invocationRequestListenerImp = null;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        int n10;
        void var1_1;
        if (instabugInvocationEvent == null) {
            InstabugSDKLogger.e(InvocationManager.class.getName(), "Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        if (invocationManager.currentInvokers != null) {
            for (n10 = 0; n10 < this.currentInvokers.length(); ++n10) {
                this.currentInvokers.get(n10).c();
            }
            this.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
        }
        block7: for (n10 = 0; n10 < this.currentInstabugInvocationEvents.length(); ++n10) {
            Object object = this.currentInstabugInvocationEvents.get(n10);
            InstabugSDKLogger.d(TAG, "set instabug invocation event: " + (Object)object);
            if (object == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new AtomicReferenceArray<a>(this.createInvokersList());
            }
            Object object2 = InstabugCore.getTargetActivity() != null ? InstabugCore.getTargetActivity() : Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (c.a[object.ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new l7(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 3: {
                    if (object2 != null && this.invocationRequestListenerImp.get() != null) {
                        t8 t82;
                        object = t82;
                        t82 = new t8((Context)object2, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new y1(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 1: {
                    if (object2 != null && this.invocationRequestListenerImp.get() != null) {
                        i8 i82;
                        object = i82;
                        ((i8)object)((Context)object2, this.invocationRequestListenerImp.get());
                        i82.a(this.currentInvocationSettings.getShakeThreshold());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.w(TAG, "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    @VisibleForTesting
    AtomicReferenceArray<InstabugInvocationEvent> removeDuplicates(InstabugInvocationEvent[] events) {
        InstabugInvocationEvent[] instabugInvocationEventArray;
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n10 = events.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            void var5_5 = instabugInvocationEventArray[i10];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        instabugInvocationEventArray = new InstabugInvocationEvent[arrayList2.size()];
        return new AtomicReferenceArray<InstabugInvocationEvent>(arrayList2.toArray(instabugInvocationEventArray));
    }

    @Nullable
    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        InstabugInvocationEvent[] instabugInvocationEventArray = o.a(this.currentInstabugInvocationEvents, InstabugInvocationEvent.class);
        if (instabugInvocationEventArray != null) {
            return Arrays.copyOf(instabugInvocationEventArray, this.currentInstabugInvocationEvents.length());
        }
        return null;
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<a> getCurrentInvokers() {
        a[] this_ = o.a(this_.currentInvokers, a.class);
        if (this_ == null) {
            return null;
        }
        return Arrays.asList(this_);
    }

    @Nullable
    public a getLastUsedInvoker() {
        AtomicReference<a> atomicReference = ((InvocationManager)((Object)atomicReference)).lastUsedInvoker;
        if (atomicReference == null) {
            return null;
        }
        return (a)atomicReference.get();
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setLastUsedInvoker(@Nullable a a10) {
        AtomicReference<a> atomicReference = ((InvocationManager)((Object)atomicReference)).lastUsedInvoker;
        if (atomicReference != null) {
            atomicReference.set(a10);
        }
    }

    public void listen() {
        if (Instabug.isEnabled() && this.isInvocationAvailable.get() && this.isPromptOptionsAvailable() && this.currentInvokers != null && InstabugCore.getTargetActivity() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                a a10 = this.currentInvokers.get(i10);
                if (a10.b()) continue;
                a10.a();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (this.currentInvokers == null) {
            return;
        }
        if (InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                void var1_1;
                a a10 = this.currentInvokers.get(i10);
                if (!(a10 instanceof t8)) continue;
                a10.a(var1_1);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                a a10 = this.currentInvokers.get(i10);
                if (!a10.b()) continue;
                a10.c();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable.set(false);
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable.set(true);
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.a.d();
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                final a a10 = this.currentInvokers.get(i10);
                if (InstabugCore.getTargetActivity() == null || !(a10 instanceof y1)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this){

                    @Override
                    public void run() {
                        b b10 = this;
                        b10.a10.c();
                        b10.a10.a();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        y1 y12 = invocationManager.getFloatingButtonInvoker();
        if (y12 != null) {
            if (bl) {
                y12.c();
            } else {
                y12.f();
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        AtomicReference<Object> atomicReference;
        AtomicReference<com.instabug.library.invocation.a> atomicReference2 = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (atomicReference2 != null && atomicReference2.get() != null) {
            ((InvocationManager)((Object)this_)).invocationRequestListenerImp.get().a();
        }
        InvocationManager invocationManager = this_;
        AtomicReference<Object> this_ = atomicReference;
        atomicReference = new AtomicReference<Object>(null);
        invocationManager.lastUsedInvoker = this_;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        AtomicReference<com.instabug.library.invocation.a> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().b((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        AtomicReference<com.instabug.library.invocation.a> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().a((int)var1_1);
        }
    }
}

