/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.instabug.library.Feature;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.internal.video.a;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.y2;

public class VideoPlayerFragment
extends InstabugBaseFragment
implements a.a {
    private static final String VIDEO_PATH = "video.uri";
    public static final String TAG = "VideoPlayerFragment";
    @Nullable
    private View videoViewToolbar;
    @Nullable
    private VideoView videoView;
    private int position = 0;
    @Nullable
    private ProgressDialog progressDialog;
    @Nullable
    private a mediaControls;
    @Nullable
    private String videoUri;

    public static VideoPlayerFragment newInstance(String videoUri) {
        String string2;
        Bundle bundle;
        VideoPlayerFragment videoPlayerFragment = new VideoPlayerFragment();
        Bundle bundle2 = bundle;
        new Bundle().putString(VIDEO_PATH, string2);
        videoPlayerFragment.setArguments(bundle2);
        return videoPlayerFragment;
    }

    /*
     * WARNING - void declaration
     */
    private void showToolbar(boolean shouldShow) {
        if ((this = this.getActivity()) != null && (this = ((AppCompatActivity)this).getSupportActionBar()) != null) {
            void var1_1;
            if (var1_1 != false) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_video_view;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        Object object;
        super.onViewCreated((View)object, (Bundle)var2_2);
        this.videoView = (VideoView)object.findViewById(R.id.video_view);
        this.videoViewToolbar = object = view.findViewById(R.id.ib_core_toolbar_video);
        if (object != null) {
            View.OnClickListener onClickListener;
            View view2 = object;
            object = onClickListener;
            onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    if (VideoPlayerFragment.this.getActivity() != null) {
                        VideoPlayerFragment.this.getActivity().onBackPressed();
                    }
                }
            };
            view2.setOnClickListener((View.OnClickListener)object);
        }
        if (y2.c().b((Object)Feature.WHITE_LABELING) == Feature.State.DISABLED && (this = this.getActivity()) != null && (this = this.findViewById(R.id.instabug_pbi_footer)) != null) {
            this.setVisibility(8);
        }
    }

    @Override
    public void onResume() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onResume();
        videoPlayerFragment.showToolbar(false);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        FragmentActivity fragmentActivity;
        VideoPlayerFragment videoPlayerFragment = this;
        super.onActivityCreated((Bundle)fragmentActivity);
        fragmentActivity = videoPlayerFragment.getActivity();
        if (fragmentActivity != null) {
            block8: {
                if (this.mediaControls == null) {
                    a a10;
                    a a11 = a10;
                    a10 = new a((Context)fragmentActivity, this);
                    this.mediaControls = a11;
                }
                VideoPlayerFragment videoPlayerFragment2 = this;
                this.progressDialog = new ProgressDialog((Context)fragmentActivity);
                this.progressDialog.setMessage((CharSequence)"Loading...");
                videoPlayerFragment2.progressDialog.setCancelable(false);
                videoPlayerFragment2.progressDialog.show();
                fragmentActivity = videoPlayerFragment2.videoView;
                if (fragmentActivity == null) break block8;
                if (this.videoUri == null) break block8;
                try {
                    fragmentActivity.setMediaController((MediaController)this.mediaControls);
                    this.videoView.setVideoURI(Uri.parse((String)this.videoUri));
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null) {
                        InstabugSDKLogger.e(TAG, exception.getMessage(), exception);
                        break block8;
                    }
                    InstabugSDKLogger.e(TAG, exception.toString(), exception);
                }
            }
            if ((fragmentActivity = this.videoView) != null) {
                VideoPlayerFragment videoPlayerFragment3 = this;
                fragmentActivity.requestFocus();
                videoPlayerFragment3.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public void onPrepared(MediaPlayer mediaPlayer) {
                        if (VideoPlayerFragment.this.progressDialog != null) {
                            VideoPlayerFragment.this.progressDialog.dismiss();
                        }
                        if (VideoPlayerFragment.this.videoView != null) {
                            b b10 = this;
                            b10.VideoPlayerFragment.this.videoView.seekTo(VideoPlayerFragment.this.position);
                            if (b10.VideoPlayerFragment.this.position == 0) {
                                b b11 = this;
                                b11.VideoPlayerFragment.this.videoView.start();
                                if (b11.VideoPlayerFragment.this.mediaControls != null) {
                                    VideoPlayerFragment.this.mediaControls.show();
                                }
                            } else {
                                VideoPlayerFragment.this.videoView.pause();
                            }
                        }
                    }
                });
                videoPlayerFragment3.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    @SuppressLint(value={"NULL_DEREFERENCE"})
                    public boolean onError(MediaPlayer mediaPlayer, int n10, int n11) {
                        if (VideoPlayerFragment.this.progressDialog != null) {
                            VideoPlayerFragment.this.progressDialog.dismiss();
                        }
                        return false;
                    }
                });
            }
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VIDEO_PLAYER_TITLE, this.getLocalizedString(R.string.instabug_str_video_player));
    }

    public void onDestroy() {
        VideoPlayerFragment videoPlayerFragment = this;
        super.onDestroy();
        videoPlayerFragment.showToolbar(true);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        String string2 = this.getArguments() == null ? null : this.getArguments().getString(VIDEO_PATH);
        this.videoUri = string2;
    }

    @Override
    protected void restoreState(Bundle savedInstanceState) {
        VideoView videoView;
        int n10;
        this.position = n10 = videoView.getInt("Position");
        videoView = this.videoView;
        if (videoView != null) {
            videoView.seekTo(n10);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void saveState(Bundle outState) {
        VideoView videoView = this.videoView;
        if (videoView != null) {
            void var1_1;
            var1_1.putInt("Position", videoView.getCurrentPosition());
            this.videoView.pause();
        }
    }

    public void onDestroyView() {
        this.mediaControls = null;
        this.videoView = null;
        this.videoViewToolbar = null;
        super.onDestroyView();
        if (y2.c().b((Object)Feature.WHITE_LABELING) == Feature.State.DISABLED && (this = this.getActivity()) != null && (this = this.findViewById(R.id.instabug_pbi_footer)) != null) {
            this.setVisibility(0);
        }
    }

    @Override
    public void isVisible(boolean isVisible) {
        VideoPlayerFragment this_ = this_.videoViewToolbar;
        if (this_ != null) {
            int n10;
            n10 = n10 != 0 ? 0 : 8;
            this_.setVisibility(n10);
        }
    }
}

