/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import android.os.Build;
import android.util.Base64;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.m3;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u0010\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0002R\u0016\u0010\t\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0016\u0010\f\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0016\u0010\r\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\nR\u0016\u0010\u000e\u001a\u00020\u00028\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\nR\u0019\u0010\u000f\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/instabug/library/encryption/EncryptionManager;", "", "", "data", "encrypt", "decrypt", "", "Ljava/security/spec/AlgorithmParameterSpec;", "getIvSpec", "TAG", "Ljava/lang/String;", "AES_MODE", "ENCRYPTION_PREFIX", "ENCRYPTION_NEW_LINE_REPLACEMENT", "LINE_FEED", "iv", "[B", "getIv", "()[B", "<init>", "()V", "instabug-core_defaultUiRelease"})
public final class EncryptionManager {
    @NotNull
    public static final EncryptionManager INSTANCE = new EncryptionManager();
    @NotNull
    private static final String TAG = "EncryptionManager";
    @NotNull
    private static final String AES_MODE = "AES/GCM/NoPadding";
    @NotNull
    private static final String ENCRYPTION_PREFIX = "^instaEncrypted^";
    @NotNull
    private static final String ENCRYPTION_NEW_LINE_REPLACEMENT = "^instaLINE^";
    @NotNull
    public static final String LINE_FEED = "\n\r";
    @NotNull
    private static final byte[] iv;

    private EncryptionManager() {
    }

    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data) {
        String string2;
        if (data != null) {
            EncryptionManager encryptionManager;
            block11: {
                String string3 = string2;
                encryptionManager = INSTANCE;
                if (!StringsKt.startsWith$default((String)string3, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) break block11;
                return string2;
            }
            Cipher cipher = Cipher.getInstance(AES_MODE);
            int n10 = 1;
            Key key = m3.a();
            AlgorithmParameterSpec algorithmParameterSpec = encryptionManager.getIvSpec();
            cipher.init(n10, key, algorithmParameterSpec);
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = cipher.doFinal(byArray);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data.toByteArray())");
                String string4 = Base64.encodeToString((byte[])byArray2, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"encodeToString(cipherText, Base64.DEFAULT)");
                return Intrinsics.stringPlus((String)ENCRYPTION_PREFIX, (Object)StringsKt.replace$default((String)string4, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(TAG, "OOM while encrypting string, returning original string", outOfMemoryError);
                NonFatals.reportNonFatal(outOfMemoryError, "OOM while encrypting string, returning original string");
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(TAG, "Error while encrypting string, returning original string", exception);
                NonFatals.reportNonFatal(exception, "Error: " + exception.getMessage() + "while encrypting string, returning original string");
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data) {
        String string2;
        block14: {
            block13: {
                Object object;
                if (data == null) break block13;
                if (string2.length() == 0) {
                    return "";
                }
                EncryptionManager encryptionManager = INSTANCE;
                if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
                    return string2;
                }
                String string3 = string2;
                Object object2 = string3.substring(16, string3.length());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                try {
                    object = Base64.decode((String)StringsKt.replace$default((String)object2, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null), (int)0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return object2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                Base64\u2026          )\n            }");
                Cipher cipher = Cipher.getInstance(AES_MODE);
                int n10 = 2;
                object2 = m3.a();
                object = encryptionManager.getIvSpec();
                cipher.init(n10, (Key)object2, (AlgorithmParameterSpec)object);
                byte[] byArray = cipher.doFinal((byte[])object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decryptedBytes");
                object2 = Charset.forName("UTF-8");
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"forName(\"UTF-8\")");
                    return new String(byArray, (Charset)object2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e(TAG, "OOM while decrypting string, returning original string", outOfMemoryError);
                    NonFatals.reportNonFatal(outOfMemoryError, "OOM while decrypting string, returning original string");
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, "Error while decrypting string, returning original string", exception);
                    NonFatals.reportNonFatal(exception, "Error: " + exception.getMessage() + "while decrypting string, returning original string");
                }
                break block14;
            }
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        EncryptionManager encryptionManager = INSTANCE;
        Cipher cipher = Cipher.getInstance(AES_MODE);
        int n10 = 1;
        Object object = m3.a();
        AlgorithmParameterSpec algorithmParameterSpec = encryptionManager.getIvSpec();
        cipher.init(n10, (Key)object, algorithmParameterSpec);
        byte[] byArray2 = cipher.doFinal(byArray);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            val cipher\u2026r.doFinal(data)\n        }");
            byArray = byArray2;
        }
        catch (Exception exception) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.toString();
            }
            InstabugSDKLogger.e(exception, (String)object);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        Object object;
        EncryptionManager encryptionManager;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            encryptionManager = INSTANCE;
        }
        catch (Exception exception) {
            object = exception.getMessage();
            if (object == null) {
                object = exception.toString();
            }
            InstabugSDKLogger.e(exception, (String)object);
            return byArray;
        }
        Cipher cipher = Cipher.getInstance(AES_MODE);
        int n10 = 2;
        object = m3.a();
        AlgorithmParameterSpec algorithmParameterSpec = encryptionManager.getIvSpec();
        cipher.init(n10, (Key)object, algorithmParameterSpec);
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data)");
        return byArray2;
    }

    private final AlgorithmParameterSpec getIvSpec() {
        Object object;
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            object = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(96, iv);
        } else {
            IvParameterSpec ivParameterSpec;
            object = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(iv);
        }
        return object;
    }

    static {
        byte[] byArray = "RandomAESIv1".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        iv = byArray;
    }

    @NotNull
    public final byte[] getIv() {
        return iv;
    }
}

