/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class InitialScreenshotHelper {
    private static Uri screenshotUri;

    public static void captureScreenshot(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        InitialScreenshotCapturingListener initialScreenshotCapturingListener;
        final Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity == null) {
            return;
        }
        if (MemoryUtils.isLowMemory((Context)activity)) {
            Activity activity2 = activity;
            InstabugSDKLogger.e(InitialScreenshotHelper.class, "Couldn't take initial screenshot due to low memory");
            initialScreenshotCapturingListener.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            Toast.makeText((Context)activity2, (CharSequence)LocaleUtils.getLocaleStringResource(InstabugCore.getLocale((Context)activity2), R.string.instabug_str_capturing_screenshot_error, (Context)activity), (int)0).show();
            return;
        }
        if (InitialScreenshotHelper.isUsingMediaProjection()) {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener2 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    a a10 = a11;
                    a a11 = a10.activity;
                    InitialScreenshotHelper.access$000(bitmap, (Activity)a11, a10.initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    a a10 = this;
                    InstabugSDKLogger.e(a10, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    a10.initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(true, activity, screenshotCapturingListener2);
        } else {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener3 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(){

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    b b10 = b11;
                    b b11 = b10.activity;
                    InitialScreenshotHelper.access$000(bitmap, (Activity)b11, b10.initialScreenshotCapturingListener);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    b b10 = this;
                    InstabugSDKLogger.e(b10, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                    b10.initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                }
            };
            ScreenshotProvider.a(activity, screenshotCapturingListener3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBitmap(Bitmap bitmap, Activity activity, InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        void var1_1;
        void var2_2;
        BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
        Object object = onSaveBitmapCallback;
        onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback((InitialScreenshotCapturingListener)var2_2){
            final /* synthetic */ InitialScreenshotCapturingListener a;
            {
                this.a = initialScreenshotCapturingListener;
            }

            @Override
            public void onSuccess(Uri uri) {
                screenshotUri = uri;
                this.a.onScreenshotCapturedSuccessfully(uri);
            }

            @Override
            public void onError(Throwable throwable) {
                c c10 = this;
                InstabugSDKLogger.e(c10, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                c10.a.onScreenshotCapturingFailed(throwable);
            }
        };
        BitmapUtils.saveBitmap(bitmap, (Context)var1_1, (BitmapUtils.OnSaveBitmapCallback)object);
    }

    private static boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Bitmap x02, Activity x12, InitialScreenshotCapturingListener x22) {
        void var2_2;
        void var1_1;
        InitialScreenshotHelper.saveBitmap(x02, (Activity)var1_1, (InitialScreenshotCapturingListener)var2_2);
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

