/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.i;
import java.util.Locale;

public class LocaleUtils {
    private static final String TAG = "LocaleUtils";

    /*
     * WARNING - void declaration
     */
    public static void setLocale(Activity activity, Locale locale) {
        Activity activity2;
        void var1_1;
        Configuration configuration = activity.getResources().getConfiguration();
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 24) {
            if (var1_1 != null) {
                LocaleList localeList;
                LocaleList localeList2 = localeList;
                Locale[] localeArray = new Locale[1];
                Locale[] localeArray2 = localeArray;
                localeArray[0] = var1_1;
                localeList = new LocaleList(localeArray2);
                configuration.setLocales(localeList2);
                LocaleUtils.updateResources((Context)activity2, (Locale)var1_1);
            }
        } else if (n2 >= 17) {
            configuration.setLocale((Locale)var1_1);
        } else {
            configuration.locale = var1_1;
        }
        activity2.getResources().updateConfiguration(configuration, activity2.getResources().getDisplayMetrics());
    }

    public static void setAppLocale(Activity activity) {
        Locale locale = SettingsManager.getInstance().getAppLocale();
        if (locale != null) {
            Activity activity2;
            InstabugSDKLogger.i(TAG, "Setting app locale to " + locale.toString());
            LocaleUtils.setLocale(activity2, locale);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=24)
    private static Context updateResources(Context context, Locale locale) {
        void var1_1;
        Context context2 = context;
        Locale.setDefault((Locale)var1_1);
        Configuration configuration = context2.getResources().getConfiguration();
        configuration.setLocale((Locale)var1_1);
        configuration.setLayoutDirection((Locale)var1_1);
        return context2.createConfigurationContext(configuration);
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocaleStringResource(Locale requestedLocale, int resourceId, @Nullable Context context) {
        void var2_2;
        void var1_1;
        return LocaleUtils.getLocaleStringResource(requestedLocale, (int)var1_1, (Context)var2_2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static String getLocaleStringResource(Locale requestedLocale, int resourceId, @Nullable Context context, Object ... formatArgs) {
        void var3_3;
        Locale locale;
        void var1_1;
        void var2_2;
        if (Build.VERSION.SDK_INT < 17) return LocaleUtils.getLocalizedStringResOldAPI((Context)var2_2, (int)var1_1, locale, (Object[])var3_3);
        String string2 = LocaleUtils.getLocalizedStringResNewAPI((Context)var2_2, (int)var1_1, locale, (Object[])var3_3);
        if (string2 != null) return string2;
        string2 = LocaleUtils.getLocalizedStringResOldAPI((Context)var2_2, (int)var1_1, locale, (Object[])var3_3);
        if (string2 != null) return string2;
        if (var2_2 == null) return "";
        string2 = var2_2.getString((int)var1_1);
        if (var3_3 == null) return string2;
        return String.format(string2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @TargetApi(value=17)
    private static String getLocalizedStringResNewAPI(@Nullable Context context, int resourceId, Locale requestedLocale, Object ... formatArgs) {
        if (context != null) {
            void var3_4;
            void var1_2;
            Object object;
            block7: {
                void var2_3;
                Context context2;
                try {
                    context2 = object;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e(TAG, exception.toString(), exception);
                    return null;
                }
                Configuration configuration = new Configuration(object.getResources().getConfiguration());
                configuration.setLocale((Locale)var2_3);
                object = context2.createConfigurationContext(configuration);
                if (object != null) break block7;
                object = null;
            }
            object = object.getText((int)var1_2).toString();
            if (var3_4 != null && object != null) {
                object = String.format((String)object, (Object[])var3_4);
            }
            return object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static String getLocalizedStringResOldAPI(@Nullable Context context, int resourceId, Locale requestedLocale, Object ... formatArgs) {
        if (context != null) {
            void var3_4;
            void var1_1;
            void var2_3;
            Object object;
            Resources resources = object.getResources();
            object = resources;
            Configuration configuration = resources.getConfiguration();
            Context context2 = object;
            object = configuration.locale;
            configuration.locale = var2_3;
            context2.updateConfiguration(configuration, null);
            String string2 = context2.getString((int)var1_1);
            resources.getConfiguration().locale = object;
            resources.updateConfiguration(configuration, null);
            if (var3_4 != null) {
                string2 = String.format(string2, (Object[])var3_4);
            }
            return string2;
        }
        return null;
    }

    public static boolean isRTL(Locale locale) {
        Locale locale2;
        if (Build.VERSION.SDK_INT >= 17) {
            return TextUtils.getLayoutDirectionFromLocale((Locale)locale2) == 1;
        }
        byte by = Character.getDirectionality(locale2.getDisplayName().charAt(0));
        return by == 1 || by == 2;
    }

    public static String getCurrentLocaleResolved(Context context) {
        Context context2;
        return new i(context2).a();
    }

    /*
     * WARNING - void declaration
     */
    public static String resolveLocale(Context context, Locale locale) {
        void var1_1;
        Context context2;
        return new i(context2).a((Locale)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSupportedBySdk(Context context, Locale locale) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            return new i(context2).c(var1_1.getLanguage());
        }
        return false;
    }
}

