/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DiskUtils {
    public static final String TAG = "DiskUtils";

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static synchronized Uri zipFiles(Context context, String fileName, ArrayList<File> files) {
        void var0_5;
        ZipOutputStream zipOutputStream;
        block19: {
            Object object;
            block20: {
                File file;
                Object object2;
                block21: {
                    ZipOutputStream zipOutputStream2;
                    FileOutputStream fileOutputStream;
                    File file2;
                    InstabugSDKLogger.v(TAG, "zipping " + ((ArrayList)object2).size() + " files ... , time in MS:" + System.currentTimeMillis());
                    object2 = null;
                    file = file2;
                    file2 = new File(AttachmentManager.getAttachmentDirectory((Context)object) + File.separator + (String)((Object)zipOutputStream) + "_" + System.currentTimeMillis() + ".zip");
                    object = fileOutputStream;
                    fileOutputStream = new FileOutputStream(file);
                    zipOutputStream = zipOutputStream2;
                    zipOutputStream2 = new ZipOutputStream((OutputStream)object);
                    object = files.iterator();
                    break block21;
                    catch (Throwable throwable) {
                        zipOutputStream = object2;
                        break block19;
                    }
                    catch (IOException iOException) {
                        zipOutputStream = object2;
                        break block20;
                    }
                }
                while (object.hasNext()) {
                    object2 = (File)object.next();
                    if (object2 == null) continue;
                    ZipOutputStream zipOutputStream3 = zipOutputStream;
                    zipOutputStream3.putNextEntry(new ZipEntry(((File)object2).getName()));
                    DiskUtils.copy((File)object2, (OutputStream)zipOutputStream3);
                    zipOutputStream.closeEntry();
                }
                ZipOutputStream zipOutputStream4 = zipOutputStream;
                InstabugSDKLogger.v(DiskUtils.class, "zipping files have been finished successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
                object = Uri.fromFile((File)file);
                try {
                    zipOutputStream4.close();
                    return object;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return object;
                catch (IOException iOException) {}
            }
            InstabugSDKLogger.e(DiskUtils.class, "zipping files went wrong: " + ((Throwable)object).getMessage() + ", time in MS: " + System.currentTimeMillis(), (Throwable)object);
            object = null;
            if (zipOutputStream == null) return object;
            try {
                zipOutputStream.close();
                return object;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return object;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (zipOutputStream == null) throw var0_5;
        try {
            zipOutputStream.close();
            throw var0_5;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        throw var0_5;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static void copy(File file, OutputStream out) throws IOException {
        void var0_3;
        FileInputStream fileInputStream;
        block10: {
            block11: {
                block9: {
                    File file2;
                    void var1_4;
                    FileInputStream fileInputStream2;
                    Object var2_5 = null;
                    fileInputStream = fileInputStream2;
                    void v1 = var1_4;
                    fileInputStream(file2);
                    try {
                        DiskUtils.copy(fileInputStream2, (OutputStream)v1);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        break block9;
                    }
                    ((InputStream)fileInputStream2).close();
                    break block11;
                    catch (Throwable throwable) {
                        fileInputStream = var2_5;
                        break block10;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileInputStream = var2_5;
                    }
                }
                try {
                    InstabugSDKLogger.e(TAG, "FileNotFoundException: can not copy file to another stream");
                    if (fileInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ((InputStream)fileInputStream).close();
            }
            return;
        }
        if (fileInputStream != null) {
            ((InputStream)fileInputStream).close();
        }
        throw var0_3;
    }

    /*
     * WARNING - void declaration
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] byArray = new byte[2048];
        InputStream inputStream;
        int n2;
        while ((n2 = inputStream.read(byArray)) >= 0) {
            void var1_1;
            var1_1.write(byArray, 0, n2);
        }
        return;
    }

    public static ArrayList<File> listFilesInDirectory(File directory) {
        ArrayList arrayList;
        File[] fileArray = directory.listFiles();
        List<Object> list = arrayList;
        arrayList = new ArrayList();
        if (fileArray != null) {
            File file;
            list = Arrays.asList(fileArray);
            InstabugSDKLogger.addVerboseLog(TAG, "listing " + fileArray.length + " files ... at Directory name: " + file.getName() + "Directory path: " + file.getPath() + ", time in MS:" + System.currentTimeMillis());
        }
        return new ArrayList<File>(list);
    }

    @NonNull
    public static Observable<List<File>> getCleanDirectoryObservable(File directory) {
        File file;
        return Observable.fromCallable((Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() {
                ArrayList<File> arrayList;
                ArrayList<File> arrayList2 = arrayList;
                arrayList = new ArrayList<File>();
                if (file.exists() && file.isDirectory() && (this = file.listFiles()) != null) {
                    for (File file2 : this) {
                        if (file2.delete()) continue;
                        arrayList2.add(file2);
                    }
                }
                return arrayList2;
            }
        }).subscribeOn(Schedulers.io());
    }
}

