/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2.request;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.a;
import com.instabug.library.user.b;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    private static final String TAG = "Request";
    private static final String SHORTEN_APP_TOKEN = "at";
    private static final String SHORTEN_UUID = "uid";
    private static final String APP_TOKEN = "application_token";
    private static final String UUID = "uuid";
    @Nullable
    private final String appTokenValue = Instabug.getAppToken();
    private final String uuidValue = b.h();
    private final String sdkVersionValue = DeviceStateProvider.getSdkVersion();
    private final String requestUrl;
    @Nullable
    private final String endPoint;
    @Nullable
    private final String requestMethod;
    private final int requestType;
    private final List<RequestParameter> urlParameters;
    private final List<RequestParameter> bodyParameters;
    private final List<RequestParameter<String>> headers;
    @Nullable
    private final FileToUpload fileToUpload;
    @Nullable
    private final File downloadedFile;
    private final boolean shorten;

    public Request(Builder builder) {
        ArrayList arrayList;
        ArrayList arrayList2;
        this.endPoint = ((Builder)((Object)arrayList2)).endpoint;
        String string2 = builder.requestUrl != null ? ((Builder)((Object)arrayList2)).requestUrl : "https://api.instabug.com/api/sdk/v3" + this.endPoint;
        this.requestUrl = string2;
        int n2 = ((Builder)((Object)arrayList2)).type != -1 ? ((Builder)((Object)arrayList2)).type : 1;
        this.requestType = n2;
        this.requestMethod = ((Builder)((Object)arrayList2)).method;
        this.fileToUpload = ((Builder)((Object)arrayList2)).fileToUpload;
        this.downloadedFile = ((Builder)((Object)arrayList2)).downloadedFile;
        this.shorten = ((Builder)((Object)arrayList2)).shorten;
        if (((Builder)((Object)arrayList2)).urlParameters != null) {
            arrayList = ((Builder)((Object)arrayList2)).urlParameters;
        } else {
            ArrayList arrayList3;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
        this.urlParameters = arrayList;
        if (((Builder)((Object)arrayList2)).bodyParameters != null) {
            arrayList = ((Builder)((Object)arrayList2)).bodyParameters;
        } else {
            ArrayList arrayList4;
            arrayList = arrayList4;
            arrayList4 = new ArrayList();
        }
        this.bodyParameters = arrayList;
        if (((Builder)((Object)arrayList2)).headers != null) {
            arrayList2 = ((Builder)((Object)arrayList2)).headers;
        } else {
            ArrayList arrayList5;
            arrayList2 = arrayList5;
            arrayList5 = new ArrayList();
        }
        Request request = this;
        request.headers = arrayList2;
        request.handleBaseParams(request.shorten);
    }

    private void handleBaseParams(boolean shorten) {
        Object object;
        ((Request)object).headers.add(new RequestParameter<String>("IBG-SDK-VERSION", ((Request)object).sdkVersionValue));
        if (!shorten) {
            String string2 = ((Request)object).appTokenValue;
            if (string2 != null) {
                RequestParameter<String> requestParameter;
                Request request = object;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(APP_TOKEN, string2);
                request.addParameter((RequestParameter)object);
            }
        } else {
            String string3 = ((Request)object).appTokenValue;
            if (string3 != null) {
                RequestParameter<String> requestParameter;
                Request request = object;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(SHORTEN_APP_TOKEN, string3);
                request.addParameter((RequestParameter)object);
            }
        }
    }

    private String getUrlEncodedParameters() {
        Request request = this_;
        a this_ = a.a();
        for (RequestParameter requestParameter : request.urlParameters) {
            this_.a(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void addParameter(RequestParameter requestParameter) {
        String string2 = this.requestMethod;
        if (string2 != null) {
            void var1_1;
            if (!string2.equals("GET") && !this.requestMethod.equals("DELETE")) {
                this.addBodyParameter((RequestParameter)var1_1);
            } else {
                this.addUrlParameter((RequestParameter)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addUrlParameter(RequestParameter parameter) {
        void var1_1;
        this.urlParameters.add((RequestParameter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addBodyParameter(RequestParameter parameter) {
        void var1_1;
        this.bodyParameters.add((RequestParameter)var1_1);
    }

    @Nullable
    public String getEndpoint() {
        return this.endPoint;
    }

    public String getRequestUrl() {
        if (!this.getUrlEncodedParameters().isEmpty()) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public String getRequestMethod() {
        String this_ = ((Request)((Object)this_)).requestMethod;
        if (this_ == null) {
            return "GET";
        }
        return this_;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public List<RequestParameter<String>> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<RequestParameter> getRequestUrlParameters() {
        return Collections.unmodifiableList(this.urlParameters);
    }

    public List<RequestParameter> getRequestBodyParameters() {
        return Collections.unmodifiableList(this.bodyParameters);
    }

    /*
     * WARNING - void declaration
     */
    public String getRequestBody() {
        void var1_4;
        JSONObject jSONObject;
        Request request = this_;
        Request this_ = jSONObject;
        jSONObject = new JSONObject();
        Iterator<RequestParameter> iterator = request.getRequestBodyParameters().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Request request2 = this_;
            RequestParameter requestParameter = iterator.next();
            RequestParameter requestParameter2 = requestParameter;
            String string2 = requestParameter.getKey();
            request2.put(string2, requestParameter2.getValue());
        }
        try {
            return this_.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Request request3 = this_;
        System.gc();
        InstabugSDKLogger.e(TAG, "OOM Exception trying to remove large logs...", (Throwable)var1_4);
        var1_4.printStackTrace();
        try {
            request3.remove("console_log");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(TAG, "Failed to resolve OOM, returning empty request body", (Throwable)var1_4);
            outOfMemoryError.printStackTrace();
            return "{}";
        }
        request3.remove("instabug_log");
        request3.remove("network_log");
        return request3.toString();
    }

    @Nullable
    public FileToUpload getFileToUpload() {
        return this.fileToUpload;
    }

    @Nullable
    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public Builder builder() {
        return Builder.access$1100(Builder.access$1000(new Builder().endpoint(this.endPoint).url(this.requestUrl).method(this.requestMethod).type(this.requestType).shorten(this.shorten).fileToUpload(this.fileToUpload).fileToDownload(this.downloadedFile), this.bodyParameters), this.urlParameters).setHeaders(this.headers);
    }

    @NonNull
    public String toString() {
        String string2 = this.requestMethod;
        if (string2 != null && string2.equals("GET")) {
            return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod;
        }
        return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod + " | Body: " + this.getRequestBody();
    }

    public boolean isMultiPartRequest() {
        return this.fileToUpload != null;
    }

    public static class Builder {
        @Nullable
        private String requestUrl;
        @Nullable
        private String endpoint;
        @Nullable
        private String method;
        private int type;
        @Nullable
        private ArrayList<RequestParameter> urlParameters;
        @Nullable
        private ArrayList<RequestParameter> bodyParameters;
        @Nullable
        private ArrayList<RequestParameter<String>> headers;
        @Nullable
        private FileToUpload fileToUpload;
        @Nullable
        private File downloadedFile;
        private boolean shorten;

        public Builder() {
            RequestParameter<String> requestParameter;
            RequestParameter<String> requestParameter2;
            RequestParameter<String> requestParameter3;
            Builder builder = this_;
            builder.type = -1;
            Object this_ = requestParameter3;
            requestParameter3 = new RequestParameter<String>("IBG-OS", "android");
            builder.addHeader((RequestParameter<String>)this_);
            this_ = requestParameter2;
            requestParameter2 = new RequestParameter<String>("IBG-OS-VERSION", Build.VERSION.RELEASE);
            builder.addHeader((RequestParameter<String>)this_);
            this_ = requestParameter;
            requestParameter = new RequestParameter<String>("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion());
            builder.addHeader((RequestParameter<String>)this_);
        }

        /*
         * WARNING - void declaration
         */
        private Builder addUrlParameter(RequestParameter parameter) {
            void var1_1;
            if (this.urlParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.urlParameters = arrayList2;
            }
            Builder builder = this;
            builder.urlParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setUrlParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).urlParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).urlParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.urlParameters = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder addBodyParameter(RequestParameter parameter) {
            void var1_1;
            if (this.bodyParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.bodyParameters = arrayList2;
            }
            Builder builder = this;
            builder.bodyParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setBodyParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).bodyParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).bodyParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.bodyParameters = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1000(Builder x0, List x1) {
            void var1_1;
            return x0.setBodyParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1100(Builder x0, List x1) {
            void var1_1;
            return x0.setUrlParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder url(String url) {
            void var1_1;
            this.requestUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder endpoint(@Nullable String endpoint) {
            void var1_1;
            this.endpoint = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder method(@Nullable String requestMethod) {
            void var1_1;
            this.method = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder type(int requestType) {
            void var1_1;
            this.type = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addParameter(RequestParameter requestParameter) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.addBodyParameter((RequestParameter)var1_1);
                } else {
                    this.addUrlParameter((RequestParameter)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setParameter(List<RequestParameter> requestParameters) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.setBodyParameter((List<RequestParameter>)var1_1);
                } else {
                    this.setUrlParameter((List<RequestParameter>)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder shorten(boolean isShortedKeys) {
            void var1_1;
            this.shorten = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addHeader(RequestParameter<String> header) {
            void var1_1;
            if (this.headers == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.headers = arrayList2;
            }
            Builder builder = this;
            builder.headers.add((RequestParameter<String>)var1_1);
            return builder;
        }

        public Builder setHeaders(List<RequestParameter<String>> headers) {
            ArrayList arrayList;
            ArrayList arrayList2;
            if (headers == null) {
                ArrayList arrayList3;
                arrayList2 = arrayList3;
                arrayList3 = new ArrayList();
            }
            Builder builder = arrayList4;
            ArrayList arrayList4 = arrayList;
            arrayList = new ArrayList(arrayList2);
            builder.headers = arrayList4;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToUpload(@Nullable FileToUpload fileToUpload) {
            void var1_1;
            this.fileToUpload = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToDownload(@Nullable File file) {
            void var1_1;
            this.downloadedFile = var1_1;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }

    public static interface Callbacks<T, K extends Throwable> {
        public void onSucceeded(T var1);

        public void onFailed(K var1);
    }
}

