/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.annotation.SuppressLint;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    private static final String TAG = "Request";
    public static final String BASE_URL = "https://api.instabug.com/api/sdk/v3";
    public static final String PRODUCTION_LOGS_URL = "https://api.instabug.com/sdklogs/upload";
    public static final String BASIC_AUTH_VALUE_PREFIX = "Basic ";
    private static final String surveysVersion = "v7";
    private static final String announcementVersion = "v2";
    private String requestUrl;
    @Nullable
    private String endPoint;
    @Nullable
    private RequestMethod requestMethod;
    private NetworkManager.RequestType requestType;
    private ArrayList<RequestParameter> urlParameters;
    private ArrayList<RequestParameter> bodyParameters;
    private ArrayList<RequestParameter> headers;
    @Nullable
    private FileToUpload fileToUpload;
    @Nullable
    private File downloadedFile;

    /*
     * WARNING - void declaration
     */
    public Request(Endpoint endpoint, NetworkManager.RequestType requestType) {
        void var2_2;
        void var1_1;
        Request request = this;
        request.endPoint = var1_1.toString();
        request.requestUrl = BASE_URL + this.getEndpoint();
        this.requestType = var2_2;
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public Request(String requestUrl, NetworkManager.RequestType requestType) {
        void var2_2;
        void var1_1;
        Request request = this;
        request.requestUrl = var1_1;
        request.requestType = var2_2;
        request.initialize();
    }

    private void initialize() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        Request request = this_;
        Object this_ = arrayList3;
        arrayList3 = new ArrayList();
        request.urlParameters = this_;
        this_ = arrayList2;
        arrayList2 = new ArrayList();
        request.bodyParameters = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        request.headers = this_;
    }

    private String getUrlEncodedParameters() {
        Uri.Builder builder;
        Request request = this_;
        Request this_ = builder;
        builder = new Uri.Builder();
        for (RequestParameter requestParameter : request.urlParameters) {
            if (requestParameter.getValue() == null) continue;
            this_.appendQueryParameter(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        return this_.toString();
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public String getEndpoint() {
        return this.endPoint;
    }

    /*
     * WARNING - void declaration
     */
    public void setEndpoint(String endpoint) {
        void var1_1;
        Request request = this;
        request.endPoint = var1_1;
        request.requestUrl = BASE_URL + this.getEndpoint();
    }

    public String getRequestUrl() {
        if (this.getUrlEncodedParameters() != null) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    /*
     * WARNING - void declaration
     */
    public Request setRequestMethod(RequestMethod requestMethod) {
        void var1_1;
        this.requestMethod = var1_1;
        return this;
    }

    @Nullable
    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public NetworkManager.RequestType getRequestType() {
        return this.requestType;
    }

    /*
     * WARNING - void declaration
     */
    public Request addHeader(RequestParameter header) {
        void var1_1;
        Request request = this;
        request.headers.add((RequestParameter)var1_1);
        return request;
    }

    public ArrayList<RequestParameter> getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    public Request addParameter(String key, @Nullable Object value) {
        RequestMethod requestMethod = this.requestMethod;
        if (requestMethod != null) {
            void var2_2;
            void var1_1;
            if (!requestMethod.equals((Object)RequestMethod.Get) && !this.requestMethod.equals((Object)RequestMethod.Delete)) {
                this.addRequestBodyParameter((String)var1_1, var2_2);
            } else {
                this.addRequestUrlParameter((String)var1_1, var2_2);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void addRequestUrlParameter(String key, @Nullable Object value) {
        void var2_2;
        void var1_1;
        this.urlParameters.add(new RequestParameter((String)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<RequestParameter> setRequestUrlParameters(ArrayList<RequestParameter> urlParameters) {
        void var1_1;
        this.urlParameters = var1_1;
        return urlParameters;
    }

    public ArrayList<RequestParameter> getRequestUrlParameters() {
        return this.urlParameters;
    }

    public ArrayList<RequestParameter> clearRequestUrlParameters() {
        Request request = this;
        request.urlParameters.clear();
        return request.urlParameters;
    }

    /*
     * WARNING - void declaration
     */
    public void addRequestBodyParameter(String key, @Nullable Object value) {
        void var2_2;
        void var1_1;
        this.bodyParameters.add(new RequestParameter((String)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<RequestParameter> setRequestBodyParameters(ArrayList<RequestParameter> bodyParameters) {
        void var1_1;
        this.bodyParameters = var1_1;
        return bodyParameters;
    }

    public ArrayList<RequestParameter> getRequestBodyParameters() {
        return this.bodyParameters;
    }

    public ArrayList<RequestParameter> clearRequestBodyParameters() {
        Request request = this;
        request.bodyParameters.clear();
        return request.bodyParameters;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String getRequestBody() {
        void var1_4;
        JSONObject jSONObject;
        Request request = this_;
        Request this_ = jSONObject;
        jSONObject = new JSONObject();
        Iterator<RequestParameter> iterator = request.getRequestBodyParameters().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Request request2 = this_;
            RequestParameter requestParameter = iterator.next();
            RequestParameter requestParameter2 = requestParameter;
            String string = requestParameter.getKey();
            request2.put(string, requestParameter2.getValue());
        }
        try {
            return this_.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Request request3 = this_;
        System.gc();
        InstabugSDKLogger.e(TAG, "OOM Exception trying to remove large logs...", (Throwable)var1_4);
        var1_4.printStackTrace();
        try {
            request3.remove("console_log");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(TAG, "Failed to resolve OOM, returning empty request body", (Throwable)var1_4);
            outOfMemoryError.printStackTrace();
            return "";
        }
        request3.remove("instabug_log");
        request3.remove("network_log");
        return request3.toString();
    }

    @Nullable
    public FileToUpload getFileToUpload() {
        return this.fileToUpload;
    }

    /*
     * WARNING - void declaration
     */
    public Request setFileToUpload(FileToUpload fileToUpload) {
        void var1_1;
        this.fileToUpload = var1_1;
        return this;
    }

    @Nullable
    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    /*
     * WARNING - void declaration
     */
    public Request setDownloadedFile(@NonNull String downloadedFilePath) {
        void var1_1;
        File file;
        Request request = this_;
        File this_ = file;
        file = new File((String)var1_1);
        request.downloadedFile = this_;
        return request;
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toString() {
        if (this.requestMethod == RequestMethod.Get) {
            return "Url: " + this.getRequestUrl() + " | Method: " + (Object)((Object)this.requestMethod);
        }
        return "Url: " + this.getRequestUrl() + " | Method: " + (Object)((Object)this.requestMethod) + " | Body: " + this.getRequestBody();
    }

    public boolean isMultiPartRequest() {
        return this.fileToUpload != null;
    }

    public static interface Callbacks<T, K> {
        public void onSucceeded(@Nullable T var1);

        public void onFailed(K var1);
    }

    public static class FileToUpload {
        private String filePartName;
        private String fileName;
        private String filePath;
        private String fileType;

        /*
         * WARNING - void declaration
         */
        public FileToUpload(@NonNull String filePartName, @NonNull String fileName, @NonNull String filePath, @NonNull String fileType) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.filePartName = var1_1;
            this.fileName = var2_2;
            this.filePath = var3_3;
            this.fileType = var4_4;
        }

        public String getFilePartName() {
            return this.filePartName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileType() {
            return this.fileType;
        }
    }

    public static class RequestParameter
    implements Serializable {
        private String key;
        @Nullable
        private Object value;

        /*
         * WARNING - void declaration
         */
        public RequestParameter(String key, @Nullable Object value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static final class RequestMethod
    extends Enum<RequestMethod> {
        public static final /* enum */ RequestMethod Get;
        public static final /* enum */ RequestMethod Post;
        public static final /* enum */ RequestMethod put;
        public static final /* enum */ RequestMethod Delete;
        private static final /* synthetic */ RequestMethod[] $VALUES;
        private final String name;

        public static RequestMethod[] values() {
            return (RequestMethod[])$VALUES.clone();
        }

        public static RequestMethod valueOf(String name) {
            String string;
            return Enum.valueOf(RequestMethod.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private RequestMethod(String s2) {
            void var3_3;
            this.name = var3_3;
        }

        static {
            RequestMethod requestMethod;
            Get = new RequestMethod("GET");
            Post = new RequestMethod("POST");
            put = new RequestMethod("PUT");
            RequestMethod requestMethod2 = requestMethod;
            Delete = new RequestMethod("DELETE");
            $VALUES = new RequestMethod[]{Get, Post, put, requestMethod2};
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }

    public static final class Endpoint
    extends Enum<Endpoint> {
        public static final /* enum */ Endpoint REPORT_BUG;
        public static final /* enum */ Endpoint ADD_BUG_ATTACHMENT;
        public static final /* enum */ Endpoint REPORT_CRASH;
        public static final /* enum */ Endpoint ADD_CRASH_ATTACHMENT;
        public static final /* enum */ Endpoint REPORT_ANR;
        public static final /* enum */ Endpoint TRIGGER_CHAT;
        public static final /* enum */ Endpoint SEND_MESSAGE;
        public static final /* enum */ Endpoint ADD_MESSAGE_ATTACHMENT;
        public static final /* enum */ Endpoint SYNC_CHATS;
        public static final /* enum */ Endpoint APP_SETTINGS;
        public static final /* enum */ Endpoint SEND_SESSION;
        public static final /* enum */ Endpoint GET_SURVEYS;
        public static final /* enum */ Endpoint SUBMIT_SURVEY;
        public static final /* enum */ Endpoint BUG_LOGS;
        public static final /* enum */ Endpoint CRASH_LOGS;
        public static final /* enum */ Endpoint CHAT_LOGS;
        public static final /* enum */ Endpoint MIGRATE_UUID;
        public static final /* enum */ Endpoint ANALYTICS;
        public static final /* enum */ Endpoint PUSH_TOKEN;
        public static final /* enum */ Endpoint REPORT_CATEGORIES;
        public static final /* enum */ Endpoint GET_FEATURES_REQUEST;
        public static final /* enum */ Endpoint GET_FEATURE_DETAILS;
        public static final /* enum */ Endpoint GET_FEATURE_TIMELINE;
        public static final /* enum */ Endpoint VOTE_FEATURE;
        public static final /* enum */ Endpoint SEARCH;
        public static final /* enum */ Endpoint ADD_NEW_FEATURE;
        public static final /* enum */ Endpoint ADD_COMMENT;
        public static final /* enum */ Endpoint RESOLVE_IP;
        public static final /* enum */ Endpoint GET_ANNOUNCEMENTS;
        public static final /* enum */ Endpoint SUBMIT_ANNOUNCEMENT;
        public static final /* enum */ Endpoint USER_ATTRIBUTES;
        public static final /* enum */ Endpoint FIRST_SEEN;
        private static final /* synthetic */ Endpoint[] $VALUES;
        private final String name;

        public static Endpoint[] values() {
            return (Endpoint[])$VALUES.clone();
        }

        public static Endpoint valueOf(String name) {
            String string;
            return Enum.valueOf(Endpoint.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private Endpoint(String s2) {
            void var3_3;
            this.name = var3_3;
        }

        static {
            Endpoint endpoint;
            REPORT_BUG = new Endpoint("/bugs");
            ADD_BUG_ATTACHMENT = new Endpoint("/bugs/:bug_token/attachments");
            REPORT_CRASH = new Endpoint("/crashes");
            ADD_CRASH_ATTACHMENT = new Endpoint("/crashes/:crash_token/attachments");
            REPORT_ANR = new Endpoint("/crashes/anr");
            TRIGGER_CHAT = new Endpoint("/chats");
            SEND_MESSAGE = new Endpoint("/chats/:chat_number/messages");
            ADD_MESSAGE_ATTACHMENT = new Endpoint("/chats/:chat_number/messages/:message_id/attachments");
            SYNC_CHATS = new Endpoint("/chats/sync");
            APP_SETTINGS = new Endpoint("/features");
            SEND_SESSION = new Endpoint("/sessions/v2");
            GET_SURVEYS = new Endpoint("/surveys/v7");
            SUBMIT_SURVEY = new Endpoint("/surveys/:survey_id/v7/responses");
            BUG_LOGS = new Endpoint("/bugs/:bug_token/state_logs");
            CRASH_LOGS = new Endpoint("/crashes/:crash_token/state_logs");
            CHAT_LOGS = new Endpoint("/chats/:chat_token/state_logs");
            MIGRATE_UUID = new Endpoint("/migrate_uuid");
            ANALYTICS = new Endpoint("/analytics");
            PUSH_TOKEN = new Endpoint("/push_token");
            REPORT_CATEGORIES = new Endpoint("/application_categories");
            GET_FEATURES_REQUEST = new Endpoint("/feature_reqs");
            GET_FEATURE_DETAILS = new Endpoint("/feature_reqs/:feature_req_id");
            GET_FEATURE_TIMELINE = new Endpoint("/feature_reqs/:feature_req_id/timeline");
            VOTE_FEATURE = new Endpoint("/feature_reqs/:feature_req_id/like");
            SEARCH = new Endpoint("/search");
            ADD_NEW_FEATURE = new Endpoint("/feature_reqs");
            ADD_COMMENT = new Endpoint("/feature_reqs/:feature_req_id/comment");
            RESOLVE_IP = new Endpoint("/resolve_ip");
            GET_ANNOUNCEMENTS = new Endpoint("/announcements/v2");
            SUBMIT_ANNOUNCEMENT = new Endpoint("/announcements/:announcement_id/v2/responses");
            USER_ATTRIBUTES = new Endpoint("/users/attributes");
            Endpoint endpoint2 = endpoint;
            FIRST_SEEN = new Endpoint("/first_seen");
            $VALUES = new Endpoint[]{REPORT_BUG, ADD_BUG_ATTACHMENT, REPORT_CRASH, ADD_CRASH_ATTACHMENT, REPORT_ANR, TRIGGER_CHAT, SEND_MESSAGE, ADD_MESSAGE_ATTACHMENT, SYNC_CHATS, APP_SETTINGS, SEND_SESSION, GET_SURVEYS, SUBMIT_SURVEY, BUG_LOGS, CRASH_LOGS, CHAT_LOGS, MIGRATE_UUID, ANALYTICS, PUSH_TOKEN, REPORT_CATEGORIES, GET_FEATURES_REQUEST, GET_FEATURE_DETAILS, GET_FEATURE_TIMELINE, VOTE_FEATURE, SEARCH, ADD_NEW_FEATURE, ADD_COMMENT, RESOLVE_IP, GET_ANNOUNCEMENTS, SUBMIT_ANNOUNCEMENT, USER_ATTRIBUTES, endpoint2};
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }
}

